/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.facilities;

import java.util.Map;
import javax.slee.ActivityContextInterface;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.facilities.ActivityContextNamingFacility;
import javax.slee.facilities.FacilityException;
import javax.slee.facilities.NameAlreadyBoundException;
import javax.slee.facilities.NameNotBoundException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextIDInterface;
import org.mobicents.slee.runtime.ActivityContextInterfaceImpl;
import org.mobicents.slee.runtime.cache.CacheableMap;
import org.mobicents.slee.runtime.transaction.TransactionManagerImpl;

public class ActivityContextNamingFacilityImpl
implements ActivityContextNamingFacility {
    private static final String tcache = TransactionManagerImpl.RUNTIME_CACHE;
    private static Logger log = Logger.getLogger((Class)ActivityContextNamingFacilityImpl.class);
    private static String MAP_NODE_NAME = "namedActivityContexts";

    private Map getNameMap() throws Exception {
        CacheableMap cmap = new CacheableMap(tcache + "-" + MAP_NODE_NAME);
        cmap.setAllowPhantomReads(false);
        return cmap;
    }

    public void bind(ActivityContextInterface aci, String aciName) throws NullPointerException, IllegalArgumentException, TransactionRequiredLocalException, NameAlreadyBoundException, FacilityException {
        SleeContainer.getTransactionManager().mandateTransaction();
        if (aciName == null) {
            throw new NullPointerException("null aci name");
        }
        if (aciName.equals("")) {
            throw new IllegalArgumentException("empty name");
        }
        if (aci == null) {
            throw new NullPointerException("Null ACI! ");
        }
        try {
            Map hmap = this.getNameMap();
            String nodeName = aciName;
            if (hmap.containsKey(nodeName)) {
                throw new NameAlreadyBoundException("Name already bound ! " + aciName);
            }
            String acId = ((ActivityContextIDInterface)aci).retrieveActivityContextID();
            hmap.put(nodeName, acId);
            SleeContainer.lookupFromJndi().getActivityContextFactory().getActivityContextById(acId).addNameBinding(aciName);
        }
        catch (NameAlreadyBoundException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("name already bound " + aciName));
            }
            throw ex;
        }
        catch (Exception e) {
            throw new FacilityException("Failed to put ac name binding in cache", (Throwable)e);
        }
    }

    public void unbind(String aciName) throws NullPointerException, TransactionRequiredLocalException, NameNotBoundException, FacilityException {
        SleeContainer.getTransactionManager().mandateTransaction();
        if (aciName == null) {
            throw new NullPointerException("null activity context name!");
        }
        String nodeName = aciName;
        try {
            Map acNames = this.getNameMap();
            if (!acNames.containsKey(aciName)) {
                throw new NameNotBoundException("Name not bound " + aciName);
            }
            String acId = (String)acNames.get(aciName);
            acNames.remove(nodeName);
            ActivityContext ac = SleeContainer.lookupFromJndi().getActivityContextFactory().getActivityContextById(acId);
            if (ac != null) {
                ac.removeNameBinding(aciName);
            }
        }
        catch (NameNotBoundException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Name not bound " + aciName));
            }
            throw ex;
        }
        catch (Exception e) {
            throw new FacilityException("Failed to remove ac name binding from cache", (Throwable)e);
        }
    }

    public void unbindWithoutCheck(String aciName) throws NullPointerException, TransactionRequiredLocalException, NameNotBoundException, FacilityException {
        SleeContainer.getTransactionManager().mandateTransaction();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unbinding: aci " + aciName));
        }
        if (aciName == null) {
            throw new NullPointerException("null activity context name!");
        }
        try {
            Map acNames = this.getNameMap();
            String acId = (String)acNames.get(aciName);
            acNames.remove(aciName);
            ActivityContext ac = SleeContainer.lookupFromJndi().getActivityContextFactory().getActivityContextById(acId);
            if (ac != null) {
                ac.removeNameBinding(aciName);
            }
        }
        catch (Exception e) {
            throw new FacilityException("Failed to remove ac name binding from cache", (Throwable)e);
        }
    }

    public ActivityContextInterface lookup(String acName) throws NullPointerException, TransactionRequiredLocalException, FacilityException {
        SleeContainer.getTransactionManager().mandateTransaction();
        if (acName == null) {
            throw new NullPointerException("null ac name");
        }
        try {
            Map acNames = this.getNameMap();
            String acId = (String)acNames.get(acName);
            if (acId == null) {
                return null;
            }
            SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
            return new ActivityContextInterfaceImpl(sleeContainer, acId);
        }
        catch (Exception e) {
            throw new FacilityException("Failed to look-up ac name binding", (Throwable)e);
        }
    }
}

