/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.facilities;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.slee.AlarmID;
import javax.slee.ComponentID;
import javax.slee.UnrecognizedAlarmException;
import javax.slee.UnrecognizedComponentException;
import javax.slee.facilities.AlarmFacility;
import javax.slee.facilities.AlarmLevel;
import javax.slee.facilities.FacilityException;
import javax.slee.facilities.Level;
import javax.slee.management.AlarmMBean;
import javax.slee.management.AlarmNotification;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.management.AlarmMBeanImpl;

public class AlarmFacilityImpl
implements AlarmFacility {
    private AlarmMBeanImpl mBean;
    private Map registeredComps;
    private Map notificationTypes;
    private Logger log = Logger.getLogger((Class)AlarmFacilityImpl.class);

    public AlarmFacilityImpl(AlarmMBeanImpl aMBean) {
        this.mBean = aMBean;
        this.registeredComps = new ConcurrentReaderHashMap();
        this.notificationTypes = new ConcurrentReaderHashMap();
    }

    public void createAlarm(ComponentID alarmSource, Level alarmLevel, String alarmType, String message, long timeStamp) throws NullPointerException, IllegalArgumentException, UnrecognizedComponentException, FacilityException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"createAlarm1");
        }
        this.createAlarmInternal(alarmSource, alarmLevel, alarmType, message, null, timeStamp);
    }

    public void createAlarm(ComponentID alarmSource, Level alarmLevel, String alarmType, String message, Throwable cause, long timeStamp) throws NullPointerException, IllegalArgumentException, UnrecognizedComponentException, FacilityException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"createAlarm2");
        }
        if (cause == null) {
            throw new NullPointerException("Null parameter");
        }
        this.createAlarmInternal(alarmSource, alarmLevel, alarmType, message, cause, timeStamp);
    }

    private void createAlarmInternal(ComponentID alarmSource, Level alarmLevel, String alarmType, String message, Throwable cause, long timeStamp) throws NullPointerException, IllegalArgumentException, UnrecognizedComponentException, FacilityException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("alarmSource:" + alarmSource + " alarmLevel:" + alarmLevel + " alarmType:" + alarmType + " message:" + message + " cause:" + cause + " timeStamp:" + timeStamp));
        }
        if (alarmSource == null || alarmLevel == null || alarmType == null || message == null) {
            throw new NullPointerException("Null parameter");
        }
        if (alarmLevel.isOff()) {
            throw new IllegalArgumentException("Invalid alarm level");
        }
        RegisteredComp comp = (RegisteredComp)this.registeredComps.get(alarmSource);
        if (comp == null) {
            throw new UnrecognizedComponentException("Component not registered");
        }
        if (!this.notificationTypes.containsKey(alarmType)) {
            this.notificationTypes.put(alarmType, alarmType);
        }
        AlarmNotification notification = new AlarmNotification((AlarmMBean)this.mBean, alarmType, (Object)alarmSource, alarmLevel, message, cause, comp.getSeqNo(), timeStamp);
        this.mBean.sendNotification(notification);
    }

    public void registerComponent(ComponentID sbbid) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Registering component with alarm facility: " + sbbid));
        }
        this.registeredComps.put(sbbid, new RegisteredComp());
    }

    public void unRegisterComponent(ComponentID sbbId) {
        this.registeredComps.remove(sbbId);
    }

    public String[] getNotificationTypes() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Getting notification types");
        }
        String[] types = new String[this.notificationTypes.size()];
        Iterator iter = this.notificationTypes.values().iterator();
        for (int i = 0; i < types.length; ++i) {
            while (iter.hasNext()) {
                types[i] = (String)iter.next();
            }
        }
        return types;
    }

    public void clearAlarm(AlarmID arg0) throws NullPointerException, FacilityException {
    }

    public void clearAlarms(String arg0) throws NullPointerException, FacilityException {
    }

    public AlarmLevel getAlarmLevel(AlarmID arg0) throws NullPointerException, UnrecognizedAlarmException, FacilityException {
        return null;
    }

    public AlarmID raiseAlarm(String arg0, AlarmLevel arg1, String arg2) throws NullPointerException, IllegalArgumentException, FacilityException {
        return null;
    }

    public AlarmID raiseAlarm(String arg0, AlarmLevel arg1, String arg2, Throwable arg3) throws NullPointerException, IllegalArgumentException, FacilityException {
        return null;
    }

    public void updateAlarm(AlarmID arg0, AlarmLevel arg1, String arg2) throws NullPointerException, UnrecognizedAlarmException, IllegalArgumentException, FacilityException {
    }

    public void updateAlarm(AlarmID arg0, AlarmLevel arg1, String arg2, Throwable arg3) throws NullPointerException, UnrecognizedAlarmException, IllegalArgumentException, FacilityException {
    }

    class RegisteredComp {
        public long seqNo;

        RegisteredComp() {
        }

        public long getSeqNo() {
            return this.seqNo++;
        }
    }
}

