/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.facilities;

import EDU.oswego.cs.dl.util.concurrent.DirectExecutor;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.slee.ActivityContextInterface;
import javax.slee.Address;
import javax.slee.TransactionRolledbackLocalException;
import javax.slee.facilities.FacilityException;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextIDInterface;
import org.mobicents.slee.runtime.cache.CacheableMap;
import org.mobicents.slee.runtime.facilities.TimerFacilityTimerTask;
import org.mobicents.slee.runtime.facilities.TimerIDImpl;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;
import org.mobicents.slee.runtime.transaction.TransactionManagerImpl;
import org.mobicents.slee.runtime.transaction.TransactionalAction;

public class TimerFacilityImpl
implements Serializable,
TimerFacility {
    private static final long serialVersionUID = 5281276761487630957L;
    private static final int DEFAULT_TIMEOUT = 100;
    public static final String JNDI_NAME = "timer";
    private static final String FQN_PREFIX = "timerfacility:";
    private static final String FQN_TIMERS_NAME = "timerfacility:timers:timertasks";
    private static String tcache = TransactionManagerImpl.RUNTIME_CACHE;
    private int timerResolution = 10;
    private transient Timer sysTimer = new Timer();
    private Map timerCacheMap;
    private static Logger logger = Logger.getLogger((Class)TimerFacilityImpl.class);

    public Map getTimerMapFromCache() throws Exception {
        if (this.timerCacheMap != null) {
            return this.timerCacheMap;
        }
        this.timerCacheMap = new CacheableMap(tcache + "-" + FQN_TIMERS_NAME);
        return this.timerCacheMap;
    }

    public TimerFacilityImpl(SleeContainer sleeContainer) {
    }

    public TimerID setTimer(ActivityContextInterface aci, Address address, long startTime, TimerOptions timerOptions) throws NullPointerException, IllegalArgumentException, FacilityException {
        return this.setTimer(aci, address, startTime, Long.MAX_VALUE, 1, timerOptions);
    }

    public TimerID setTimer(ActivityContextInterface aci, Address address, long startTime, long period, int numRepetitions, TimerOptions timerOptions) throws NullPointerException, IllegalArgumentException, TransactionRolledbackLocalException, FacilityException {
        long now;
        if (aci == null) {
            throw new NullPointerException("Null ActivityContextInterface");
        }
        if (timerOptions == null) {
            throw new NullPointerException("Null TimerOptions");
        }
        if (startTime < 0L) {
            throw new IllegalArgumentException("startTime < 0");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("period <= 0");
        }
        if (numRepetitions < 0) {
            throw new IllegalArgumentException("numRepetitions < 0");
        }
        if (timerOptions.getTimeout() > period) {
            throw new IllegalArgumentException("timeout > period");
        }
        if (timerOptions.getTimeout() < this.getResolution()) {
            timerOptions.setTimeout(Math.min(period, this.getResolution()));
        }
        SleeTransactionManager txMgr = SleeContainer.getTransactionManager();
        boolean startedTx = txMgr.requireTransaction();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setTimer: startTime = " + startTime + " period = " + period + " numRepetitions = " + numRepetitions + " timeroptions =" + timerOptions));
        }
        TimerIDImpl timerID = new TimerIDImpl();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Timer id is: " + timerID));
        }
        if (startTime < (now = System.currentTimeMillis())) {
            startTime = now;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("START TIME IS " + startTime));
        }
        TimerFacilityTimerTask task = new TimerFacilityTimerTask(timerID, ((ActivityContextIDInterface)aci).retrieveActivityContextID(), address, startTime, period, numRepetitions, timerOptions);
        try {
            Map cmap = this.getTimerMapFromCache();
            cmap.put(timerID.toString(), task);
        }
        catch (Exception e) {
            throw new FacilityException("Failed to add timer to cache", (Throwable)e);
        }
        logger.debug((Object)"Added new timer to cache");
        ((ActivityContextIDInterface)aci).retrieveActivityContext().attachTimer(timerID);
        TimerFacilityAction action = new TimerFacilityAction(task, new Date(startTime), period);
        try {
            SleeContainer.getTransactionManager().addAfterCommitAction(action);
        }
        catch (SystemException e) {
            logger.error((Object)e);
        }
        if (startedTx) {
            try {
                SleeContainer.getTransactionManager().commit();
            }
            catch (Exception e) {
                throw new TransactionRolledbackLocalException("Failed to commit transaction");
            }
        }
        return timerID;
    }

    public void cancelTimer(TimerID timerID) throws NullPointerException, TransactionRolledbackLocalException, FacilityException {
        this.cancelTimer(timerID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelTimer(TimerID timerID, boolean checkForActivityEnd) throws NullPointerException, TransactionRolledbackLocalException, FacilityException {
        if (timerID == null) {
            throw new NullPointerException("Null TimerID");
        }
        SleeTransactionManager txMgr = SleeContainer.getTransactionManager();
        boolean startedTx = txMgr.requireTransaction();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Started tx: " + startedTx));
            logger.debug((Object)"Cancelling timer");
        }
        try {
            TimerFacilityTimerTask task = this.removeReferencesToTimer(timerID, checkForActivityEnd);
            if (task != null) {
                this.addPostTimerCancelationAction(timerID, txMgr, task);
            }
        }
        finally {
            if (startedTx) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"started tx so committing it");
                    }
                    SleeContainer.getTransactionManager().commit();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to commit tx in cancelTimer(). Rolling back tx.", (Throwable)e);
                    try {
                        SleeContainer.getTransactionManager().rollback();
                    }
                    catch (SystemException e1) {
                        logger.error((Object)"Failed to rollback tx in cancelTimer().", (Throwable)e1);
                        throw new TransactionRolledbackLocalException("Failed to rollback transaction");
                    }
                    throw new TransactionRolledbackLocalException("Failed to commit transaction");
                }
            }
        }
    }

    private void addPostTimerCancelationAction(TimerID timerID, SleeTransactionManager txMgr, TimerFacilityTimerTask task) {
        boolean needToAdd;
        block11: {
            needToAdd = true;
            try {
                List actions = ((TransactionManagerImpl)txMgr).getCommitActions();
                if (actions == null) break block11;
                Iterator iter = actions.iterator();
                logger.debug((Object)("There are " + actions.size() + " actions"));
                while (iter.hasNext()) {
                    TransactionalAction action = (TransactionalAction)iter.next();
                    if (!(action instanceof TimerFacilityAction)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Timerfacilityaction");
                    }
                    TimerFacilityAction tfAction = (TimerFacilityAction)action;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Action 2 is: " + tfAction));
                        logger.debug((Object)("timerid is: " + tfAction.timerID));
                        logger.debug((Object)("actiontype is: " + tfAction.actionType));
                        logger.debug((Object)("timerid is: " + timerID));
                    }
                    if (tfAction.actionType != 0 && tfAction.actionType != 1 || !tfAction.timerID.equals(timerID)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Removing it:");
                    }
                    iter.remove();
                    needToAdd = false;
                    break;
                }
            }
            catch (SystemException e) {
                throw new FacilityException("Failed to get actions", (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Need to add: " + needToAdd));
        }
        if (needToAdd) {
            TimerFacilityAction action = new TimerFacilityAction(task);
            try {
                this.getTimerMapFromCache().remove(task.getTimerID().toString());
                SleeContainer.getTransactionManager().addAfterCommitAction(action);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Added cancel timer commit action");
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private TimerFacilityTimerTask removeReferencesToTimer(TimerID timerID, boolean checkForActivityEnd) {
        TimerFacilityTimerTask task = null;
        try {
            Map cmap = this.getTimerMapFromCache();
            task = (TimerFacilityTimerTask)cmap.get(timerID.toString());
            if (task == null) {
                logger.warn((Object)("TASK================ Can't find timer[" + timerID.toString() + "] task in cache! ==============="));
                return null;
            }
            logger.info((Object)("TASK[" + task + "]"));
            SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
            ActivityContext ac = sleeContainer.getActivityContextFactory().getActivityContextById(task.getActivityContextId());
            if (ac == null) {
                throw new FacilityException("Can't find ac in cache!");
            }
            ac.detachTimer(timerID, checkForActivityEnd);
            cmap.remove(timerID.toString());
        }
        catch (Exception e) {
            throw new FacilityException("Failed to remove timer from cache", (Throwable)e);
        }
        return task;
    }

    public long getResolution() throws FacilityException {
        return this.timerResolution;
    }

    public long getDefaultTimeout() throws FacilityException {
        return 100L;
    }

    public void stop() {
        this.sysTimer.cancel();
        logger.info((Object)"TimerFacility stopped");
        this.recycleTimer();
    }

    public synchronized void recycleTimer() {
        this.sysTimer = new Timer();
    }

    public void start() {
    }

    public void restart() {
        SleeContainer.getTransactionManager().mandateTransaction();
        try {
            Map cmap = this.getTimerMapFromCache();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TimeFacility.restart() cmap size " + cmap.size()));
            }
            Iterator it = cmap.keySet().iterator();
            while (it.hasNext()) {
                long lastTick;
                String timerId = (String)it.next();
                TimerFacilityTimerTask task = (TimerFacilityTimerTask)cmap.get(timerId);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("TimerFacility.restart(): restarting timer task \n" + task));
                }
                long period = task.period;
                long now = System.currentTimeMillis();
                long startTime = task.getTimerOptions().isPersistent() ? ((lastTick = task.getLastTick()) + period < now ? now : lastTick + period) : now;
                TimerFacilityAction action = new TimerFacilityAction(task, new Date(startTime), period);
                try {
                    SleeContainer.getTransactionManager().addAfterCommitAction(action);
                }
                catch (SystemException e) {
                    logger.error((Object)e);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Bad startup !", (Throwable)ex);
        }
    }

    public void setTimerResolution(int resolution) {
        if (resolution < 10) {
            throw new IllegalArgumentException("min resolution is 10 miliseconds");
        }
        this.timerResolution = resolution;
    }

    public int getTimerResolution() {
        return this.timerResolution;
    }

    public void persistTimer(TimerFacilityTimerTask task) throws Exception {
        Map cmap = this.getTimerMapFromCache();
        cmap.put(task.getTimerID().toString(), task);
    }

    class TimerFacilityAction
    implements TransactionalAction {
        private static final int TYPE_SET_ONETIME = 0;
        private static final int TYPE_SET_PERIOD = 1;
        private static final int TYPE_CANCEL = 2;
        private TimerTask task;
        private Date startTime;
        private long period;
        private TimerID timerID;
        private int actionType;

        public String toString() {
            return this.getClass() + " Type: " + this.actionType;
        }

        TimerFacilityAction(TimerFacilityTimerTask task, Date startTime, long period) {
            this(task, startTime);
            if (task.numRepetitions != 1) {
                this.period = period;
                this.actionType = 1;
            }
        }

        TimerFacilityAction(TimerFacilityTimerTask task, Date startTime) {
            this.task = task;
            this.startTime = startTime;
            this.actionType = 0;
            this.timerID = task.getTimerID();
        }

        TimerFacilityAction(TimerFacilityTimerTask task) {
            this.task = task;
            this.actionType = 2;
        }

        public void execute() {
            try {
                new DirectExecutor().execute((Runnable)new TimerStarterTask(this));
            }
            catch (Exception e) {
                logger.error((Object)"Failed to execute TimerStarterTask", (Throwable)e);
            }
        }

        class TimerStarterTask
        implements Runnable {
            private TimerFacilityAction timerFacilityAction;

            public TimerStarterTask(TimerFacilityAction timerFacilityAction2) {
                this.timerFacilityAction = timerFacilityAction2;
            }

            public void run() {
                try {
                    TimerFacilityImpl tf = TimerFacilityImpl.this;
                    if (TimerFacilityAction.this.actionType == 0) {
                        this.scheduleOneTimeTask(tf);
                    } else if (TimerFacilityAction.this.actionType == 1) {
                        this.schedulePeriodicTask(tf);
                    } else if (TimerFacilityAction.this.actionType == 2) {
                        logger.info((Object)"TASK===Cancelling timer");
                        this.timerFacilityAction.task.cancel();
                    }
                }
                catch (RuntimeException e) {
                    logger.error((Object)"Failed to run timer start task", (Throwable)e);
                    throw e;
                }
            }

            private void schedulePeriodicTask(TimerFacilityImpl tf) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"===Scheduling periodic timer");
                }
                try {
                    tf.sysTimer.scheduleAtFixedRate(TimerFacilityAction.this.task, TimerFacilityAction.this.startTime, TimerFacilityAction.this.period);
                }
                catch (RuntimeException e) {
                    logger.warn((Object)"Failed to schedule new task with system timer. Will recycle system timer and retry.", (Throwable)e);
                    TimerFacilityImpl.this.recycleTimer();
                    logger.info((Object)"Timer task scheduled successfully with recycled system timer.");
                }
            }

            private void scheduleOneTimeTask(TimerFacilityImpl tf) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"===Scheduling one-time timer");
                }
                try {
                    tf.sysTimer.schedule(TimerFacilityAction.this.task, TimerFacilityAction.this.startTime);
                }
                catch (RuntimeException e) {
                    logger.warn((Object)"Failed to schedule new task with system timer. Will recycle system timer and retry.", (Throwable)e);
                    TimerFacilityImpl.this.recycleTimer();
                    logger.info((Object)"Timer task scheduled successfully with recycled system timer.");
                }
            }
        }
    }
}

