/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.facilities;

import java.io.Serializable;
import java.util.TimerTask;
import javax.naming.NamingException;
import javax.slee.Address;
import javax.slee.InvalidStateException;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.management.ComponentKey;
import org.mobicents.slee.container.management.EventTypeIDImpl;
import org.mobicents.slee.runtime.facilities.TimerEventImpl;
import org.mobicents.slee.runtime.facilities.TimerFacilityImpl;

public class TimerFacilityTimerTask
extends TimerTask
implements Serializable {
    private static final long serialVersionUID = -938503788187751855L;
    private static Logger logger = Logger.getLogger((Class)TimerFacilityTimerTask.class);
    private static boolean isDebugEnabled = logger.isDebugEnabled();
    private TimerID timerId;
    private String activityContextId;
    private Address address;
    private TimerOptions timerOptions;
    long startTime;
    int numRepetitions;
    int remainingRepetitions;
    int missedRepetitions;
    long period;
    private long lastTick;
    private EventTypeIDImpl timerEventID;

    public String toString() {
        return "timerId = " + this.timerId + ("\nacid = " + this.activityContextId) + ("\nAddress = " + this.address) + ("\ntimerOptions = " + this.timerOptions) + ("\nstartTime = " + this.startTime) + ("\nnumReps = " + this.numRepetitions) + ("\nremainingReps " + this.remainingRepetitions) + ("\nperiod  " + this.period);
    }

    public TimerFacilityTimerTask(TimerID timerId, String activityContextId, Address address, long startTime, long period, int numRepetitions, TimerOptions timerOptions) {
        this.timerId = timerId;
        this.activityContextId = activityContextId;
        this.address = address;
        this.startTime = startTime;
        this.period = period;
        this.numRepetitions = numRepetitions;
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        ComponentKey timerEventKey = new ComponentKey("javax.slee.facilities.TimerEvent", "javax.slee", "1.0");
        this.timerEventID = sleeContainer.getEventType(timerEventKey);
        this.remainingRepetitions = numRepetitions <= 0 ? Integer.MAX_VALUE : numRepetitions;
        this.missedRepetitions = 0;
        this.timerOptions = timerOptions;
    }

    public TimerOptions getTimerOptions() {
        return this.timerOptions;
    }

    TimerID getTimerID() {
        return this.timerId;
    }

    public void run() {
        try {
            this.runInternal();
        }
        catch (Throwable t) {
            logger.warn((Object)("Failed to cancel timer task[ID:" + this.timerId + "]"), t);
        }
    }

    private void runInternal() {
        if (isDebugEnabled) {
            logger.debug((Object)"In TimerFacilityTimerTask.run()");
        }
        TimerFacilityImpl timerFacility = null;
        try {
            timerFacility = (TimerFacilityImpl)SleeContainer.getTimerFacility();
        }
        catch (NamingException ex) {
            logger.error((Object)"Error getting timer facility cannot run timer", (Throwable)ex);
            return;
        }
        long tRes = timerFacility.getResolution();
        long tSys = System.currentTimeMillis();
        long tDto = timerFacility.getDefaultTimeout();
        boolean postIt = false;
        if (this.timerOptions.getPreserveMissed() == TimerPreserveMissed.ALL) {
            postIt = true;
            if (isDebugEnabled) {
                logger.debug((Object)"TimerPreserveMissed.ALL so posting the event");
            }
        } else {
            long timeOut = this.timerOptions.getTimeout() == 0L ? tDto : this.timerOptions.getTimeout();
            timeOut = Math.min(Math.max(timeOut, tRes), this.period);
            if (isDebugEnabled) {
                logger.debug((Object)("I'm using " + timeOut + " for the timeout to work out whether the event's late"));
            }
            if (this.timerOptions.getPreserveMissed() == TimerPreserveMissed.NONE) {
                if (isDebugEnabled) {
                    logger.debug((Object)"TimerPreserveMissed.NONE");
                }
                if (tSys <= this.scheduledExecutionTime() + timeOut) {
                    postIt = true;
                    if (isDebugEnabled) {
                        logger.debug((Object)"Event is NOT late so I'm posting it");
                    }
                } else {
                    if (isDebugEnabled) {
                        logger.debug((Object)"Event is late so I'm NOT posting it");
                    }
                    ++this.missedRepetitions;
                }
            } else if (this.timerOptions.getPreserveMissed() == TimerPreserveMissed.LAST) {
                if (isDebugEnabled) {
                    logger.debug((Object)"TimerPreserveMissed.LAST");
                }
                if (this.remainingRepetitions > 1 && tSys > this.scheduledExecutionTime() + timeOut) {
                    if (isDebugEnabled) {
                        logger.debug((Object)"Event is late and NOT the last one so I'm NOT posting it");
                    }
                    ++this.missedRepetitions;
                } else {
                    if (isDebugEnabled) {
                        logger.debug((Object)"Event is either NOT late, or late and is the last event so I'm posting it");
                    }
                    postIt = true;
                }
            }
        }
        if (isDebugEnabled) {
            logger.debug((Object)("SCHEDULED EXECUTION TIME IS " + this.scheduledExecutionTime()));
            logger.debug((Object)("Remaining repetitions:" + this.remainingRepetitions));
        }
        this.decrementRemainingRepetitions();
        if (postIt) {
            SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
            ComponentKey timerEventKey = new ComponentKey("javax.slee.facilities.TimerEvent", "javax.slee", "1.0");
            EventTypeIDImpl timerEventID = sleeContainer.getEventType(timerEventKey);
            TimerEventImpl timerEvent = new TimerEventImpl(this.timerId, this.scheduledExecutionTime(), tSys, this.period, this.numRepetitions, this.remainingRepetitions, this.missedRepetitions, timerEventID, this);
            this.missedRepetitions = 0;
            this.postEvent(timerEvent);
        }
        this.checkForTimerEnd(timerFacility);
    }

    private void decrementRemainingRepetitions() {
        if (this.remainingRepetitions > 0 && this.numRepetitions != 0) {
            --this.remainingRepetitions;
        }
    }

    private void checkForTimerEnd(TimerFacilityImpl timerFacility) {
        if (this.remainingRepetitions == 0) {
            this.cancel();
            if (isDebugEnabled) {
                logger.debug((Object)"Timer has expired - removing it");
            }
            timerFacility.cancelTimer(this.timerId);
        }
    }

    void postEvent(TimerEventImpl timerEvent) {
        logger.debug((Object)("Posting timer event:" + timerEvent));
        this.lastTick = System.currentTimeMillis();
        try {
            SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
            Object act = sleeContainer.getActivityContextFactory().getActivityFromKey(this.activityContextId);
            if (logger.isDebugEnabled()) {
                logger.info((Object)("Posting timer event on event router queue. TimerEventID: " + this.timerEventID + ", Activity:  " + act + " remainingRepetitions: " + this.remainingRepetitions));
            }
            if (act == null) {
                logger.warn((Object)"Cannot fire a timer event, because the underlying activity is gone.");
                this.remainingRepetitions = 0;
            } else {
                sleeContainer.getSleeEndpoint().enqueueEvent(this.timerEventID, (Object)timerEvent, act, this.address);
            }
        }
        catch (InvalidStateException e) {
            logger.error((Object)"Failed to send timer event", (Throwable)e);
        }
    }

    public long getLastTick() {
        return this.lastTick;
    }

    public String getActivityContextId() {
        return this.activityContextId;
    }

    public long getStartTime() {
        return this.startTime;
    }
}

