/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.facilities;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.slee.ComponentID;
import javax.slee.UnrecognizedComponentException;
import javax.slee.facilities.FacilityException;
import javax.slee.facilities.Level;
import javax.slee.facilities.TraceFacility;
import javax.slee.management.TraceMBean;
import javax.slee.management.TraceNotification;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.management.jmx.TraceMBeanImpl;

public class TraceFacilityImpl
implements TraceFacility {
    private Hashtable traceLevelTable;
    private TraceMBeanImpl traceMBeanImpl;
    private HashSet notificationTypes = new HashSet();
    private static Logger log = Logger.getLogger((Class)TraceFacilityImpl.class);

    public TraceMBeanImpl getTraceMBeanImpl() {
        return this.traceMBeanImpl;
    }

    public TraceFacilityImpl(TraceMBeanImpl traceMB) throws NotCompliantMBeanException {
        this.traceLevelTable = new Hashtable();
        this.traceMBeanImpl = traceMB;
    }

    public void setTraceLevel(ComponentID componentId, Level traceLevel) {
        TraceLevel level = (TraceLevel)this.traceLevelTable.get(componentId);
        if (level == null) {
            level = new TraceLevel(traceLevel);
            this.traceLevelTable.put(componentId, level);
        }
        level.level = traceLevel;
    }

    public void unSetTraceLevel(ComponentID componentId) {
        this.traceLevelTable.remove(componentId);
    }

    public void checkComponentID(ComponentID componentId) throws UnrecognizedComponentException {
        if (this.traceLevelTable.get(componentId) == null) {
            throw new UnrecognizedComponentException(componentId.toString());
        }
    }

    public Level getTraceLevel(ComponentID componentId) throws NullPointerException, UnrecognizedComponentException, FacilityException {
        this.checkComponentID(componentId);
        return ((TraceLevel)this.traceLevelTable.get(componentId)).getLevel();
    }

    public void createTrace(ComponentID componentId, Level level, String messageType, String message, long timeStamp) throws NullPointerException, IllegalArgumentException, UnrecognizedComponentException, FacilityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("createTrace: " + componentId + " level = " + level + " messageType " + messageType + " message " + message + " timeStamp " + timeStamp));
        }
        this.checkComponentID(componentId);
        TraceLevel tl = (TraceLevel)this.traceLevelTable.get(componentId);
        this.notificationTypes.add(messageType);
        if (tl == null) {
            throw new UnrecognizedComponentException("Could not find " + componentId);
        }
        Level lev = tl.getLevel();
        int seqno = tl.getSeqno();
        if (lev.isOff()) {
            return;
        }
        if (!lev.isHigherLevel(level)) {
            TraceNotification traceNotification = new TraceNotification((TraceMBean)this.traceMBeanImpl, messageType, (Object)componentId, level, message, null, (long)seqno, timeStamp);
            this.traceMBeanImpl.sendNotification((Notification)traceNotification);
        }
    }

    public void createTrace(ComponentID componentId, Level level, String messageType, String message, Throwable cause, long timeStamp) throws NullPointerException, IllegalArgumentException, UnrecognizedComponentException, FacilityException {
        this.checkComponentID(componentId);
        TraceLevel tl = (TraceLevel)this.traceLevelTable.get(componentId);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" createTrace: " + componentId + " level " + level + " messageType " + messageType + " message " + message + " cause " + cause + " time stamp " + timeStamp));
        }
        if (tl == null) {
            throw new UnrecognizedComponentException("Could not find " + componentId);
        }
        this.notificationTypes.add(messageType);
        Level lev = tl.getLevel();
        int seqno = tl.getSeqno();
        if (lev.isOff()) {
            return;
        }
        if (level.isHigherLevel(lev)) {
            TraceNotification traceNotification = new TraceNotification((TraceMBean)this.traceMBeanImpl, messageType, (Object)componentId, level, message, cause, (long)seqno, timeStamp);
            this.traceMBeanImpl.sendNotification((Notification)traceNotification);
        }
    }

    public String[] getNotificationTypes() {
        String[] ntypes = new String[this.notificationTypes.size()];
        Iterator it = this.notificationTypes.iterator();
        int i = 0;
        while (it.hasNext()) {
            ntypes[i++] = (String)it.next();
        }
        return ntypes;
    }

    class TraceLevel {
        private Level level;
        private int seqno;

        public TraceLevel(Level level) {
            this.level = level;
        }

        public int getSeqno() {
            return this.seqno++;
        }

        public Level getLevel() {
            return this.level;
        }
    }
}

