/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.runtime.transaction;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.SyncList;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.transaction.TransactionManagerImpl;
import org.mobicents.slee.runtime.transaction.TransactionalAction;

class TxLocalEntry {
    private SyncList afterCommitActions = new SyncList(new ArrayList(), (ReadWriteLock)new WriterPreferenceReadWriteLock());
    private SyncList afterRollbackActions = new SyncList(new ArrayList(), (ReadWriteLock)new WriterPreferenceReadWriteLock());
    private SyncList prepareActions = new SyncList(new ArrayList(), (ReadWriteLock)new WriterPreferenceReadWriteLock());
    private Map data;
    private String transaction;
    private static Logger logger = Logger.getLogger((Class)TxLocalEntry.class);

    public void addAfterCommitAction(TransactionalAction action) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("addAfterCommitAction " + action + " list " + this.afterCommitActions));
        }
        this.afterCommitActions.add((Object)action);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("after adding listLength is " + this.afterCommitActions.size()));
        }
    }

    public TxLocalEntry(String transaction) {
        this.transaction = transaction;
    }

    public void addPrepareAction(TransactionalAction action) {
        if (logger.isDebugEnabled()) {
            Integer exetran = null;
            try {
                exetran = TransactionManagerImpl.makeKey(SleeContainer.getTransactionManager().getTransaction());
            }
            catch (Exception ex) {
                exetran = null;
            }
            logger.debug((Object)("[ transaction owner = " + this.transaction + ", [current executing transaction = " + exetran + "]"));
        }
        this.prepareActions.add((Object)action);
    }

    public void addAfterRollbackAction(TransactionalAction action) {
        this.afterRollbackActions.add((Object)action);
    }

    public List getAfterCommitActions() {
        return this.afterCommitActions;
    }

    public List getAfterRollbackActions() {
        return this.afterRollbackActions;
    }

    public List getPrepareActions() {
        if (logger.isDebugEnabled()) {
            Integer exetran = null;
            try {
                exetran = TransactionManagerImpl.makeKey(SleeContainer.getTransactionManager().getTransaction());
            }
            catch (Exception ex) {
                exetran = null;
            }
            logger.debug((Object)("[ transaction owner = " + this.transaction + ", [current executing transaction = " + exetran + "]"));
        }
        return this.prepareActions;
    }

    public Object getData(Object key) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(key);
    }

    public void putData(Object key, Object value) {
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.data.put(key, value);
    }

    public void removeData(Object key) {
        if (this.data == null) {
            return;
        }
        this.data.remove(key);
    }

    public void executeAfterCommitActions() {
        if (this.afterCommitActions != null) {
            this.executeActions((List)this.afterCommitActions);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"No commit actions to execute");
        }
    }

    public void executePrepareActions() {
        if (this.prepareActions != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Executing prepare actions");
            }
            this.executeActions((List)this.prepareActions);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"No prepare actions to execute");
        }
    }

    public void executeAfterRollbackActions() {
        if (this.afterRollbackActions != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Executing rollback actions");
            }
            this.executeActions((List)this.afterRollbackActions);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"No rollback actions to execute");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeActions(List actions) {
        try {
            while (!actions.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"*** ITERATION");
                }
                TransactionalAction action = (TransactionalAction)actions.remove(0);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing action:" + action));
                }
                try {
                    action.execute();
                }
                catch (Throwable t) {
                    if (logger.isDebugEnabled()) {
                        logger.error((Object)("FAILED DURING PREPARE ACTION:" + t.getMessage()));
                    }
                    t.printStackTrace();
                    throw new RuntimeException("FAILED DURING ACTION:", t);
                    return;
                }
            }
        }
        catch (ConcurrentModificationException e) {
            Integer exetran = null;
            try {
                exetran = TransactionManagerImpl.makeKey(SleeContainer.getTransactionManager().getTransaction());
            }
            catch (Exception ex) {
                exetran = null;
            }
            String s = "unexpecting concurrent accesses of transaction data.  [ transaction owner = " + this.transaction + ", [current executing transaction = " + exetran + "]";
            logger.error((Object)s);
            throw e;
        }
    }
}

