/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.test.connector.ejb;

import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.resource.spi.ManagedConnection;
import javax.slee.EventTypeID;
import javax.slee.connection.ExternalActivityHandle;
import javax.slee.connection.SleeConnection;
import javax.slee.connection.SleeConnectionFactory;
import org.jboss.logging.Logger;
import org.mobicents.slee.connector.adaptor.SleeConnectionImpl;
import org.mobicents.slee.test.connector.TestEvent;

public class ConnectorTestEJB
implements SessionBean {
    private static Logger log = Logger.getLogger((Class)ConnectorTestEJB.class);
    private boolean failed = false;

    public void ejbCreate() {
    }

    public void ejbActivate() {
    }

    public void ejbRemove() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext ctx) {
    }

    private void doAssert(boolean b) {
        if (!b) {
            this.failed = true;
            log.debug((Object)"Failed assertion");
        }
    }

    public boolean test1() {
        try {
            this.failed = false;
            log.debug((Object)"Running JCA adaptor test1====================");
            InitialContext ic = new InitialContext();
            Context envCtx = (Context)new InitialContext().lookup("java:comp/env");
            envCtx.bind("foo", (Object)"bar");
            log.debug((Object)"Worked!!");
            SleeConnectionFactory factory = (SleeConnectionFactory)ic.lookup("java:/MobicentsConnectionFactory");
            log.debug((Object)"Looked up sleeconnectionfactory");
            SleeConnectionImpl conn1 = (SleeConnectionImpl)factory.getConnection();
            SleeConnectionImpl conn2 = (SleeConnectionImpl)factory.getConnection();
            log.debug((Object)("conn1 is: " + conn1));
            log.debug((Object)("conn2 is: " + conn2));
            ManagedConnection mc1 = conn1.getMC();
            ManagedConnection mc2 = conn2.getMC();
            log.debug((Object)("mc1 is: " + mc1));
            log.debug((Object)("mc2 is: " + mc2));
            conn1.close();
            conn2.close();
            log.debug((Object)"Closed them");
            conn1 = (SleeConnectionImpl)factory.getConnection();
            mc1 = conn1.getMC();
            conn1.close();
            conn2 = (SleeConnectionImpl)factory.getConnection();
            mc2 = conn2.getMC();
            log.debug((Object)("mc1 is: " + mc1));
            log.debug((Object)("mc2 is: " + mc2));
            conn2.close();
            return !this.failed;
        }
        catch (Throwable t) {
            log.error((Object)"Caught throwable in running JCA tests", t);
            return false;
        }
    }

    private boolean testNoHandle() {
        try {
            InitialContext ic = new InitialContext();
            SleeConnectionFactory factory = (SleeConnectionFactory)ic.lookup("java:/MobicentsConnectionFactory");
            log.debug((Object)"Looked up sleeconnectionfactory");
            SleeConnection conn1 = factory.getConnection();
            EventTypeID eventTypeOne = conn1.getEventTypeID("org.mobicents.slee.test.connector.TestEventTypeName", "mobicents", "0.1");
            log.debug((Object)("Event type is: " + eventTypeOne));
            TestEvent eventOne = new TestEvent("test 1");
            log.debug((Object)"Firing first event without activity handle");
            conn1.fireEvent((Object)eventOne, eventTypeOne, null, null);
            log.debug((Object)"Firing second event without activity handle");
            conn1.fireEvent((Object)eventOne, eventTypeOne, null, null);
            conn1.close();
            return !this.failed;
        }
        catch (Throwable t) {
            log.error((Object)"Caught throwable in running JCA tests", t);
            return false;
        }
    }

    public boolean test2() {
        log.debug((Object)"Running test2===============================");
        this.failed = false;
        return this.testNoHandle();
    }

    public boolean test3() {
        log.debug((Object)"Running test3======================================");
        this.failed = false;
        return this.testNoHandle();
    }

    private boolean testWithHandle() {
        try {
            InitialContext ic = new InitialContext();
            SleeConnectionFactory factory = (SleeConnectionFactory)ic.lookup("java:/MobicentsConnectionFactory");
            log.debug((Object)"Looked up sleeconnectionfactory");
            SleeConnection conn1 = factory.getConnection();
            EventTypeID eventTypeOne = conn1.getEventTypeID("org.mobicents.slee.test.connector.TestEventTypeName", "mobicents", "0.1");
            log.debug((Object)("Event type is: " + eventTypeOne));
            TestEvent eventOne = new TestEvent("test 1");
            ExternalActivityHandle handle = conn1.createActivityHandle();
            log.debug((Object)("Created activityhandle: " + handle));
            log.debug((Object)"Firing first event with activity handle");
            conn1.fireEvent((Object)eventOne, eventTypeOne, handle, null);
            log.debug((Object)"Firing second event with activity handle");
            conn1.fireEvent((Object)eventOne, eventTypeOne, handle, null);
            conn1.close();
            return !this.failed;
        }
        catch (Throwable t) {
            log.error((Object)"Caught throwable in running JCA tests", t);
            return false;
        }
    }

    public boolean test4() {
        log.debug((Object)"Running test4===================================");
        this.failed = false;
        return this.testWithHandle();
    }

    public boolean test5() {
        log.debug((Object)"Running test5=======================================");
        this.failed = false;
        return this.testWithHandle();
    }

    private boolean testWith2Handles() {
        try {
            InitialContext ic = new InitialContext();
            SleeConnectionFactory factory = (SleeConnectionFactory)ic.lookup("java:/MobicentsConnectionFactory");
            log.debug((Object)"Looked up sleeconnectionfactory");
            SleeConnection conn1 = factory.getConnection();
            EventTypeID eventTypeOne = conn1.getEventTypeID("org.mobicents.slee.test.connector.TestEventTypeName", "mobicents", "0.1");
            log.debug((Object)("Event type is: " + eventTypeOne));
            TestEvent eventOne = new TestEvent("test 1");
            ExternalActivityHandle handle1 = conn1.createActivityHandle();
            log.debug((Object)("Created activityhandle: " + handle1));
            log.debug((Object)"Firing first event without activity handle");
            conn1.fireEvent((Object)eventOne, eventTypeOne, handle1, null);
            ExternalActivityHandle handle2 = conn1.createActivityHandle();
            log.debug((Object)("Created activityhandle: " + handle2));
            log.debug((Object)"Firing second event without activity handle");
            conn1.fireEvent((Object)eventOne, eventTypeOne, handle2, null);
            conn1.close();
            return !this.failed;
        }
        catch (Throwable t) {
            log.error((Object)"Caught throwable in running JCA tests", t);
            return false;
        }
    }

    public boolean test6() {
        log.debug((Object)"Running test6=======================");
        this.failed = false;
        return this.testWith2Handles();
    }

    public boolean test7() {
        log.debug((Object)"Running test7=======================");
        this.failed = false;
        return this.testWith2Handles();
    }
}

