/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.test.junit;

import java.io.File;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestSuite;

public class AllTestsAgregator {
    public static final String testClassNamePattern = "Z\\w+Test\\.class";
    public static final String classes = "classes";
    static /* synthetic */ Class class$org$mobicents$slee$runtime$cache$tests$CacheAllTests;

    public static void main(String[] args) {
        AllTestsAgregator.suite();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String mobicents_HOME = System.getProperty("MOBICENTS_HOME");
        File rootDir = new File(mobicents_HOME + "/classes");
        if (!rootDir.exists()) {
            System.out.println("ERROR DIR[" + rootDir + "] DOES NOT EXIST");
            return suite;
        }
        suite.addTest(AllTestsAgregator.digInDir(rootDir));
        return suite;
    }

    private static Test digInDir(File dir) {
        TestSuite suite = new TestSuite();
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            File f = new File(dir, files[i]);
            if (f.isDirectory()) {
                suite.addTest(AllTestsAgregator.digInDir(f));
                continue;
            }
            String fileName = f.getName();
            if (!Pattern.matches(testClassNamePattern, fileName)) continue;
            String className = fileName.split("\\.")[0];
            String packageName = "";
            String parentName = f.getParentFile().getPath();
            int index = parentName.indexOf(classes);
            packageName = parentName.substring(index + classes.length() + 1, parentName.length());
            packageName = packageName.replace(File.separator.charAt(0), ".".charAt(0));
            Class<?> testClass = null;
            try {
                Class clazz = class$org$mobicents$slee$runtime$cache$tests$CacheAllTests == null ? AllTestsAgregator.class$("org.mobicents.slee.runtime.cache.tests.CacheAllTests") : class$org$mobicents$slee$runtime$cache$tests$CacheAllTests;
                testClass = Class.forName(packageName + "." + className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (testClass == null) {
                System.out.println("TESTS CLASS IS NULL");
                continue;
            }
            Method method = null;
            try {
                method = testClass.getMethod("suite", null);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            if (method != null) {
                System.out.println("ADDDING[" + testClass + "]");
                suite.addTestSuite(testClass);
                continue;
            }
            System.out.println("CLASS[" + testClass + "] MATCHES PATTERN BUT DOESNT HAVE suite() METHOD!!");
        }
        return suite;
    }
}

