/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.test.suite;

import com.opencloud.logging.Logable;
import com.opencloud.logging.PrintWriterLog;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.infra.SleeTCKTestUtilsImpl;
import com.opencloud.sleetck.lib.infra.eventbridge.BulkEventHandler;
import com.opencloud.sleetck.lib.infra.eventbridge.TCKEventBroadcaster;
import com.opencloud.sleetck.lib.infra.eventbridge.TCKEventListenerRegistry;
import com.opencloud.sleetck.lib.infra.eventbridge.TCKEventListenerRegistryImpl;
import com.opencloud.sleetck.lib.infra.jmx.MBeanFacadeAgentRemote;
import com.opencloud.sleetck.lib.infra.jmx.MBeanFacadeAgentRemoteImpl;
import com.opencloud.sleetck.lib.infra.jmx.MBeanFacadeImpl;
import com.opencloud.sleetck.lib.resource.impl.TCKResourceTestInterfaceProxy;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanFacade;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanProxyFactory;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.slee.ComponentID;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.facilities.Level;
import javax.slee.management.ComponentDescriptor;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.SbbDescriptor;
import javax.slee.management.ServiceDescriptor;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.jmx.connector.RemoteMBeanServer;
import org.mobicents.slee.test.suite.BulkEventHandlerImpl;
import org.mobicents.slee.test.suite.MBeanProxyFactoryImpl;
import org.mobicents.slee.test.suite.MBeanServerImpl;

public class JUnitSleeTestUtils
implements SleeTCKTestUtils {
    private Hashtable env;
    private Logable log;
    private RMIAdaptor rmiAdaptor;
    private Properties envParams;
    private Set activatedServiceIDs = new HashSet();
    private ObjectName sleeMBean;
    private ObjectName deploymentMBean;
    private ObjectName serviceManagementMBean;
    private ObjectName traceMBean;
    private ObjectName mgmtMBeanName;
    private HashSet deployableUnitIds = new HashSet();
    private TCKResourceTestInterface resourceInterface;
    private Properties testParameters = new Properties();
    private SleeManagementMBeanProxy sleeManagementMBeanProxy;
    private DeploymentMBeanProxy deploymentMBeanProxy;
    private ServiceManagementMBeanProxy serviceManagementMBeanProxy;
    private TraceMBeanProxy traceMBeanProxy;
    private ProfileProvisioningMBeanProxy profileProvisioningMBeanProxy;
    private MBeanFacadeImpl mbeanFacade;
    private MBeanProxyFactoryImpl mBeanProxyFactory;
    private RemoteMBeanServer server;
    public static String TCK_TEST_JARS;
    private ObjectName profileMBean;
    private Properties properties;
    private BulkEventHandlerImpl bulkEventHandler;
    private int testTimeout = 7000;

    public JUnitSleeTestUtils() throws Exception {
        this.envParams = new Properties();
        this.envParams.setProperty("sbbTraceLevel", new Integer(5).toString());
        this.log = new PrintWriterLog(new PrintWriter(System.out), 17, true, true);
        Registry rmiRegistry = LocateRegistry.getRegistry(4099);
        TCKResourceTestInterface remoteHandle = (TCKResourceTestInterface)rmiRegistry.lookup("TCKResourceTestInterface");
        this.resourceInterface = new TCKResourceTestInterfaceProxy(remoteHandle, this.log);
        this.env = new Hashtable();
        this.env.put("java.naming.provider.url", "jnp://localhost:1099");
        this.env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        this.env.put("java.naming.factory.url.pkgs", "org.jnp.interfaces");
        InitialContext ctx = new InitialContext(this.env);
        this.rmiAdaptor = (RMIAdaptor)ctx.lookup("jmx/rmi/RMIAdaptor");
        if (this.rmiAdaptor == null) {
            System.out.println("RMIAdaptor is null");
        }
        this.sleeMBean = new ObjectName("slee:service=SleeManagement");
        this.deploymentMBean = (ObjectName)this.invokeOperation(this.sleeMBean, "getDeploymentMBean", null, null);
        this.serviceManagementMBean = (ObjectName)this.invokeOperation(this.sleeMBean, "getServiceManagementMBean", null, null);
        this.traceMBean = (ObjectName)this.invokeOperation(this.sleeMBean, "getTraceMBean", null, null);
        this.profileMBean = (ObjectName)this.invokeOperation(this.sleeMBean, "getProfileProvisioningMBean", null, null);
        this.mBeanProxyFactory = new MBeanProxyFactoryImpl(this);
        this.deploymentMBeanProxy = this.mBeanProxyFactory.createDeploymentMBeanProxy(this.deploymentMBean);
        this.serviceManagementMBeanProxy = this.mBeanProxyFactory.createServiceManagementMBeanProxy(this.serviceManagementMBean);
        this.sleeManagementMBeanProxy = this.mBeanProxyFactory.createSleeManagementMBeanProxy(this.sleeMBean);
        this.traceMBeanProxy = this.mBeanProxyFactory.createTraceMBeanProxy(this.traceMBean);
        this.profileProvisioningMBeanProxy = this.mBeanProxyFactory.createProfileProvisioningMBeanProxy(this.profileMBean);
        MBeanServerImpl mbeanServer = new MBeanServerImpl(this);
        MBeanFacadeAgentRemoteImpl mbAgentRemote = new MBeanFacadeAgentRemoteImpl();
        mbAgentRemote.setMBeanServer((MBeanServer)mbeanServer);
        TCKEventBroadcaster eventBroadcaster = new TCKEventBroadcaster();
        this.bulkEventHandler = new BulkEventHandlerImpl();
        eventBroadcaster.setBulkEventHandler((BulkEventHandler)this.bulkEventHandler);
        mbAgentRemote.setEventBroadcaster(eventBroadcaster);
        this.mbeanFacade = new MBeanFacadeImpl(this.log);
        this.mbeanFacade.setMBeanFacadeAgentRemote((MBeanFacadeAgentRemote)mbAgentRemote);
        TCKEventListenerRegistryImpl eventListenerRegistry = new TCKEventListenerRegistryImpl();
        this.mbeanFacade.setListenerRegistry((TCKEventListenerRegistry)eventListenerRegistry);
        this.bulkEventHandler.setMBeanFacade(this.mbeanFacade);
    }

    public SleeTCKTestUtilsImpl createSleeTCKTestUtilsImpl() {
        return new SleeTCKTestUtilsImpl(this.testParameters, this.envParams, (MBeanFacade)this.mbeanFacade, (MBeanProxyFactory)this.mBeanProxyFactory, this.resourceInterface, this.log, this.sleeMBean, TCK_TEST_JARS, 10000, 10000);
    }

    public BulkEventHandlerImpl getBulkEventHandler() {
        return this.bulkEventHandler;
    }

    public RMIAdaptor getRMIAdapter() {
        return this.rmiAdaptor;
    }

    public JUnitSleeTestUtils(Properties properties) throws Exception {
        this();
        this.testParameters = properties;
    }

    public Object invokeOperation(ObjectName oname, String methodname, Object[] pParams, String[] pSignature) throws Exception {
        Object result = null;
        try {
            result = this.rmiAdaptor.invoke(oname, methodname, pParams, pSignature);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return result;
    }

    public Object getAttribute(ObjectName oname, String attributeName) throws Exception {
        Object result = null;
        try {
            result = this.rmiAdaptor.getAttribute(oname, attributeName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return result;
    }

    public void setAttribute(ObjectName oname, Attribute attribute) throws Exception {
        try {
            this.rmiAdaptor.setAttribute(oname, attribute);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Properties getTestParams() {
        return this.testParameters;
    }

    public Properties getEnvParams() {
        return null;
    }

    public int getDefaultTimeout() {
        return 5000;
    }

    public void setTestTimeout(int timeout) {
        this.testTimeout = timeout;
    }

    public int getTestTimeout() {
        return this.testTimeout;
    }

    public Logable getLog() {
        return this.log;
    }

    public MBeanFacade getMBeanFacade() {
        return this.mbeanFacade;
    }

    public MBeanProxyFactory getMBeanProxyFactory() {
        return this.mBeanProxyFactory;
    }

    public ObjectName getSleeManagementMBeanName() {
        return this.mgmtMBeanName;
    }

    public SleeManagementMBeanProxy getSleeManagementMBeanProxy() throws TCKTestErrorException {
        return this.sleeManagementMBeanProxy;
    }

    public String getDeploymentUnitURL(String deployableUnitName) {
        try {
            return new URL(deployableUnitName).toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public DeploymentMBeanProxy getDeploymentMBeanProxy() throws TCKTestErrorException {
        return this.deploymentMBeanProxy;
    }

    public ServiceManagementMBeanProxy getServiceManagementMBeanProxy() {
        return this.serviceManagementMBeanProxy;
    }

    public ObjectName getDeploymentMBeanName() {
        return this.deploymentMBean;
    }

    public DeployableUnitID install(String url) throws TCKTestErrorException {
        try {
            this.log.debug("URL is " + url);
            DeployableUnitID deployableUnitId = this.deploymentMBeanProxy.install(url);
            this.deployableUnitIds.add(deployableUnitId);
            return deployableUnitId;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TCKTestErrorException("error installing ", (Exception)e.getCause());
        }
    }

    public boolean uninstallAll() throws TCKTestErrorException {
        Iterator i = this.deployableUnitIds.iterator();
        while (i.hasNext()) {
            DeployableUnitID duid = (DeployableUnitID)i.next();
            try {
                this.deploymentMBeanProxy.uninstall(duid);
            }
            catch (Exception e) {
                throw new TCKTestErrorException("Could not uninstall DeployableUnit " + duid, e);
            }
        }
        return true;
    }

    private ServiceID[] getServices(DeployableUnitID duID) throws TCKTestErrorException {
        try {
            DeployableUnitDescriptor duDes = this.deploymentMBeanProxy.getDescriptor(duID);
            ComponentID[] componentIDs = duDes.getComponents();
            ServiceID[] serviceIDs = new ServiceID[componentIDs.length];
            int serviceCount = 0;
            for (int i = 0; i < componentIDs.length; ++i) {
                if (!(componentIDs[i] instanceof ServiceID)) continue;
                serviceIDs[serviceCount++] = (ServiceID)componentIDs[i];
            }
            if (serviceCount < serviceIDs.length) {
                ServiceID[] copyTo = new ServiceID[serviceCount];
                System.arraycopy(serviceIDs, 0, copyTo, 0, serviceCount);
                serviceIDs = copyTo;
            }
            return serviceIDs;
        }
        catch (Exception e) {
            throw new TCKTestErrorException("Caught Exception while trying to get ServiceIDs from DeployableUnitID " + duID, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceID[] activateServices(DeployableUnitID duID, boolean setTraceLevel) throws TCKTestErrorException {
        try {
            int traveLevelInt;
            String traceLevelString;
            Level traceLevel = null;
            if (setTraceLevel && (traceLevelString = this.envParams.getProperty("sbbTraceLevel")) != null && (traveLevelInt = Integer.parseInt(traceLevelString)) != 0) {
                traceLevel = Level.fromInt((int)traveLevelInt);
            }
            this.log.fine("Activating services for deployable unit " + duID);
            ServiceID[] serviceIDs = this.getServices(duID);
            Set set = this.activatedServiceIDs;
            synchronized (set) {
                for (int i = 0; i < serviceIDs.length; ++i) {
                    this.log.finer("Activating service " + serviceIDs[i]);
                    this.serviceManagementMBeanProxy.activate(serviceIDs[i]);
                    this.activatedServiceIDs.add(serviceIDs[i]);
                    if (traceLevel == null) continue;
                    ComponentDescriptor serviceDescriptor = this.deploymentMBeanProxy.getDescriptor((ComponentID)serviceIDs[i]);
                    SbbID rootSbbID = ((ServiceDescriptor)serviceDescriptor).getRootSbb();
                    this.setTraceLevelForSbbTree(rootSbbID, traceLevel);
                }
            }
            return serviceIDs;
        }
        catch (Exception e) {
            if (e instanceof TCKTestErrorException) {
                throw (TCKTestErrorException)((Object)e);
            }
            throw new TCKTestErrorException("Caught Exception while trying to activate service", e);
        }
    }

    private void setTraceLevelForSbbTree(SbbID rootSbbID, Level traceLevel) throws TCKTestErrorException {
        HashSet<SbbID> s = new HashSet<SbbID>();
        s.add(rootSbbID);
        this.setTraceLevelForSbbTree(rootSbbID, traceLevel, s);
    }

    private void setTraceLevelForSbbTree(SbbID rootSbbID, Level traceLevel, HashSet visited) throws TCKTestErrorException {
        try {
            SbbDescriptor sbbDescriptor = (SbbDescriptor)this.deploymentMBeanProxy.getDescriptor((ComponentID)rootSbbID);
            this.traceMBeanProxy.setTraceLevel((ComponentID)rootSbbID, traceLevel);
            SbbID[] sbbIDs = sbbDescriptor.getSbbs();
            if (sbbIDs != null) {
                for (int i = 0; i < sbbIDs.length; ++i) {
                    if (!visited.add(sbbIDs[i])) continue;
                    this.setTraceLevelForSbbTree(sbbIDs[i], traceLevel, visited);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof TCKTestErrorException) {
                throw (TCKTestErrorException)((Object)e);
            }
            throw new TCKTestErrorException("Caught Exception while trying to set trace level for SBB. sbbID=" + rootSbbID, e);
        }
    }

    public boolean deactivateAllServices() throws TCKTestErrorException {
        try {
            Iterator it = this.activatedServiceIDs.iterator();
            while (it.hasNext()) {
                ServiceID id = (ServiceID)it.next();
                this.serviceManagementMBeanProxy.deactivate(id);
            }
        }
        catch (Exception ex) {
            throw new TCKTestErrorException("Could not deactivate ", (Exception)ex.getCause());
        }
        return true;
    }

    public TraceMBeanProxy getTraceMBeanProxy() throws TCKTestErrorException {
        return this.traceMBeanProxy;
    }

    public ProfileProvisioningMBeanProxy getProfileProvisioningProxy() throws TCKTestErrorException {
        return this.profileProvisioningMBeanProxy;
    }

    public ProfileMBeanProxy getProfileMBeanProxy(ObjectName objectName) throws TCKTestErrorException {
        try {
            return this.mBeanProxyFactory.createProfileMBeanProxy(objectName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TCKTestErrorException("error getting the profileMBean proxy");
        }
    }

    public TCKResourceTestInterface getResourceInterface() {
        return this.resourceInterface;
    }

    static {
        try {
            TCK_TEST_JARS = new File("TckTestJars").toURL().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

