/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.test.suite;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanProxyFactory;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SbbUsageMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceUsageMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.AlarmMBeanProxyImpl;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javax.management.ObjectName;
import org.mobicents.slee.test.suite.JUnitSleeTestUtils;

public class MBeanProxyFactoryImpl
implements MBeanProxyFactory {
    private static ClassPool pool;
    private static String packagePrefix;
    private static String directory;
    private JUnitSleeTestUtils utils;
    private static Class deploymentMBeanProxy;
    private static Class serviceManagementMBeanProxy;
    private static Class sleeManagementMBeanProxy;
    private static Class traceMBeanProxy;
    private static Class profileProvisioningMBeanProxy;
    private static Class profileMBeanProxy;
    private static Class serviceUsageMBeanProxy;
    private static Class sbbUsageMBeanProxy;
    private static Class alarmMBeanProxy;
    private static Class mbeanFacade;

    public MBeanProxyFactoryImpl(JUnitSleeTestUtils utils) {
        this.utils = utils;
    }

    private static String getImplClassName(Class interfaceClass) {
        return packagePrefix + "." + interfaceClass.getName().substring(interfaceClass.getName().lastIndexOf(".") + 1) + "Impl";
    }

    public DeploymentMBeanProxy createDeploymentMBeanProxy(ObjectName objectName) {
        try {
            if (deploymentMBeanProxy == null) {
                deploymentMBeanProxy = this.generateMBeanProxy(packagePrefix, DeploymentMBeanProxy.class);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(DeploymentMBeanProxy.class)).writeFile(directory);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(DeploymentMBeanProxy.class)).detach();
            }
            Constructor cons = deploymentMBeanProxy.getConstructor(ObjectName.class, JUnitSleeTestUtils.class);
            return (DeploymentMBeanProxy)cons.newInstance(objectName, this.utils);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ServiceManagementMBeanProxy createServiceManagementMBeanProxy(ObjectName objectName) {
        try {
            if (serviceManagementMBeanProxy == null) {
                serviceManagementMBeanProxy = this.generateMBeanProxy(packagePrefix, ServiceManagementMBeanProxy.class);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(ServiceManagementMBeanProxy.class)).writeFile(directory);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(ServiceManagementMBeanProxy.class)).detach();
            }
            Constructor cons = serviceManagementMBeanProxy.getConstructor(ObjectName.class, JUnitSleeTestUtils.class);
            return (ServiceManagementMBeanProxy)cons.newInstance(objectName, this.utils);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public SleeManagementMBeanProxy createSleeManagementMBeanProxy(ObjectName objectName) {
        try {
            if (sleeManagementMBeanProxy == null) {
                sleeManagementMBeanProxy = this.generateMBeanProxy(packagePrefix, SleeManagementMBeanProxy.class);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(SleeManagementMBeanProxy.class)).writeFile(directory);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(SleeManagementMBeanProxy.class)).detach();
            }
            Constructor cons = sleeManagementMBeanProxy.getConstructor(ObjectName.class, JUnitSleeTestUtils.class);
            return (SleeManagementMBeanProxy)cons.newInstance(objectName, this.utils);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TraceMBeanProxy createTraceMBeanProxy(ObjectName objectName) {
        try {
            if (traceMBeanProxy == null) {
                traceMBeanProxy = this.generateMBeanProxy(packagePrefix, TraceMBeanProxy.class);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(TraceMBeanProxy.class)).writeFile(directory);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(TraceMBeanProxy.class)).detach();
            }
            Constructor cons = traceMBeanProxy.getConstructor(ObjectName.class, JUnitSleeTestUtils.class);
            return (TraceMBeanProxy)cons.newInstance(objectName, this.utils);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ProfileProvisioningMBeanProxy createProfileProvisioningMBeanProxy(ObjectName objectName) {
        try {
            if (profileProvisioningMBeanProxy == null) {
                profileProvisioningMBeanProxy = this.generateMBeanProxy(packagePrefix, ProfileProvisioningMBeanProxy.class);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(ProfileProvisioningMBeanProxy.class)).writeFile(directory);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(ProfileProvisioningMBeanProxy.class)).detach();
            }
            Constructor cons = profileProvisioningMBeanProxy.getConstructor(ObjectName.class, JUnitSleeTestUtils.class);
            return (ProfileProvisioningMBeanProxy)cons.newInstance(objectName, this.utils);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ProfileMBeanProxy createProfileMBeanProxy(ObjectName objectName) {
        try {
            if (profileMBeanProxy == null) {
                profileMBeanProxy = this.generateMBeanProxy(packagePrefix, ProfileMBeanProxy.class);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(ProfileMBeanProxy.class)).writeFile(directory);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(ProfileMBeanProxy.class)).detach();
            }
            Constructor cons = profileMBeanProxy.getConstructor(ObjectName.class, JUnitSleeTestUtils.class);
            return (ProfileMBeanProxy)cons.newInstance(objectName, this.utils);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Class generateMBeanProxy(String destinationPackageName, Class mbeanProxyInterfaceClass) throws Exception {
        if (pool == null) {
            throw new Exception("Could not find class path");
        }
        String classNameToBeGenerated = MBeanProxyFactoryImpl.getImplClassName(mbeanProxyInterfaceClass);
        CtClass ctClass = null;
        try {
            ctClass = pool.get(classNameToBeGenerated).getClassPool().makeClass(classNameToBeGenerated);
        }
        catch (NotFoundException nfe) {
            ctClass = pool.makeClass(classNameToBeGenerated);
        }
        CtClass[] params = new CtClass[]{pool.get(ObjectName.class.getName()), pool.get(JUnitSleeTestUtils.class.getName())};
        this.createConstructor(ctClass, params);
        CtClass interfaceClass = pool.get(mbeanProxyInterfaceClass.getName());
        ctClass.addInterface(interfaceClass);
        CtMethod[] methods = interfaceClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getName().equals("equals") || methods[i].getName().equals("clone") || methods[i].getName().equals("toString") || methods[i].getName().equals("finalize") || methods[i].getName().equals("hashCode") || methods[i].getName().equals("getClass") || methods[i].getName().equals("wait") || methods[i].getName().equals("notify") || methods[i].getName().equals("notifyAll")) continue;
            this.genMethod(methods[i], ctClass);
        }
        return ctClass.toClass();
    }

    private void genMethod(CtMethod method, CtClass ctClass) throws NotFoundException, CannotCompileException {
        int i;
        CtClass[] exceptions = method.getExceptionTypes();
        CtClass returnType = method.getReturnType();
        CtClass[] parameterTypes = method.getParameterTypes();
        String methodName = method.getName();
        String utils = MBeanProxyFactoryImpl.paramNameFromClassName(pool.get(JUnitSleeTestUtils.class.getName()));
        String oname = MBeanProxyFactoryImpl.paramNameFromClassName(pool.get(ObjectName.class.getName()));
        String body = "public " + returnType.getName() + " " + method.getName() + "(";
        for (i = 0; i < parameterTypes.length; ++i) {
            CtClass param = parameterTypes[i];
            String className = param.getName();
            body = body + className;
            body = body + " ";
            body = body + MBeanProxyFactoryImpl.paramNameFromClassName(param, i);
            if (i == parameterTypes.length - 1) continue;
            body = body + ",";
        }
        body = body + ") \n";
        if (exceptions.length != 0) {
            body = body + " throws ";
            for (i = 0; i < exceptions.length; ++i) {
                body = body + exceptions[i].getName();
                body = i != exceptions.length - 1 ? body + " , " : body + "\n ";
            }
        }
        body = body + " {\n";
        body = body + "try { \n";
        if (parameterTypes.length == 0) {
            body = body + "Object retval = ";
            body = body + utils + ".invokeOperation(" + oname + ",\"" + methodName + "\",(Object[])null,(String[])null);  \n";
        } else {
            body = body + "String[] sig =  new String[" + parameterTypes.length + "];";
            for (i = 0; i < parameterTypes.length; ++i) {
                if (!parameterTypes[i].isArray()) {
                    body = body + "sig[";
                    body = body + i;
                    body = body + "] =";
                    body = body + "\"";
                    body = body + parameterTypes[i].getName();
                    body = body + "\";\n";
                    continue;
                }
                body = body + "sig[";
                body = body + i;
                body = body + "] =";
                body = body + "\"[L";
                body = body + parameterTypes[i].getComponentType().getName();
                body = body + ";\";\n";
            }
            body = body + " Object[] args = new Object[" + parameterTypes.length + "];";
            for (i = 0; i < parameterTypes.length; ++i) {
                int parmNumber = i + 1;
                body = body + "args[";
                body = body + i;
                body = body + "] = ";
                body = body + MBeanProxyFactoryImpl.paramNameFromClassName(parameterTypes[i], i);
                body = body + "; \n";
            }
            body = body + "Object retval = ";
            body = body + utils + ".invokeOperation(" + oname + "," + "\"" + methodName + "\"," + "args, sig);\n";
        }
        if (returnType != CtClass.voidType) {
            if (returnType == CtClass.booleanType) {
                body = body + " return ((Boolean) retval).booleanValue();";
            } else if (returnType == CtClass.intType) {
                body = body + " return ((Integer) retval).intValue();";
            } else if (returnType == CtClass.longType) {
                body = body + "return ((Long) retval).longValue();";
            } else if (returnType == CtClass.byteType) {
                body = body + "return ((Byte) retval).byteValue();";
            } else if (returnType == CtClass.floatType) {
                body = body + "return ((Float) retval).floatValue();";
            }
            body = body + " return (" + returnType.getName() + ") retval; \n ";
        }
        body = body + " }\n ";
        body = body + " catch ( Exception ex ) {\n";
        body = body + " Exception cause = (Exception) ex.getCause();\n";
        for (i = 0; i < exceptions.length; ++i) {
            body = body + " if  ( cause instanceof " + exceptions[i].getName() + ")";
            body = body + "throw  (" + exceptions[i].getName() + ") (cause);\n";
        }
        body = body + "throw new " + TCKTestErrorException.class.getName() + "(\"unexpected exception\",cause);\n";
        body = body + " } \n";
        if (returnType != CtClass.voidType) {
            body = returnType == CtClass.booleanType ? body + "return false;" : (returnType == CtClass.byteType || returnType == CtClass.charType || returnType == CtClass.doubleType || returnType == CtClass.longType || returnType == CtClass.intType ? body + "return 0;" : body + "return null;");
        }
        body = body + "} \n";
        try {
            CtMethod newMethod = CtNewMethod.make((String)body, (CtClass)ctClass);
            ctClass.addMethod(newMethod);
        }
        catch (CannotCompileException ex) {
            System.out.println("body = " + body);
            throw ex;
        }
    }

    private void createConstructor(CtClass proxy, CtClass[] parameters) throws Exception {
        CtConstructor ctCons = new CtConstructor(parameters, proxy);
        String constructorBody = "{";
        for (int i = 0; i < parameters.length; ++i) {
            String parameterName = MBeanProxyFactoryImpl.paramNameFromClassName(parameters[i]);
            try {
                CtField ctField = new CtField(parameters[i], parameterName, proxy);
                ctField.setModifiers(2);
                proxy.addField(ctField);
            }
            catch (CannotCompileException cce) {
                cce.printStackTrace();
            }
            int paramNumber = i + 1;
            constructorBody = constructorBody + parameterName + "=$" + paramNumber + ";";
        }
        constructorBody = constructorBody + "}";
        ctCons.setBody(constructorBody);
        proxy.addConstructor(ctCons);
    }

    private static String paramNameFromClassName(CtClass parameter, int index) {
        return MBeanProxyFactoryImpl.paramNameFromClassName(parameter) + index;
    }

    private static String paramNameFromClassName(CtClass parameter) {
        String parameterName = parameter.getName();
        if ((parameterName = parameterName.substring(parameterName.lastIndexOf(".") + 1)).indexOf(91) != -1) {
            parameterName = parameterName.substring(0, parameterName.indexOf(91));
        }
        String firstCharLowerCase = parameterName.substring(0, 1).toLowerCase();
        parameterName = firstCharLowerCase.concat(parameterName.substring(1));
        return parameterName;
    }

    public AlarmMBeanProxy createAlarmMBeanProxy(ObjectName alarmMBeanName) {
        AlarmMBeanProxyImpl alarmMBeanProxy = new AlarmMBeanProxyImpl(alarmMBeanName, this.utils.getMBeanFacade());
        return alarmMBeanProxy;
    }

    public SbbUsageMBeanProxy createSbbUsageMBeanProxy(ObjectName objectName) {
        try {
            if (sbbUsageMBeanProxy == null) {
                sbbUsageMBeanProxy = this.generateMBeanProxy(packagePrefix, SbbUsageMBeanProxy.class);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(SbbUsageMBeanProxy.class)).writeFile(directory);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(SbbUsageMBeanProxy.class)).detach();
            }
            Constructor cons = sbbUsageMBeanProxy.getConstructor(ObjectName.class, JUnitSleeTestUtils.class);
            return (SbbUsageMBeanProxy)cons.newInstance(objectName, this.utils);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ServiceUsageMBeanProxy createServiceUsageMBeanProxy(ObjectName objectName) {
        try {
            if (serviceUsageMBeanProxy == null) {
                serviceUsageMBeanProxy = this.generateMBeanProxy(packagePrefix, ServiceUsageMBeanProxy.class);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(ServiceUsageMBeanProxy.class)).writeFile(directory);
                pool.get(MBeanProxyFactoryImpl.getImplClassName(ServiceUsageMBeanProxy.class)).detach();
            }
            Constructor cons = serviceUsageMBeanProxy.getConstructor(ObjectName.class, JUnitSleeTestUtils.class);
            return (ServiceUsageMBeanProxy)cons.newInstance(objectName, this.utils);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        packagePrefix = "org.mobicents.slee.test.suite";
        directory = "classes";
        try {
            pool = ClassPool.getDefault();
            pool.appendClassPath("classes");
            pool.appendClassPath("lib/slee_1_1.jar");
            StringTokenizer st = new StringTokenizer(packagePrefix, ".");
            while (st.hasMoreTokens()) {
                String dirElement = st.nextToken(".");
                directory = directory + "/" + dirElement;
            }
        }
        catch (NotFoundException ex) {
            pool = null;
        }
    }
}

