/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.test.suite.tckwrapper;

import com.opencloud.sleetck.lib.infra.sleeplugin.SleeTCKPlugin;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.slee.management.ComponentDescriptor;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.management.ResourceAdaptorIDImpl;
import org.mobicents.slee.resource.InstalledResourceAdaptor;
import org.mobicents.slee.resource.ResourceAdaptorDescriptorImpl;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorType;
import org.mobicents.slee.resource.ResourceAdaptorTypeDescriptorImpl;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.TCKActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.test.suite.tckwrapper.SleeTCKPluginWrapperMBean;
import sun.rmi.registry.RegistryImpl;

public class SleeTCKPluginWrapper
extends ServiceMBeanSupport
implements SleeTCKPluginWrapperMBean {
    private String tckPluginMBObjName;
    private ObjectInstance tckPluginMBean;
    private String tckPluginClassName;
    private int rmiRegistryPort;
    private String sleeProviderImpl;
    private Registry rmiRegistry;
    private static Logger logger = Logger.getLogger((Class)SleeContainer.class);

    public void startService() throws Exception {
        try {
            new RegistryImpl(this.getRMIRegistryPort());
        }
        catch (RemoteException re) {
            logger.info((Object)("RMIRegistry failed to bind on port " + this.getRMIRegistryPort() + ". This is expected in case of redeployment. The exception message is " + re.getMessage()));
        }
        MBeanServer mbserver = this.getServer();
        ObjectName objName = new ObjectName(this.tckPluginMBObjName);
        SleeTCKPlugin tckPlugin = new SleeTCKPlugin(this.rmiRegistryPort, this.sleeProviderImpl);
        this.tckPluginMBean = mbserver.registerMBean(tckPlugin, objName);
        this.initializeTCKResourceAdaptor();
    }

    public void stopService() throws Exception {
        MBeanServer mbserver = this.getServer();
        mbserver.unregisterMBean(this.tckPluginMBean.getObjectName());
    }

    public void setTCKPluginClassName(String newClName) {
        this.tckPluginClassName = newClName;
    }

    public String getTCKPluginClassName() {
        return this.tckPluginClassName;
    }

    public void setRMIRegistryPort(int port) {
        this.rmiRegistryPort = port;
    }

    public int getRMIRegistryPort() {
        return this.rmiRegistryPort;
    }

    public void setSleeProviderImpl(String provider) {
        this.sleeProviderImpl = provider;
    }

    public String getSleeProviderImpl() {
        return this.sleeProviderImpl;
    }

    public void setTCKPluginMBeanObjectName(String newMBObjectName) {
        this.tckPluginMBObjName = newMBObjectName;
    }

    public String getTCKPluginMBeanObjectName() {
        return this.tckPluginMBObjName;
    }

    protected void initializeTCKResourceAdaptor() {
        ResourceAdaptorTypeDescriptorImpl ratDescr = new ResourceAdaptorTypeDescriptorImpl();
        ratDescr.parseTckRA();
        ResourceAdaptorType raType = new ResourceAdaptorType(ratDescr);
        ResourceAdaptorTypeIDImpl key = raType.getResourceAdaptorTypeID();
        logger.info((Object)("Inserting RAType kye: " + key + " RAType: " + raType));
        SleeContainer slee = SleeContainer.lookupFromJndi();
        slee.addResourceAdaptorType(key, raType);
        ResourceAdaptorDescriptorImpl raDescr = new ResourceAdaptorDescriptorImpl();
        raDescr.parseTckRA();
        try {
            slee.install((ComponentDescriptor)raDescr, null);
            ResourceAdaptorIDImpl raID = new ResourceAdaptorIDImpl(raDescr.getName(), raDescr.getVendor(), raDescr.getVersion());
            Properties p = new Properties();
            ResourceAdaptorEntity raEntity = slee.createResourceAdaptorEntity(raID, "tck", p);
            slee.activateResourceAdaptorEntity("tck");
            slee.createResourceAdaptorEntityLink("slee/resources/tck", "tck");
            InstalledResourceAdaptor ira = slee.getInstalledResourceAdaptor(raID);
            ira.addResourceAdaptorEntity(raEntity);
        }
        catch (Exception e) {
            logger.error((Object)"Class for RA not found", (Throwable)e);
            throw new RuntimeException("Something bad happened while installing RA ", e);
        }
        TCKActivityContextInterfaceFactoryImpl acif = new TCKActivityContextInterfaceFactoryImpl(slee, "tck");
        SleeContainer.registerWithJndi("slee/resources", "tckacif", acif);
        slee.addActivityContextInterfaceFactory(key, acif);
    }
}

