/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.connector.adaptor;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.mobicents.slee.connector.adaptor.ManagedConnectionImpl;
import org.mobicents.slee.connector.adaptor.SleeConnectionFactoryImpl;
import org.mobicents.slee.connector.server.RemoteSleeService;

public class ManagedConnectionFactoryImpl
implements ManagedConnectionFactory,
Serializable {
    private static Logger log = Logger.getLogger(ManagedConnectionFactoryImpl.class);
    private String sleeJndiName;
    private RemoteSleeService rmiStub;
    private PrintWriter printWriter;

    public String getSleeJndiName() {
        log.debug((Object)"mcf.getSleeJndiName() called");
        return this.sleeJndiName;
    }

    public void setSleeJndiName(String name) {
        log.debug((Object)("mcf.setSleeJndiName() called with " + name));
        this.sleeJndiName = name;
    }

    public ManagedConnectionFactoryImpl() {
        log.debug((Object)"Creating ManagedConnectionFactoryImpl instance");
    }

    private synchronized void lookupRMIStub() {
        if (this.rmiStub == null) {
            try {
                InitialContext ctx = new InitialContext();
                log.debug((Object)("Looking up slee service with name " + this.sleeJndiName));
                this.rmiStub = (RemoteSleeService)ctx.lookup(this.sleeJndiName);
                log.debug((Object)("RMI Stub is: " + this.rmiStub));
            }
            catch (NamingException e) {
                log.error((Object)"Failed to lookup Slee service in JNDI ", (Throwable)e);
            }
        }
    }

    public Object createConnectionFactory() throws ResourceException {
        log.debug((Object)"createConnectionFactory() called");
        throw new ResourceException("Mobicents SLEE resource adaptor only works in managed environment!");
    }

    public Object createConnectionFactory(ConnectionManager connectionMgr) throws ResourceException {
        log.debug((Object)"createConnectionFactory(ConnectionManager connectionMgr) called");
        return new SleeConnectionFactoryImpl(connectionMgr, this);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        log.debug((Object)"createManagedConnection() called");
        this.lookupRMIStub();
        return new ManagedConnectionImpl(this.rmiStub);
    }

    public ManagedConnection matchManagedConnections(Set connections, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        log.debug((Object)"matchManagedConnections() called");
        if (connections.isEmpty()) {
            return null;
        }
        return (ManagedConnection)connections.iterator().next();
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.printWriter;
    }

    public void setLogWriter(PrintWriter writer) throws ResourceException {
        this.printWriter = writer;
    }
}

