/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.connector.adaptor;

import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.slee.Address;
import javax.slee.EventTypeID;
import javax.slee.connection.ExternalActivityHandle;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.mobicents.slee.connector.adaptor.ConnectionMetaDataImpl;
import org.mobicents.slee.connector.adaptor.SleeConnectionImpl;
import org.mobicents.slee.connector.server.EventInvocation;
import org.mobicents.slee.connector.server.RemoteSleeService;

public class ManagedConnectionImpl
implements ManagedConnection,
LocalTransaction {
    private static Logger log = Logger.getLogger(ManagedConnectionImpl.class);
    private static ConnectionMetaDataImpl metaData = new ConnectionMetaDataImpl();
    private RemoteSleeService rmiStub;
    private LinkedList listeners = new LinkedList();
    private LinkedList connectionHandles = new LinkedList();
    private ArrayList eventQueue = new ArrayList();
    private boolean destroyed;
    private PrintWriter printWriter;
    private boolean inTransaction;

    ManagedConnectionImpl(RemoteSleeService rmiStub) {
        log.debug((Object)"Creating ManagedConnectionImpl");
        this.rmiStub = rmiStub;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        log.debug((Object)"addConnectionEventListener() called");
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        log.debug((Object)"removeConnectionEventListener() called");
        this.listeners.remove(listener);
    }

    public void associateConnection(Object connection) throws ResourceException {
        log.debug((Object)"associateConnection() called");
        SleeConnectionImpl conn = (SleeConnectionImpl)connection;
        conn.getManagedConnection().removeConnectionHandle(conn);
        this.connectionHandles.add(conn);
        conn.setManagedConnection(this);
    }

    public void cleanup() throws ResourceException {
        log.debug((Object)("cleanUp() called on " + this));
        for (SleeConnectionImpl handle : this.connectionHandles) {
            handle.invalidate();
        }
        this.connectionHandles.clear();
    }

    public void destroy() throws ResourceException {
        log.debug((Object)("destroy() called on " + this));
        if (this.destroyed) {
            return;
        }
        this.cleanup();
        this.destroyed = true;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        log.debug((Object)("getConnection() called on " + this));
        if (this.destroyed) {
            throw new IllegalStateException("This ManagedConnection has already been destroyed!");
        }
        SleeConnectionImpl conn = new SleeConnectionImpl(this);
        this.connectionHandles.add(conn);
        return conn;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return metaData;
    }

    public XAResource getXAResource() throws ResourceException {
        return null;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        log.debug((Object)"getLocalTransaction() called");
        return this;
    }

    public void setLogWriter(PrintWriter pw) throws ResourceException {
        this.printWriter = pw;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.printWriter;
    }

    public void begin() throws ResourceException {
        log.debug((Object)"begin() called on local transaction");
        if (this.inTransaction) {
            throw new ResourceException("begin() called on transaction already in progress");
        }
        if (this.eventQueue.size() != 0) {
            throw new IllegalStateException("begin() called on transaction but events already in queue!");
        }
        this.inTransaction = true;
    }

    public void commit() throws ResourceException {
        log.debug((Object)"commit() called on local transaction");
        if (!this.inTransaction) {
            throw new ResourceException("commit() called on transaction but transaction not started");
        }
        this.sendQueuedEvents();
        this.eventQueue.clear();
        this.inTransaction = false;
    }

    public void rollback() throws ResourceException {
        log.debug((Object)"rollback() called on local transaction");
        if (!this.inTransaction) {
            throw new ResourceException("rollback() called on transaction but transaction not started");
        }
        this.eventQueue.clear();
        this.inTransaction = false;
    }

    private void removeConnectionHandle(SleeConnectionImpl connectionHandle) {
        log.debug((Object)"removeConnectionHandle() called");
        this.connectionHandles.remove(connectionHandle);
    }

    private void sendNotification(ConnectionEvent event) {
        log.debug((Object)("sendNotification() called with " + event + " eventID = " + event.getId()));
        block7: for (ConnectionEventListener listener : this.listeners) {
            switch (event.getId()) {
                case 1: {
                    listener.connectionClosed(event);
                    continue block7;
                }
                case 2: {
                    listener.localTransactionStarted(event);
                    continue block7;
                }
                case 3: {
                    listener.localTransactionCommitted(event);
                    continue block7;
                }
                case 4: {
                    listener.localTransactionRolledback(event);
                    continue block7;
                }
                case 5: {
                    listener.connectionErrorOccurred(event);
                    continue block7;
                }
            }
            throw new IllegalStateException("Invalid event id:" + event.getId());
        }
    }

    void handleClosed(SleeConnectionImpl handle) {
        log.debug((Object)"handleClosed() called");
        if (this.destroyed) {
            throw new IllegalStateException("Attempt to close a handle on a destroyed connection!");
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle((Object)handle);
        this.sendNotification(event);
        this.connectionHandles.remove(handle);
    }

    void connectionError(SleeConnectionImpl handle, Exception e) {
        log.debug((Object)"connectionError() called");
        if (this.destroyed) {
            throw new IllegalStateException("Attempt to signal a conection error on a destroyed connection!");
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5);
        event.setConnectionHandle((Object)handle);
        this.sendNotification(event);
    }

    ExternalActivityHandle createActivityHandle() throws ResourceException {
        log.debug((Object)"createActivityHandle() called");
        if (this.destroyed) {
            throw new IllegalStateException("Connection is destroyed!");
        }
        try {
            return this.rmiStub.createActivityHandle();
        }
        catch (RemoteException e) {
            String s = "Failed to invoke createActivityHandle";
            log.error((Object)s, (Throwable)e);
            ResourceException ex = new ResourceException(s);
            ex.setLinkedException((Exception)e);
            throw ex;
        }
    }

    EventTypeID getEventTypeID(String name, String vendor, String version) throws ResourceException {
        log.debug((Object)("getEventTypeID called:" + name + "," + vendor + "," + version));
        if (this.destroyed) {
            throw new IllegalStateException("Connection is destroyed!");
        }
        try {
            return this.rmiStub.getEventTypeID(name, vendor, version);
        }
        catch (RemoteException e) {
            String s = "Failed to invoke getEventTypeID";
            log.error((Object)s, (Throwable)e);
            ResourceException ex = new ResourceException(s);
            ex.setLinkedException((Exception)e);
            throw ex;
        }
    }

    void fireEvent(Object event, EventTypeID eventType, ExternalActivityHandle activityHandle, Address address) throws ResourceException {
        log.debug((Object)("fireEvent() called:" + event + "," + eventType + "," + activityHandle + "," + address));
        if (this.destroyed) {
            throw new IllegalStateException("Connection is destroyed!");
        }
        if (!this.inTransaction) {
            this.fireEventNow(event, eventType, activityHandle, address);
        } else {
            this.fireEventLater(event, eventType, activityHandle, address);
        }
    }

    private void fireEventNow(Object event, EventTypeID eventType, ExternalActivityHandle activityHandle, Address address) throws ResourceException {
        log.debug((Object)("Firing single event on SLEE:" + event));
        try {
            this.rmiStub.fireEvent(event, eventType, activityHandle, address);
        }
        catch (RemoteException e) {
            String s = "Failed to invoke fireEvent";
            log.error((Object)s, (Throwable)e);
            ResourceException ex = new ResourceException(s);
            ex.setLinkedException((Exception)e);
            throw ex;
        }
    }

    private void fireEventLater(Object event, EventTypeID eventType, ExternalActivityHandle activityHandle, Address address) {
        log.debug((Object)"Adding event to event queue");
        EventInvocation ei = new EventInvocation(event, eventType, activityHandle, address);
        this.eventQueue.add(ei);
    }

    private void sendQueuedEvents() throws ResourceException {
        log.debug((Object)("Firing queue of events on SLEE: " + this.eventQueue.size()));
        try {
            this.rmiStub.fireEventQueue(this.eventQueue);
        }
        catch (RemoteException e) {
            String s = "Failed to invoke fireEventQueue";
            log.error((Object)s, (Throwable)e);
            ResourceException ex = new ResourceException(s);
            ex.setLinkedException((Exception)e);
            throw ex;
        }
    }
}

