/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.SyncMap;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import com.opencloud.sleetck.lib.resource.sbbapi.TransactionIDAccess;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TreeSet;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.slee.ActivityContextInterface;
import javax.slee.Address;
import javax.slee.ComponentID;
import javax.slee.CreateException;
import javax.slee.EventTypeID;
import javax.slee.InvalidArgumentException;
import javax.slee.InvalidStateException;
import javax.slee.SLEEException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.UnrecognizedServiceException;
import javax.slee.facilities.ActivityContextNamingFacility;
import javax.slee.facilities.Level;
import javax.slee.facilities.TimerFacility;
import javax.slee.management.AlreadyDeployedException;
import javax.slee.management.ComponentDescriptor;
import javax.slee.management.DependencyException;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.DeploymentException;
import javax.slee.management.ManagementException;
import javax.slee.management.ResourceAdaptorEntityAlreadyExistsException;
import javax.slee.management.ResourceAdaptorEntityState;
import javax.slee.management.SbbDescriptor;
import javax.slee.management.ServiceManagementMBean;
import javax.slee.management.ServiceState;
import javax.slee.management.SleeManagementMBean;
import javax.slee.management.SleeState;
import javax.slee.management.UnrecognizedDeployableUnitException;
import javax.slee.management.UnrecognizedLinkNameException;
import javax.slee.management.UnrecognizedResourceAdaptorEntityException;
import javax.slee.management.UnrecognizedResourceAdaptorException;
import javax.slee.nullactivity.NullActivityFactory;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileSpecificationDescriptor;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.resource.ResourceAdaptorID;
import javax.slee.resource.ResourceAdaptorTypeDescriptor;
import javax.slee.resource.ResourceAdaptorTypeID;
import javax.slee.resource.ResourceException;
import javax.transaction.SystemException;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.commons.pool.impl.GenericObjectPoolFactory;
import org.jboss.ha.framework.interfaces.FirstAvailable;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HARMIServerImpl;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.UnifiedClassLoader3;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.util.naming.NonSerializableFactory;
import org.jboss.util.naming.Util;
import org.mobicents.slee.connector.server.RemoteSleeService;
import org.mobicents.slee.connector.server.RemoteSleeServiceImpl;
import org.mobicents.slee.container.DeploymentCacheManager;
import org.mobicents.slee.container.SleeContainerLingeringServiceSbbRemoverTask;
import org.mobicents.slee.container.component.ComponentContainer;
import org.mobicents.slee.container.component.ComponentIDImpl;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.DeployableUnitDescriptorImpl;
import org.mobicents.slee.container.component.DeployableUnitIDImpl;
import org.mobicents.slee.container.component.EJBReference;
import org.mobicents.slee.container.component.EnvironmentEntry;
import org.mobicents.slee.container.component.EventTypeIDImpl;
import org.mobicents.slee.container.component.MobicentsEventTypeDescriptor;
import org.mobicents.slee.container.component.MobicentsResourceAdaptorTypeBinding;
import org.mobicents.slee.container.component.MobicentsSbbDescriptor;
import org.mobicents.slee.container.component.ProfileSpecificationDescriptorImpl;
import org.mobicents.slee.container.component.ProfileSpecificationIDImpl;
import org.mobicents.slee.container.component.ResourceAdaptorEntityBinding;
import org.mobicents.slee.container.component.ResourceAdaptorIDImpl;
import org.mobicents.slee.container.component.SbbEventEntry;
import org.mobicents.slee.container.component.SbbIDImpl;
import org.mobicents.slee.container.component.ServiceDescriptorImpl;
import org.mobicents.slee.container.component.ServiceIDImpl;
import org.mobicents.slee.container.component.deployment.DeploymentManager;
import org.mobicents.slee.container.component.deployment.EventTypeDeploymentDescriptorParser;
import org.mobicents.slee.container.component.deployment.ProfileSpecificationDescriptorParser;
import org.mobicents.slee.container.deployment.ConcreteClassGeneratorUtils;
import org.mobicents.slee.container.deployment.RaTypeDeployer;
import org.mobicents.slee.container.deployment.SbbDeployer;
import org.mobicents.slee.container.management.jmx.AlarmMBeanImpl;
import org.mobicents.slee.container.management.jmx.ComponentIDArrayPropertyEditor;
import org.mobicents.slee.container.management.jmx.ComponentIDPropertyEditor;
import org.mobicents.slee.container.management.jmx.DeployableUnitIDPropertyEditor;
import org.mobicents.slee.container.management.jmx.LevelPropertyEditor;
import org.mobicents.slee.container.management.jmx.ObjectPropertyEditor;
import org.mobicents.slee.container.management.jmx.PropertiesPropertyEditor;
import org.mobicents.slee.container.management.jmx.ServiceStatePropertyEditor;
import org.mobicents.slee.container.management.jmx.ServiceUsageMBeanImpl;
import org.mobicents.slee.container.management.xml.DefaultSleeEntityResolver;
import org.mobicents.slee.container.profile.ProfileDeployer;
import org.mobicents.slee.container.profile.ProfileSpecificationIDPropertyEditor;
import org.mobicents.slee.container.profile.ProfileVerifier;
import org.mobicents.slee.container.service.Service;
import org.mobicents.slee.container.service.ServiceComponent;
import org.mobicents.slee.resource.ConfigPropertyDescriptor;
import org.mobicents.slee.resource.EventLookup;
import org.mobicents.slee.resource.EventLookupFacilityImpl;
import org.mobicents.slee.resource.InstalledResourceAdaptor;
import org.mobicents.slee.resource.ResourceAdaptorActivityContextInterfaceFactory;
import org.mobicents.slee.resource.ResourceAdaptorBoostrapContext;
import org.mobicents.slee.resource.ResourceAdaptorContext;
import org.mobicents.slee.resource.ResourceAdaptorDescriptorImpl;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorType;
import org.mobicents.slee.resource.ResourceAdaptorTypeDescriptorImpl;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.SleeEndpointImpl;
import org.mobicents.slee.resource.TCKActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextFactoryImpl;
import org.mobicents.slee.runtime.ActivityContextState;
import org.mobicents.slee.runtime.EventRouter;
import org.mobicents.slee.runtime.EventRouterImpl;
import org.mobicents.slee.runtime.SbbEntityFactory;
import org.mobicents.slee.runtime.SbbObjectPoolFactory;
import org.mobicents.slee.runtime.SleeInternalEndpoint;
import org.mobicents.slee.runtime.SleeInternalEndpointImpl;
import org.mobicents.slee.runtime.cache.CacheableSet;
import org.mobicents.slee.runtime.facilities.ActivityContextNamingFacilityImpl;
import org.mobicents.slee.runtime.facilities.AlarmFacilityImpl;
import org.mobicents.slee.runtime.facilities.NullActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.runtime.facilities.NullActivityFactoryImpl;
import org.mobicents.slee.runtime.facilities.ProfileFacilityImpl;
import org.mobicents.slee.runtime.facilities.ProfileTableActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.runtime.facilities.TimerFacilityImpl;
import org.mobicents.slee.runtime.facilities.TraceFacilityImpl;
import org.mobicents.slee.runtime.serviceactivity.ServiceActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.runtime.serviceactivity.ServiceActivityImpl;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;
import org.mobicents.slee.runtime.transaction.TransactionIDAccessImpl;
import org.mobicents.slee.runtime.transaction.TransactionManagerImpl;

public class SleeContainer
implements ComponentContainer {
    public static boolean isSecurityEnabled = false;
    private static final String JNDI_NAME = "container";
    public static final String JVM_ENV = "java:";
    public static final String COMP_ENV = "java:comp/env";
    private static final String CTX_SLEE = "slee";
    private SleeState sleeState;
    private HashMap sbbPooling;
    private GenericObjectPool.Config poolConfig;
    private EventLookup eventLookup;
    private HashMap eventTypeIDToDescriptor;
    private HashMap eventKeyToEventTypeIDMap;
    private HashMap eventTypeIDs;
    private ActivityContextFactoryImpl activityContextFactory;
    private SleeInternalEndpoint sleeEndpoint;
    private EventRouter router;
    private DeploymentManager deploymentManager;
    private ServiceActivityContextInterfaceFactoryImpl serviceActivityContextInterfaceFactory;
    private NullActivityContextInterfaceFactoryImpl nullActivityContextInterfaceFactory;
    private static TimerFacilityImpl timerFacility;
    private ProfileFacilityImpl profileFacility;
    private HashMap eventTypeIDToEventKeyMap;
    private static final Logger logger;
    private ActivityContextNamingFacilityImpl activityContextNamingFacility;
    private HARMIServerImpl rmiServer;
    private SbbEntityFactory sbbEntityFactory;
    private HashMap resourceAdaptorTypes;
    private HashMap installedResourceAdaptors;
    private HashMap resourceAdaptorEntityLinks;
    private HashMap resourceAdaptorEntities;
    private ResourceAdaptorContext bootstrapContext;
    private HashMap activityContextInterfaceFactories;
    private NullActivityFactoryImpl nullActivityFactory;
    private ProfileTableActivityContextInterfaceFactoryImpl profileTableActivityContextInterfaceFactory;
    private TransactionIDAccess transactionIDAccess;
    private MBeanServer mbeanServer;
    private ServiceManagementMBean serviceManagementMBean;
    private Timer sbbEntityRemoverTimer = null;
    private Map sevriceIdsToRemovalTasks = new SyncMap(new HashMap(), (ReadWriteLock)new WriterPreferenceReadWriteLock());
    private ClassLoader loader;
    private DeploymentCacheManager deploymentCacheManager;
    private static SleeContainer sleeContainer;
    private static SleeTransactionManager sleeTransactionManager;
    private static String deployPath;

    private DeploymentCacheManager getDeploymentCacheManager() {
        if (this.deploymentCacheManager == null) {
            this.deploymentCacheManager = new DeploymentCacheManager();
        }
        return this.deploymentCacheManager;
    }

    private static void initDeployPath() {
        URL url = SleeContainer.class.getResource("/");
        try {
            URI uri = new URI(url.toExternalForm());
            File file = new File(uri);
            deployPath = file.getAbsolutePath();
        }
        catch (URISyntaxException e) {
            logger.error((Object)"Failed to establish path to Mobicents root deployment directory (mobicents.sar)", (Throwable)e);
            deployPath = null;
        }
    }

    public static String getDeployPath() {
        return deployPath;
    }

    public DeploymentCacheManager getDeploymentManager() {
        return this.deploymentCacheManager;
    }

    public static TraceFacilityImpl getTraceFacility() throws NamingException {
        return (TraceFacilityImpl)SleeContainer.lookupFacilityInJndi("trace");
    }

    public static AlarmFacilityImpl getAlarmFacility() throws NamingException {
        return (AlarmFacilityImpl)SleeContainer.lookupFacilityInJndi(AlarmMBeanImpl.JNDI_NAME);
    }

    public static ProfileTableActivityContextInterfaceFactoryImpl getProfileTableActivityContextInterfaceFactory() throws NamingException {
        return (ProfileTableActivityContextInterfaceFactoryImpl)SleeContainer.lookupFacilityInJndi(ProfileTableActivityContextInterfaceFactoryImpl.JNDI_NAME);
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public ServiceManagementMBean getServiceManagementMBean() {
        return this.serviceManagementMBean;
    }

    public void init(SleeManagementMBean sleeManagementMBean) throws Exception {
        logger.info((Object)"Initializing Slee");
        this.initNamingContexts();
        this.serviceManagementMBean = (ServiceManagementMBean)MBeanProxy.get(ServiceManagementMBean.class, (ObjectName)sleeManagementMBean.getServiceManagementMBean(), (MBeanServer)this.mbeanServer);
        ConcreteClassGeneratorUtils.class.getClass();
        DefaultSleeEntityResolver.init(this.getClass().getClassLoader());
        this.poolConfig = this.configurePooling();
        this.sbbPooling = new HashMap();
        this.sbbEntityFactory = new SbbEntityFactory(this);
        this.deploymentManager = new DeploymentManager();
        this.eventTypeIDs = new HashMap();
        this.eventTypeIDToDescriptor = new HashMap();
        this.eventKeyToEventTypeIDMap = new HashMap();
        this.transactionIDAccess = new TransactionIDAccessImpl((TransactionManagerImpl)SleeContainer.getTransactionManager());
        this.eventLookup = new EventLookup(this);
        this.eventTypeIDToEventKeyMap = new HashMap();
        this.deployStandardEvents();
        this.deployStandardProfileSpecs();
        this.activityContextFactory = new ActivityContextFactoryImpl(this);
        this.router = new EventRouterImpl(this);
        this.sleeEndpoint = new SleeInternalEndpointImpl(this.activityContextFactory, this.router, this);
        this.activityContextNamingFacility = new ActivityContextNamingFacilityImpl();
        SleeContainer.registerWithJndi("slee/facilities", "activitycontextnaming", this.activityContextNamingFacility);
        this.nullActivityContextInterfaceFactory = new NullActivityContextInterfaceFactoryImpl(this);
        SleeContainer.registerWithJndi("slee/nullactivity", "nullactivitycontextinterfacefactory", this.nullActivityContextInterfaceFactory);
        this.nullActivityFactory = new NullActivityFactoryImpl(this);
        SleeContainer.registerWithJndi("slee/nullactivity", "nullactivityfactory", this.nullActivityFactory);
        this.profileTableActivityContextInterfaceFactory = new ProfileTableActivityContextInterfaceFactoryImpl();
        SleeContainer.registerWithJndi("slee/facilities", ProfileTableActivityContextInterfaceFactoryImpl.JNDI_NAME, this.profileTableActivityContextInterfaceFactory);
        timerFacility = new TimerFacilityImpl(this);
        SleeContainer.registerWithJndi("slee/facilities", "timer", timerFacility);
        this.profileFacility = new ProfileFacilityImpl();
        SleeContainer.registerWithJndi("slee/facilities", "profile", this.profileFacility);
        this.serviceActivityContextInterfaceFactory = new ServiceActivityContextInterfaceFactoryImpl(this);
        SleeContainer.registerWithJndi("slee/serviceactivity/", ServiceActivityContextInterfaceFactoryImpl.JNDI_NAME, this.serviceActivityContextInterfaceFactory);
        this.bootstrapContext = new ResourceAdaptorContext(this.getSleeEndpoint(), this.getEventLookupFacility());
        this.resourceAdaptorTypes = new HashMap();
        this.resourceAdaptorEntities = new HashMap();
        this.installedResourceAdaptors = new HashMap();
        this.resourceAdaptorEntityLinks = new HashMap();
        this.activityContextInterfaceFactories = new HashMap();
        this.registerWithJndi();
        this.startRMIServer(this.nullActivityFactory, this.sleeEndpoint, this.eventLookup);
        this.registerPropertyEditors();
        this.sbbEntityRemoverTimer = new Timer();
    }

    private GenericObjectPool.Config configurePooling() {
        GenericObjectPool.Config conf = new GenericObjectPool.Config();
        conf.maxActive = -1;
        conf.maxIdle = -1;
        conf.maxWait = -1L;
        conf.minEvictableIdleTimeMillis = -1L;
        conf.minIdle = 5;
        conf.numTestsPerEvictionRun = -1;
        conf.testOnBorrow = false;
        conf.testOnReturn = false;
        conf.testWhileIdle = false;
        conf.timeBetweenEvictionRunsMillis = -1L;
        conf.whenExhaustedAction = 0;
        return conf;
    }

    private void registerWithJndi() {
        SleeContainer.registerWithJndi(CTX_SLEE, JNDI_NAME, this);
    }

    private void unregisterWithJndi() {
        SleeContainer.unregisterWithJndi("slee/container");
    }

    public static SleeContainer lookupFromJndi() {
        try {
            if (sleeContainer != null) {
                return sleeContainer;
            }
            sleeContainer = (SleeContainer)SleeContainer.getFromJndi("slee/container");
            return sleeContainer;
        }
        catch (Exception ex) {
            logger.error((Object)"Unexpected error: Cannot retrieve SLEE Container!", (Throwable)ex);
            return null;
        }
    }

    private void startRMIServer(NullActivityFactory naf, SleeInternalEndpoint endpoint, EventLookup eventLookup) {
        try {
            logger.debug((Object)"Starting Slee Service RMI Server");
            InitialContext ctx = new InitialContext();
            HAPartition myPartition = (HAPartition)ctx.lookup("/HAPartition/DefaultPartition");
            this.rmiServer = new HARMIServerImpl(myPartition, "RemoteSleeService", RemoteSleeService.class, (Object)new RemoteSleeServiceImpl(naf, endpoint, eventLookup, this.activityContextFactory));
            RemoteSleeService stub = (RemoteSleeService)this.rmiServer.createHAStub((LoadBalancePolicy)new FirstAvailable());
            logger.debug((Object)"Created SleeService rmi stub");
            ctx.rebind("/SleeService", (Object)stub);
            logger.debug((Object)"Bound SleeService rmi stub in jndi");
        }
        catch (Exception e) {
            logger.error((Object)"Failed to start HA RMI server for Remote slee service", (Throwable)e);
        }
    }

    private void stopRMIServer() {
        try {
            logger.debug((Object)"Stopping RMI Server for slee service");
            InitialContext ctx = new InitialContext();
            Util.unbind((Context)ctx, (String)"/SleeService");
            this.rmiServer.destroy();
        }
        catch (NamingException e) {
            logger.error((Object)"Failed to stop HA RMI Server for remote slee service", (Throwable)e);
        }
    }

    public void initializeServices() throws Exception {
        try {
            this.deploymentManager.deployAllUnitsAtLocation(SleeContainer.getDeployPath() + "/deploy", SleeContainer.getDeployPath(), this);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new Exception(ex.getMessage());
        }
    }

    public synchronized void startService(ServiceID serviceID) throws UnrecognizedServiceException, InvalidStateException {
        if (serviceID == null) {
            throw new NullPointerException("null service id");
        }
        SleeTransactionManager transactionManager = SleeContainer.getTransactionManager();
        boolean b = transactionManager.requireTransaction();
        boolean rb = true;
        try {
            Service service = this.getService(serviceID);
            if (service == null) {
                throw new UnrecognizedServiceException("unrecognized service " + serviceID);
            }
            if (service.getState().equals((Object)ServiceState.ACTIVE)) {
                this.getDeploymentCacheManager().getActiveServiceIDs().add(serviceID);
                throw new InvalidStateException("Service already active");
            }
            ServiceComponent svcComponent = this.getServiceComponent(serviceID);
            HashSet sbbIDs = svcComponent.getSbbComponents();
            HashSet<ResourceAdaptorEntity> raEntities = new HashSet<ResourceAdaptorEntity>();
            Iterator i = sbbIDs.iterator();
            while (i.hasNext()) {
                SbbDescriptor sbbdesc = this.getSbbComponent((SbbID)i.next());
                if (sbbdesc == null) continue;
                String[] raLinks = sbbdesc.getResourceAdaptorEntityLinks();
                for (int c = 0; raLinks != null && c < raLinks.length; ++c) {
                    ResourceAdaptorEntity raEntity = this.getRAEntity(raLinks[c]);
                    if (raEntity == null || raEntities.contains(raEntity)) continue;
                    raEntity.serviceActivated(serviceID.toString());
                    raEntities.add(raEntity);
                }
            }
            service.activate();
            this.getDeploymentCacheManager().getActiveServiceIDs().add(serviceID);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Service Activated. Service ID: " + serviceID));
            }
            svcComponent.lock();
            rb = false;
        }
        catch (InvalidStateException ise) {
            throw ise;
        }
        catch (UnrecognizedServiceException use) {
            throw use;
        }
        catch (Exception ex) {
            throw new SLEEException("Failed starting service", (Throwable)ex);
        }
        finally {
            try {
                if (rb) {
                    transactionManager.setRollbackOnly();
                }
                if (b) {
                    transactionManager.commit();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed: transaction commit", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reviveAndStartService(ServiceID serviceID) throws Exception {
        SleeTransactionManager txmgr = SleeContainer.getTransactionManager();
        txmgr.begin();
        try {
            Service svc = this.getService(serviceID);
            ServiceActivityImpl svcActivity = svc.getServiceActivity();
            String acid = svcActivity.getActivityContextId();
            ActivityContext ac = this.getActivityContextFactory().getActivityContextById(acid);
            ac.setState(ActivityContextState.ACTIVE);
            this.startService(serviceID);
        }
        catch (Exception ex) {
            txmgr.setRollbackOnly();
        }
        finally {
            try {
                txmgr.commit();
            }
            catch (SystemException ex) {
                throw new RuntimeException("txmgr failed", ex);
            }
        }
    }

    public ResourceAdaptorEntity getResourceAdaptorEntity(ResourceAdaptorTypeID raTypeID) throws Exception {
        ResourceAdaptorType raType = (ResourceAdaptorType)this.resourceAdaptorTypes.get(raTypeID);
        if (raType == null) {
            throw new Exception("Ra Type not found! ");
        }
        HashSet resourceAdaptors = raType.getResourceAdaptorIDs();
        if (resourceAdaptors == null || resourceAdaptors.isEmpty()) {
            throw new Exception("Could not find a resource adaptor for this type: " + raTypeID);
        }
        ResourceAdaptorIDImpl raId = (ResourceAdaptorIDImpl)resourceAdaptors.iterator().next();
        InstalledResourceAdaptor installedRa = (InstalledResourceAdaptor)this.installedResourceAdaptors.get(raId);
        if (installedRa.getResourceAdaptorEntities().size() == 0) {
            throw new Exception("cannot find RA Entity! ");
        }
        return (ResourceAdaptorEntity)installedRa.getResourceAdaptorEntities().iterator().next();
    }

    public InstalledResourceAdaptor getInstalledResourceAdaptor(ResourceAdaptorID raId) throws Exception {
        InstalledResourceAdaptor installedRa = (InstalledResourceAdaptor)this.installedResourceAdaptors.get(raId);
        return installedRa;
    }

    public void closeTckResourceAdaptor() {
        SleeContainer.unregisterWithJndi("slee/resources", "tckacif");
        try {
            this.deactivateResourceAdaptorEntity("tck");
            this.resourceAdaptorEntityLinks.remove("slee/resources/tck");
        }
        catch (Exception e) {
            logger.error((Object)"Error Closing RA", (Throwable)e);
        }
    }

    public void activateResourceAdaptorEntity(String name) throws UnrecognizedResourceAdaptorEntityException, InvalidStateException, ResourceException, ManagementException {
        if (this.resourceAdaptorEntities.get(name) == null) {
            throw new UnrecognizedResourceAdaptorEntityException("Resource Adaptor Entity " + name + " not found.");
        }
        ResourceAdaptorEntity raEntity = (ResourceAdaptorEntity)this.resourceAdaptorEntities.get(name);
        raEntity.activate();
    }

    public void addResourceAdaptorType(ResourceAdaptorTypeID key, ResourceAdaptorType rat) {
        this.resourceAdaptorTypes.put(key, rat);
    }

    public HashMap getResourceAdaptorTypes() {
        return this.resourceAdaptorTypes;
    }

    public void close() throws NamingException {
        this.unregisterWithJndi();
        InitialContext ctx = new InitialContext();
        Util.unbind((Context)ctx, (String)"java:slee");
        this.closeTckResourceAdaptor();
        this.stopRMIServer();
    }

    private void deployStandardEvents() throws Exception {
        logger.info((Object)"Deploying standard events.");
        List stdEvents = EventTypeDeploymentDescriptorParser.parseStandardEvents(SleeContainer.getDeployPath() + "/xml/slee-event-jar.xml");
        for (MobicentsEventTypeDescriptor etype : stdEvents) {
            this.installEventType(etype);
        }
        stdEvents = EventTypeDeploymentDescriptorParser.parseStandardEvents(SleeContainer.getDeployPath() + "/xml/event-jar.xml");
        for (MobicentsEventTypeDescriptor etype : stdEvents) {
            this.installEventType(etype);
        }
    }

    private void deployStandardProfileSpecs() throws Exception {
        logger.info((Object)"Deploying standard profile specs.");
        List stdProfileSpecs = ProfileSpecificationDescriptorParser.parseStandardProfileSpecifications(SleeContainer.getDeployPath() + "/xml/slee-profile-spec-jar.xml");
        for (ProfileSpecificationDescriptorImpl profileSpecification : stdProfileSpecs) {
            this.install((ComponentDescriptor)profileSpecification, null);
        }
    }

    private void installEventType(MobicentsEventTypeDescriptor descriptorImpl) throws AlreadyDeployedException {
        ComponentKey ckey = new ComponentKey(descriptorImpl.getName(), descriptorImpl.getVendor(), descriptorImpl.getVersion());
        if (this.eventKeyToEventTypeIDMap.get(ckey) != null) {
            throw new AlreadyDeployedException("The event " + ckey + " is already deployed");
        }
        EventTypeIDImpl eventTypeID = new EventTypeIDImpl(ckey);
        logger.info((Object)("Installing event Type:" + eventTypeID + " descriptor " + descriptorImpl));
        this.eventTypeIDToDescriptor.put(eventTypeID, descriptorImpl);
        this.eventKeyToEventTypeIDMap.put(ckey, eventTypeID);
        this.eventTypeIDToEventKeyMap.put(eventTypeID, ckey);
        this.eventTypeIDs.put(new Integer(eventTypeID.getEventID()), eventTypeID);
        descriptorImpl.setID(eventTypeID);
        logger.info((Object)("Added Event " + ckey + "to the Container"));
    }

    private synchronized void removeEventType(DeployableUnitID deployableUnitID) {
        Iterator it = this.eventTypeIDToDescriptor.keySet().iterator();
        logger.info((Object)"entry of removeEventType DeployableUnit");
        while (it.hasNext()) {
            EventTypeIDImpl eventTypeID = (EventTypeIDImpl)it.next();
            MobicentsEventTypeDescriptor desc = (MobicentsEventTypeDescriptor)this.eventTypeIDToDescriptor.get(eventTypeID);
            if (desc == null || desc.getDeployableUnit() == null || !desc.getDeployableUnit().equals(deployableUnitID)) continue;
            it.remove();
            ComponentKey ckey = (ComponentKey)this.eventTypeIDToEventKeyMap.get(eventTypeID);
            logger.info((Object)("EVENT TYPE REMOVED: " + eventTypeID));
            this.eventTypeIDToEventKeyMap.remove(eventTypeID);
            if (ckey != null) {
                this.eventKeyToEventTypeIDMap.remove(ckey);
            }
            this.eventTypeIDs.remove(new Integer(eventTypeID.getEventID()));
        }
    }

    public static void unregisterWithJndi(String prefix, String name) {
        SleeContainer.unregisterWithJndi(prefix + "/" + name);
    }

    public static void unregisterWithJndi(String name) {
        String path = JVM_ENV + name;
        try {
            InitialContext ctx = new InitialContext();
            Util.unbind((Context)ctx, (String)path);
        }
        catch (NamingException ex) {
            logger.warn((Object)("unregisterWithJndi failed for " + path));
        }
    }

    public static void registerWithJndi(String prefix, String name, Object object) {
        String fullName = JVM_ENV + prefix + "/" + name;
        try {
            Context ctx = new InitialContext();
            try {
                Util.createSubcontext((Context)ctx, (String)fullName);
            }
            catch (NamingException e) {
                logger.warn((Object)("Context, " + fullName + " might have been bound."));
                logger.warn((Object)e);
            }
            ctx = (Context)ctx.lookup(JVM_ENV + prefix);
            NonSerializableFactory.rebind((String)fullName, (Object)object);
            StringRefAddr addr = new StringRefAddr("nns", fullName);
            Reference ref = new Reference(object.getClass().getName(), addr, NonSerializableFactory.class.getName(), null);
            Util.rebind((Context)ctx, (String)name, (Object)ref);
            logger.debug((Object)("registered with jndi " + fullName));
        }
        catch (Exception ex) {
            logger.warn((Object)("registerWithJndi failed for " + fullName), (Throwable)ex);
        }
    }

    public static void registerFacilityWithJndi(String facilityName, Object facility) {
        SleeContainer.registerWithJndi("slee/facilities", facilityName, facility);
    }

    public static void unregisterFacilityWithJndi(String facilityName) {
        SleeContainer.unregisterWithJndi("slee/facilities", facilityName);
    }

    private static Object lookupFacilityInJndi(String facilityName) throws NamingException {
        return SleeContainer.getFromJndi("slee/facilities/" + facilityName);
    }

    private static Object getFromJndi(String resourceName) throws NamingException {
        InitialContext initialContext = new InitialContext();
        Context compEnv = (Context)initialContext.lookup(JVM_ENV);
        return compEnv.lookup(resourceName);
    }

    private void installService(ServiceDescriptorImpl serviceDescriptorImpl) throws Exception {
        ServiceComponent svc = new ServiceComponent(serviceDescriptorImpl);
        this.addService((ServiceID)serviceDescriptorImpl.getID(), svc);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\n==================INSTALLING SERVICE=================\nROOTSBB: " + svc.getRootSbbComponent() + "\n" + "ROOTSBBID: " + svc.getRootSbbComponent().getID() + "\n" + "SERVICEID: " + svc.getServiceID() + "\n" + "====================================================="));
        }
        HashSet sbbIDs = svc.getSbbComponents();
        if (logger.isDebugEnabled()) {
            Iterator sbbIdsIterator = sbbIDs.iterator();
            StringBuffer sb = new StringBuffer(300);
            while (sbbIdsIterator.hasNext()) {
                MobicentsSbbDescriptor sbbdesc = (MobicentsSbbDescriptor)this.getSbbComponent((SbbID)sbbIdsIterator.next());
                sb.append("NAME=" + sbbdesc.getName() + " COMPONENTID=" + sbbdesc.getID() + "\n");
            }
            logger.debug((Object)("\n==================SERVICE SBBS=======================\n" + sb.toString() + "\n" + "====================================================="));
        }
        HashMap raEntitiesToEventTypeIDsOfInterest = new HashMap(5);
        HashMap eventTypeIDsToResourceOptions = new HashMap(30);
        HashMap raEntitiesToEventsFired = new HashMap(5);
        Iterator sbbIdsIterator = sbbIDs.iterator();
        while (sbbIdsIterator.hasNext()) {
            MobicentsSbbDescriptor sbbdesc = (MobicentsSbbDescriptor)this.getSbbComponent((SbbID)sbbIdsIterator.next());
            if (sbbdesc == null) continue;
            HashMap eventTypeIdToEventEntriesMappings = sbbdesc.getEventTypesMappings();
            Set sbbEventsOfInterest = eventTypeIdToEventEntriesMappings.keySet();
            String[] raLinks = sbbdesc.getResourceAdaptorEntityLinks();
            if (raLinks == null || raLinks.length == 0) {
                logger.info((Object)"======= R ALINKS.length==0 ======");
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\n=============SBB==============================\n" + sbbdesc.getName() + ", " + sbbdesc.getVendor() + ", " + sbbdesc.getVersion() + "\n" + "=============================================="));
                Iterator eventEntryItarator = eventTypeIdToEventEntriesMappings.values().iterator();
                StringBuffer sb = new StringBuffer(300);
                while (eventEntryItarator.hasNext()) {
                    SbbEventEntry eventEntry = (SbbEventEntry)eventEntryItarator.next();
                    sb.append("EVENT :" + eventEntry + "\n");
                }
                logger.debug((Object)("\n==================EVENTS OF SBB INTEREST=======================\n" + sb.toString() + "\n" + "================================================================="));
                sb = new StringBuffer(300);
                for (int i = 0; i < raLinks.length; ++i) {
                    sb.append("RALINK : " + raLinks[i] + "\n");
                }
                logger.debug((Object)("\n================== RA LINKS FOR SBB ==================\n" + sb + "\n" + "======================================================"));
            }
            for (int i = 0; i < raLinks.length; ++i) {
                ResourceAdaptorEntity raEntity = this.getRAEntity(raLinks[i]);
                ResourceAdaptorType raType = raEntity.getInstalledResourceAdaptor().getRaType();
                if (!raEntitiesToEventsFired.containsKey(raEntity)) {
                    HashSet<EventTypeID> setOfFiredEventIds = new HashSet<EventTypeID>();
                    EventTypeID[] events = raType.getRaTypeDescr().getEventTypes();
                    if (events == null) continue;
                    for (int j = 0; j < events.length; ++j) {
                        setOfFiredEventIds.add(events[j]);
                    }
                    raEntitiesToEventsFired.put(raEntity, setOfFiredEventIds);
                    raEntitiesToEventTypeIDsOfInterest.put(raEntity, new HashSet(20));
                }
                Set eventsOfInterest = (Set)raEntitiesToEventTypeIDsOfInterest.get(raEntity);
                Set eventsFiredByRAEntity = (Set)raEntitiesToEventsFired.get(raEntity);
                for (Object eventIdOfSbbItenrest : sbbEventsOfInterest) {
                    if (!eventsFiredByRAEntity.contains(eventIdOfSbbItenrest)) continue;
                    eventsOfInterest.add(eventIdOfSbbItenrest);
                    SbbEventEntry eventEntry = (SbbEventEntry)eventTypeIdToEventEntriesMappings.get(eventIdOfSbbItenrest);
                    String resourceOption = eventEntry.getResourceOption();
                    if (resourceOption == null) continue;
                    if (eventTypeIDsToResourceOptions.containsKey(eventIdOfSbbItenrest)) {
                        String value = (String)eventTypeIDsToResourceOptions.remove(eventIdOfSbbItenrest);
                        if (value.indexOf(resourceOption) != -1) continue;
                        value = value + "," + resourceOption;
                        eventTypeIDsToResourceOptions.put(eventIdOfSbbItenrest, value);
                        continue;
                    }
                    eventTypeIDsToResourceOptions.put(eventIdOfSbbItenrest, resourceOption);
                }
                if (!logger.isDebugEnabled()) continue;
                StringBuffer sb = new StringBuffer(300);
                Iterator it = eventsOfInterest.iterator();
                while (it.hasNext()) {
                    sb.append(it.next() + "\n");
                }
                logger.debug((Object)("\n=========================== EVENTIDS OF INTEREST FROM RA===========================\n" + sb + "\n" + "====================================================================================="));
            }
        }
        Iterator raEntities = raEntitiesToEventTypeIDsOfInterest.keySet().iterator();
        Iterator eventTypeIdIterator = null;
        String resourceOption = null;
        int eventID = -1;
        while (raEntities.hasNext()) {
            ResourceAdaptorEntity raEntity = (ResourceAdaptorEntity)raEntities.next();
            TreeSet eventsOfServiceInterest = (TreeSet)raEntitiesToEventTypeIDsOfInterest.get(raEntity);
            int[] eventIDs = new int[eventsOfServiceInterest.size()];
            String[] resourceOptions = new String[eventsOfServiceInterest.size()];
            eventsOfServiceInterest = new TreeSet(eventsOfServiceInterest);
            int i = 0;
            for (EventTypeID ETID : eventsOfServiceInterest) {
                eventID = this.eventLookup.getEventID(this.getEventKey(ETID));
                resourceOption = (String)eventTypeIDsToResourceOptions.get(ETID);
                eventIDs[i] = eventID;
                resourceOptions[i++] = resourceOption;
            }
            if (logger.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer(300);
                sb.append("INDEX[ eventID | resourceOptions ]\n");
                for (int k = 0; k < eventIDs.length; ++k) {
                    sb.append("#" + k + "[ " + eventIDs[k] + " | " + resourceOptions[k] + " ]\n");
                }
                ResourceAdaptorTypeDescriptorImpl raDesc = raEntity.getInstalledResourceAdaptor().getRaType().getRaTypeDescr();
                logger.debug((Object)("\n============= PASSING INSTALL SERVCICE ARGS TO RA =============\n| RA DESC: " + raDesc.getName() + ", " + raDesc.getVendor() + ", " + raDesc.getVersion() + "\n" + "===============================================================\n" + "| EVENTS : |\n" + "============\n" + "" + sb + "\n" + "==============================================================="));
            }
            raEntity.serviceInstalled(svc.getServiceID().toString(), eventIDs, resourceOptions);
            resourceOption = null;
            eventID = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void uninstallService(DeployableUnitIDImpl deployableUnitID) throws Exception {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            logger.debug((Object)("uninstallService " + deployableUnitID));
            Map serviceComps = this.getDeploymentCacheManager().getServiceComponents();
            for (Map.Entry nentry : serviceComps.entrySet()) {
                ServiceComponent serviceComponent = (ServiceComponent)nentry.getValue();
                ServiceDescriptorImpl serviceDescriptor = serviceComponent.getServiceDescriptor();
                DeployableUnitID duid = serviceDescriptor.getDeployableUnit();
                ServiceID serviceID = (ServiceID)serviceDescriptor.getID();
                if (!duid.equals(deployableUnitID)) continue;
                HashSet sbbIDs = serviceComponent.getSbbComponents();
                HashSet<ResourceAdaptorEntity> raEntities = new HashSet<ResourceAdaptorEntity>();
                Iterator i = sbbIDs.iterator();
                while (i.hasNext()) {
                    SbbDescriptor sbbdesc = this.getSbbComponent((SbbID)i.next());
                    if (sbbdesc == null) continue;
                    String[] raLinks = sbbdesc.getResourceAdaptorEntityLinks();
                    for (int c = 0; raLinks != null && c < raLinks.length; ++c) {
                        ResourceAdaptorEntity raEntity = this.getRAEntity(raLinks[c]);
                        if (raEntity == null || raEntities.contains(raEntity)) continue;
                        raEntity.serviceUninstalled(serviceComponent.getServiceID().toString());
                        raEntities.add(raEntity);
                    }
                }
                Service service = this.getService(serviceID);
                Object task = this.sevriceIdsToRemovalTasks.get(serviceID.toString());
                if (task != null) {
                    logger.info((Object)"STARTING REMOVAL RUN");
                    SleeContainerLingeringServiceSbbRemoverTask castedTask = null;
                    castedTask = (SleeContainerLingeringServiceSbbRemoverTask)task;
                    boolean canceled = castedTask.cancel();
                    logger.debug((Object)("CANCEL[" + canceled + "]"));
                    if (!canceled) {
                        castedTask = (SleeContainerLingeringServiceSbbRemoverTask)this.sevriceIdsToRemovalTasks.get(serviceID.toString());
                        logger.debug((Object)("FETCHED ANOTHER[" + castedTask + "]"));
                    }
                    if (castedTask != null) {
                        logger.debug((Object)("HAS RUN[" + castedTask.getHasRun() + "] CANCEL[" + castedTask.cancel() + "]"));
                    }
                    if (castedTask != null && !castedTask.getHasRun() && canceled) {
                        castedTask.run();
                    }
                    this.sevriceIdsToRemovalTasks.remove(serviceID.toString());
                }
                logger.debug((Object)("unregisterMBean " + serviceComponent.getUsageMBean()));
                this.mbeanServer.unregisterMBean(serviceComponent.getUsageMBean());
                Iterator itr = serviceComponent.getSbbUsageMBeans();
                while (itr.hasNext()) {
                    ObjectName usageMbeanName = (ObjectName)itr.next();
                    this.mbeanServer.unregisterMBean(usageMbeanName);
                }
                this.serviceActivityContextInterfaceFactory.removeServiceActivityContextInterface(service.getServiceActivity());
                Service.removeAllUsageParameters(service.getServiceID());
                for (String eid : service.getChildObj()) {
                    this.getSbbEntityFactory().removeFromCache(eid);
                }
                ServiceID sid = (ServiceID)nentry.getKey();
                serviceComps.remove(sid);
                service.removeFromCache();
            }
        }
        finally {
            if (b) {
                SleeContainer.getTransactionManager().commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void uninstallRA(DeployableUnitIDImpl deployableUnitID) throws Exception {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            ResourceAdaptorIDImpl[] raID = this.getResourceAdaptorIDs();
            logger.info((Object)("uninstallRA for " + deployableUnitID));
            for (int indx = 0; indx < raID.length; ++indx) {
                ResourceAdaptorIDImpl _raID = raID[indx];
                logger.info((Object)("checking " + _raID));
                ComponentID[] components = deployableUnitID.getDescriptor().getComponents();
                for (int itx = 0; itx < components.length; ++itx) {
                    ComponentID cid = components[itx];
                    if (!((Object)_raID).equals(cid)) continue;
                    if (!deployableUnitID.getDescriptor().hasInstalledComponent(cid)) {
                        logger.debug((Object)("RAComp[" + _raID + "] WAS NOT ISNTALLED BY DU[" + deployableUnitID.getSourceURL() + "]"));
                        continue;
                    }
                    logger.info((Object)("removing " + _raID));
                    InstalledResourceAdaptor ra = (InstalledResourceAdaptor)this.installedResourceAdaptors.remove(_raID);
                    ra.uninstall();
                }
            }
        }
        finally {
            if (b) {
                SleeContainer.getTransactionManager().commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void uninstallRAType(DeployableUnitIDImpl deployableUnitID) throws Exception {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            ComponentID[] components = deployableUnitID.getDescriptor().getComponents();
            for (int itx = 0; itx < components.length; ++itx) {
                ResourceAdaptorTypeID testRaType;
                ResourceAdaptorType type;
                ComponentID cid = components[itx];
                if (!(cid instanceof ResourceAdaptorTypeID) || (type = this.getResourceAdaptorType(testRaType = (ResourceAdaptorTypeID)cid)).getResourceAdaptorIDs().size() == 0) continue;
                HashSet ras = type.getResourceAdaptorIDs();
                StringBuffer sb = new StringBuffer(ras.size() * 50);
                for (ResourceAdaptorIDImpl raid : ras) {
                    sb.append("" + raid.getComponentKey() + "; ");
                }
                throw new RuntimeException(" RAType [" + type.getResourceAdaptorTypeID().getComponentKey() + "] is still referenced by some RA/s --> " + sb);
            }
            Iterator it = this.getResourceAdaptorTypes().keySet().iterator();
            logger.info((Object)("uninstallRATypes for " + deployableUnitID));
            while (it.hasNext()) {
                ResourceAdaptorTypeIDImpl raTypeID = (ResourceAdaptorTypeIDImpl)it.next();
                logger.info((Object)("checking " + raTypeID));
                for (int itx = 0; itx < components.length; ++itx) {
                    ComponentID cid = components[itx];
                    if (!((Object)raTypeID).equals(cid)) continue;
                    if (!deployableUnitID.getDescriptor().hasInstalledComponent(cid)) {
                        logger.debug((Object)("RATYPEComp[" + raTypeID + "] WAS NOT ISNTALLED BY DU[" + deployableUnitID.getSourceURL() + "]"));
                        continue;
                    }
                    logger.info((Object)("removing " + raTypeID));
                    it.remove();
                    this.resourceAdaptorTypes.remove(raTypeID);
                }
            }
        }
        finally {
            if (b) {
                SleeContainer.getTransactionManager().commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void installSbb(MobicentsSbbDescriptor mobicentsSbbDescriptor) throws Exception {
        SleeContainer.getTransactionManager().assertIsInTx();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Installing SbbID: " + mobicentsSbbDescriptor.getID()));
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(mobicentsSbbDescriptor.getClassLoader());
            this.setupSbbEnvironment(mobicentsSbbDescriptor);
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        SbbObjectPoolFactory objectPoolFactory = new SbbObjectPoolFactory((SbbID)mobicentsSbbDescriptor.getID(), this);
        this.sbbPooling.put(mobicentsSbbDescriptor.getID(), new GenericObjectPoolFactory((PoolableObjectFactory)objectPoolFactory, this.poolConfig).createPool());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created Pool for SbbID: " + mobicentsSbbDescriptor.getID()));
        }
        SbbDeployer sbbDeployer = new SbbDeployer(SleeContainer.getDeployPath());
        oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(mobicentsSbbDescriptor.getClassLoader());
            sbbDeployer.deploySbb(mobicentsSbbDescriptor, this);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        this.installSbbEventEntries(mobicentsSbbDescriptor);
        SleeContainer.getTraceFacility().setTraceLevel(mobicentsSbbDescriptor.getID(), Level.OFF);
        SleeContainer.getAlarmFacility().registerComponent(mobicentsSbbDescriptor.getID());
        this.addSbbComponent(mobicentsSbbDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupSbbEnvironment(MobicentsSbbDescriptor sbbDescriptor) throws Exception {
        Context newCtx;
        Context ctx = (Context)new InitialContext().lookup("java:comp");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("THE CONTEXT IS ############## " + ctx));
        }
        Context envCtx = null;
        try {
            envCtx = ctx.createSubcontext("env");
        }
        catch (NameAlreadyBoundException ex) {
            envCtx = (Context)ctx.lookup("env");
        }
        Context sleeCtx = null;
        try {
            sleeCtx = envCtx.createSubcontext(CTX_SLEE);
        }
        catch (NameAlreadyBoundException ex) {
            sleeCtx = (Context)envCtx.lookup(CTX_SLEE);
        }
        String containerName = "java:slee/container/Container";
        try {
            newCtx = sleeCtx.createSubcontext(JNDI_NAME);
        }
        catch (NameAlreadyBoundException ex) {
        }
        finally {
            newCtx = (Context)sleeCtx.lookup(JNDI_NAME);
        }
        try {
            newCtx.bind("Container", (Object)new LinkRef(containerName));
        }
        catch (NameAlreadyBoundException ex) {
            // empty catch block
        }
        String nullAciFactory = "java:slee/nullactivity/nullactivitycontextinterfacefactory";
        String nullActivityFactory = "java:slee/nullactivity/nullactivityfactory";
        try {
            newCtx = sleeCtx.createSubcontext("nullactivity");
        }
        catch (NameAlreadyBoundException ex) {
        }
        finally {
            newCtx = (Context)sleeCtx.lookup("nullactivity");
        }
        try {
            newCtx.bind("activitycontextinterfacefactory", (Object)new LinkRef(nullAciFactory));
        }
        catch (NameAlreadyBoundException ex) {
            // empty catch block
        }
        try {
            newCtx.bind("factory", (Object)new LinkRef(nullActivityFactory));
        }
        catch (NameAlreadyBoundException ex) {
            // empty catch block
        }
        String serviceActivityContextInterfaceFactory = "java:slee/serviceactivity/activitycontextinterfacefactory";
        try {
            newCtx = sleeCtx.createSubcontext("serviceactivity");
        }
        catch (NameAlreadyBoundException ex) {
        }
        finally {
            newCtx = (Context)sleeCtx.lookup("serviceactivity");
        }
        try {
            newCtx.bind(ServiceActivityContextInterfaceFactoryImpl.JNDI_NAME, (Object)new LinkRef(serviceActivityContextInterfaceFactory));
        }
        catch (NameAlreadyBoundException ex) {
            // empty catch block
        }
        String timer = "java:slee/facilities/timer";
        String aciNaming = "java:slee/facilities/activitycontextnaming";
        try {
            newCtx = sleeCtx.createSubcontext("facilities");
        }
        catch (NameAlreadyBoundException ex) {
        }
        finally {
            newCtx = (Context)sleeCtx.lookup("facilities");
        }
        try {
            newCtx.bind("timer", (Object)new LinkRef(timer));
        }
        catch (NameAlreadyBoundException ex) {
            // empty catch block
        }
        try {
            newCtx.bind("activitycontextnaming", (Object)new LinkRef(aciNaming));
        }
        catch (NameAlreadyBoundException ex) {
            // empty catch block
        }
        String trace = "java:slee/facilities/trace";
        try {
            newCtx.bind("trace", (Object)new LinkRef(trace));
        }
        catch (NameAlreadyBoundException ex) {
            // empty catch block
        }
        String alarm = "java:slee/facilities/alarm";
        try {
            newCtx.bind("alarm", (Object)new LinkRef(alarm));
        }
        catch (NameAlreadyBoundException ex) {
            // empty catch block
        }
        String profile = "java:slee/facilities/profile";
        try {
            newCtx.bind("profile", (Object)new LinkRef(profile));
        }
        catch (NameAlreadyBoundException ex) {
            // empty catch block
        }
        String profilteTableAciFactory = "java:slee/facilities/profiletableactivitycontextinterfacefactory";
        try {
            newCtx.bind("profiletableactivitycontextinterfacefactory", (Object)new LinkRef(profilteTableAciFactory));
        }
        catch (NameAlreadyBoundException ex) {
            // empty catch block
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Number of Resource Bindings:" + sbbDescriptor.getResourceAdapterTypeBindings()));
        }
        Iterator it = sbbDescriptor.getResourceAdapterTypeBindings();
        while (it.hasNext()) {
            MobicentsResourceAdaptorTypeBinding binding = (MobicentsResourceAdaptorTypeBinding)it.next();
            ResourceAdaptorTypeIDImpl resourceAdaptorTypeID = (ResourceAdaptorTypeIDImpl)binding.getResourceAdapterTypeId();
            ResourceAdaptorType raType = this.getResourceAdaptorType(resourceAdaptorTypeID);
            if (raType == null) {
                throw new Exception("Resource Adaptor type is not implemented: " + resourceAdaptorTypeID);
            }
            Iterator it1 = sbbDescriptor.getResourceAdaptorEntityBindings(resourceAdaptorTypeID);
            while (it1.hasNext()) {
                ResourceAdaptorEntityBinding ralink = (ResourceAdaptorEntityBinding)it1.next();
                String raObjectName = ralink.getResourceAdapterObjectName();
                String linkName = ralink.getResourceAdaptorEntityLink();
                ResourceAdaptorEntity raEntity = this.getRAEntity(linkName, raType);
                if (raEntity == null) {
                    throw new Exception("Could not find Resource adaptor Entity for Link Name: [" + linkName + "] of RA Type [" + raType.getResourceAdaptorTypeID() + "]");
                }
                NameParser parser = ctx.getNameParser("");
                Name local = parser.parse(raObjectName);
                int tokenCount = local.size();
                Context subContext = envCtx;
                for (int i = 0; i < tokenCount - 1; ++i) {
                    String nextTok = local.get(i);
                    try {
                        subContext.lookup(nextTok);
                        continue;
                    }
                    catch (NameNotFoundException nfe) {
                        subContext.createSubcontext(nextTok);
                        continue;
                    }
                    finally {
                        subContext = (Context)subContext.lookup(nextTok);
                    }
                }
                String lastTok = local.get(tokenCount - 1);
                logger.info((Object)("setupSbbEnvironment: Binding a JNDI reference to resource adaptor instance [" + raEntity.getFactoryInterfaceJNDIName() + "] to where the Sbb expects to find it [" + lastTok + "]"));
                try {
                    subContext.bind(lastTok, (Object)new LinkRef(raEntity.getFactoryInterfaceJNDIName()));
                }
                catch (NameAlreadyBoundException e) {
                    logger.warn((Object)("setupSbbEnvironment: Failed to bind JNDI reference [" + lastTok + "] to resource adaptor instance [" + raEntity.getFactoryInterfaceJNDIName() + "] due to NameAlreadyBoundException"), (Throwable)e);
                }
            }
            String localFactoryName = binding.getActivityContextInterfaceFactoryName();
            if (localFactoryName == null) continue;
            String globalFactoryName = this.getRAActivityContextInterfaceFactoryJNDIName(binding.getResourceAdapterTypeId());
            NameParser parser = ctx.getNameParser("");
            Name local = parser.parse(localFactoryName);
            int nameSize = local.size();
            Context tempCtx = envCtx;
            for (int a = 0; a < nameSize - 1; ++a) {
                String temp = local.get(a);
                try {
                    tempCtx.lookup(temp);
                    continue;
                }
                catch (NameNotFoundException ne) {
                    tempCtx.createSubcontext(temp);
                    continue;
                }
                finally {
                    tempCtx = (Context)tempCtx.lookup(temp);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ACI factory reference binding: " + local.get(nameSize - 1) + " to " + globalFactoryName));
            }
            String factoryRefName = local.get(nameSize - 1);
            try {
                tempCtx.bind(factoryRefName, (Object)new LinkRef(globalFactoryName));
            }
            catch (NameAlreadyBoundException e) {
                logger.warn((Object)("setupSbbEnvironment: Failed to bind ACI factory JNDI reference [" + factoryRefName + "] to global factory name [" + globalFactoryName + "] due to NameAlreadyBoundException"), (Throwable)e);
            }
        }
        try {
            envCtx.createSubcontext("ejb");
        }
        catch (NameAlreadyBoundException ex) {
            envCtx.lookup("ejb");
        }
        logger.debug((Object)"Created ejb local context");
        for (EJBReference ejbRef : sbbDescriptor.getEjbRefs()) {
            String jndiName = ejbRef.getJndiName();
            if (jndiName == null) {
                logger.warn((Object)"JNDI name not specified so defaulting to ejb-name");
                jndiName = ejbRef.getEjbRefName();
            }
            logger.debug((Object)("Binding ejb: " + ejbRef.getEjbRefName() + " with link to " + jndiName));
            try {
                envCtx.bind(ejbRef.getEjbRefName(), (Object)new LinkRef(jndiName));
            }
            catch (NameAlreadyBoundException ex) {}
        }
        for (EnvironmentEntry ee : sbbDescriptor.getEnvEntries()) {
            Class<?> type = null;
            logger.debug((Object)("Got an environment entry:" + ee));
            try {
                type = Thread.currentThread().getContextClassLoader().loadClass(ee.getType());
            }
            catch (Exception e) {
                throw new DeploymentException(ee.getType() + " is not a valid type for an environment entry");
            }
            Object entry = null;
            String s = ee.getValue();
            try {
                if (type == String.class) {
                    entry = new String(s);
                } else if (type == Character.class) {
                    if (s.length() != 1) {
                        throw new DeploymentException(s + " is not a valid value for an environment entry of type Character");
                    }
                    entry = new Character(s.charAt(0));
                } else if (type == Integer.class) {
                    entry = new Integer(s);
                } else if (type == Boolean.class) {
                    entry = new Boolean(s);
                } else if (type == Double.class) {
                    entry = new Double(s);
                } else if (type == Byte.class) {
                    entry = new Byte(s);
                } else if (type == Short.class) {
                    entry = new Short(s);
                } else if (type == Long.class) {
                    entry = new Long(s);
                } else if (type == Float.class) {
                    entry = new Float(s);
                }
            }
            catch (NumberFormatException e) {
                throw new DeploymentException("Environment entry value " + s + " is not a valid value for type " + type);
            }
            logger.debug((Object)("Binding environment entry with name:" + ee.getName() + " type  " + entry.getClass() + " with value:" + entry));
            logger.debug((Object)("current classloader = " + Thread.currentThread().getContextClassLoader()));
            try {
                envCtx.bind(ee.getName(), entry);
            }
            catch (NameAlreadyBoundException ex) {
                logger.error((Object)"Name already bound ! ", (Throwable)ex);
            }
        }
    }

    public ActivityContextFactoryImpl getActivityContextFactory() {
        return this.activityContextFactory;
    }

    public MobicentsEventTypeDescriptor getEventDescriptor(EventTypeID id) {
        return (MobicentsEventTypeDescriptor)this.eventTypeIDToDescriptor.get(id);
    }

    public int getActivityContextCount() {
        return this.activityContextFactory.getActivityContextCount();
    }

    public SleeInternalEndpoint getSleeEndpoint() {
        return this.sleeEndpoint;
    }

    public SleeContainer(MBeanServer mbserver) throws Exception {
        SleeContainer.initDeployPath();
        this.sleeState = SleeState.STOPPED;
        this.mbeanServer = mbserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SbbIDImpl[] getSbbIDs() throws Exception {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            SbbIDImpl[] retval = new SbbIDImpl[this.getDeploymentCacheManager().getSbbComponents().size()];
            this.getDeploymentCacheManager().getSbbComponents().keySet().toArray(retval);
            SbbIDImpl[] sbbIDImplArray = retval;
            return sbbIDImplArray;
        }
        finally {
            if (b) {
                SleeContainer.getTransactionManager().commit();
            }
        }
    }

    public ActivityContextNamingFacility getActivityContextNamingFacility() {
        return this.activityContextNamingFacility;
    }

    public static ProfileFacility getProfileFacility() throws NamingException {
        return (ProfileFacility)SleeContainer.lookupFacilityInJndi("profile");
    }

    public static TimerFacility getTimerFacility() throws NamingException {
        if (timerFacility == null) {
            return (TimerFacility)SleeContainer.lookupFacilityInJndi("timer");
        }
        return timerFacility;
    }

    public SbbDescriptor getSbbComponent(SbbID sbbComponentId) {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        boolean rb = true;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getting " + sbbComponentId));
            }
            SbbDescriptor retval = (SbbDescriptor)this.getDeploymentCacheManager().getSbbComponents().get(sbbComponentId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" returning " + retval));
            }
            rb = false;
            SbbDescriptor sbbDescriptor = retval;
            return sbbDescriptor;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected exception ", ex);
        }
        finally {
            try {
                if (rb) {
                    SleeContainer.getTransactionManager().setRollbackOnly();
                }
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (SystemException e) {
                logger.error((Object)e);
            }
        }
    }

    private void addSbbComponent(SbbDescriptor sbbComponent) throws Exception {
        SleeContainer.getTransactionManager().assertIsInTx();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("adding sbb component for " + sbbComponent.getID().toString()));
        }
        this.getDeploymentCacheManager().getSbbComponents().put(sbbComponent.getID(), sbbComponent);
        SbbID[] sbbs = sbbComponent.getSbbs();
        for (int i = 0; i < sbbs.length; ++i) {
            this.addReferringComponent((ComponentID)sbbs[i], sbbComponent.getID());
        }
        ProfileSpecificationID[] profileIDs = sbbComponent.getProfileSpecifications();
        for (int i = 0; i < profileIDs.length; ++i) {
            this.addReferringComponent((ComponentID)profileIDs[i], sbbComponent.getID());
        }
        EventTypeID[] eventTypes = sbbComponent.getEventTypes();
        for (int i = 0; i < eventTypes.length; ++i) {
            this.addReferringComponent((ComponentID)eventTypes[i], sbbComponent.getID());
        }
        ResourceAdaptorTypeID[] raTypeIDs = sbbComponent.getResourceAdaptorTypes();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ResourceAdaptorTypeIDs " + raTypeIDs.length));
        }
        for (int i = 0; i < raTypeIDs.length; ++i) {
            this.addReferringComponent((ComponentID)raTypeIDs[i], sbbComponent.getID());
        }
        ProfileSpecificationID addressProfile = sbbComponent.getAddressProfileSpecification();
        if (addressProfile != null) {
            this.addReferringComponent((ComponentID)addressProfile, sbbComponent.getID());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("dependencyTable " + this.getDeploymentCacheManager().getReferringComponents()));
            logger.debug((Object)("sbbComponents " + this.getDeploymentCacheManager().getSbbComponents()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service getService(ServiceID serviceId) throws SystemException, UnrecognizedServiceException {
        boolean b = false;
        boolean rb = true;
        ServiceComponent service = null;
        Service svc = null;
        try {
            b = SleeContainer.getTransactionManager().requireTransaction();
            service = (ServiceComponent)this.getDeploymentCacheManager().getServiceComponents().get(serviceId);
            if (service == null) {
                String s = "Service does not exist - has it been uninstalled?";
                logger.error((Object)s);
                rb = false;
                throw new UnrecognizedServiceException(s);
            }
            svc = new Service(service.getServiceDescriptor());
            rb = false;
        }
        finally {
            try {
                if (rb) {
                    SleeContainer.getTransactionManager().setRollbackOnly();
                }
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (SystemException e) {
                throw new RuntimeException("Failed to commit transaction!", e);
            }
        }
        return svc;
    }

    public static SleeTransactionManager getTransactionManager() {
        try {
            if (sleeTransactionManager == null) {
                sleeTransactionManager = (SleeTransactionManager)SleeContainer.getFromJndi("slee/SleeTransactionManager");
            }
            return sleeTransactionManager;
        }
        catch (Exception ex) {
            logger.error((Object)"Error fetching transaciton manager!", (Throwable)ex);
            return null;
        }
    }

    public TransactionIDAccess getTransactionIDAccess() {
        return this.transactionIDAccess;
    }

    public ServiceID[] getServiceIDs() {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            ServiceID[] retval = new ServiceIDImpl[this.getDeploymentCacheManager().getServiceComponents().size()];
            this.getDeploymentCacheManager().getServiceComponents().keySet().toArray(retval);
            ServiceID[] serviceIDArray = retval;
            return serviceIDArray;
        }
        catch (SystemException ex) {
            throw new RuntimeException("Tx manager failed");
        }
        finally {
            try {
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (SystemException ex) {
                throw new RuntimeException("Tx manager failed");
            }
        }
    }

    private synchronized void installSbbEventEntries(MobicentsSbbDescriptor mobicentsSbbDescriptor) throws DeploymentException {
        HashSet sbbEventEntries = mobicentsSbbDescriptor.getSbbEventEntries();
        Iterator it = sbbEventEntries.iterator();
        logger.debug((Object)("installSbbEventEntries: " + mobicentsSbbDescriptor.getID()));
        while (it.hasNext()) {
            SbbEventEntry eventEntry = (SbbEventEntry)it.next();
            ComponentKey eventTypeRefKey = eventEntry.getEventTypeRefKey();
            EventTypeIDImpl eventTypeId = this.getEventType(eventTypeRefKey);
            if (eventTypeId == null) {
                throw new DeploymentException("Unknown event type " + eventTypeRefKey);
            }
            mobicentsSbbDescriptor.addEventEntry(eventTypeId, eventEntry);
        }
    }

    public ObjectPool getObjectPool(SbbID sbbid) {
        return (ObjectPool)this.sbbPooling.get(sbbid);
    }

    private void addReferringComponent(ComponentID componentID, ComponentID referringComponent) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AddReferringComponent componentID = " + componentID + " referringComponent = " + referringComponent));
        }
        try {
            Set rcomp = (Set)this.getDeploymentCacheManager().getReferringComponents().get(componentID);
            if (rcomp == null) {
                rcomp = this.getDeploymentCacheManager().newReferringCompSet();
                this.getDeploymentCacheManager().getReferringComponents().put(componentID, rcomp);
            }
            rcomp.add(referringComponent);
        }
        catch (SystemException ex) {
            throw new RuntimeException("Tx manager failed! ", ex);
        }
    }

    private void removeReferredComponent(ComponentID componentID) {
        try {
            for (ComponentID key : this.getDeploymentCacheManager().getReferringComponents().keySet()) {
                Map refComps = this.getDeploymentCacheManager().getReferringComponents();
                CacheableSet rcomp = (CacheableSet)refComps.get(key);
                rcomp.remove(componentID);
                if (!rcomp.isEmpty()) continue;
                refComps.remove(key);
                rcomp.remove();
            }
        }
        catch (SystemException ex) {
            throw new RuntimeException("Tx manager failed!", ex);
        }
    }

    public ComponentIDImpl[] getReferringComponents(ComponentID referredComponent) {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            Set rcomp = (Set)this.getDeploymentCacheManager().getReferringComponents().get(referredComponent);
            if (rcomp == null) {
                ComponentIDImpl[] componentIDImplArray = new ComponentIDImpl[]{};
                return componentIDImplArray;
            }
            ComponentIDImpl[] retval = new ComponentIDImpl[rcomp.size()];
            rcomp.toArray(retval);
            ComponentIDImpl[] componentIDImplArray = retval;
            return componentIDImplArray;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected exception!", ex);
        }
        finally {
            try {
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("tx manager failed", ex);
            }
        }
    }

    private boolean addReferringDU(ComponentID cid, DeployableUnitID duid) {
        boolean installedForTheFirstTime = false;
        try {
            Set referringDus = (Set)this.getDeploymentCacheManager().getComponentIDToDeployableUnitIDMap().get(cid);
            if (referringDus == null) {
                referringDus = this.newReferringDuSet();
                this.getDeploymentCacheManager().getComponentIDToDeployableUnitIDMap().put(cid, referringDus);
                installedForTheFirstTime = true;
            }
            referringDus.add(duid);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("componentToDUMap = " + this.getDeploymentCacheManager().getComponentIDToDeployableUnitIDMap()));
            }
            return installedForTheFirstTime;
        }
        catch (Exception ex) {
            throw new RuntimeException("Tx manager failed !", ex);
        }
    }

    private Set newReferringDuSet() {
        Set refs = this.getDeploymentCacheManager().newReferringDuSet();
        return refs;
    }

    private void removeReferredDU(DeployableUnitID duid) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("removeReferredDU " + duid));
            }
            Map ci2du = this.getDeploymentCacheManager().getComponentIDToDeployableUnitIDMap();
            for (ComponentID cid : ci2du.keySet()) {
                CacheableSet dus = (CacheableSet)ci2du.get(cid);
                dus.remove(duid);
                if (!dus.isEmpty()) continue;
                ci2du.remove(cid);
                dus.remove();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("removeReferredDU After Remove " + this.getDeploymentCacheManager().getComponentIDToDeployableUnitIDMap()));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("tx manager failed ! ", ex);
        }
    }

    private boolean hasReferringDU(DeployableUnitDescriptorImpl dudesc) throws Exception {
        ComponentID[] cid = dudesc.getComponents();
        for (int i = 0; i < cid.length; ++i) {
            Set hset = (Set)this.getDeploymentCacheManager().getComponentIDToDeployableUnitIDMap().get(cid[i]);
            if (hset == null) {
                return false;
            }
            if (hset.size() != 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Direct reference detected to component  " + cid[i]));
                    logger.debug((Object)("componentID to DUID Map = " + hset));
                }
                if (dudesc.hasInstalledComponent(cid[i])) {
                    logger.info((Object)"dudesc.hasInstalledComponent(cid[i])[TRUE]");
                    return true;
                }
                logger.info((Object)"dudesc.hasInstalledComponent(cid[i])[FALSE]");
                return false;
            }
            ComponentIDImpl[] referringComponents = this.getReferringComponents(cid[i]);
            if (referringComponents == null) continue;
            for (int k = 0; k < referringComponents.length; ++k) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("checking referring component " + referringComponents[k]));
                }
                if (((Set)this.getDeploymentCacheManager().getComponentIDToDeployableUnitIDMap().get(referringComponents[k])).contains(dudesc.getDeployableUnit())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("referring component = " + this.getDeploymentCacheManager().getComponentIDToDeployableUnitIDMap().get(referringComponents[k])));
                    logger.debug((Object)("attempting to remove = " + dudesc.getDeployableUnit()));
                }
                return true;
            }
        }
        return false;
    }

    private void addService(ServiceID serviceID, ServiceComponent service) throws Exception {
        MobicentsSbbDescriptor sbbDesc = service.getRootSbbComponent();
        if (sbbDesc == null) {
            throw new DeploymentException("cannot find root SbbID component ! cannot install service ");
        }
        this.getDeploymentCacheManager().getServiceComponents().put(serviceID, service);
        this.addReferringComponent((SbbIDImpl)sbbDesc.getID(), (ComponentID)serviceID);
        ServiceUsageMBeanImpl serviceUsageMBean = new ServiceUsageMBeanImpl(service.getServiceID());
        ServiceID serviceId = service.getServiceID();
        ObjectName usageMBeanName = this.serviceManagementMBean.getServiceUsageMBean(serviceId);
        service.setUsageMBeanName(usageMBeanName);
        this.mbeanServer.registerMBean(serviceUsageMBean, usageMBeanName);
        service.installDefaultUsageParameters(sbbDesc, new HashSet());
    }

    public EventTypeIDImpl getEventType(ComponentKey componentKey) {
        return (EventTypeIDImpl)this.eventKeyToEventTypeIDMap.get(componentKey);
    }

    public ComponentKey getEventKey(EventTypeIDImpl eventTypeId) {
        return (ComponentKey)this.eventTypeIDToEventKeyMap.get(eventTypeId);
    }

    public EventLookup getEventLookupFacility() {
        return this.eventLookup;
    }

    public EventTypeIDImpl getEventTypeID(int eventID) {
        return (EventTypeIDImpl)this.eventTypeIDs.get(new Integer(eventID));
    }

    public ComponentKey getEventKey(EventTypeID eventTypeId) {
        ComponentKey key = (ComponentKey)this.eventTypeIDToEventKeyMap.get(eventTypeId);
        return key;
    }

    public synchronized void postEvent(ComponentKey eventKey, Object event, ActivityContextInterface aci, Address address) {
        int eventID = this.eventLookup.getEventID(eventKey);
        EventTypeIDImpl eventTypeID = this.getEventTypeID(eventID);
        this.router.routeEvent(eventTypeID, event, aci, address);
    }

    public synchronized void install(ComponentDescriptor descriptor, DeployableUnitDescriptor duDescriptor) throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Installing " + descriptor));
        }
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            if (descriptor instanceof MobicentsSbbDescriptor) {
                this.installSbb((MobicentsSbbDescriptor)descriptor);
            } else if (descriptor instanceof ServiceDescriptorImpl) {
                this.installService((ServiceDescriptorImpl)descriptor);
            } else if (descriptor instanceof MobicentsEventTypeDescriptor) {
                this.installEventType((MobicentsEventTypeDescriptor)descriptor);
            } else if (descriptor instanceof ResourceAdaptorTypeDescriptor) {
                this.installResourceAdaptorTypes((ResourceAdaptorTypeDescriptorImpl)descriptor);
            } else if (descriptor instanceof ProfileSpecificationDescriptorImpl) {
                this.installProfile((ProfileSpecificationDescriptorImpl)descriptor);
            } else if (descriptor instanceof ResourceAdaptorDescriptorImpl) {
                this.installResourceAdaptor((ResourceAdaptorDescriptorImpl)descriptor);
            } else {
                logger.fatal((Object)"unknown component type!");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception caught while installing component", (Throwable)ex);
            throw ex;
        }
        finally {
            if (b) {
                SleeContainer.getTransactionManager().commit();
            }
        }
    }

    private void installProfile(ProfileSpecificationDescriptorImpl profileSpecificationDescriptorImpl) throws DeploymentException {
        logger.debug((Object)("Installing ProfileID: " + profileSpecificationDescriptorImpl.getID()));
        logger.debug((Object)("deployable Unit ID : " + profileSpecificationDescriptorImpl.getDeployableUnit()));
        File duPath = null;
        duPath = profileSpecificationDescriptorImpl.getDeployableUnit() != null ? ((DeployableUnitIDImpl)profileSpecificationDescriptorImpl.getDeployableUnit()).getDUDeployer().getTempClassDeploymentDir() : new File(SleeContainer.getDeployPath());
        ProfileDeployer profileDeployer = new ProfileDeployer(duPath);
        ProfileVerifier profileVerifier = new ProfileVerifier(profileSpecificationDescriptorImpl);
        if (profileVerifier.verifyProfileSpecification()) {
            logger.info((Object)"passed registrar abstract class profile verificiation");
        } else {
            logger.fatal((Object)"failed registrar abstract verification ! ");
        }
        profileDeployer.deployProfile(profileSpecificationDescriptorImpl);
        this.addProfileComponent(profileSpecificationDescriptorImpl);
    }

    private void addProfileComponent(ProfileSpecificationDescriptorImpl profileSpecificationDescriptorImpl) {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            logger.debug((Object)("adding profile component for " + profileSpecificationDescriptorImpl.getID().toString()));
            this.getDeploymentCacheManager().getProfileComponents().put(profileSpecificationDescriptorImpl.getID(), profileSpecificationDescriptorImpl);
        }
        catch (SystemException ex) {
            throw new RuntimeException("Tx manager failure ! ", ex);
        }
        finally {
            try {
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (SystemException ex) {
                throw new RuntimeException("unexpected exception ! ", ex);
            }
        }
    }

    private void installResourceAdaptorTypes(ResourceAdaptorTypeDescriptorImpl raTypeDescriptor) throws DeploymentException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Installing Resource Adaptor Types ");
        }
        RaTypeDeployer deployer = new RaTypeDeployer(raTypeDescriptor, this);
        deployer.deployRaType();
    }

    private void installResourceAdaptor(ResourceAdaptorDescriptorImpl raDescr) throws DeploymentException {
        ResourceAdaptorType raType = (ResourceAdaptorType)this.resourceAdaptorTypes.get(raDescr.getResourceAdaptorType());
        if (raType == null) {
            throw new DeploymentException("missing resource adaptor type where id = " + raDescr.getResourceAdaptorType());
        }
        ResourceAdaptorIDImpl raID = (ResourceAdaptorIDImpl)raDescr.getID();
        raType.addResourceAdaptor(raID);
        try {
            InstalledResourceAdaptor ira = new InstalledResourceAdaptor(this, raDescr, raID);
            logger.info((Object)("Inserting RA id: " + raID + " RA: " + raType));
            this.installedResourceAdaptors.put(raID, ira);
        }
        catch (Exception e) {
            String s = "Error Installing Resource Adaptor";
            logger.error((Object)s, (Throwable)e);
            throw new DeploymentException(s, (Throwable)e);
        }
    }

    public synchronized void addDeployableUnit(DeployableUnitDescriptor descriptor) {
        SleeTransactionManager transactionManager = SleeContainer.getTransactionManager();
        boolean b = false;
        try {
            b = transactionManager.requireTransaction();
            DeployableUnitDescriptorImpl dudesc = (DeployableUnitDescriptorImpl)descriptor;
            DeployableUnitIDImpl deployableUnitId = ((DeployableUnitDescriptorImpl)descriptor).getDeployableUnit();
            logger.info((Object)("installing duid " + deployableUnitId));
            logger.info((Object)("descriptor = " + descriptor));
            if (descriptor == null) {
                logger.fatal((Object)"null descriptor");
            }
            this.getDeploymentCacheManager().getDeployableUnitIDtoDescriptorMap().put(deployableUnitId, descriptor);
            String url = descriptor.getURL();
            this.getDeploymentCacheManager().getUrlToDeployableUnitIDMap().put(url, deployableUnitId);
            ComponentID[] components = dudesc.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (this.addReferringDU(components[i], deployableUnitId)) {
                    dudesc.installComponent(components[i]);
                    logger.info((Object)("VIRGIN INSTALLATION[" + components[i] + "] BY[" + dudesc.getURL() + "]"));
                } else {
                    logger.info((Object)("ALREADY PRESENT[" + components[i] + "] NOT INSTALLED BY[" + dudesc.getURL() + "]"));
                }
                logger.info((Object)("ADDIGN DEPS[" + components[i] + "] TO[" + dudesc.getURL() + "]"));
            }
        }
        catch (Exception ex) {
            try {
                transactionManager.setRollbackOnly();
            }
            catch (SystemException se) {
                String err = "Failed addDeployableUnit(" + descriptor + "), because of system exception during tx.setRollbackOnly()! ";
                logger.error((Object)err, (Throwable)se);
                throw new RuntimeException(err, se);
            }
            throw new RuntimeException("unexpected exception ! ", ex);
        }
        finally {
            try {
                if (b) {
                    transactionManager.commit();
                }
            }
            catch (SystemException se) {
                String err = "Failed addDeployableUnit(" + descriptor + "), because of system exception during tx.commit()! ";
                logger.error((Object)err, (Throwable)se);
                throw new RuntimeException("unexpected exception ! ", se);
            }
        }
    }

    public DeployableUnitID[] getDeployableUnits() {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            int defaultSleeDUs = 2;
            int duds = this.getDeploymentCacheManager().getDeployableUnitIDtoDescriptorMap().size();
            DeployableUnitID[] duArray = new DeployableUnitIDImpl[duds + 2];
            this.getDeploymentCacheManager().getDeployableUnitIDtoDescriptorMap().keySet().toArray(duArray);
            DeployableUnitIDImpl dummyDud = new DeployableUnitIDImpl(-1);
            for (int i = duds; i < duArray.length; ++i) {
                duArray[i] = dummyDud;
            }
            DeployableUnitID[] deployableUnitIDArray = duArray;
            return deployableUnitIDArray;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected exception ", ex);
        }
        finally {
            try {
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("unexpected exception ! ", ex);
            }
        }
    }

    public DeployableUnitDescriptor getDeployableUnitDescriptor(DeployableUnitID deployableUnitID) {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            DeployableUnitDescriptor dud;
            DeployableUnitDescriptor deployableUnitDescriptor = dud = (DeployableUnitDescriptor)this.getDeploymentCacheManager().getDeployableUnitIDtoDescriptorMap().get(deployableUnitID);
            return deployableUnitDescriptor;
        }
        catch (Exception ex) {
            throw new RuntimeException("unexpected error getting du descriptor", ex);
        }
        finally {
            try {
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Unexpected exception ", ex);
            }
        }
    }

    public ComponentDescriptor getComponentDescriptor(ComponentID componentId) throws IllegalArgumentException {
        boolean b = false;
        try {
            b = SleeContainer.getTransactionManager().requireTransaction();
            ComponentIDImpl cidImpl = (ComponentIDImpl)componentId;
            if (cidImpl.isSbbID()) {
                ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.getDeploymentCacheManager().getSbbComponents().get(componentId);
                return componentDescriptor;
            }
            if (cidImpl.isServiceID()) {
                ServiceDescriptorImpl serviceDescriptorImpl = ((ServiceComponent)this.getDeploymentCacheManager().getServiceComponents().get(componentId)).getServiceDescriptor();
                return serviceDescriptorImpl;
            }
            if (cidImpl.isProfileSpecificationID()) {
                ProfileSpecificationDescriptor profileSpecificationDescriptor = (ProfileSpecificationDescriptor)this.getDeploymentCacheManager().getProfileComponents().get(componentId);
                return profileSpecificationDescriptor;
            }
            if (cidImpl.isEventTypeID()) {
                ComponentDescriptor componentDescriptor = (ComponentDescriptor)this.eventTypeIDToDescriptor.get(componentId);
                return componentDescriptor;
            }
            if (cidImpl.isResourceAdaptorTypeID()) {
                ResourceAdaptorTypeDescriptorImpl resourceAdaptorTypeDescriptorImpl = ((ResourceAdaptorType)this.resourceAdaptorTypes.get(componentId)).getRaTypeDescr();
                return resourceAdaptorTypeDescriptorImpl;
            }
            if (cidImpl instanceof ResourceAdaptorIDImpl) {
                ResourceAdaptorDescriptorImpl resourceAdaptorDescriptorImpl = ((InstalledResourceAdaptor)this.installedResourceAdaptors.get(componentId)).getDescriptor();
                return resourceAdaptorDescriptorImpl;
            }
            try {
                throw new IllegalArgumentException(" bad component id");
            }
            catch (SystemException ex) {
                throw new RuntimeException("Tx manager failed !", ex);
            }
        }
        finally {
            try {
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (SystemException ex) {
                throw new RuntimeException("Tx manager failed !", ex);
            }
        }
    }

    public EventTypeID[] getEventTypes() {
        EventTypeID[] eventTypeIDArray = new EventTypeIDImpl[this.eventTypeIDs.size()];
        this.eventTypeIDs.values().toArray(eventTypeIDArray);
        return eventTypeIDArray;
    }

    public ResourceAdaptorContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public synchronized ResourceAdaptorIDImpl[] getResourceAdaptorIDs() {
        ResourceAdaptorIDImpl[] retval = new ResourceAdaptorIDImpl[this.installedResourceAdaptors.size()];
        this.installedResourceAdaptors.keySet().toArray(retval);
        return retval;
    }

    public synchronized ResourceAdaptorTypeID[] getResourceAdaptorTypeIDs() {
        ResourceAdaptorTypeID[] raTypeIds = new ResourceAdaptorTypeID[this.resourceAdaptorTypes.size()];
        this.resourceAdaptorTypes.keySet().toArray(raTypeIds);
        return raTypeIds;
    }

    public ResourceAdaptorEntity createResourceAdaptorEntity(ResourceAdaptorIDImpl id, String name, Properties properties) throws NullPointerException, UnrecognizedResourceAdaptorException, InvalidArgumentException, ResourceAdaptorEntityAlreadyExistsException, ResourceException, ManagementException, CreateException {
        if (this.installedResourceAdaptors.get(id) == null) {
            String msg = "Failed to create RA Entity. RA ID: " + id + " not found.";
            logger.error((Object)msg);
            throw new UnrecognizedResourceAdaptorException(msg);
        }
        if (this.resourceAdaptorEntities.get(name) != null) {
            String msg = "Failed to create RA Entity. Resource Adpator Entity Name: " + name + " already exists! RA ID: " + id;
            logger.error((Object)msg);
            throw new ResourceAdaptorEntityAlreadyExistsException(msg);
        }
        InstalledResourceAdaptor installedRA = (InstalledResourceAdaptor)this.installedResourceAdaptors.get(id);
        ResourceAdaptorEntity raEntity = new ResourceAdaptorEntity(name, installedRA, new ResourceAdaptorBoostrapContext(new SleeEndpointImpl(this.activityContextFactory, this.router, this, name), new EventLookupFacilityImpl(this), name), this);
        this.resourceAdaptorEntities.put(name, raEntity);
        try {
            logger.info((Object)("PROPERTIES: " + properties));
            raEntity.configure(properties);
        }
        catch (InvalidStateException e) {
            logger.warn((Object)"Failed to create RA Entity. ", (Throwable)e);
            new ResourceException("Resource exception ");
        }
        installedRA.addResourceAdaptorEntity(raEntity);
        return raEntity;
    }

    public String getRAEntityInterfaceJNDIName(String link) {
        ResourceAdaptorEntity raEntity = (ResourceAdaptorEntity)this.resourceAdaptorEntities.get(this.resourceAdaptorEntityLinks.get(link));
        return raEntity.getFactoryInterfaceJNDIName();
    }

    public String getRAEntityFactoryInterfaceJNDIName(String link) {
        ResourceAdaptorEntity raEntity = (ResourceAdaptorEntity)this.resourceAdaptorEntities.get(this.resourceAdaptorEntityLinks.get(link));
        return raEntity.getFactoryInterfaceJNDIName();
    }

    public ResourceAdaptorEntity getRAEntity(String link, ResourceAdaptorType raType) {
        ResourceAdaptorEntity raEntity = (ResourceAdaptorEntity)this.resourceAdaptorEntities.get(this.resourceAdaptorEntityLinks.get(link));
        return raEntity != null && raEntity.getInstalledResourceAdaptor().getRaType() == raType ? raEntity : null;
    }

    public ResourceAdaptorEntity getRAEntity(String link) {
        return (ResourceAdaptorEntity)this.resourceAdaptorEntities.get(this.resourceAdaptorEntityLinks.get(link));
    }

    public void removeResourceAdaptorEntity(String name) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, DependencyException, ManagementException {
        if (this.resourceAdaptorEntities.get(name) == null) {
            throw new UnrecognizedResourceAdaptorEntityException("Resource Adaptor Entity " + name + " not found.");
        }
        ResourceAdaptorEntity raEntity = (ResourceAdaptorEntity)this.resourceAdaptorEntities.get(name);
        try {
            raEntity.remove();
        }
        catch (InvalidStateException e) {
            e.printStackTrace();
            throw new DependencyException("Resource Adaptor Entity " + name + " is in the wrong state");
        }
        raEntity.getInstalledResourceAdaptor().removeResourceAdaptorEntity(raEntity);
        this.resourceAdaptorEntities.remove(name);
    }

    public void updateConfigurationProperties(String name, Properties properties) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, InvalidStateException, ResourceException, ManagementException {
        if (this.resourceAdaptorEntities.get(name) == null) {
            throw new UnrecognizedResourceAdaptorEntityException("Resource Adaptor Entity " + name + " not found.");
        }
        ResourceAdaptorEntity raEntity = (ResourceAdaptorEntity)this.resourceAdaptorEntities.get(name);
        raEntity.configure(properties);
    }

    public void deactivateResourceAdaptorEntity(String name) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, InvalidStateException, ManagementException {
        if (this.resourceAdaptorEntities.get(name) == null) {
            throw new UnrecognizedResourceAdaptorEntityException("Resource Adaptor Entity " + name + " not found.");
        }
        ResourceAdaptorEntity raEntity = (ResourceAdaptorEntity)this.resourceAdaptorEntities.get(name);
        raEntity.deactivate();
    }

    public Properties getRAEntityProperties(String entityName) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, ManagementException {
        if (entityName == null) {
            throw new NullPointerException("null entity name");
        }
        ResourceAdaptorEntity resourceAdaptorEntity = (ResourceAdaptorEntity)this.resourceAdaptorEntities.get(entityName);
        if (resourceAdaptorEntity == null) {
            throw new UnrecognizedResourceAdaptorEntityException("Resource Adaptor Entity " + entityName + " not found.");
        }
        try {
            Properties properties = new Properties();
            for (ConfigPropertyDescriptor configPropertyDescriptor : resourceAdaptorEntity.getInstalledResourceAdaptor().getDescriptor().getConfigPropertyDescriptors()) {
                String value = resourceAdaptorEntity.getConfigProperty(configPropertyDescriptor).toString();
                properties.setProperty(configPropertyDescriptor.getName(), value);
            }
            return properties;
        }
        catch (ResourceException e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage());
        }
    }

    public Properties getRAProperties(ResourceAdaptorID id) throws NullPointerException, UnrecognizedResourceAdaptorException {
        if (id == null) {
            throw new NullPointerException("null resource adaptor id");
        }
        InstalledResourceAdaptor installedResourceAdaptor = (InstalledResourceAdaptor)this.installedResourceAdaptors.get(id);
        if (installedResourceAdaptor == null) {
            throw new UnrecognizedResourceAdaptorException("unrecognized resource adaptor " + id.toString());
        }
        Properties properties = new Properties();
        for (ConfigPropertyDescriptor configPropertyDescriptor : installedResourceAdaptor.getDescriptor().getConfigPropertyDescriptors()) {
            String value = configPropertyDescriptor.getValue().toString();
            properties.setProperty(configPropertyDescriptor.getName(), value);
        }
        return properties;
    }

    public synchronized ResourceAdaptorType getResourceAdaptorType(ResourceAdaptorTypeID key) {
        return (ResourceAdaptorType)this.resourceAdaptorTypes.get(key);
    }

    public boolean isInstalled(DeployableUnitID deployableUnitID) {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            boolean bl = this.getDeploymentCacheManager().getDeployableUnitIDtoDescriptorMap().containsKey(deployableUnitID);
            return bl;
        }
        catch (SystemException ex) {
            throw new RuntimeException("tx manager failed! ", ex);
        }
        finally {
            try {
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (SystemException ex) {
                throw new RuntimeException("tx maanger failed ", ex);
            }
        }
    }

    public boolean isInstalled(ComponentID componentId) {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            if (componentId instanceof SbbID) {
                boolean bl = this.getDeploymentCacheManager().getSbbComponents().containsKey(componentId);
                return bl;
            }
            if (componentId instanceof ServiceID) {
                boolean bl = this.getDeploymentCacheManager().getServiceComponents().containsKey(componentId);
                return bl;
            }
            if (componentId instanceof EventTypeID) {
                boolean bl = this.eventTypeIDs.containsKey(componentId);
                return bl;
            }
            if (componentId instanceof ProfileSpecificationID) {
                boolean bl = this.getDeploymentCacheManager().getProfileComponents().containsKey(componentId);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SystemException ex) {
            throw new RuntimeException("tx manager failed! ", ex);
        }
        finally {
            try {
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (SystemException ex) {
                throw new RuntimeException("tx maanger failed ", ex);
            }
        }
    }

    private void removeReferredComponents(DeployableUnitDescriptorImpl dudesc) {
        ComponentID[] cid = dudesc.getComponents();
        for (int i = 0; i < cid.length; ++i) {
            this.removeReferredComponent(cid[i]);
        }
    }

    public void removeDeployableUnit(DeployableUnitID deployableUnitID) throws Exception {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            DeployableUnitDescriptorImpl deployableUnitDescriptor;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("removeDeployableUnit " + deployableUnitID));
                logger.debug((Object)("referring components map " + this.getDeploymentCacheManager().getReferringComponents()));
                logger.debug((Object)("serviceToDUMap = " + this.getDeploymentCacheManager().getComponentIDToDeployableUnitIDMap()));
            }
            if ((deployableUnitDescriptor = (DeployableUnitDescriptorImpl)this.getDeploymentCacheManager().getDeployableUnitIDtoDescriptorMap().get(deployableUnitID)) == null) {
                throw new UnrecognizedDeployableUnitException("Unrecognized deployable unit " + deployableUnitID);
            }
            if (this.hasReferringDU(deployableUnitDescriptor)) {
                throw new DependencyException("Somebody is referencing a component of this DU -- cannot uninstall it!");
            }
            this.removeDU(deployableUnitDescriptor);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Done with removeDeployableUnit " + deployableUnitID));
                logger.debug((Object)("referring components map " + this.getDeploymentCacheManager().getReferringComponents()));
                logger.debug((Object)("serviceToDUMap = " + this.getDeploymentCacheManager().getComponentIDToDeployableUnitIDMap()));
                logger.debug((Object)("profileTable = " + this.getDeploymentCacheManager().getProfileComponents()));
                logger.debug((Object)("sbbComponents = " + this.getDeploymentCacheManager().getSbbComponents()));
                logger.debug((Object)("serviceComponents = " + this.getDeploymentCacheManager().getServiceComponents()));
            }
        }
        catch (Exception ex) {
            SleeContainer.getTransactionManager().setRollbackOnly();
            throw ex;
        }
        finally {
            if (b) {
                SleeContainer.getTransactionManager().commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDU(DeployableUnitDescriptorImpl deployableUnitDescriptor) throws Exception {
        logger.info((Object)"doRemove entry");
        DeployableUnitIDImpl deployableUnitID = deployableUnitDescriptor.getDeployableUnit();
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("doRemove: " + deployableUnitDescriptor.getDeployableUnit()));
            }
            this.removeReferredComponents(deployableUnitDescriptor);
            this.removeReferredDU(deployableUnitID);
            this.checkServicesStateOnDUUndeploy(deployableUnitID);
            this.getDeploymentCacheManager().getDeployableUnitIDtoDescriptorMap().remove(deployableUnitID);
            this.uninstallRA(deployableUnitID);
            this.uninstallRAType(deployableUnitID);
            this.removeEventType(deployableUnitID);
            this.uninstallService(deployableUnitID);
            this.deploymentManager.undeployUnit(deployableUnitID);
            String url = deployableUnitID.getSourceURL().toString();
            this.getDeploymentCacheManager().getUrlToDeployableUnitIDMap().remove(url);
            this.removeDeployedProfileComps(deployableUnitID);
            this.removeDeployedSbbComps(deployableUnitID);
            try {
                deployableUnitDescriptor.getTmpDeploymentDirectory().delete();
                deployableUnitDescriptor.getTmpDUJarsDirectory().delete();
            }
            catch (Exception ex) {
                logger.error((Object)"Error removing tmp directories ", (Throwable)ex);
            }
        }
        finally {
            if (b) {
                SleeContainer.getTransactionManager().commit();
            }
        }
    }

    private void checkServicesStateOnDUUndeploy(DeployableUnitIDImpl deployableUnitID) throws SystemException, InvalidStateException {
        Map serviceComps = this.getDeploymentCacheManager().getServiceComponents();
        for (Map.Entry nentry : serviceComps.entrySet()) {
            ServiceComponent svc = (ServiceComponent)nentry.getValue();
            if (!svc.getDeployableUnit().equals(deployableUnitID) || !svc.isLocked()) continue;
            throw new InvalidStateException("Service state is not stopped");
        }
    }

    private void removeDeployedSbbComps(DeployableUnitIDImpl deployableUnitID) throws SystemException, Exception, NamingException {
        Map sbbComps = this.getDeploymentCacheManager().getSbbComponents();
        for (Map.Entry nentry : sbbComps.entrySet()) {
            MobicentsSbbDescriptor sbbDescriptor = (MobicentsSbbDescriptor)nentry.getValue();
            if (sbbDescriptor.getDeployableUnit().equals(deployableUnitID)) {
                if (!deployableUnitID.getDescriptor().hasInstalledComponent((ComponentID)nentry.getKey())) {
                    logger.info((Object)(" === SBBComp[" + sbbDescriptor.getID() + "] WAS NOT ISNTALLED BY DU[" + deployableUnitID.getSourceURL() + "] ==="));
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("removing SbbComponent : " + deployableUnitID));
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("removing sbbComponent : " + sbbDescriptor.getID()));
                }
                ((UnifiedClassLoader3)sbbDescriptor.getClassLoader()).unregister();
                ComponentID cid = (ComponentID)nentry.getKey();
                sbbComps.remove(cid);
                ObjectPool sbbObjPool = this.getObjectPool((SbbID)sbbDescriptor.getID());
                sbbObjPool.clear();
                this.sbbPooling.remove(sbbDescriptor.getID());
                SleeContainer.getTraceFacility().unSetTraceLevel(sbbDescriptor.getID());
                SleeContainer.getAlarmFacility().unRegisterComponent(sbbDescriptor.getID());
                continue;
            }
            logger.info((Object)("sbbComponent " + sbbDescriptor.getID() + " belongs to " + sbbDescriptor.getDeployableUnit()));
        }
    }

    private void removeDeployedProfileComps(DeployableUnitIDImpl deployableUnitID) throws SystemException {
        Map profileComps = this.getDeploymentCacheManager().getProfileComponents();
        for (Map.Entry nentry : profileComps.entrySet()) {
            ProfileSpecificationDescriptorImpl profileDescriptor = (ProfileSpecificationDescriptorImpl)nentry.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("deployableUnit = " + profileDescriptor.getDeployableUnit()));
            }
            if (profileDescriptor.getDeployableUnit() == null || !profileDescriptor.getDeployableUnit().equals(deployableUnitID)) continue;
            if (!deployableUnitID.getDescriptor().hasInstalledComponent((ComponentID)nentry.getKey())) {
                logger.debug((Object)(" === ProfileComp[" + profileDescriptor.getID() + "] WAS NOT ISNTALLED BY DU[" + deployableUnitID.getSourceURL() + "] ==="));
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("removing Profile " + profileDescriptor.getID()));
            }
            ComponentID cid = (ComponentID)nentry.getKey();
            profileComps.remove(cid);
        }
    }

    public DeployableUnitID getDeployableUnitIDFromUrl(String deploymentUrl) throws UnrecognizedDeployableUnitException {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            DeployableUnitID retval = (DeployableUnitID)this.getDeploymentCacheManager().getUrlToDeployableUnitIDMap().get(deploymentUrl);
            if (retval == null) {
                throw new UnrecognizedDeployableUnitException("Unrecognized  deployable unit " + deploymentUrl);
            }
            DeployableUnitID deployableUnitID = retval;
            return deployableUnitID;
        }
        catch (SystemException ex) {
            throw new RuntimeException("Tx manager failed! ", ex);
        }
        finally {
            if (b) {
                try {
                    SleeContainer.getTransactionManager().commit();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to complete tx for getDeployableUnitIDFromUrl()", (Throwable)e);
                    throw new SLEEException("Failed to complete tx for getDeployableUnitIDFromUrl()", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceID[] getServicesByState(ServiceState serviceState) throws Exception {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            if (serviceState == ServiceState.ACTIVE) {
                DeploymentCacheManager dumgr = this.getDeploymentCacheManager();
                Set activeServiceIds = dumgr.getActiveServiceIDs();
                ServiceID[] serviceIDArray = activeServiceIds.toArray(new ServiceID[0]);
                return serviceIDArray;
            }
            Iterator it = this.getDeploymentCacheManager().getServiceComponents().values().iterator();
            ArrayList<ServiceID> retval = new ArrayList<ServiceID>();
            while (it.hasNext()) {
                ServiceComponent svc = (ServiceComponent)it.next();
                Service service = this.getService(svc.getServiceID());
                if (!service.getState().equals((Object)serviceState)) continue;
                retval.add(svc.getServiceID());
            }
            ServiceID[] ret = new ServiceID[retval.size()];
            retval.toArray(ret);
            ServiceID[] serviceIDArray = ret;
            return serviceIDArray;
        }
        finally {
            try {
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Transaction manager failed commit", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopService(ServiceID serviceID) throws UnrecognizedServiceException, InvalidStateException {
        Serializable svc;
        if (serviceID == null) {
            throw new NullPointerException("null service ID");
        }
        logger.debug((Object)("============Stopping service:" + serviceID));
        SleeTransactionManager transactionManager = SleeContainer.getTransactionManager();
        boolean rb = true;
        try {
            transactionManager.begin();
            if (this.getDeploymentCacheManager().getServiceComponents().get(serviceID) == null) {
                throw new UnrecognizedServiceException("Service not found for " + serviceID);
            }
            svc = this.getServiceComponent(serviceID);
            Service service = this.getService(serviceID);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Service is " + service + " serviceState = " + service.getState()));
            }
            if (service.getState().equals((Object)ServiceState.STOPPING)) {
                throw new InvalidStateException("Service is STOPPING");
            }
            if (service.getState().equals((Object)ServiceState.INACTIVE)) {
                this.getDeploymentCacheManager().getActiveServiceIDs().remove(serviceID);
                throw new InvalidStateException("Service already deactivated");
            }
            HashSet sbbIDs = ((ServiceComponent)svc).getSbbComponents();
            HashSet<ResourceAdaptorEntity> raEntities = new HashSet<ResourceAdaptorEntity>();
            Iterator i = sbbIDs.iterator();
            while (i.hasNext()) {
                SbbDescriptor sbbdesc = this.getSbbComponent((SbbID)i.next());
                if (sbbdesc == null) continue;
                String[] raLinks = sbbdesc.getResourceAdaptorEntityLinks();
                for (int c = 0; raLinks != null && c < raLinks.length; ++c) {
                    ResourceAdaptorEntity raEntity = this.getRAEntity(raLinks[c]);
                    if (raEntity == null || raEntities.contains(raEntity)) continue;
                    raEntity.serviceDeactivated(serviceID.toString());
                    raEntities.add(raEntity);
                }
            }
            service.deactivate();
            this.getDeploymentCacheManager().getActiveServiceIDs().remove(serviceID);
            rb = false;
        }
        catch (InvalidStateException ise) {
            logger.error((Object)ise);
            throw ise;
        }
        catch (SystemException ex) {
            logger.error((Object)ex);
            throw new RuntimeException("Tx manager failed! ", ex);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new SLEEException("Failed to stop service " + serviceID, (Throwable)e);
        }
        finally {
            try {
                if (rb) {
                    transactionManager.setRollbackOnly();
                }
                transactionManager.commit();
            }
            catch (SystemException e2) {
                logger.error((Object)e2);
            }
        }
        try {
            SleeContainer.getTransactionManager().begin();
            this.getServiceComponent(serviceID).unlock();
            SleeContainer.getTransactionManager().commit();
            while (true) {
                logger.info((Object)("Waiting for Stop " + serviceID));
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                SleeContainer.getTransactionManager().begin();
                svc = this.getService(serviceID);
                if (svc == null) {
                    logger.info((Object)"Service has been removed!");
                    break;
                }
                if (((Service)svc).getState().equals((Object)ServiceState.INACTIVE)) {
                    new SleeContainerLingeringServiceSbbRemoverTask(this.sbbEntityRemoverTimer, (Service)svc, this.sevriceIdsToRemovalTasks);
                    break;
                }
                logger.info((Object)("Service State is " + ((Service)svc).getState()));
                SleeContainer.getTransactionManager().commit();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                Service svc2 = this.getService(serviceID);
                logger.info((Object)("Successfully Stopped service " + serviceID + " State = " + svc2.getState()));
                SleeContainer.getTransactionManager().commit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getRAActivityContextInterfaceFactoryJNDIName(ResourceAdaptorTypeID resourceAdapterTypeId) {
        ResourceAdaptorActivityContextInterfaceFactory acif = (ResourceAdaptorActivityContextInterfaceFactory)this.activityContextInterfaceFactories.get(resourceAdapterTypeId);
        return acif.getJndiName();
    }

    public EventRouter getEventRouter() {
        return this.router;
    }

    public ProfileSpecificationID[] getProfileSpecificationIDs() {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            ProfileSpecificationID[] retval = new ProfileSpecificationIDImpl[this.getDeploymentCacheManager().getProfileComponents().size()];
            this.getDeploymentCacheManager().getProfileComponents().keySet().toArray(retval);
            ProfileSpecificationID[] profileSpecificationIDArray = retval;
            return profileSpecificationIDArray;
        }
        catch (SystemException ex) {
            throw new RuntimeException("Tx manager failed ", ex);
        }
        finally {
            try {
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (SystemException ex) {
                throw new RuntimeException("tx maanger failed ", ex);
            }
        }
    }

    public NullActivityFactoryImpl getNullActivityFactory() {
        return this.nullActivityFactory;
    }

    public NullActivityContextInterfaceFactoryImpl getNullActivityContextInterfaceFactory() {
        return this.nullActivityContextInterfaceFactory;
    }

    protected void initNamingContexts() throws Exception {
        Context ctx = new InitialContext();
        ctx = Util.createSubcontext((Context)ctx, (String)"java:slee");
        Util.createSubcontext((Context)ctx, (String)"resources");
        Util.createSubcontext((Context)ctx, (String)JNDI_NAME);
        Util.createSubcontext((Context)ctx, (String)"facilities");
        Util.createSubcontext((Context)ctx, (String)"sbbs");
        ctx = Util.createSubcontext((Context)ctx, (String)"nullactivity");
        Util.createSubcontext((Context)ctx, (String)"factory");
        Util.createSubcontext((Context)ctx, (String)"nullactivitycontextinterfacefactory");
    }

    protected void registerPropertyEditors() {
        PropertyEditorManager.registerEditor(ComponentID.class, ComponentIDPropertyEditor.class);
        PropertyEditorManager.registerEditor(Level.class, LevelPropertyEditor.class);
        PropertyEditorManager.registerEditor(Properties.class, PropertiesPropertyEditor.class);
        PropertyEditorManager.registerEditor(ProfileSpecificationID.class, ProfileSpecificationIDPropertyEditor.class);
        PropertyEditorManager.registerEditor(ComponentID[].class, ComponentIDArrayPropertyEditor.class);
        PropertyEditorManager.registerEditor(SbbID[].class, ComponentIDArrayPropertyEditor.class);
        PropertyEditorManager.registerEditor(DeployableUnitID.class, DeployableUnitIDPropertyEditor.class);
        PropertyEditorManager.registerEditor(Object.class, ObjectPropertyEditor.class);
        PropertyEditorManager.registerEditor(ServiceID.class, ComponentIDPropertyEditor.class);
        PropertyEditorManager.registerEditor(Object.class, ServiceStatePropertyEditor.class);
        PropertyEditorManager.registerEditor(ResourceAdaptorID.class, ComponentIDPropertyEditor.class);
    }

    public SleeState getSleeState() {
        return this.sleeState;
    }

    public SleeState setSleeState(SleeState newState) {
        this.sleeState = newState;
        return this.sleeState;
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public SbbEntityFactory getSbbEntityFactory() {
        return this.sbbEntityFactory;
    }

    public ServiceActivityContextInterfaceFactoryImpl getServiceActivityContextFactory() {
        return this.serviceActivityContextInterfaceFactory;
    }

    public synchronized void removeEventType(MobicentsEventTypeDescriptor descriptor) {
        EventTypeIDImpl eventTypeID = (EventTypeIDImpl)descriptor.getID();
        ComponentKey ckey = eventTypeID.getComponentKey();
        logger.info((Object)"entry of removeEventType MobicentsEventTypeDescriptor");
        this.eventTypeIDToDescriptor.remove(eventTypeID);
        this.eventKeyToEventTypeIDMap.remove(ckey);
        this.eventTypeIDToEventKeyMap.remove(eventTypeID);
        this.eventTypeIDs.remove(new Integer(eventTypeID.getEventID()));
        logger.info((Object)("EVENT TYPE REMOVED: " + eventTypeID));
    }

    public HashMap getActivityContextInterfaceFactories() {
        return this.activityContextInterfaceFactories;
    }

    public void addActivityContextInterfaceFactory(ComponentID key, TCKActivityContextInterfaceFactoryImpl acif) {
        this.activityContextInterfaceFactories.put(key, acif);
    }

    public void createResourceAdaptorEntityLink(String link, String entityName) throws ManagementException {
        if (this.resourceAdaptorEntityLinks.containsKey(link)) {
            throw new ManagementException("Entity Link already exist!");
        }
        this.resourceAdaptorEntityLinks.put(link, entityName);
    }

    public void removeResourceAdaptorEntityLink(String link) throws ManagementException {
        if (!this.resourceAdaptorEntityLinks.containsKey(link)) {
            throw new ManagementException("Entity Link not found!");
        }
        this.resourceAdaptorEntityLinks.remove(link);
    }

    public Set listResourceAdaptorEntityLinks() {
        return this.resourceAdaptorEntityLinks.keySet();
    }

    public String[] getResourceAdaptorEntityLinks() throws ManagementException {
        Set entityLinksSet = this.resourceAdaptorEntityLinks.keySet();
        String[] entityLinksArray = new String[entityLinksSet.size()];
        entityLinksArray = entityLinksSet.toArray(entityLinksArray);
        return entityLinksArray;
    }

    public String getResourceAdaptorEntityName(String linkName) throws NullPointerException, UnrecognizedLinkNameException {
        if (linkName == null) {
            throw new NullPointerException("null link name");
        }
        String entityName = (String)this.resourceAdaptorEntityLinks.get(linkName);
        if (entityName == null) {
            throw new UnrecognizedLinkNameException("Entity link " + linkName + " not found");
        }
        return entityName;
    }

    public String[] getResourceAdaptorEntityNames(String[] linkNames) throws NullPointerException {
        if (linkNames == null) {
            throw new NullPointerException("null link names");
        }
        String[] resultEntityNames = new String[linkNames.length];
        for (int i = 0; i < linkNames.length; ++i) {
            String entityName;
            resultEntityNames[i] = entityName = (String)this.resourceAdaptorEntityLinks.get(linkNames[i]);
        }
        return resultEntityNames;
    }

    public String[] getResourceAdaptorEntityNames() {
        String[] entityNames = new String[this.resourceAdaptorEntities.keySet().size()];
        entityNames = this.resourceAdaptorEntities.keySet().toArray(entityNames);
        return entityNames;
    }

    public String[] getResourceAdaptorEntityNames(ResourceAdaptorID resourceAdaptorID) throws NullPointerException, UnrecognizedResourceAdaptorException {
        if (resourceAdaptorID == null) {
            throw new NullPointerException("null resource adaptor");
        }
        InstalledResourceAdaptor installedRA = (InstalledResourceAdaptor)this.installedResourceAdaptors.get(resourceAdaptorID);
        if (installedRA == null) {
            throw new UnrecognizedResourceAdaptorException("Resource adaptor " + resourceAdaptorID.toString() + " not found");
        }
        HashSet resourceAdaptorEntitiesSet = installedRA.getResourceAdaptorEntities();
        ResourceAdaptorEntity[] resourceAdaptorEntitiesArray = new ResourceAdaptorEntity[resourceAdaptorEntitiesSet.size()];
        resourceAdaptorEntitiesArray = resourceAdaptorEntitiesSet.toArray(resourceAdaptorEntitiesArray);
        String[] entityNames = new String[resourceAdaptorEntitiesArray.length];
        for (int i = 0; i < entityNames.length; ++i) {
            entityNames[i] = resourceAdaptorEntitiesArray[i].getName();
        }
        return entityNames;
    }

    public String[] getResourceAdaptorEntityLinks(String entityName) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, ManagementException {
        if (entityName == null) {
            throw new NullPointerException("null entity name");
        }
        if (!this.resourceAdaptorEntities.containsKey(entityName)) {
            throw new UnrecognizedResourceAdaptorEntityException("Entity " + entityName + " not found");
        }
        String[] entityLinksArray = this.getResourceAdaptorEntityLinks();
        ArrayList<String> resultEntityLinksArrayList = new ArrayList<String>();
        for (int i = 0; i < entityLinksArray.length; ++i) {
            String entityLink = entityLinksArray[i];
            String entity = (String)this.resourceAdaptorEntityLinks.get(entityLink);
            if (!entity.equals(entityName)) continue;
            resultEntityLinksArrayList.add(entityLink);
        }
        String[] resultEntityLinks = new String[resultEntityLinksArrayList.size()];
        resultEntityLinks = resultEntityLinksArrayList.toArray(resultEntityLinks);
        return resultEntityLinks;
    }

    public ResourceAdaptorEntity getResourceAdaptorEntity(String entityName) throws NullPointerException, UnrecognizedResourceAdaptorEntityException {
        if (entityName == null) {
            throw new NullPointerException("null entity name");
        }
        ResourceAdaptorEntity entity = (ResourceAdaptorEntity)this.resourceAdaptorEntities.get(entityName);
        if (entity == null) {
            throw new UnrecognizedResourceAdaptorEntityException("Entity " + entityName + " not found");
        }
        return entity;
    }

    public ResourceAdaptorEntity getResourceAdaptorEnitity(String enitityName) {
        return (ResourceAdaptorEntity)this.resourceAdaptorEntities.get(enitityName);
    }

    public HashMap getResourceAdaptorEntities() {
        return this.resourceAdaptorEntities;
    }

    public HashMap getResourceAdaptorEnitities() {
        return this.resourceAdaptorEntities;
    }

    public ResourceAdaptorID getResourceAdaptorID(String entityName) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, ManagementException {
        if (entityName == null) {
            throw new NullPointerException("null entity name");
        }
        ResourceAdaptorEntity resourceAdaptorEntity = (ResourceAdaptorEntity)this.resourceAdaptorEntities.get(entityName);
        if (resourceAdaptorEntity == null) {
            throw new UnrecognizedResourceAdaptorEntityException("Entity " + entityName + " not found");
        }
        return resourceAdaptorEntity.getInstalledResourceAdaptor().getKey();
    }

    public String[] getResourceAdaptorEntities(ResourceAdaptorEntityState state) throws NullPointerException, ManagementException {
        if (state == null) {
            throw new NullPointerException("null entity state");
        }
        Iterator resourceAdaptorEntityIterator = this.resourceAdaptorEntities.values().iterator();
        ArrayList<String> resultEntityNamesArrayList = new ArrayList<String>();
        while (resourceAdaptorEntityIterator.hasNext()) {
            ResourceAdaptorEntity resourceAdaptorEntity = (ResourceAdaptorEntity)resourceAdaptorEntityIterator.next();
            if (!resourceAdaptorEntity.getState().equals((Object)state)) continue;
            resultEntityNamesArrayList.add(resourceAdaptorEntity.getName());
        }
        String[] resultEntityNames = new String[resultEntityNamesArrayList.size()];
        resultEntityNames = resultEntityNamesArrayList.toArray(resultEntityNames);
        return resultEntityNames;
    }

    public ServiceComponent getServiceComponent(ServiceID svc) {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            ServiceComponent serviceComponent = (ServiceComponent)this.getDeploymentCacheManager().getServiceComponents().get(svc);
            return serviceComponent;
        }
        catch (SystemException ex) {
            throw new RuntimeException("Tx manager failed ", ex);
        }
        finally {
            try {
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (SystemException ex) {
                throw new RuntimeException("tx maanger failed ", ex);
            }
        }
    }

    public boolean checkServiceExists(ServiceID serviceID) {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            boolean bl = this.getDeploymentCacheManager().getServiceComponents().containsKey(serviceID);
            return bl;
        }
        catch (SystemException ex) {
            throw new RuntimeException("Tx manager failed ", ex);
        }
        finally {
            try {
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (SystemException ex) {
                throw new RuntimeException("tx maanger failed ", ex);
            }
        }
    }

    public int getRmiRegistryPort() throws Exception {
        Integer port = (Integer)this.mbeanServer.getAttribute(new ObjectName("slee:service=SleeTCKWrapper"), "RMIRegistryPort");
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployableUnitDescriptor[] getDeployableUnitDescriptors() throws SystemException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getDeployableUnitDescriptors() ");
        }
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            Object[] descriptors = this.getDeploymentCacheManager().getDeployableUnitIDtoDescriptorMap().values().toArray();
            DeployableUnitDescriptor[] retval = new DeployableUnitDescriptor[descriptors.length];
            for (int i = 0; i < descriptors.length; ++i) {
                retval[i] = (DeployableUnitDescriptor)descriptors[i];
            }
            DeployableUnitDescriptor[] deployableUnitDescriptorArray = retval;
            return deployableUnitDescriptorArray;
        }
        finally {
            try {
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (SystemException ex) {
                throw new RuntimeException("tx maanger failed ", ex);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getDeployableUnitDescriptors() exit");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentDescriptor[] getDescriptors(ComponentID[] componentIds) {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        try {
            ArrayList<ComponentDescriptor> knownComps = new ArrayList<ComponentDescriptor>();
            for (int i = 0; i < componentIds.length; ++i) {
                if (!this.isInstalled(componentIds[i])) continue;
                ComponentDescriptor descr = this.getComponentDescriptor(componentIds[i]);
                knownComps.add(descr);
            }
            ComponentDescriptor[] components = new ComponentDescriptor[knownComps.size()];
            knownComps.toArray(components);
            ComponentDescriptor[] componentDescriptorArray = components;
            return componentDescriptorArray;
        }
        finally {
            try {
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (SystemException ex) {
                throw new RuntimeException("tx maanger failed ", ex);
            }
        }
    }

    public static boolean isSecurityEnabled() {
        return isSecurityEnabled;
    }

    static {
        logger = Logger.getLogger(SleeContainer.class);
    }
}

