/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.slee.ServiceID;
import javax.slee.UnrecognizedServiceException;
import javax.slee.management.ServiceState;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.service.Service;
import org.mobicents.slee.runtime.SbbEntity;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

class SleeContainerLingeringServiceSbbRemoverTask
extends TimerTask {
    private static Logger logger = Logger.getLogger(SleeContainerLingeringServiceSbbRemoverTask.class);
    private static double sbbEntityRemovalDelay = 60.0;
    private static final String propertyName = "entities.removal.delay";
    private static final String propertyFileName = "removal.properties";
    private Timer runningTimer = null;
    private ServiceID serviceID = null;
    private Service svc1 = null;
    private Map mapOfTasks = null;
    private boolean hasRun = false;

    public SleeContainerLingeringServiceSbbRemoverTask(Timer timerToRunIn, Service svcComponent, Map mapOfTasks) {
        this.mapOfTasks = mapOfTasks;
        this.runningTimer = timerToRunIn;
        this.serviceID = svcComponent.getServiceID();
        this.svc1 = svcComponent;
        this.mapOfTasks.put(this.serviceID.toString(), this);
        long executionTime = (long)(60000.0 * sbbEntityRemovalDelay);
        this.runningTimer.schedule((TimerTask)this, executionTime);
        logger.info((Object)(" == REMOVAL SCHEDULED FOR:" + this.serviceID + " in [" + (double)executionTime / 1000.0 + "] seconds =="));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAll() {
        SleeContainer container = SleeContainer.lookupFromJndi();
        SleeTransactionManager mgr = SleeContainer.getTransactionManager();
        Service svc = null;
        boolean needAnotherRun = false;
        boolean txAlreadyStarted = false;
        try {
            if (mgr.isInTx()) {
                txAlreadyStarted = true;
            } else {
                mgr.begin();
            }
            try {
                svc = container.getService(this.serviceID);
            }
            catch (UnrecognizedServiceException USE) {
                logger.debug((Object)"Service has been undeployed/deactivated");
                svc = this.svc1;
            }
            if (svc == null) {
                logger.debug((Object)("Service[ " + this.serviceID + " ] has been removed!"));
                return;
            }
            logger.debug((Object)(" == SERVICE STATE[" + svc.getState() + "] == "));
            if (svc.getState().equals((Object)ServiceState.INACTIVE)) {
                HashSet hashSet = new HashSet(svc.getChildObj());
                logger.info((Object)" STARTING REMOVAL ");
                for (String sbbeid : hashSet) {
                    logger.info((Object)(" REMOVING SBBE[" + sbbeid + "]"));
                    SbbEntity sbbEntity = SleeContainer.lookupFromJndi().getSbbEntityFactory().getSbbEntity(sbbeid);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("ServiceShutdown: removing Sbb Entity tree" + sbbeid));
                    }
                    ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(sbbEntity.getSbbDescriptor().getClassLoader());
                        sbbEntity.remove();
                    }
                    catch (Exception ex) {
                        logger.debug((Object)"error removing entity ", (Throwable)ex);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                    }
                }
            } else {
                if (svc.getState().equals((Object)ServiceState.ACTIVE)) {
                    logger.debug((Object)"Service has been activated again, skipping removal");
                    return;
                }
                logger.debug((Object)("Service State is " + svc.getState()));
                logger.debug((Object)"Scheduling another removal run.");
                needAnotherRun = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (!txAlreadyStarted) {
                    mgr.commit();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (needAnotherRun) {
            new SleeContainerLingeringServiceSbbRemoverTask(this.runningTimer, this.svc1, this.mapOfTasks);
        } else {
            this.mapOfTasks.remove(this.serviceID.toString());
        }
    }

    public void run() {
        logger.info((Object)(" == REMOVAL START:" + this.serviceID + " =="));
        this.removeAll();
        this.hasRun = true;
        logger.info((Object)(" == REMOVAL COMPLETED:" + this.serviceID + " =="));
    }

    public boolean getHasRun() {
        return this.hasRun;
    }

    static {
        InputStream IS = SleeContainerLingeringServiceSbbRemoverTask.class.getResourceAsStream(propertyFileName);
        Properties props = new Properties();
        try {
            props.load(IS);
            sbbEntityRemovalDelay = Double.parseDouble(props.getProperty(propertyName, "60"));
        }
        catch (IOException e) {
            logger.error((Object)("FAILED TO LOAD PROPERTIES[removal.properties], SETTING REMOVAL DELAY TO[" + sbbEntityRemovalDelay + "] minutes."));
            e.printStackTrace();
        }
    }
}

