/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.component;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class ComponentKey
implements Serializable,
Comparable {
    private static final long serialVersionUID = -8786296602099616559L;
    private String name;
    private String version;
    private String vendor;
    private String key;
    private static final String SEPARATOR = "#";
    private Pattern separatorPtn = Pattern.compile("/");

    public ComponentKey() {
    }

    public ComponentKey(String name, String vendor, String version) {
        this.name = name;
        this.version = version;
        this.vendor = vendor;
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(name).append(SEPARATOR).append(vendor).append(SEPARATOR).append(version);
        this.key = sbuff.toString();
    }

    public ComponentKey(String text) {
        String normalizedKey = this.separatorPtn.matcher(text).replaceAll(SEPARATOR);
        StringTokenizer st = new StringTokenizer(normalizedKey);
        try {
            this.name = st.nextToken(SEPARATOR);
            this.vendor = st.nextToken(SEPARATOR);
            this.version = st.nextToken();
        }
        catch (NoSuchElementException ex) {
            this.name = "";
            this.vendor = "";
            this.version = "";
        }
        this.key = normalizedKey;
    }

    public String toString() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ComponentKey)) {
            return false;
        }
        ComponentKey that = (ComponentKey)obj;
        return this.name.equals(that.name) && this.version.equals(that.version) && this.vendor.equals(that.vendor);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public int compareTo(Object o) {
        return o != this ? this.key.compareTo(((ComponentKey)o).key) : 0;
    }
}

