/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.component;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import org.mobicents.slee.container.component.DeployableUnitIDImpl;

public class DeployableUnitDescriptorImpl
implements DeployableUnitDescriptor,
Serializable {
    private String url;
    private LinkedList components;
    private LinkedList installedComponents;
    private Date deploymentDate;
    private DeployableUnitIDImpl deployableUnitID;
    private transient File tmpDeploymentDirectory;
    private transient File tmpDUJarsDirectory;
    private String description;
    private HashSet jars;
    private URI sourceUri;
    private transient Collection jarNodes;
    private transient Collection serviceNodes;

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("url = " + this.url).append("\nDate = " + this.deploymentDate).append("\ndeployableUnitID = " + this.deployableUnitID).append("\ndescription = " + this.description).append("\ncomponents = ");
        Iterator it = this.components.iterator();
        while (it.hasNext()) {
            sbuf.append("\n" + it.next());
        }
        sbuf.append("\njars = ");
        it = this.jars.iterator();
        while (it.hasNext()) {
            sbuf.append("\n" + it.next());
        }
        return sbuf.toString();
    }

    public void setTmpDeploymentDirectory(File deploymentDirectory) {
        this.tmpDeploymentDirectory = deploymentDirectory;
    }

    public File getTmpDeploymentDirectory() {
        return this.tmpDeploymentDirectory;
    }

    public void setTmpDUJarsDirectory(File tmpDUJarsDirectory) {
        this.tmpDUJarsDirectory = tmpDUJarsDirectory;
    }

    public File getTmpDUJarsDirectory() {
        return this.tmpDUJarsDirectory;
    }

    public DeployableUnitDescriptorImpl(String url, Date date) {
        this.url = url;
        this.deploymentDate = date;
        this.components = new LinkedList();
        this.installedComponents = new LinkedList();
        this.jars = new HashSet();
    }

    public String getURL() {
        return this.url;
    }

    public URI getSourceURI() {
        return this.sourceUri;
    }

    public Date getDeploymentDate() {
        return this.deploymentDate;
    }

    public ComponentID[] getComponents() {
        ComponentID[] retval = new ComponentID[this.components.size()];
        this.components.toArray(retval);
        return retval;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getJars() {
        if (this.jars == null) {
            return null;
        }
        String[] jarArray = new String[this.jars.size()];
        this.jars.toArray(jarArray);
        return jarArray;
    }

    public void addJar(String jar) {
        this.jars.add(jar);
    }

    public void setDeployableUnit(DeployableUnitIDImpl deployableUnit) {
        this.deployableUnitID = deployableUnit;
    }

    public DeployableUnitIDImpl getDeployableUnit() {
        return this.deployableUnitID;
    }

    public void addComponent(ComponentID componentID) {
        this.components.add(componentID);
    }

    public void setJarNodes(Collection jnodes) {
        this.jarNodes = jnodes;
    }

    public Collection getJarNodes() {
        return this.jarNodes;
    }

    public void setServiceNodes(Collection snodes) {
        this.serviceNodes = snodes;
    }

    public Collection getServiceNodes() {
        return this.serviceNodes;
    }

    public void installComponent(ComponentID cid) {
        if (!this.hasInstalledComponent(cid)) {
            this.installedComponents.add(cid);
        }
    }

    public void uninstallComponent(ComponentID cid) {
        this.installedComponents.remove(cid);
    }

    public boolean hasInstalledComponent(ComponentID cid) {
        return this.installedComponents.contains(cid);
    }

    public ComponentID[] getInstalledComponents() {
        ComponentID[] retval = new ComponentID[this.installedComponents.size()];
        this.installedComponents.toArray(retval);
        return retval;
    }
}

