/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.component;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.slee.Address;
import javax.slee.ComponentID;
import javax.slee.EventTypeID;
import javax.slee.InitialEventSelector;
import javax.slee.SbbID;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.DeploymentException;
import javax.slee.management.LibraryID;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.resource.ResourceAdaptorTypeID;
import org.apache.commons.pool.ObjectPool;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.InitialEventSelectorImpl;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.CMPField;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.DeployableUnitIDImpl;
import org.mobicents.slee.container.component.GetChildRelationMethod;
import org.mobicents.slee.container.component.MobicentsSbbDescriptor;
import org.mobicents.slee.container.component.MobicentsSbbDescriptorInternal;
import org.mobicents.slee.container.component.ProfileCMPMethod;
import org.mobicents.slee.container.component.ProfileSpecificationDescriptorImpl;
import org.mobicents.slee.container.component.ProfileSpecificationIDImpl;
import org.mobicents.slee.container.component.ResourceAdaptorEntityBinding;
import org.mobicents.slee.container.component.SbbEventEntry;
import org.mobicents.slee.container.component.SbbIDImpl;
import org.mobicents.slee.container.component.SbbRef;
import org.mobicents.slee.container.profile.SleeProfileManager;
import org.mobicents.slee.container.service.ServiceComponent;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.runtime.SbbConcrete;
import org.mobicents.slee.runtime.SbbObject;
import org.mobicents.slee.runtime.SleeEvent;

public class MobicentsSbbDescriptorInternalImpl
implements MobicentsSbbDescriptorInternal,
MobicentsSbbDescriptor {
    private static final long serialVersionUID = 9153818261657909355L;
    private transient ClassLoader loader;
    private Set initialEvents;
    private Set receivedEvents;
    private Map typeNameToNameMap;
    private Map typeNameToTypeMap;
    private boolean reentrant = false;
    private String abstractClassName;
    private transient Class concreteSbbClass;
    private String source;
    private HashSet profiles;
    private HashSet childSbbs;
    private CMPField[] cmpFields;
    private HashSet firedEvents;
    private String sbbAlias;
    private HashSet resourceAdaptorTypeBindings;
    private HashSet resourceAdapterEntityLinks;
    private HashSet resourceAdapterTypeIDs;
    private HashMap eventTypes;
    private HashSet receivedEventTypes;
    private HashSet initialEventTypes;
    private HashSet firedEventTypes;
    private HashSet sbbEventEntries;
    private SbbIDImpl sbbID;
    private transient GetChildRelationMethod[] childRelationMethods;
    private transient ProfileCMPMethod[] profileCMPMethods;
    private DeployableUnitIDImpl deployableUnitID;
    private HashMap resourceAdaptorEntityBindings = new HashMap();
    private HashSet ejbRefs;
    private HashSet envEntries;
    private HashMap profileSpecReferences;
    private transient ProfileSpecificationID addressProfile;
    private HashSet sbbRef;
    private transient Class sbbLocalInterfaceClass;
    private transient Class sbbLocalInterfaceConcreteClass;
    private String activityContextInterfaceClassName;
    private transient Class activityContextInterface;
    private transient Class activityContextInterfaceConcreteClass;
    private HashMap activityContextInterfaceAttributeAliases;
    private String usageParameterInterface;
    private String usageParametersInterfaceDescription;
    private static transient Logger logger = Logger.getLogger(MobicentsSbbDescriptor.class);
    private String description;
    private String sbbLocalInterfaceClassName;
    private transient Class usageParameterClass;

    public MobicentsSbbDescriptorInternalImpl() {
        this.childSbbs = new HashSet();
        this.envEntries = new HashSet();
        this.ejbRefs = new HashSet();
        this.profiles = new HashSet();
        this.initialEvents = new HashSet();
        this.receivedEvents = new HashSet();
        this.typeNameToNameMap = new HashMap();
        this.firedEvents = new HashSet();
        this.resourceAdaptorTypeBindings = new HashSet();
        this.typeNameToTypeMap = new HashMap();
        this.eventTypes = new HashMap();
        this.firedEventTypes = new HashSet();
        this.receivedEventTypes = new HashSet();
        this.initialEventTypes = new HashSet();
        this.sbbEventEntries = new HashSet();
        this.sbbRef = new HashSet();
        this.profileSpecReferences = new HashMap();
        this.activityContextInterfaceAttributeAliases = new HashMap();
        this.resourceAdapterEntityLinks = new HashSet();
        this.resourceAdapterTypeIDs = new HashSet();
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
    }

    public void addEventMap(String typeName, SbbEventEntry eventEntry) {
        this.typeNameToTypeMap.put(typeName, eventEntry);
    }

    public void setReentrant(boolean flag) {
        this.reentrant = flag;
    }

    public boolean isReentrant() {
        return this.reentrant;
    }

    public Set getInitialEventTypes() {
        return this.initialEventTypes;
    }

    public void addRef(SbbRef ref) {
        this.sbbRef.add(ref);
    }

    public String getEventName(EventTypeID typeName) {
        return (String)this.typeNameToNameMap.get(typeName);
    }

    public SbbEventEntry getEventType(String typeName) {
        logger.debug((Object)("typeName = " + typeName));
        return (SbbEventEntry)this.typeNameToTypeMap.get(typeName);
    }

    public Class getConcreteSbbClass() {
        return this.concreteSbbClass;
    }

    public void setConcreteSbb(Class concreteSbbClass) {
        this.concreteSbbClass = concreteSbbClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String computeConvergenceName(SleeEvent sleeEvent, ServiceComponent svc) throws Exception {
        EventTypeID eventType = sleeEvent.getEventTypeID();
        SbbEventEntry entry = (SbbEventEntry)this.eventTypes.get(eventType);
        Object activity = sleeEvent.getActivity();
        InitialEventSelectorImpl selector = new InitialEventSelectorImpl(eventType, sleeEvent.getEventObject(), activity, entry.getInitialEventSelectors(), entry.getInitialEventSelectorMethod(), sleeEvent.getAddress());
        if (selector.isSelectMethod()) {
            selector.setAddress(sleeEvent.getAddress());
            selector.setCustomName(null);
            selector.setInitialEvent(true);
            ObjectPool pool = SleeContainer.lookupFromJndi().getObjectPool((SbbID)svc.getRootSbbComponent().getID());
            SbbObject sbbObject = (SbbObject)pool.borrowObject();
            SbbConcrete concreteSbb = (SbbConcrete)sbbObject.getSbbConcrete();
            Class[] argtypes = new Class[]{InitialEventSelector.class};
            Method m = this.getConcreteSbbClass().getMethod(selector.getSelectMethodName(), argtypes);
            Object[] args = new Object[]{selector};
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
                selector = (InitialEventSelectorImpl)m.invoke((Object)concreteSbb, args);
                if (selector == null) {
                    logger.debug((Object)"Sbb returned null. So its not interested in this event");
                    String string = null;
                    return string;
                }
                if (!selector.isInitialEvent()) {
                    logger.debug((Object)"Sbb has determined it will not attend to this event");
                    String string = null;
                    return string;
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
                pool.returnObject((Object)sbbObject);
            }
        }
        Object convergenceName = null;
        StringBuffer buff = new StringBuffer();
        if (selector.isActivityContextSelected()) {
            buff.append(sleeEvent.getActivityContextID());
        } else {
            buff.append("null");
        }
        buff.append("null");
        if (selector.isAddressSelected()) {
            Address address = selector.getAddress();
            if (address == null) {
                buff.append("null");
            } else {
                buff.append(address.toString());
            }
        } else {
            buff.append("null");
        }
        if (selector.isEventTypeSelected()) {
            buff.append(selector.getEventTypeID());
        } else {
            buff.append("null");
        }
        if (selector.isEventSelected()) {
            buff.append(sleeEvent.hashCode());
        } else {
            buff.append("null");
        }
        if (selector.isAddressProfileSelected()) {
            ProfileSpecificationID addressProfileId = this.getAddressProfileSpecification();
            if (selector.getAddress() == null) {
                buff.append("null");
            } else {
                Collection profileNames;
                SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
                ProfileSpecificationDescriptorImpl profileSpecDescriptor = (ProfileSpecificationDescriptorImpl)sleeContainer.getComponentDescriptor((ComponentID)addressProfileId);
                if (profileSpecDescriptor == null) {
                    throw new Exception("Could not find address profile ! " + addressProfileId);
                }
                SleeProfileManager sleeProfileManager = SleeProfileManager.getInstance();
                String addressProfileTable = sleeContainer.getServiceComponent(svc.getServiceID()).getServiceDescriptor().getAddressProfileTable();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("addressProfileTable = " + addressProfileTable));
                }
                if (addressProfileTable == null) {
                    throw new Exception("null address profile table in service !");
                }
                logger.debug((Object)("indexes = " + profileSpecDescriptor.getProfileIndexes()));
                String profileName = profileSpecDescriptor.getName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("profileName = " + profileName + " addressString = " + selector.getAddress().getAddressString()));
                }
                if ((profileNames = sleeProfileManager.getProfilesByIndexedAttribute(addressProfileTable, "addresses", selector.getAddress(), true)) == null || profileNames.isEmpty()) {
                    throw new Exception("Could not find the specified profile");
                }
                buff.append(profileNames.iterator().next().toString());
            }
        } else {
            buff.append("null");
        }
        String customName = selector.getCustomName();
        buff.append(customName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("computed convergence name = " + buff.toString()));
            logger.debug((Object)("selector = " + selector));
        }
        return buff.toString();
    }

    public Set getReceivedEvents() {
        return this.receivedEventTypes;
    }

    public Set getFiredEvents() {
        return this.firedEventTypes;
    }

    public SbbID[] getSbbs() {
        HashSet<CMPField> retval = new HashSet<CMPField>();
        retval.addAll(this.childSbbs);
        for (int i = 0; this.cmpFields != null && i < this.cmpFields.length; ++i) {
            CMPField f = this.cmpFields[i];
            if (!(f instanceof SbbID)) continue;
            retval.add(f);
        }
        SbbID[] sbbIDs = new SbbID[retval.size()];
        retval.toArray(sbbIDs);
        return sbbIDs;
    }

    public void setChildSbbComponentID(SbbID sbbid) {
        this.childSbbs.add(sbbid);
    }

    public void addEvent(SbbEventEntry eventEntry) throws Exception {
        logger.debug((Object)("ADD EVENT INVOKED FOR EVENT " + this.getID() + " Event Name " + eventEntry.getEventName() + " IS INITIAL " + eventEntry.isInitial()));
        logger.debug((Object)("ADD EVENT ADDING " + eventEntry));
        this.sbbEventEntries.add(eventEntry);
        this.addEventMap(eventEntry.getEventName(), eventEntry);
    }

    public void addEventEntry(EventTypeID eventTypeId, SbbEventEntry eventEntry) {
        logger.debug((Object)("addEventEntry: sbbId " + this.getID() + " eventTypeID " + eventTypeId + "eventEntry " + eventEntry));
        this.typeNameToNameMap.put(eventTypeId, eventEntry.getEventName());
        this.eventTypes.put(eventTypeId, eventEntry);
        if (eventEntry.isFired()) {
            this.firedEvents.add(eventTypeId);
            this.firedEventTypes.add(eventTypeId);
        }
        if (eventEntry.isReceived()) {
            this.receivedEvents.add(eventTypeId);
            this.receivedEventTypes.add(eventTypeId);
        }
        if (eventEntry.isInitial()) {
            this.initialEvents.add(eventTypeId);
            this.initialEventTypes.add(eventTypeId);
        }
    }

    public ProfileSpecificationID[] getProfileSpecifications() {
        ProfileSpecificationID[] retval = new ProfileSpecificationID[this.profiles.size()];
        this.profiles.toArray(retval);
        return retval;
    }

    public ProfileSpecificationID getAddressProfileSpecification() {
        return this.addressProfile;
    }

    public void addResourceAdapterType(ResourceAdaptorTypeID resourceAdapterType) {
        this.resourceAdapterTypeIDs.add(resourceAdapterType);
    }

    public ResourceAdaptorTypeID[] getResourceAdaptorTypes() {
        ResourceAdaptorTypeID[] raTypeIDs = new ResourceAdaptorTypeID[this.resourceAdapterTypeIDs.size()];
        return this.resourceAdapterTypeIDs.toArray(raTypeIDs);
    }

    public void setResourceAdapterTypeBindings(HashSet resourceAdapterTypes) {
        this.resourceAdaptorTypeBindings = resourceAdapterTypes;
    }

    public Iterator getResourceAdapterTypeBindings() {
        return this.resourceAdaptorTypeBindings.iterator();
    }

    public void addResourceAdapterEntityLink(String entityLink) {
        this.resourceAdapterEntityLinks.add(entityLink);
    }

    public String[] getResourceAdaptorEntityLinks() {
        return this.resourceAdapterEntityLinks.toArray(new String[this.resourceAdapterEntityLinks.size()]);
    }

    public DeployableUnitID getDeployableUnit() {
        return this.deployableUnitID;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public ComponentID getID() {
        return this.sbbID;
    }

    public String getName() {
        return this.sbbID.getComponentKey().getName();
    }

    public String getVendor() {
        return this.sbbID.getComponentKey().getVendor();
    }

    public String getVersion() {
        return this.sbbID.getComponentKey().getVersion();
    }

    public void setComponentKey(ComponentKey componentKey) throws Exception {
        SbbIDImpl sbbId;
        this.sbbID = sbbId = new SbbIDImpl(componentKey);
    }

    public void parseSbb() {
    }

    public void setSbbAbstractClassName(String className) {
        this.abstractClassName = className;
    }

    public String getSbbAbstractClassName() {
        return this.abstractClassName;
    }

    public void setChildRelationMethods(GetChildRelationMethod[] childRelationMethods) {
        this.childRelationMethods = childRelationMethods;
    }

    public GetChildRelationMethod[] getChildRelationMethods() {
        return this.childRelationMethods;
    }

    public void setCMPFields(CMPField[] cmpFields) {
        this.cmpFields = cmpFields;
    }

    public CMPField[] getCMPFields() {
        return this.cmpFields;
    }

    public void setProfileCMPMethods(ProfileCMPMethod[] profileCmpMethods) {
        this.profileCMPMethods = profileCmpMethods;
    }

    public ProfileCMPMethod[] getProfileCMPMethods() {
        return this.profileCMPMethods;
    }

    public void setSbbLocalInterfaceClassName(String localInterfaceClassName) throws Exception {
        this.sbbLocalInterfaceClassName = localInterfaceClassName;
    }

    public Class getSbbLocalInterface() {
        return this.sbbLocalInterfaceClass;
    }

    public void setLocalInterfaceConcreteClass(Class clazz) {
        this.sbbLocalInterfaceConcreteClass = clazz;
    }

    public Class getLocalInterfaceConcreteClass() {
        return this.sbbLocalInterfaceConcreteClass;
    }

    public Class getActivityContextInterface() {
        return this.activityContextInterface;
    }

    public void setActivityContextInterfaceClassName(String activityContextInterfaceClassName) throws Exception {
        this.activityContextInterfaceClassName = activityContextInterfaceClassName;
    }

    public void setActivityContextInterfaceConcreteClass(Class aciConcreteClass) {
        this.activityContextInterfaceConcreteClass = aciConcreteClass;
    }

    public Class getActivityContextInterfaceConcreteClass() {
        return this.activityContextInterfaceConcreteClass;
    }

    public void setAddressProfileSpecAlias(String key) throws Exception {
        if (!this.profileSpecReferences.containsKey(key)) {
            throw new Exception("nothing known about the key " + key);
        }
        this.addressProfile = (ProfileSpecificationID)this.profileSpecReferences.get(key);
    }

    public void setProfileSpecReferences(HashMap pspecRefs) {
        this.profileSpecReferences = pspecRefs;
        for (ProfileSpecificationIDImpl ck : this.profileSpecReferences.values()) {
            this.profiles.add(ck);
        }
    }

    public void setActivityContextInterfaceAttributeAliases(HashMap aciAttributeAliases) {
        this.activityContextInterfaceAttributeAliases = aciAttributeAliases;
    }

    public void setUsageParametersInterface(String usageParamsInterfaceClassName) throws Exception {
        this.usageParameterInterface = usageParamsInterfaceClassName;
    }

    public String getUsageParametersInterface() {
        return this.usageParameterInterface;
    }

    public HashSet getEjbRefs() {
        return this.ejbRefs;
    }

    public void setEjbRefs(HashSet ejbRefs) {
        this.ejbRefs = ejbRefs;
    }

    public HashSet getEnvEntries() {
        return this.envEntries;
    }

    public void setEnvironmentEntries(HashSet envEntries) {
        this.envEntries = envEntries;
    }

    public HashSet getSbbEventEntries() {
        return this.sbbEventEntries;
    }

    public EventTypeID[] getEventTypes() {
        EventTypeID[] myTypes = new EventTypeID[this.eventTypes.size()];
        this.eventTypes.keySet().toArray(myTypes);
        return myTypes;
    }

    public HashSet getSbbRef() {
        return this.sbbRef;
    }

    public void setSbbRef(HashSet sbbRef) {
        this.sbbRef = sbbRef;
    }

    public HashMap getActivityContextInterfaceAttributeAliases() {
        return this.activityContextInterfaceAttributeAliases;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void setClassLoader(ClassLoader loader) {
        logger.debug((Object)("setClassloader " + loader));
        this.loader = loader;
    }

    public void setDeployableUnit(DeployableUnitID deployableUnitID) {
        this.deployableUnitID = (DeployableUnitIDImpl)deployableUnitID;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void checkDeployment() throws DeploymentException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        try {
            if (this.activityContextInterfaceClassName != null) {
                if (this.activityContextInterface == null) {
                    this.activityContextInterface = this.getClassLoader().loadClass(this.activityContextInterfaceClassName);
                }
                if (!this.activityContextInterface.isInterface()) {
                    throw new ClassCastException("Must be an interface " + this.activityContextInterfaceClassName);
                }
            }
            if (this.sbbLocalInterfaceClassName != null) {
                this.sbbLocalInterfaceClass = this.getClassLoader().loadClass(this.sbbLocalInterfaceClassName);
            }
        }
        catch (Exception ex) {
            throw new DeploymentException("Deployment was not consistent .. clean up ", (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    public void postInstall() throws Exception {
    }

    public String getActivityContextInterfaceClassName() {
        return this.activityContextInterfaceClassName;
    }

    public void addResourceAdaptorEntityBinding(ResourceAdaptorTypeIDImpl raTypeID, ResourceAdaptorEntityBinding raEntityLink) {
        HashSet<ResourceAdaptorEntityBinding> rabindingSet = (HashSet<ResourceAdaptorEntityBinding>)this.resourceAdaptorEntityBindings.get(raTypeID);
        if (rabindingSet == null) {
            rabindingSet = new HashSet<ResourceAdaptorEntityBinding>();
            this.resourceAdaptorEntityBindings.put(raTypeID, rabindingSet);
        }
        rabindingSet.add(raEntityLink);
    }

    public Iterator getResourceAdaptorEntityBindings(ResourceAdaptorTypeIDImpl raTypeID) {
        HashSet rabindings = (HashSet)this.resourceAdaptorEntityBindings.get(raTypeID);
        if (rabindings == null) {
            return new HashSet().iterator();
        }
        return rabindings.iterator();
    }

    public void setUsageParameterClass(Class usageParamClazz) {
        this.usageParameterClass = usageParamClazz;
    }

    public Class getUsageParameterClass() {
        return this.usageParameterClass;
    }

    public String getDeploymentPath() {
        return ((DeployableUnitIDImpl)this.getDeployableUnit()).getDUDeployer().getTempClassDeploymentDir().getAbsolutePath();
    }

    public HashMap getEventTypesMappings() {
        return new HashMap(this.eventTypes);
    }

    public LibraryID[] getLibraries() {
        return null;
    }
}

