/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.component;

import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.MobicentsSbbEventEntryInternal;
import org.mobicents.slee.container.component.SbbEventEntry;

public class MobicentsSbbEventEntryInternalImpl
implements MobicentsSbbEventEntryInternal,
SbbEventEntry {
    private int eventDirection;
    private String typeName = null;
    private String initialEventSelectorMethod = null;
    private String eventName = null;
    private String resourceOption = null;
    private ComponentKey eventTypeRefKey = null;
    private boolean maskedEvent;
    private int[] initialEventSelectors;

    public MobicentsSbbEventEntryInternalImpl(ComponentKey eventTypeRefKey, int direction) {
        this.setEventTypeRefKey(eventTypeRefKey);
        this.eventDirection = direction;
    }

    public static int eventSelectVarToInt(String eventSelectVar) {
        if (eventSelectVar == null) {
            throw new NullPointerException("<null> is not a legal event select variable.");
        }
        if (eventSelectVar.equals("ActivityContext")) {
            return 1;
        }
        if (eventSelectVar.equals("AddressProfile")) {
            return 2;
        }
        if (eventSelectVar.equals("Address")) {
            return 3;
        }
        if (eventSelectVar.equals("EventType")) {
            return 4;
        }
        if (eventSelectVar.equals("Event")) {
            return 5;
        }
        throw new IllegalArgumentException(eventSelectVar + " is not a legal event select variable.");
    }

    public String toString() {
        return this.eventName + " Event Direction = " + this.eventDirection;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isInitial() {
        return (this.eventDirection & 4) != 0;
    }

    public boolean isReceived() {
        return (this.eventDirection & 1) != 0;
    }

    public boolean isFired() {
        return (this.eventDirection & 2) != 0;
    }

    public boolean isFiredAndReceived() {
        return (this.eventDirection & 3) != 0;
    }

    public int getEventDirection() {
        return this.eventDirection;
    }

    public boolean isMasked() {
        return this.maskedEvent;
    }

    public void maskEvent() {
        this.maskedEvent = true;
    }

    public void setInitial(boolean flag) {
        this.eventDirection = flag ? (this.eventDirection |= 4) : (this.eventDirection &= 0xFFFFFFFB);
    }

    public void setReceived(boolean flag) {
        this.eventDirection = flag ? (this.eventDirection |= 1) : (this.eventDirection &= 0xFFFFFFFE);
    }

    public void setFired(boolean flag) {
        this.eventDirection = flag ? (this.eventDirection |= 2) : (this.eventDirection &= 0xFFFFFFFD);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        MobicentsSbbEventEntryInternalImpl that = (MobicentsSbbEventEntryInternalImpl)other;
        return that.typeName.equals(this.typeName) && that.eventDirection == this.eventDirection;
    }

    public void setInitialEventSelectors(int[] initialEventSelectors) {
        this.initialEventSelectors = initialEventSelectors;
    }

    public int[] getInitialEventSelectors() {
        return this.initialEventSelectors;
    }

    public void setResourceOption(String resourceOption) {
        this.resourceOption = resourceOption;
    }

    public String getResourceOption() {
        return this.resourceOption;
    }

    public void setEventTypeRefKey(ComponentKey eventTypeRefKey) {
        this.eventTypeRefKey = eventTypeRefKey;
    }

    public ComponentKey getEventTypeRefKey() {
        return this.eventTypeRefKey;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getInitialEventSelectorMethod() {
        return this.initialEventSelectorMethod;
    }

    public void setInitialEventSelectorMethod(String initialEventSelectorMethod) {
        this.initialEventSelectorMethod = initialEventSelectorMethod;
    }
}

