/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.component.deployment;

import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.deployment.AbstractDeploymentDescriptorParser;
import org.mobicents.slee.container.management.xml.XMLDescriptorStringsFixture;
import org.mobicents.slee.container.management.xml.XMLException;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class AbstractDeploymentDescriptorParserTest
extends TestCase {
    private AbstractDeploymentDescriptorParser abstractDeploymentDescriptorParser = null;
    private Document sbbJarDocument = null;
    private Element sbbNode = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.abstractDeploymentDescriptorParser = new AbstractDeploymentDescriptorParser();
        InputSource sbbJarSource = new InputSource(new StringReader(XMLDescriptorStringsFixture.SBB_JAR_XML));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.sbbJarDocument = builder.parse(sbbJarSource);
        List sbbNodes = XMLUtils.getAllChildElements(this.sbbJarDocument.getDocumentElement(), "sbb");
        this.sbbNode = (Element)sbbNodes.get(0);
    }

    protected void tearDown() throws Exception {
        this.abstractDeploymentDescriptorParser = null;
        this.sbbJarDocument = null;
        this.sbbNode = null;
        super.tearDown();
    }

    public void testAssertNonZeroLength() throws XMLException {
        String value = "";
        String elementName = "ELEMENT";
        try {
            this.abstractDeploymentDescriptorParser.assertNonZeroLength(value, elementName);
            AbstractDeploymentDescriptorParserTest.fail((String)"assertNonZeroLength did not throw an exception for a 0 length argument");
        }
        catch (XMLException ex) {
            // empty catch block
        }
        value = "asdf";
        try {
            this.abstractDeploymentDescriptorParser.assertNonZeroLength(value, elementName);
        }
        catch (XMLException ex) {
            AbstractDeploymentDescriptorParserTest.fail((String)"assertNonZeroLength threw an exception for a non-0 length argument");
        }
    }

    public void testCreateKey() throws XMLException {
        Element node = this.sbbNode;
        ComponentKey expectedReturn = new ComponentKey("JCC Call Forwarding SBB", "The Open Source Community", "1.0");
        ComponentKey actualReturn = this.abstractDeploymentDescriptorParser.createKey(node);
        AbstractDeploymentDescriptorParserTest.assertEquals((String)"Malformed component key", (Object)expectedReturn, (Object)actualReturn);
    }

    public void testCreateKey1() throws XMLException {
        Element node = this.sbbNode;
        String componentPrefix = "sbb";
        ComponentKey expectedReturn = new ComponentKey("JCC Call Forwarding SBB", "The Open Source Community", "1.0");
        ComponentKey actualReturn = this.abstractDeploymentDescriptorParser.createKey(node, componentPrefix);
        AbstractDeploymentDescriptorParserTest.assertEquals((String)"return value", (Object)expectedReturn, (Object)actualReturn);
    }
}

