/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.component.deployment;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import javax.slee.SLEEException;
import javax.slee.management.AlreadyDeployedException;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.DeploymentException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.component.ComponentContainer;
import org.mobicents.slee.container.component.DeployableUnitIDImpl;
import org.mobicents.slee.container.component.deployment.DeployableUnitDeployer;

public class DeploymentManager {
    private static Logger logger = Logger.getLogger(DeploymentManager.class);
    private static byte[] buffer = new byte[8192];

    public DeployableUnitID deployUnit(URL sourceUrl, File deploymentRootDir, File classpathDirectory, ComponentContainer componentContainer) throws NullPointerException, DeploymentException, AlreadyDeployedException {
        File unitJarFile;
        if (sourceUrl == null || deploymentRootDir == null || classpathDirectory == null || componentContainer == null) {
            throw new NullPointerException("null arg!");
        }
        File tempDUJarsDeploymentDir = this.createTempDUJarsDeploymentDir(deploymentRootDir, sourceUrl);
        try {
            unitJarFile = DeploymentManager.retrieveFile(sourceUrl, tempDUJarsDeploymentDir);
        }
        catch (IOException ioe) {
            throw new DeploymentException("Error retrieving file from URL=[" + sourceUrl + "] to local storage", (Throwable)ioe);
        }
        logger.info((Object)("Deploying from " + unitJarFile.getAbsolutePath()));
        try {
            DeployableUnitIDImpl deployableUnitID = DeployableUnitDeployer.deploy(sourceUrl, unitJarFile, tempDUJarsDeploymentDir, componentContainer);
            logger.info((Object)"Installation of deployable unit successful");
            return deployableUnitID;
        }
        catch (AlreadyDeployedException ex) {
            unitJarFile.delete();
            throw ex;
        }
        catch (Exception ex) {
            unitJarFile.delete();
            throw new DeploymentException("Could not deploy: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void deployAllUnitsAtLocation(String srcPath, String classpathDirectoryStr, ComponentContainer componentContainer) throws NullPointerException, DeploymentException {
        logger.debug((Object)("srcPath " + srcPath + " classPathDirectoryStr " + classpathDirectoryStr));
        File srcDir = new File(srcPath);
        if (srcDir.exists()) {
            if (!srcDir.isDirectory()) {
                throw new DeploymentException("Specified Destination " + srcPath + " is not a directory");
            }
        } else {
            throw new DeploymentException("Specified location " + srcPath + " not found");
        }
        File classpathDirectory = new File(classpathDirectoryStr);
        File[] deployableUnits = srcDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith("jar");
            }
        });
        int i = 0;
        while (i < deployableUnits.length) {
            File unitJarFile = deployableUnits[i];
            try {
                DeployableUnitDeployer.deploy(deployableUnits[i].toURL(), unitJarFile, srcDir, componentContainer);
            }
            catch (MalformedURLException e1) {
                logger.fatal((Object)"unexpected exception ");
                e1.printStackTrace();
            }
            ++i;
        }
    }

    public void deployAllUnitsAtLocation(String sourceUrlStr, String destinationPath, String classpathDirectoryStr, ComponentContainer componentContainer) throws NullPointerException, DeploymentException {
        URL sourceUrl;
        try {
            sourceUrl = new URL(sourceUrlStr);
        }
        catch (MalformedURLException exc) {
            throw new DeploymentException("Invalid source url.", (Throwable)exc);
        }
        logger.info((Object)("Deploying all units in location" + sourceUrlStr + " to location " + destinationPath));
        File srcDir = new File(sourceUrl.getFile());
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            throw new DeploymentException("Source Directory " + sourceUrlStr + " does not exist or is not a directory");
        }
        File destinationDir = new File(destinationPath);
        if (destinationDir.exists()) {
            if (!destinationDir.isDirectory()) {
                throw new DeploymentException("Specified Destination " + destinationPath + " is not a directory");
            }
            if (!destinationDir.mkdirs()) {
                throw new DeploymentException("Failed to create destination directory: " + destinationPath);
            }
        }
        File classpathDirectory = new File(classpathDirectoryStr);
        if (destinationDir.exists()) {
            if (!destinationDir.isDirectory()) {
                throw new DeploymentException("Specified Destination " + destinationPath + " is not a directory");
            }
            if (!destinationDir.mkdirs()) {
                throw new DeploymentException("Failed to create destination directory: " + destinationPath);
            }
        }
        File[] deployableUnits = srcDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches("*.jar");
            }
        });
        int i = 0;
        while (i < deployableUnits.length) {
            try {
                this.deployUnit(deployableUnits[i].toURL(), destinationDir, classpathDirectory, componentContainer);
            }
            catch (MalformedURLException ex) {
                throw new DeploymentException(String.valueOf(deployableUnits[i].toString()) + " is not a valid url.", (Throwable)ex);
            }
            ++i;
        }
    }

    public void startDeployingLocation(String sourceURL, String deploymentPath, ComponentContainer container) throws NullPointerException, DeploymentException {
    }

    static JarFile retrieveJar(URL url, File localDstDir) throws NullPointerException, IOException {
        return new JarFile(DeploymentManager.retrieveFile(url, localDstDir));
    }

    static File retrieveFile(URL url, File localDstDir) throws NullPointerException, IOException {
        if (url == null) {
            throw new NullPointerException("NULL url");
        }
        if (localDstDir == null) {
            throw new NullPointerException("NULL file");
        }
        File destFile = new File(localDstDir, new File(url.getFile()).getName());
        InputStream is = url.openStream();
        FileOutputStream os = new FileOutputStream(destFile);
        DeploymentManager.pipeStream(is, os);
        return destFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pipeStream(InputStream is, OutputStream os) throws IOException {
        byte[] byArray = buffer;
        synchronized (buffer) {
            try {
                int bytesRead = is.read(buffer);
                while (bytesRead != -1) {
                    os.write(buffer, 0, bytesRead);
                    bytesRead = is.read(buffer);
                }
                is.close();
                os.close();
            }
            catch (IOException ioe) {
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ioe;
            }
            return;
        }
    }

    static File extractFile(String fileName, JarFile containingJar, File dstDir) throws IOException {
        ZipEntry zipFileEntry = containingJar.getEntry(fileName);
        logger.debug((Object)("Extracting file " + fileName + " from " + containingJar.getName()));
        if (zipFileEntry == null) {
            logger.debug((Object)("Could not extract jar file entry " + fileName + " from " + containingJar.getName()));
            return null;
        }
        File extractedFile = new File(dstDir, new File(zipFileEntry.getName()).getName());
        DeploymentManager.pipeStream(containingJar.getInputStream(zipFileEntry), new FileOutputStream(extractedFile));
        logger.debug((Object)("Extracted file " + extractedFile.getName()));
        return extractedFile;
    }

    public static void extractJar(JarFile jarFile, File dstDir) throws IOException {
        JarInputStream jarIs = new JarInputStream(new BufferedInputStream(new FileInputStream(jarFile.getName())));
        JarEntry entry = jarIs.getNextJarEntry();
        while (jarIs.available() > 0 && entry != null) {
            File dir;
            logger.debug((Object)("zipEntry = " + entry.getName()));
            if (entry.isDirectory()) {
                dir = new File(dstDir, entry.getName());
                if (!dir.exists()) {
                    if (!dir.mkdirs()) {
                        logger.debug((Object)("Failed to create directory " + dir.getAbsolutePath()));
                        throw new IOException("Failed to create directory " + dir.getAbsolutePath());
                    }
                } else {
                    logger.debug((Object)("Created directory" + dir.getAbsolutePath()));
                }
            } else {
                dir = new File(dstDir, entry.getName()).getParentFile();
                if (!dir.exists()) {
                    if (!dir.mkdirs()) {
                        logger.debug((Object)("Failed to create directory " + dir.getAbsolutePath()));
                        throw new IOException("Failed to create directory " + dir.getAbsolutePath());
                    }
                    logger.debug((Object)("Created directory" + dir.getAbsolutePath()));
                }
                DeploymentManager.pipeStream(jarFile.getInputStream(entry), new FileOutputStream(new File(dstDir, entry.getName())));
            }
            entry = jarIs.getNextJarEntry();
        }
        jarIs.close();
        jarFile.close();
    }

    public void undeployUnit(DeployableUnitIDImpl deployableUnitID) {
        Iterator it = deployableUnitID.getDeployedFiles();
        while (it.hasNext()) {
            File f = new File((String)it.next());
            if (!f.isFile()) continue;
            f.delete();
            logger.info((Object)("deleted " + f.getAbsolutePath()));
        }
        URI deploymentURI = deployableUnitID.getSourceURI();
        if (deploymentURI != null) {
            File srcFile = new File(deploymentURI);
            logger.info((Object)("Deleting " + srcFile.getAbsolutePath()));
            srcFile.delete();
        }
        deployableUnitID.getDUDeployer().undeploy();
    }

    private File createTempDUJarsDeploymentDir(File rootDir, URL sourceUrl) {
        String jarName = new File(sourceUrl.getFile()).getName();
        try {
            File tempDeploymentFile = File.createTempFile("tmpDUJars", "", rootDir);
            tempDeploymentFile.deleteOnExit();
            File tempDUJarsDeploymentDir = new File(String.valueOf(tempDeploymentFile.getAbsolutePath()) + "-contents");
            if (!tempDUJarsDeploymentDir.exists()) {
                tempDUJarsDeploymentDir.mkdirs();
            }
            tempDUJarsDeploymentDir.deleteOnExit();
            return tempDUJarsDeploymentDir;
        }
        catch (IOException e) {
            logger.error((Object)("Temp Deployment Directory could not be created for SLEE DU: " + jarName));
            throw new SLEEException("Failed to create temp deployment dir", (Throwable)e);
        }
    }
}

