/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.component.deployment;

import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.mobicents.slee.container.component.MobicentsEventTypeDescriptor;
import org.mobicents.slee.container.component.MobicentsEventTypeDescriptorInternalImpl;
import org.mobicents.slee.container.component.deployment.EventTypeDeploymentDescriptorParser;
import org.mobicents.slee.container.management.xml.XMLDescriptorStringsFixture;
import org.mobicents.slee.container.management.xml.XMLException;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class EventTypeDeploymentDescriptorParserTest
extends TestCase {
    private EventTypeDeploymentDescriptorParser eventTypeDeploymentDescriptorParser = null;
    private Document eventJarDocument = null;
    private Element eventDefinitionNode = null;
    private MobicentsEventTypeDescriptor descriptorImpl = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.eventTypeDeploymentDescriptorParser = new EventTypeDeploymentDescriptorParser();
        InputSource eventJarSource = new InputSource(new StringReader(XMLDescriptorStringsFixture.EVENT_JAR_XML));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.eventJarDocument = builder.parse(eventJarSource);
        List sbbNodes = XMLUtils.getAllChildElements(this.eventJarDocument.getDocumentElement(), "event-definition");
        this.eventDefinitionNode = (Element)sbbNodes.get(0);
        this.descriptorImpl = new MobicentsEventTypeDescriptorInternalImpl();
    }

    protected void tearDown() throws Exception {
        this.eventTypeDeploymentDescriptorParser = null;
        super.tearDown();
    }

    public void testParse() throws XMLException {
        this.eventTypeDeploymentDescriptorParser.parse(this.eventDefinitionNode, this.descriptorImpl);
        EventTypeDeploymentDescriptorParserTest.assertEquals((String)"Event type name didn't match", (String)this.descriptorImpl.getName(), (String)"com.foobar.event.HelpRequestedEvent");
        EventTypeDeploymentDescriptorParserTest.assertEquals((String)"Event type vendor didn't match", (String)this.descriptorImpl.getVendor(), (String)"com.foobar");
        EventTypeDeploymentDescriptorParserTest.assertEquals((String)"Event type version didn't match", (String)this.descriptorImpl.getVersion(), (String)"1.0a");
        EventTypeDeploymentDescriptorParserTest.assertEquals((String)"Event class name didn't match", (String)this.descriptorImpl.getEventClassName(), (String)"com.foobar.event.HelpRequestedEvent");
    }
}

