/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.component.deployment;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.ProfileSpecificationDescriptorImpl;
import org.mobicents.slee.container.component.deployment.AbstractDeploymentDescriptorParser;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ProfileSpecificationDescriptorParser
extends AbstractDeploymentDescriptorParser {
    public static List parseStandardProfileSpecifications(String urlForEventJar) throws Exception {
        String profileSpecificationJarXML = new String();
        FileInputStream reader = new FileInputStream(urlForEventJar);
        byte[] buffer = new byte[reader.available()];
        reader.read(buffer);
        profileSpecificationJarXML = new String(buffer);
        reader.close();
        ProfileSpecificationDescriptorParser parser = new ProfileSpecificationDescriptorParser();
        InputSource profileSpecificationJarSource = new InputSource(new StringReader(profileSpecificationJarXML));
        Document profileSpecificationJarDocument = XMLUtils.parseDocument(profileSpecificationJarSource, true);
        List profileSpecNodes = XMLUtils.getAllChildElements(profileSpecificationJarDocument.getDocumentElement(), "profile-spec");
        LinkedList<ProfileSpecificationDescriptorImpl> retval = new LinkedList<ProfileSpecificationDescriptorImpl>();
        int i = 0;
        while (i < profileSpecNodes.size()) {
            ProfileSpecificationDescriptorImpl descriptorImpl = new ProfileSpecificationDescriptorImpl();
            Element profileSpecNode = (Element)profileSpecNodes.get(i);
            parser.parseProfileComponent(profileSpecNode, descriptorImpl);
            retval.add(descriptorImpl);
            ++i;
        }
        return retval;
    }

    public ProfileSpecificationDescriptorImpl parseProfileComponent(Element profileNode, ProfileSpecificationDescriptorImpl profileDescriptorImpl) throws IOException, Exception {
        ComponentKey sbbKey = this.createKey(profileNode);
        profileDescriptorImpl.setComponentKey(sbbKey);
        String description = XMLUtils.getElementTextValue(profileNode, "description");
        profileDescriptorImpl.setDescription(description);
        Element profileClassesNode = XMLUtils.getChildElement(profileNode, "profile-classes");
        String profileDescriptionStr = XMLUtils.getElementTextValue(profileClassesNode, "description");
        String profileCMPInterfaceStr = XMLUtils.getElementTextValue(profileClassesNode, "profile-cmp-interface-name");
        String profileManagementInterfaceNameStr = XMLUtils.getElementTextValue(profileClassesNode, "profile-management-interface-name");
        String profileManagementAbstractClassNameStr = XMLUtils.getElementTextValue(profileClassesNode, "profile-management-abstract-class-name");
        profileDescriptorImpl.setCMPInterfaceName(profileCMPInterfaceStr);
        profileDescriptorImpl.setManagementInterfaceName(profileManagementInterfaceNameStr);
        profileDescriptorImpl.setManagementAbstractClassName(profileManagementAbstractClassNameStr);
        profileDescriptorImpl.setClassesDescription(profileDescriptionStr);
        Element profileHintsNode = XMLUtils.getChildElement(profileNode, "profile-hints");
        boolean profileHintsSingleProfile = new Boolean(profileNode.getAttribute("single-profile"));
        profileDescriptorImpl.setSingleProfile(profileHintsSingleProfile);
        List profileIndexNodes = XMLUtils.getAllChildElements(profileNode, "profile-index");
        Iterator it = profileIndexNodes.iterator();
        HashMap<String, Boolean> profileIndexes = new HashMap<String, Boolean>();
        while (it.hasNext()) {
            Element profileIndexNode = (Element)it.next();
            String attributeName = XMLUtils.getElementTextValue(profileIndexNode);
            profileIndexes.put(attributeName, new Boolean(profileIndexNode.getAttribute("unique")));
        }
        profileDescriptorImpl.setProfileIndexes(profileIndexes);
        return profileDescriptorImpl;
    }
}

