/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.component.deployment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.slee.management.DeploymentException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.component.DeployableUnitIDImpl;
import org.mobicents.slee.container.component.deployment.AbstractComponentDeployer;
import org.mobicents.slee.container.component.deployment.ResourceAdaptorTypeDescriptorParser;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.mobicents.slee.resource.ResourceAdaptorTypeDescriptorImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ResourceAdaptorTypeComponentDeployer
extends AbstractComponentDeployer {
    private DeployableUnitIDImpl deployableUnitID;
    private JarEntry ddXmlEntry;
    private ResourceAdaptorTypeDescriptorParser parser;
    private static Logger logger = Logger.getLogger(ResourceAdaptorTypeComponentDeployer.class);

    public ResourceAdaptorTypeComponentDeployer(DeployableUnitIDImpl deployableUnitID, JarEntry ddXmlEntry) {
        this.deployableUnitID = deployableUnitID;
        this.ddXmlEntry = ddXmlEntry;
        this.parser = new ResourceAdaptorTypeDescriptorParser();
    }

    protected List parseComponentDescriptors() throws Exception {
        logger.debug((Object)("Parsing a Resource Adaptor from " + this.getJar().getName()));
        JarFile jar = this.getJar();
        if (this.ddXmlEntry == null) {
            throw new DeploymentException("No SbbDeploymentDescriptor descriptor (META-INF/resource-adaptor-type-jar.xml) was found in " + jar.getName());
        }
        Document doc = null;
        try {
            doc = XMLUtils.parseDocument(jar.getInputStream(this.ddXmlEntry), true);
        }
        catch (IOException ex) {
            throw new DeploymentException("Failed to extract the SBB deployment descriptor from " + jar.getName());
        }
        Element raJarNode = doc.getDocumentElement();
        ArrayList<ResourceAdaptorTypeDescriptorImpl> retval = new ArrayList<ResourceAdaptorTypeDescriptorImpl>();
        List raTypeNodes = XMLUtils.getAllChildElements(raJarNode, "resource-adaptor-type");
        String description = XMLUtils.getElementTextValue(raJarNode, "description");
        if (raTypeNodes != null) {
            Iterator it = raTypeNodes.iterator();
            while (it.hasNext()) {
                ResourceAdaptorTypeDescriptorImpl raTypeDescriptor = new ResourceAdaptorTypeDescriptorImpl();
                this.parser.parseResourceAdaptorTypeDescriptor((Element)it.next(), raTypeDescriptor);
                raTypeDescriptor.setDeployableUnit(this.deployableUnitID);
                this.deployableUnitID.setDescription(description);
                retval.add(raTypeDescriptor);
            }
        }
        return retval;
    }
}

