/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.component.deployment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.slee.ActivityContextInterface;
import javax.slee.SbbLocalObject;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.component.CMPField;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.EJBReference;
import org.mobicents.slee.container.component.EnvironmentEntry;
import org.mobicents.slee.container.component.GetChildRelationMethod;
import org.mobicents.slee.container.component.MobicentsResourceAdaptorTypeBindingInternalImpl;
import org.mobicents.slee.container.component.MobicentsSbbDescriptor;
import org.mobicents.slee.container.component.MobicentsSbbDescriptorInternalImpl;
import org.mobicents.slee.container.component.MobicentsSbbEventEntryInternalImpl;
import org.mobicents.slee.container.component.ProfileCMPMethod;
import org.mobicents.slee.container.component.ProfileSpecificationIDImpl;
import org.mobicents.slee.container.component.ResourceAdaptorEntityBinding;
import org.mobicents.slee.container.component.SbbIDImpl;
import org.mobicents.slee.container.component.SbbRef;
import org.mobicents.slee.container.component.deployment.AbstractDeploymentDescriptorParser;
import org.mobicents.slee.container.management.xml.XMLException;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.w3c.dom.Element;

public class SbbDeploymentDescriptorParser
extends AbstractDeploymentDescriptorParser {
    public static Logger logger = null;

    static {
        logger = Logger.getLogger(SbbDeploymentDescriptorParser.class);
    }

    public MobicentsSbbDescriptor parseSbbComponent(Element sbbNode, MobicentsSbbDescriptorInternalImpl descriptorImpl) throws IOException, Exception {
        String sbbAliasRef;
        ComponentKey sbbKey = this.createKey(sbbNode);
        descriptorImpl.setComponentKey(sbbKey);
        String description = XMLUtils.getElementTextValue(sbbNode, "description");
        descriptorImpl.setDescription(description);
        String aliasStr = XMLUtils.getElementTextValue(sbbNode, "sbb-alias");
        List sbbRefsNodeList = XMLUtils.getAllChildElements(sbbNode, "sbb-ref");
        HashMap<String, ComponentKey> sbbReferences = new HashMap<String, ComponentKey>();
        if (aliasStr != null) {
            sbbReferences.put(aliasStr, sbbKey);
        }
        for (Element sbbRefNode : sbbRefsNodeList) {
            ComponentKey sbbRefKey;
            String nameStr = XMLUtils.getElementTextValue(sbbRefNode, "sbb-name");
            String vendorStr = XMLUtils.getElementTextValue(sbbRefNode, "sbb-vendor");
            String versionStr = XMLUtils.getElementTextValue(sbbRefNode, "sbb-version");
            String sbbRefAlias = XMLUtils.getElementTextValue(sbbRefNode, "sbb-alias");
            if (sbbReferences.put(sbbRefAlias, sbbRefKey = new ComponentKey(nameStr, vendorStr, versionStr)) != null) {
                throw new XMLException("Found multiple appearances of " + sbbRefKey.toString());
            }
            SbbRef sbbRef = new SbbRef(sbbRefKey, sbbRefAlias);
            descriptorImpl.addRef(sbbRef);
        }
        List ejbRefNodeList = XMLUtils.getAllChildElements(sbbNode, "ejb-ref");
        HashSet<EJBReference> ejbRefs = new HashSet<EJBReference>();
        for (Element ejbRefNode : ejbRefNodeList) {
            String ejbRefName = XMLUtils.getElementTextValue(ejbRefNode, "ejb-ref-name");
            String ejbRefType = XMLUtils.getElementTextValue(ejbRefNode, "ejb-ref-type");
            String ejbRefRemote = XMLUtils.getElementTextValue(ejbRefNode, "remote");
            String ejbRefHome = XMLUtils.getElementTextValue(ejbRefNode, "home");
            String ejbRefLink = XMLUtils.getElementTextValue(ejbRefNode, "ejb-link");
            EJBReference ejbRef = new EJBReference(ejbRefName, ejbRefType, ejbRefHome, ejbRefRemote, ejbRefLink);
            ejbRefs.add(ejbRef);
        }
        descriptorImpl.setEjbRefs(ejbRefs);
        List profileSpecRefNodes = XMLUtils.getAllChildElements(sbbNode, "profile-spec-ref");
        HashMap<String, ProfileSpecificationIDImpl> profileSpecReferences = new HashMap<String, ProfileSpecificationIDImpl>();
        for (Element profileSpecNode : profileSpecRefNodes) {
            ComponentKey profileSpecKey;
            ProfileSpecificationIDImpl pidImpl;
            String specNameStr = XMLUtils.getElementTextValue(profileSpecNode, "profile-spec-name");
            String specVendorStr = XMLUtils.getElementTextValue(profileSpecNode, "profile-spec-vendor");
            String specVersionStr = XMLUtils.getElementTextValue(profileSpecNode, "profile-spec-version");
            String specAliasStr = XMLUtils.getElementTextValue(profileSpecNode, "profile-spec-alias");
            if (profileSpecReferences.put(specAliasStr, pidImpl = new ProfileSpecificationIDImpl(profileSpecKey = new ComponentKey(specNameStr, specVendorStr, specVersionStr))) == null) continue;
            throw new XMLException("Multiple declarations of a profile spec reference are not allowed. Detected multiple declarations of: " + profileSpecKey.toString());
        }
        descriptorImpl.setProfileSpecReferences(profileSpecReferences);
        Element sbbClassesNode = XMLUtils.getChildElement(sbbNode, "sbb-classes", true);
        String usageParametersInterfaceStr = null;
        Element usageParametersInterfaceNode = XMLUtils.getChildElement(sbbClassesNode, "sbb-usage-parameters-interface", true);
        if (usageParametersInterfaceNode != null) {
            usageParametersInterfaceStr = XMLUtils.getElementTextValue(usageParametersInterfaceNode, "sbb-usage-parameters-interface-name");
            descriptorImpl.setUsageParametersInterface(usageParametersInterfaceStr);
        }
        Element sbbAbstractClassNode = XMLUtils.getChildElement(sbbClassesNode, "sbb-abstract-class", true);
        boolean reentrant = new Boolean(sbbAbstractClassNode.getAttribute("reentrant"));
        descriptorImpl.setReentrant(reentrant);
        String sbbAbstractClassStr = XMLUtils.getElementTextValue(sbbAbstractClassNode, "sbb-abstract-class-name");
        descriptorImpl.setSbbAbstractClassName(sbbAbstractClassStr);
        HashSet<Object> duplicatesDetector = new HashSet<Object>();
        List sbbCMPFieldNodes = XMLUtils.getAllChildElements(sbbAbstractClassNode, "cmp-field");
        CMPField[] sbbCMPFields = new CMPField[sbbCMPFieldNodes.size()];
        Iterator iterator = sbbCMPFieldNodes.iterator();
        int i = 0;
        while (i < sbbCMPFields.length) {
            Element sbbCMPFieldNode = (Element)iterator.next();
            String cmpFieldName = XMLUtils.getElementTextValue(sbbCMPFieldNode, "cmp-field-name");
            if (!duplicatesDetector.add(cmpFieldName)) {
                throw new XMLException("SBB CMP field name '" + cmpFieldName + "' appears in multiple <cmp-field> declarations");
            }
            sbbAliasRef = XMLUtils.getElementTextValue(sbbCMPFieldNode, "sbb-alias-ref");
            ComponentKey referencedSbbKey = null;
            if (sbbAliasRef != null) {
                referencedSbbKey = (ComponentKey)sbbReferences.get(sbbAliasRef);
                if (sbbKey == null) {
                    throw new XMLException("SBB alias reference '" + sbbAliasRef + "' unknown in <cmp-field> declaration");
                }
            }
            sbbCMPFields[i] = new CMPField(cmpFieldName, referencedSbbKey);
            ++i;
        }
        descriptorImpl.setCMPFields(sbbCMPFields);
        List childRelationMethodNodes = XMLUtils.getAllChildElements(sbbAbstractClassNode, "get-child-relation-method");
        ArrayList<GetChildRelationMethod> childRelationMethodList = new ArrayList<GetChildRelationMethod>();
        for (Element childRelationMethodNode : childRelationMethodNodes) {
            sbbAliasRef = XMLUtils.getElementTextValue(childRelationMethodNode, "sbb-alias-ref");
            ComponentKey childKey = (ComponentKey)sbbReferences.get(sbbAliasRef);
            descriptorImpl.setChildSbbComponentID(new SbbIDImpl(childKey));
            if (childKey == null) {
                throw new XMLException("SBB alias reference '" + sbbAliasRef + "' unknown in <get-child-relation-method> declaration");
            }
            String getChildRelationMethodName = XMLUtils.getElementTextValue(childRelationMethodNode, "get-child-relation-method-name");
            String defaultPriority = XMLUtils.getElementTextValue(childRelationMethodNode, "default-priority");
            if (childKey == null) continue;
            try {
                childRelationMethodList.add(new GetChildRelationMethod(childKey, getChildRelationMethodName, Byte.parseByte(defaultPriority)));
            }
            catch (NumberFormatException nfe) {
                throw new XMLException(String.valueOf(defaultPriority) + "is not a valid " + "default priority value in <get-child-relation-method>." + " Value must be between -128 and 127 (inclusive).");
            }
        }
        GetChildRelationMethod[] childRelationMethods = childRelationMethodList.toArray(new GetChildRelationMethod[childRelationMethodList.size()]);
        descriptorImpl.setChildRelationMethods(childRelationMethods);
        List eventNodes = XMLUtils.getAllChildElements(sbbNode, "event");
        duplicatesDetector.clear();
        Iterator eventNodesIterator = eventNodes.iterator();
        while (eventNodesIterator.hasNext()) {
            boolean received;
            MobicentsSbbEventEntryInternalImpl eventEntry = null;
            Element eventNode = (Element)eventNodesIterator.next();
            String eventName = XMLUtils.getElementTextValue(eventNode, "event-name");
            Element eventTypeRefNode = XMLUtils.getChildElement(eventNode, "event-type-ref");
            ComponentKey eventTypeRefKey = this.createKey(eventTypeRefNode, "event-type");
            if (!duplicatesDetector.add(eventTypeRefKey)) {
                throw new XMLException("Only one <event> declaration is permitted per event type: " + eventTypeRefKey.toString());
            }
            List initialEventSelectorNodes = XMLUtils.getAllChildElements(eventNode, "initial-event-select");
            int[] initialEventSelectors = new int[initialEventSelectorNodes.size()];
            Iterator evtSelectorsIterator = initialEventSelectorNodes.iterator();
            int i2 = 0;
            while (i2 < initialEventSelectors.length) {
                Element initialEventSelectNode = (Element)evtSelectorsIterator.next();
                logger.debug((Object)("Initial-Event-Select variable = " + initialEventSelectNode.getAttribute("variable")));
                initialEventSelectors[i2] = MobicentsSbbEventEntryInternalImpl.eventSelectVarToInt(initialEventSelectNode.getAttribute("variable"));
                ++i2;
            }
            String initialEventSelectorMethod = XMLUtils.getElementTextValue(eventNode, "initial-event-selector-method-name");
            if (initialEventSelectorMethod != null && (initialEventSelectorMethod.toLowerCase().startsWith("sbb") || initialEventSelectorMethod.toLowerCase().startsWith("ejb"))) {
                throw new XMLException("<The initial event selector method> can not start with sbb or ejb: " + initialEventSelectorMethod);
            }
            String resourceOption = XMLUtils.getElementTextValue(eventNode, "event-resource-option");
            String direction = eventNode.getAttribute("event-direction");
            boolean fired = direction.equalsIgnoreCase("Fire") || direction.equals("FireAndReceive");
            boolean bl = received = direction.equalsIgnoreCase("Receive") || direction.equals("FireAndReceive");
            if (!fired && !received) {
                throw new XMLException("Neither Fired Nor Recieved !");
            }
            boolean maskOnAttach = eventNode.getAttribute("mask-on-attach").equalsIgnoreCase("True");
            boolean initial = eventNode.getAttribute("initial-event").equalsIgnoreCase("True");
            if (fired) {
                if (!received) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)">>>>> Event is FIRED ONLY");
                    }
                    if (initial) {
                        throw new XMLException("Cannot specify the initial-event property for a fired event: " + eventTypeRefKey.toString());
                    }
                    if (initialEventSelectors.length > 0 || initialEventSelectorMethod != null) {
                        throw new XMLException("Cannot specify initial event selectors for a fired event: " + eventTypeRefKey.toString());
                    }
                    if (maskOnAttach) {
                        throw new XMLException("Cannot specify the mask-on-attach property for a fired event: " + eventTypeRefKey.toString());
                    }
                    if (resourceOption != null) {
                        throw new XMLException("Cannot specify an event resource option for a fired event: " + eventTypeRefKey.toString());
                    }
                }
                eventEntry = new MobicentsSbbEventEntryInternalImpl(eventTypeRefKey, 2);
                eventEntry.setEventName(eventName);
                eventEntry.setFired(true);
                eventEntry.setResourceOption(resourceOption);
            }
            if (received) {
                if (initial && initialEventSelectors.length == 0 && initialEventSelectorMethod == null) {
                    throw new XMLException("Need to specify at least one of <initial-event-select> or <initial-event-selector-method-name> elements for initial event: " + eventTypeRefKey.toString());
                }
                if (eventEntry == null) {
                    eventEntry = new MobicentsSbbEventEntryInternalImpl(eventTypeRefKey, 1);
                    eventEntry.setEventName(eventName);
                } else {
                    eventEntry.setReceived(true);
                }
                eventEntry.setInitial(initial);
                eventEntry.setInitialEventSelectors(initialEventSelectors);
                eventEntry.setInitialEventSelectorMethod(initialEventSelectorMethod);
                eventEntry.setResourceOption(resourceOption);
                if (maskOnAttach) {
                    eventEntry.maskEvent();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("MobicentsSbbDescriptor.parseSbbComponent(): >>>>> Event entry added: " + eventEntry));
            }
            descriptorImpl.addEvent(eventEntry);
        }
        List profileCMPMethodNodes = XMLUtils.getAllChildElements(sbbAbstractClassNode, "get-profile-cmp-method");
        ArrayList<ProfileCMPMethod> profileCMPMethodList = new ArrayList<ProfileCMPMethod>();
        for (Element profileCMPMethodNode : profileCMPMethodNodes) {
            String profileSpecAliasRef = XMLUtils.getElementTextValue(profileCMPMethodNode, "profile-spec-alias-ref");
            ComponentKey profileSpecKey = ((ProfileSpecificationIDImpl)profileSpecReferences.get(profileSpecAliasRef)).getComponentKey();
            if (profileSpecKey == null) {
                new XMLException("Profile specification alias reference '" + profileSpecAliasRef + "' unknown in <get-profile-cmp-method> declaration");
                continue;
            }
            String getProfileCMPMethod = XMLUtils.getElementTextValue(profileCMPMethodNode, "get-profile-cmp-method-name");
            profileCMPMethodList.add(new ProfileCMPMethod(profileSpecKey, getProfileCMPMethod));
        }
        try {
            Collections.sort(profileCMPMethodList);
        }
        catch (Exception ex1) {
            logger.warn((Object)("sort threw exception: " + ex1.toString()));
        }
        ProfileCMPMethod[] profileCMPMethods = profileCMPMethodList.toArray(new ProfileCMPMethod[profileCMPMethodList.size()]);
        descriptorImpl.setProfileCMPMethods(profileCMPMethods);
        String sbbLocalInterface = null;
        Element sbbLocalInterfaceNode = XMLUtils.getChildElement(sbbClassesNode, "sbb-local-interface");
        if (sbbLocalInterfaceNode != null) {
            sbbLocalInterface = XMLUtils.getElementTextValue(sbbLocalInterfaceNode, "sbb-local-interface-name");
        }
        if (sbbLocalInterface == null) {
            sbbLocalInterface = SbbLocalObject.class.getName();
        }
        descriptorImpl.setSbbLocalInterfaceClassName(sbbLocalInterface);
        String sbbActivityContextInterface = null;
        Element sbbActivityContextInterfaceNode = XMLUtils.getChildElement(sbbClassesNode, "sbb-activity-context-interface");
        if (sbbActivityContextInterfaceNode != null) {
            sbbActivityContextInterface = XMLUtils.getElementTextValue(sbbActivityContextInterfaceNode, "sbb-activity-context-interface-name");
            if (sbbActivityContextInterface.equals(ActivityContextInterface.class.getName())) {
                sbbActivityContextInterface = null;
            } else {
                descriptorImpl.setActivityContextInterfaceClassName(sbbActivityContextInterface);
            }
        }
        ProfileSpecificationIDImpl addressProfileSpec = null;
        String addressProfileSpecRef = XMLUtils.getElementTextValue(sbbNode, "address-profile-spec-alias-ref");
        if (addressProfileSpecRef != null) {
            this.assertNonZeroLength(addressProfileSpecRef, "address-profile-spec-alias-ref");
            addressProfileSpec = (ProfileSpecificationIDImpl)profileSpecReferences.get(addressProfileSpecRef);
            if (addressProfileSpec == null) {
                new XMLException("Profile specification alias reference '" + addressProfileSpecRef + "' unknown in <address-profile-spec-alias-ref> declaration");
            }
            descriptorImpl.setAddressProfileSpecAlias(addressProfileSpecRef);
        }
        List aciAttrAliasNodes = XMLUtils.getAllChildElements(sbbNode, "activity-context-attribute-alias");
        HashMap<String, String> aciAttributeAliases = new HashMap<String, String>();
        for (Element aciAttrAliasNode : aciAttrAliasNodes) {
            String aliasName = XMLUtils.getElementTextValue(aciAttrAliasNode, "attribute-alias-name");
            Iterator iterator2 = XMLUtils.getAllChildElements(aciAttrAliasNode, "sbb-activity-context-attribute-name").iterator();
            while (iterator2.hasNext()) {
                String aciAttributeName = XMLUtils.getElementTextValue((Element)iterator2.next());
                this.assertNonZeroLength(aciAttributeName, "sbb-activity-context-attribute-name");
                if (aciAttributeAliases.put(aciAttributeName, aliasName) == null) continue;
                throw new XMLException("Activity context interface attribute name '" + aciAttributeName + "' appears multiple times in <activity-context-attribute-alias> declarations");
            }
        }
        descriptorImpl.setActivityContextInterfaceAttributeAliases(aciAttributeAliases);
        List envEntryNodes = XMLUtils.getAllChildElements(sbbNode, "env-entry");
        HashSet<EnvironmentEntry> envEntries = new HashSet<EnvironmentEntry>();
        for (Element envEntry : envEntryNodes) {
            String name = XMLUtils.getElementTextValue(envEntry, "env-entry-name");
            String value = XMLUtils.getElementTextValue(envEntry, "env-entry-value");
            String type = XMLUtils.getElementTextValue(envEntry, "env-entry-type");
            description = XMLUtils.getElementTextValue(envEntry, "description");
            envEntries.add(new EnvironmentEntry(description, name, value, type));
        }
        descriptorImpl.setEnvironmentEntries(envEntries);
        List resourceAdapterTypeBindingNodes = XMLUtils.getAllChildElements(sbbNode, "resource-adaptor-type-binding");
        HashSet<MobicentsResourceAdaptorTypeBindingInternalImpl> resourceAdapterTypeBindings = new HashSet<MobicentsResourceAdaptorTypeBindingInternalImpl>();
        Iterator it = resourceAdapterTypeBindingNodes.iterator();
        while (it.hasNext()) {
            MobicentsResourceAdaptorTypeBindingInternalImpl ratBinding = new MobicentsResourceAdaptorTypeBindingInternalImpl();
            Element raTypeBinding = (Element)it.next();
            description = XMLUtils.getElementTextValue(raTypeBinding, "description");
            Element raTypeRef = XMLUtils.getChildElement(raTypeBinding, "resource-adaptor-type-ref");
            String name = XMLUtils.getElementTextValue(raTypeRef, "resource-adaptor-type-name");
            String vendor = XMLUtils.getElementTextValue(raTypeRef, "resource-adaptor-type-vendor");
            String version = XMLUtils.getElementTextValue(raTypeRef, "resource-adaptor-type-version");
            ResourceAdaptorTypeIDImpl raTypeIDImpl = new ResourceAdaptorTypeIDImpl(new ComponentKey(name, vendor, version));
            descriptorImpl.addResourceAdapterType(raTypeIDImpl);
            ratBinding.setResourceAdapterTypeId(raTypeIDImpl);
            String acifName = XMLUtils.getElementTextValue(raTypeBinding, "activity-context-interface-factory-name");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ACI Factory Name " + acifName));
            }
            ratBinding.setActivityContextInterfaceFactoryName(acifName);
            HashSet<ResourceAdaptorEntityBinding> raEntityBindings = new HashSet<ResourceAdaptorEntityBinding>();
            List raEntityBindingList = XMLUtils.getAllChildElements(raTypeBinding, "resource-adaptor-entity-binding");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("entity type bindings >>>>>>>> " + raEntityBindingList.size()));
            }
            for (Element raEntityBindingNode : raEntityBindingList) {
                String descr = XMLUtils.getElementTextValue(raEntityBindingNode, "description");
                String bname = XMLUtils.getElementTextValue(raEntityBindingNode, "resource-adaptor-object-name");
                String elink = XMLUtils.getElementTextValue(raEntityBindingNode, "resource-adaptor-entity-link");
                descriptorImpl.addResourceAdapterEntityLink(elink);
                ResourceAdaptorEntityBinding raEntityLink = new ResourceAdaptorEntityBinding(descr, bname, elink);
                raEntityBindings.add(raEntityLink);
                descriptorImpl.addResourceAdaptorEntityBinding(raTypeIDImpl, raEntityLink);
            }
            ratBinding.setResourceAdapterEntityBindings(raEntityBindings);
            resourceAdapterTypeBindings.add(ratBinding);
        }
        descriptorImpl.setResourceAdapterTypeBindings(resourceAdapterTypeBindings);
        return descriptorImpl;
    }
}

