/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.component.deployment;

import java.io.File;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.List;
import javax.slee.ComponentID;
import javax.slee.management.ComponentDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.DeploymentException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.component.ComponentContainer;
import org.mobicents.slee.container.component.DeployableUnitDescriptorImpl;
import org.mobicents.slee.container.component.DeployableUnitIDImpl;
import org.mobicents.slee.container.component.DeployedComponent;
import org.mobicents.slee.container.component.MobicentsServiceDescriptorInternalImpl;
import org.mobicents.slee.container.component.ServiceDescriptorImpl;
import org.mobicents.slee.container.component.deployment.ServiceDeploymentDescriptorParser;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

class ServiceDeployer {
    private File serviceXML = null;
    private List componentDescriptors = null;
    private ComponentContainer componentContainer = null;
    private static Logger log = Logger.getLogger(ServiceDeployer.class);

    ServiceDeployer() {
    }

    File getServiceXML() {
        return this.serviceXML;
    }

    protected void initDeployer(File serviceXML, ComponentContainer container) throws DeploymentException {
        this.serviceXML = serviceXML;
        this.componentContainer = container;
        try {
            this.componentDescriptors = this.parseServiceDescriptors();
        }
        catch (Exception ex) {
            DeploymentException de = new DeploymentException("Failed to parse deployment descriptor of " + serviceXML.getName(), (Throwable)ex);
            log.error((Object)de.getMessage(), (Throwable)ex);
            throw de;
        }
    }

    protected List parseServiceDescriptors() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Service = " + this.serviceXML));
        }
        InputSource inputSource = new InputSource(new FileReader(this.serviceXML));
        ServiceDeploymentDescriptorParser parser = new ServiceDeploymentDescriptorParser();
        Document serviceJarDocument = XMLUtils.parseDocument(inputSource, true);
        List serviceNodes = XMLUtils.getAllChildElements(serviceJarDocument.getDocumentElement(), "service");
        LinkedList<ServiceDescriptorImpl> componentDescriptors = new LinkedList<ServiceDescriptorImpl>();
        int i = serviceNodes.size() - 1;
        while (i >= 0) {
            Element sbbNode = (Element)serviceNodes.get(i);
            componentDescriptors.add(parser.parseServiceComponent(sbbNode, new MobicentsServiceDescriptorInternalImpl()));
            --i;
        }
        return componentDescriptors;
    }

    protected void deployAndInstall(DeployableUnitID deployableUnitID) throws Exception {
        if (this.componentDescriptors == null || this.componentDescriptors.size() == 0) {
            return;
        }
        for (DeployedComponent du : this.componentDescriptors) {
            du.setDeployableUnit(deployableUnitID);
            DeployableUnitDescriptorImpl duImpl = ((DeployableUnitIDImpl)deployableUnitID).getDescriptor();
            this.componentContainer.install((ComponentDescriptor)du, duImpl);
            ComponentID componentID = ((ComponentDescriptor)du).getID();
            duImpl.addComponent(componentID);
        }
    }
}

