/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.deployment.ConcreteClassGeneratorUtils;

public class ClassUtils {
    private static final String PUBLIC_IDENTIFIER = "Public";
    private static Logger logger = Logger.getLogger(ClassUtils.class);
    public static final String IS_PREFIX = "is";
    public static final String GET_PREFIX = "get";
    public static final String SET_PREFIX = "set";

    public static Set getCMPFields(CtClass clazz) {
        HashSet<String> properties = new HashSet<String>();
        Set methods = ClassUtils.getPublicAbstractMethods(clazz);
        Iterator<Object> iter = methods.iterator();
        HashMap<String, CtMethod> getters = new HashMap<String, CtMethod>();
        HashMap<String, CtMethod> setters = new HashMap<String, CtMethod>();
        while (iter.hasNext()) {
            CtMethod ctMethod = (CtMethod)iter.next();
            String mname = ctMethod.getName();
            if (Modifier.isStatic(ctMethod.getModifiers())) continue;
            String property = "";
            try {
                if (ctMethod.getExceptionTypes().length > 0) continue;
                if (mname.startsWith(GET_PREFIX)) {
                    property = mname.substring(GET_PREFIX.length());
                    getters.put(property, ctMethod);
                } else if (mname.startsWith(IS_PREFIX) && ctMethod.getReturnType().equals(CtClass.booleanType)) {
                    property = mname.substring(IS_PREFIX.length());
                    getters.put(property, ctMethod);
                } else if (mname.startsWith(SET_PREFIX)) {
                    property = mname.substring(SET_PREFIX.length());
                    setters.put(property, ctMethod);
                }
            }
            catch (NotFoundException e) {
                logger.warn((Object)e);
            }
            if (property.length() != 0 && Character.isUpperCase(property.charAt(0)) && !property.equals(PUBLIC_IDENTIFIER)) continue;
            logger.warn((Object)("Method " + mname + " has a non-capitalized first character of the JavaBean property."));
            getters.remove(property);
            setters.remove(property);
        }
        for (Map.Entry entry : getters.entrySet()) {
            String property = (String)entry.getKey();
            CtMethod getter = (CtMethod)entry.getValue();
            String mname = getter.getName();
            CtMethod setter = (CtMethod)setters.get(property);
            try {
                CtClass[] sparams;
                if (setter == null || (sparams = setter.getParameterTypes()).length != 1 || !sparams[0].equals(getter.getReturnType())) continue;
                properties.add(property);
            }
            catch (NotFoundException e) {
                logger.warn((Object)e);
            }
        }
        return properties;
    }

    public static String getObjectFromPrimitiveType(String argumentType, String argument) {
        if (argumentType.equals("int")) {
            return "new Integer(" + argument + ")";
        }
        if (argumentType.equals("boolean")) {
            return "new Boolean(" + argument + ")";
        }
        if (argumentType.equals("byte")) {
            return "new Byte(" + argument + ")";
        }
        if (argumentType.equals("char")) {
            return "new Character(" + argument + ")";
        }
        if (argumentType.equals("double")) {
            return "new Double(" + argument + ")";
        }
        if (argumentType.equals("float")) {
            return "new Float(" + argument + ")";
        }
        if (argumentType.equals("long")) {
            return "new Long(" + argument + ")";
        }
        if (argumentType.equals("short")) {
            return "new Short(" + argument + ")";
        }
        return null;
    }

    public static String getClassFromPrimitiveType(String argumentType) {
        if (argumentType.equals("int")) {
            return "java.lang.Integer";
        }
        if (argumentType.equals("boolean")) {
            return "java.lang.Boolean";
        }
        if (argumentType.equals("byte")) {
            return "java.lang.Byte";
        }
        if (argumentType.equals("char")) {
            return "java.lang.Character";
        }
        if (argumentType.equals("double")) {
            return "java.lang.Double";
        }
        if (argumentType.equals("float")) {
            return "java.lang.Float";
        }
        if (argumentType.equals("long")) {
            return "java.lang.Long";
        }
        if (argumentType.equals("short")) {
            return "java.lang.Short";
        }
        return null;
    }

    public static String getPrimitiveTypeFromClass(String argumentType) {
        if (argumentType.equals("java.lang.Integer")) {
            return "int";
        }
        if (argumentType.equals("java.lang.Boolean")) {
            return "boolean";
        }
        if (argumentType.equals("java.lang.Byte")) {
            return "byte";
        }
        if (argumentType.equals("java.lang.Character")) {
            return "char";
        }
        if (argumentType.equals("java.lang.Double")) {
            return "double";
        }
        if (argumentType.equals("java.lang.Float")) {
            return "float";
        }
        if (argumentType.equals("java.lang.Long")) {
            return "long";
        }
        if (argumentType.equals("java.lang.Short")) {
            return "short";
        }
        return argumentType;
    }

    public static String getPrimitiveTypeFromObject(String argumentType, String argument) {
        if (argumentType.equals("int")) {
            return "((Integer)" + argument + ").intValue()";
        }
        if (argumentType.equals("boolean")) {
            return "((Boolean)" + argument + ").booleanValue()";
        }
        if (argumentType.equals("byte")) {
            return "((Byte)" + argument + ").byteValue()";
        }
        if (argumentType.equals("char")) {
            return "((Character)" + argument + ").charValue()";
        }
        if (argumentType.equals("double")) {
            return "((Double)" + argument + ").doubleValue()";
        }
        if (argumentType.equals("float")) {
            return "((Float)" + argument + ").floatValue()";
        }
        if (argumentType.equals("long")) {
            return "((Long)" + argument + ").longValue()";
        }
        if (argumentType.equals("short")) {
            return "((Short)" + argument + ").shortValue()";
        }
        return null;
    }

    public static Map getAbstractMethodsFromClass(CtClass sbbAbstractClass) {
        HashMap<String, CtMethod> abstractMethods = new HashMap<String, CtMethod>();
        CtMethod[] methods = sbbAbstractClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (Modifier.isAbstract(methods[i].getModifiers())) {
                abstractMethods.put(methods[i].getName(), methods[i]);
            }
            ++i;
        }
        return abstractMethods;
    }

    public static Map getConcreteMethodsFromClass(CtClass sbbClass) {
        HashMap<String, CtMethod> concreteMethods = new HashMap<String, CtMethod>();
        CtMethod[] methods = sbbClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            int mods = methods[i].getModifiers();
            if (!Modifier.isAbstract(mods) && !Modifier.isNative(mods)) {
                concreteMethods.put(ClassUtils.getMethodKey(methods[i]), methods[i]);
            }
            ++i;
        }
        return concreteMethods;
    }

    public static Set getConcreteMethodsNamesFromClass(CtClass sbbClass) {
        HashSet<String> concreteMethods = new HashSet<String>();
        CtMethod[] methods = sbbClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            int mods = methods[i].getModifiers();
            if (!Modifier.isAbstract(mods) && !Modifier.isNative(mods)) {
                concreteMethods.add(methods[i].getName());
            }
            ++i;
        }
        return concreteMethods;
    }

    public static Map getSuperClassesAbstractMethodsFromClass(CtClass sbbAbstractClass) {
        HashMap<String, CtMethod> abstractMethods = new HashMap<String, CtMethod>();
        CtMethod[] methods = null;
        try {
            CtClass superClass = sbbAbstractClass.getSuperclass();
            while (superClass.getName().compareTo("java.lang.Object") != 0) {
                methods = superClass.getDeclaredMethods();
                int i = 0;
                while (i < methods.length) {
                    if (Modifier.isAbstract(methods[i].getModifiers())) {
                        abstractMethods.put(methods[i].getName(), methods[i]);
                    }
                    ++i;
                }
                superClass = superClass.getSuperclass();
            }
        }
        catch (NotFoundException e) {
            String s = "Method not found ! Huh!!";
            ConcreteClassGeneratorUtils.logger.fatal((Object)s, (Throwable)e);
            throw new RuntimeException("s", e);
        }
        return abstractMethods;
    }

    public static Map getSuperClassesAbstractMethodsFromInterface(CtClass sbbAbstractClass) {
        HashMap<String, CtMethod> abstractMethods = new HashMap<String, CtMethod>();
        CtMethod[] methods = null;
        try {
            CtClass[] superClass = sbbAbstractClass.getInterfaces();
            int j = 0;
            while (superClass != null && j < superClass.length) {
                methods = superClass[j].getDeclaredMethods();
                int i = 0;
                while (i < methods.length) {
                    abstractMethods.put(ClassUtils.getMethodKey(methods[i]), methods[i]);
                    ++i;
                }
                ++j;
            }
        }
        catch (NotFoundException e) {
            logger.error((Object)e);
        }
        return abstractMethods;
    }

    public static Map getInterfaceMethodsFromInterface(CtClass interfaceClass) {
        HashMap<String, CtMethod> interfaceMethods = new HashMap<String, CtMethod>();
        CtMethod[] methods = interfaceClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            interfaceMethods.put(ClassUtils.getMethodKey(methods[i]), methods[i]);
            ++i;
        }
        interfaceMethods.putAll(ClassUtils.getSuperClassesAbstractMethodsFromInterface(interfaceClass));
        return interfaceMethods;
    }

    public static Map getInterfaceMethodsFromInterface(CtClass interfaceClass, Map inputMap) {
        HashMap<String, Object> interfaceMethods = new HashMap<String, Object>();
        CtMethod[] methods = interfaceClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (inputMap.get(methods[i].getName()) == null) {
                ConcreteClassGeneratorUtils.logger.debug((Object)methods[i].getName());
                interfaceMethods.put(ClassUtils.getMethodKey(methods[i]), methods[i]);
            }
            ++i;
        }
        Map temp = ClassUtils.getSuperClassesAbstractMethodsFromInterface(interfaceClass);
        for (String key : temp.keySet()) {
            if (inputMap.containsKey(key)) continue;
            interfaceMethods.put(key, temp.get(key));
        }
        return interfaceMethods;
    }

    public static Set getPublicAbstractMethods(CtClass abstractClass) {
        HashSet<CtMethod> methodsSet = new HashSet<CtMethod>();
        CtMethod[] methods = abstractClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (Modifier.isPublic(methods[i].getModifiers()) && Modifier.isAbstract(methods[i].getModifiers())) {
                methodsSet.add(methods[i]);
            }
            ++i;
        }
        return methodsSet;
    }

    public static Set getPublicMethods(CtClass abstractClass) {
        HashSet<CtMethod> methodsSet = new HashSet<CtMethod>();
        CtMethod[] methods = abstractClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (Modifier.isPublic(methods[i].getModifiers())) {
                methodsSet.add(methods[i]);
            }
            ++i;
        }
        return methodsSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidOverride(CtMethod parent, CtMethod child) {
        if (!parent.getName().equals(child.getName())) {
            return false;
        }
        try {
            CtClass[] childArgs;
            if (!parent.getReturnType().equals(child.getReturnType())) {
                return false;
            }
            CtClass[] parentArgs = parent.getParameterTypes();
            if (parentArgs.length != (childArgs = child.getParameterTypes()).length) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= parentArgs.length) {
                    if (!Modifier.isPublic(parent.getModifiers())) return false;
                    if (Modifier.isPublic(child.getModifiers())) break;
                    return false;
                }
                if (!parentArgs[i].equals(childArgs[i])) {
                    return false;
                }
                ++i;
            }
            if (!Modifier.isPrivate(parent.getModifiers()) && Modifier.isPrivate(child.getModifiers())) {
                return false;
            }
            CtClass[] parentEx = parent.getExceptionTypes();
            CtClass[] childEx = child.getExceptionTypes();
            if (childEx.length <= 0) return true;
            int i2 = 0;
            while (true) {
                if (i2 >= parentEx.length) {
                    return true;
                }
                boolean validEx = false;
                int j = 0;
                while (true) {
                    if (j >= childEx.length) {
                        if (validEx) break;
                        return false;
                    }
                    if (childEx[j].subtypeOf(parentEx[i2])) {
                        validEx = true;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        catch (NotFoundException e) {
            logger.warn((Object)"Failed: isValidOverride", (Throwable)e);
            return false;
        }
    }

    private static String getMethodKey(CtMethod method) {
        String ret = String.valueOf(method.getName()) + method.getSignature();
        return ret;
    }
}

