/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment;

import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javax.slee.management.DeploymentException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.component.DeployableUnitIDImpl;
import org.mobicents.slee.container.component.MobicentsSbbDescriptor;
import org.mobicents.slee.container.deployment.ClassUtils;
import org.mobicents.slee.container.deployment.ConcreteClassGeneratorUtils;
import org.mobicents.slee.container.deployment.interceptors.ActivityContextInterfaceInterceptor;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextIDInterface;
import org.mobicents.slee.runtime.ActivityContextInterfaceImpl;

public class ConcreteActivityContextInterfaceGenerator {
    private MobicentsSbbDescriptor descriptor;
    private static Logger logger = null;
    private ClassPool pool = null;
    protected CtClass activityContextInterface = null;
    protected CtClass concreteActivityContextInterface = null;
    protected CtClass activityContextIDInterfaceClass = null;
    private static String ACTIVITY_CONTEXT_INTERFACE_IMPL = "activityContextInterface";
    private static String THIS_ACTIVITY_CONTEXT_INTERFACE_IMPL = "this." + ACTIVITY_CONTEXT_INTERFACE_IMPL;

    static {
        logger = Logger.getLogger(ConcreteActivityContextInterfaceGenerator.class);
    }

    public ConcreteActivityContextInterfaceGenerator(MobicentsSbbDescriptor descriptor) {
        this.pool = ((DeployableUnitIDImpl)descriptor.getDeployableUnit()).getDUDeployer().getClassPool();
        this.descriptor = descriptor;
    }

    public Class generateActivityContextInterfaceConcreteClass(String activityContextInterfaceName) throws DeploymentException {
        String tmpClassName = activityContextInterfaceName + "Impl";
        try {
            this.concreteActivityContextInterface = this.pool.get(tmpClassName).getClassPool().makeClass(tmpClassName);
        }
        catch (NotFoundException e2) {
            this.concreteActivityContextInterface = this.pool.makeClass(tmpClassName);
        }
        try {
            this.activityContextInterface = this.pool.get(activityContextInterfaceName);
            this.activityContextIDInterfaceClass = this.pool.get(ActivityContextIDInterface.class.getName());
        }
        catch (NotFoundException nfe) {
            String s = "Could not find aci " + activityContextInterfaceName;
            throw new DeploymentException(s, (Throwable)nfe);
        }
        ConcreteClassGeneratorUtils.createInterfaceLinks(this.concreteActivityContextInterface, new CtClass[]{this.activityContextInterface, this.activityContextIDInterfaceClass});
        this.createFields();
        try {
            CtClass[] parameters = new CtClass[]{this.pool.get("org.mobicents.slee.runtime.ActivityContextInterfaceImpl"), this.pool.get("org.mobicents.slee.container.component.MobicentsSbbDescriptor")};
            this.createConstructorWithParameter(parameters);
        }
        catch (NotFoundException nfe) {
            String s = "Could not find class";
            logger.error((Object)"Constructor With Parameter not created");
            throw new DeploymentException(s, (Throwable)nfe);
        }
        Map interfaceMethods = ClassUtils.getInterfaceMethodsFromInterface(this.activityContextInterface);
        this.generateConcreteMethods(interfaceMethods);
        String sbbDeploymentPathStr = this.descriptor.getDeploymentPath();
        try {
            this.pool.get(tmpClassName).writeFile(sbbDeploymentPathStr);
            this.pool.get(tmpClassName).detach();
            logger.debug((Object)("Concrete Class " + tmpClassName + " generated in the following path " + sbbDeploymentPathStr));
        }
        catch (Exception e) {
            logger.error((Object)"problem generating concrete class", (Throwable)e);
            throw new DeploymentException("problem generating concrete class! ", (Throwable)e);
        }
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(tmpClassName);
        }
        catch (Exception e1) {
            logger.error((Object)"problem loading generated class", (Throwable)e1);
            throw new DeploymentException("problem loading the generated class! ", (Throwable)e1);
        }
        this.concreteActivityContextInterface.defrost();
        return clazz;
    }

    private boolean isBaseInterfaceMethod(String methodName) {
        return "getActivity".equals(methodName) || "attach".equals(methodName) || "detach".equals(methodName) || "isEnding".equals(methodName);
    }

    private void generateConcreteMethods(Map interfaceMethods) {
        CtMethod methodTest;
        if (interfaceMethods == null) {
            return;
        }
        for (CtMethod interfaceMethod : interfaceMethods.values()) {
            if (interfaceMethod != null && this.isBaseInterfaceMethod(interfaceMethod.getName())) continue;
            ConcreteClassGeneratorUtils.addInterceptedMethod(this.concreteActivityContextInterface, interfaceMethod, "sbbActivityContextInterfaceInterceptor", false);
        }
        String methodToAdd = "public Object getActivity() throws javax.slee.TransactionRequiredLocalException, javax.slee.SLEEException { return " + THIS_ACTIVITY_CONTEXT_INTERFACE_IMPL + ".getActivity();" + "}";
        try {
            methodTest = CtNewMethod.make((String)methodToAdd, (CtClass)this.concreteActivityContextInterface);
            this.concreteActivityContextInterface.addMethod(methodTest);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
        methodToAdd = "public void attach(javax.slee.SbbLocalObject sbbLocalObject) throws NullPointerException, javax.slee.TransactionRequiredLocalException, javax.slee.TransactionRolledbackLocalException, javax.slee.SLEEException {" + THIS_ACTIVITY_CONTEXT_INTERFACE_IMPL + ".attach($1);" + "}";
        try {
            methodTest = CtNewMethod.make((String)methodToAdd, (CtClass)this.concreteActivityContextInterface);
            this.concreteActivityContextInterface.addMethod(methodTest);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
        methodToAdd = "public void detach(javax.slee.SbbLocalObject sbbLocalObject) throws NullPointerException, javax.slee.TransactionRequiredLocalException, javax.slee.TransactionRolledbackLocalException, javax.slee.SLEEException {" + THIS_ACTIVITY_CONTEXT_INTERFACE_IMPL + ".detach($1);" + "}";
        try {
            methodTest = CtNewMethod.make((String)methodToAdd, (CtClass)this.concreteActivityContextInterface);
            this.concreteActivityContextInterface.addMethod(methodTest);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
        methodToAdd = "public boolean isEnding() throws javax.slee.TransactionRequiredLocalException, javax.slee.SLEEException {return " + THIS_ACTIVITY_CONTEXT_INTERFACE_IMPL + ".isEnding();" + "}";
        try {
            methodTest = CtNewMethod.make((String)methodToAdd, (CtClass)this.concreteActivityContextInterface);
            this.concreteActivityContextInterface.addMethod(methodTest);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
        methodToAdd = "public String retrieveActivityContextID() { return " + THIS_ACTIVITY_CONTEXT_INTERFACE_IMPL + ".retrieveActivityContextID(); }";
        try {
            methodTest = CtNewMethod.make((String)methodToAdd, (CtClass)this.concreteActivityContextInterface);
            this.concreteActivityContextInterface.addMethod(methodTest);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
        methodToAdd = "public " + ActivityContext.class.getName() + " retrieveActivityContext() { return " + THIS_ACTIVITY_CONTEXT_INTERFACE_IMPL + ".getActivityContext(); }";
        try {
            methodTest = CtNewMethod.make((String)methodToAdd, (CtClass)this.concreteActivityContextInterface);
            this.concreteActivityContextInterface.addMethod(methodTest);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
    }

    protected void createFields() {
        CtField activityContextInterfaceInterceptor = null;
        try {
            activityContextInterfaceInterceptor = new CtField(this.pool.get(ActivityContextInterfaceImpl.class.getName()), ACTIVITY_CONTEXT_INTERFACE_IMPL, this.concreteActivityContextInterface);
            activityContextInterfaceInterceptor.setModifiers(2);
            this.concreteActivityContextInterface.addField(activityContextInterfaceInterceptor);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
        }
        this.createInterceptorFields();
        logger.debug((Object)"Fields created");
    }

    protected void createInterceptorFields() {
        CtField activityContextInterfaceInterceptor = null;
        try {
            activityContextInterfaceInterceptor = new CtField(this.pool.get(ActivityContextInterfaceInterceptor.class.getName()), "sbbActivityContextInterfaceInterceptor", this.concreteActivityContextInterface);
            activityContextInterfaceInterceptor.setModifiers(2);
            this.concreteActivityContextInterface.addField(activityContextInterfaceInterceptor);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
        }
    }

    protected void createDefaultConstructor() {
        CtConstructor defaultConstructor = new CtConstructor(null, this.concreteActivityContextInterface);
        String constructorBody = "{";
        constructorBody = String.valueOf(constructorBody) + "sbbActivityContextInterfaceInterceptor=new org.mobicents.slee.container.deployment.interceptors.DefaultActivityContextInterfaceInterceptor(null);";
        constructorBody = String.valueOf(constructorBody) + "}";
        try {
            defaultConstructor.setBody(constructorBody);
            this.concreteActivityContextInterface.addConstructor(defaultConstructor);
            logger.debug((Object)"DefaultConstructor created");
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
    }

    protected void createConstructorWithParameter(CtClass[] parameters) {
        CtConstructor constructorWithParameter = new CtConstructor(parameters, this.concreteActivityContextInterface);
        String constructorBody = "{";
        int i = 0;
        while (i < parameters.length) {
            String parameterName = parameters[i].getName();
            parameterName = parameterName.substring(parameterName.lastIndexOf(".") + 1);
            String firstCharLowerCase = parameterName.substring(0, 1).toLowerCase();
            parameterName = firstCharLowerCase.concat(parameterName.substring(1));
            try {
                CtField ctField = new CtField(parameters[i], parameterName, this.concreteActivityContextInterface);
                ctField.setModifiers(2);
                this.concreteActivityContextInterface.addField(ctField);
            }
            catch (CannotCompileException cce) {
                cce.printStackTrace();
            }
            int paramNumber = i + 1;
            constructorBody = String.valueOf(constructorBody) + parameterName + "=$" + paramNumber + ";";
            ++i;
        }
        constructorBody = String.valueOf(constructorBody) + "sbbActivityContextInterfaceInterceptor=new org.mobicents.slee.container.deployment.interceptors.DefaultActivityContextInterfaceInterceptor(mobicentsSbbDescriptor);";
        constructorBody = String.valueOf(constructorBody) + "sbbActivityContextInterfaceInterceptor.setActivityContextInterface(activityContextInterfaceImpl); this." + ACTIVITY_CONTEXT_INTERFACE_IMPL + " = activityContextInterfaceImpl;";
        constructorBody = String.valueOf(constructorBody) + "}";
        try {
            this.concreteActivityContextInterface.addConstructor(constructorWithParameter);
            constructorWithParameter.setBody(constructorBody);
            logger.debug((Object)"ConstructorWithParameter created");
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
    }
}

