/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javax.slee.SLEEException;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainerUtils;
import org.mobicents.slee.container.deployment.ClassUtils;
import org.mobicents.slee.container.deployment.SbbDeployer;

public class ConcreteClassGeneratorUtils {
    public static Logger logger = null;
    public static final String SBB_CONCRETE_CLASS_NAME_PREFIX = "";
    public static final String SBB_CONCRETE_CLASS_NAME_SUFFIX = "Impl";
    public static final String CONCRETE_ACTIVITY_INTERFACE_CLASS_NAME_PREFIX = "";
    public static final String CONCRETE_ACTIVITY_INTERFACE_CLASS_NAME_SUFFIX = "Impl";
    public static final String SBB_LOCAL_OBJECT_CLASS_NAME_PREFIX = "";
    public static final String SBB_LOCAL_OBJECT_CLASS_NAME_SUFFIX = "Impl";
    public static final String PROFILE_CONCRETE_CLASS_NAME_PREFIX = "";
    public static final String PROFILE_CONCRETE_CLASS_NAME_SUFFIX = "Impl";
    public static final String PROFILE_MBEAN_CONCRETE_CLASS_NAME_PREFIX = "";
    public static final String PROFILE_MBEAN_CONCRETE_CLASS_NAME_SUFFIX = "MBeanImpl";
    public static final String PROFILE_TRANSIENT_CLASS_NAME_PREFIX = "";
    public static final String PROFILE_TRANSIENT_CLASS_NAME_SUFFIX = "TransientState";
    public static final String SBB_USAGE_PARAMETERS_INTERFACE_PREFIX = "";
    public static final String SBB_USAGE_PARAMETERS_INTERFACE_SUFFIX = "Impl";
    private static ClassPool pool;

    static {
        logger = Logger.getLogger(ConcreteClassGeneratorUtils.class);
        pool = new ClassPool(ClassPool.getDefault());
        try {
            File mobicentsSar = new File(SbbDeployer.getLibPath());
            List filesJars = ConcreteClassGeneratorUtils.getJarsFileListing(mobicentsSar);
            int i = 0;
            while (i < filesJars.size()) {
                File jar = (File)filesJars.get(i);
                pool.insertClassPath(String.valueOf(SbbDeployer.getLibPath()) + jar.getName());
                ++i;
            }
            pool.appendClassPath(SbbDeployer.getLibPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed initializing javassist", e);
        }
    }

    public static List getJarsFileListing(File aStartingDir) throws FileNotFoundException {
        ConcreteClassGeneratorUtils.validateDirectory(aStartingDir);
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        });
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        Iterator<File> filesIter = filesDirs.iterator();
        File file = null;
        while (filesIter.hasNext()) {
            file = filesIter.next();
            result.add(file);
            if (file.isFile()) continue;
            List deeperList = ConcreteClassGeneratorUtils.getJarsFileListing(file);
            result.addAll(deeperList);
        }
        Collections.sort(result);
        return result;
    }

    private static void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }

    public static ClassPool createClassPool() {
        return new ClassPool(pool);
    }

    public static String getSbbConcreteClassName(String sbbAbstractClassName) {
        return sbbAbstractClassName + "Impl";
    }

    public static void createInterfaceLinks(CtClass concreteClass, CtClass[] interfaces) {
        if (interfaces == null) {
            return;
        }
        concreteClass.setInterfaces(interfaces);
        int i = 0;
        while (i < interfaces.length) {
            logger.debug((Object)(String.valueOf(concreteClass.getName()) + " Implements link with " + interfaces[i].getName() + " interface created"));
            ++i;
        }
    }

    public static void createInheritanceLink(CtClass concreteClass, CtClass superClass) {
        if (superClass == null) {
            return;
        }
        try {
            concreteClass.setSuperclass(superClass);
            logger.debug((Object)(String.valueOf(concreteClass.getName()) + " Inheritance link with " + superClass.getName() + " class created"));
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
    }

    public static void addInterceptedMethod(CtClass concreteClass, CtMethod method, String interceptorName, boolean callSuperMethod) {
        if (method == null) {
            throw new InvalidParameterException("Intercepted method should not be null");
        }
        if (interceptorName == null) {
            throw new InvalidParameterException("Interceptor class name should not be null");
        }
        String methodToAdd = "public ";
        boolean hasReturn = false;
        CtClass returnType = null;
        try {
            returnType = method.getReturnType();
            methodToAdd = methodToAdd.concat(String.valueOf(returnType.getName()) + " ");
            hasReturn = true;
        }
        catch (NotFoundException nfe) {
            logger.debug((Object)"No return type -- assuming return type is void ");
            methodToAdd = String.valueOf(methodToAdd) + "void ";
        }
        methodToAdd = methodToAdd.concat(String.valueOf(method.getName()) + "(");
        CtClass[] parameterTypes = null;
        String parametersInit = "Object[] args=null;";
        String argsInit = "Class[] classes=null;";
        try {
            parameterTypes = method.getParameterTypes();
            parametersInit = String.valueOf(parametersInit) + "args=new Object[" + parameterTypes.length + "];";
            argsInit = String.valueOf(argsInit) + "classes=new Class[" + parameterTypes.length + "];";
            int argNumber = 0;
            while (argNumber < parameterTypes.length) {
                methodToAdd = methodToAdd.concat(String.valueOf(parameterTypes[argNumber].getName()) + " arg_" + argNumber);
                parametersInit = !parameterTypes[argNumber].isPrimitive() ? String.valueOf(parametersInit) + " args[" + argNumber + "]=arg_" + argNumber + ";" : String.valueOf(parametersInit) + " args[" + argNumber + "]=" + ClassUtils.getObjectFromPrimitiveType(parameterTypes[argNumber].getName(), "arg_" + argNumber) + ";";
                String typeClass = parameterTypes[argNumber].getName();
                if (!parameterTypes[argNumber].isPrimitive()) {
                    if (parameterTypes[argNumber].isArray()) {
                        String arrayClassRepresentation = ConcreteClassGeneratorUtils.toArray(parameterTypes[argNumber]);
                        if (arrayClassRepresentation != null) {
                            argsInit = String.valueOf(argsInit) + "classes[" + argNumber + "]=" + SleeContainerUtils.class.getName() + ".getCurrentThreadClassLoader().loadClass(\"" + arrayClassRepresentation + "\");";
                        }
                    } else {
                        argsInit = String.valueOf(argsInit) + "classes[" + argNumber + "]=" + SleeContainerUtils.class.getName() + ".getCurrentThreadClassLoader().loadClass(\"" + typeClass + "\");";
                    }
                } else {
                    argsInit = String.valueOf(argsInit) + "classes[" + argNumber + "]=" + ClassUtils.getClassFromPrimitiveType(typeClass) + ".TYPE;";
                }
                if (argNumber + 1 < parameterTypes.length) {
                    methodToAdd = String.valueOf(methodToAdd) + ",";
                }
                ++argNumber;
            }
            methodToAdd = String.valueOf(methodToAdd) + ") ";
            if (method.getExceptionTypes().length > 0) {
                CtClass[] exceptions = method.getExceptionTypes();
                methodToAdd = String.valueOf(methodToAdd) + " throws ";
                int i = 0;
                while (i < exceptions.length - 1) {
                    String exName = exceptions[i].getName();
                    methodToAdd = String.valueOf(methodToAdd) + exName + ", ";
                    ++i;
                }
                methodToAdd = String.valueOf(methodToAdd) + exceptions[exceptions.length - 1].getName();
            }
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
            throw new SLEEException("Failed creating concrete Profile MBean implementation class", (Throwable)nfe);
        }
        methodToAdd = String.valueOf(methodToAdd) + " { ";
        methodToAdd = String.valueOf(methodToAdd) + parametersInit;
        methodToAdd = String.valueOf(methodToAdd) + argsInit;
        methodToAdd = String.valueOf(methodToAdd) + "Class clazz=this.getClass();";
        methodToAdd = String.valueOf(methodToAdd) + "Object result=null;";
        methodToAdd = String.valueOf(methodToAdd) + "try{";
        if (callSuperMethod && method.getName().equals("profileStore")) {
            methodToAdd = String.valueOf(methodToAdd) + "super." + method.getName() + "(";
            if (parameterTypes != null && parameterTypes.length > 0) {
                int argNumber = 0;
                while (argNumber < parameterTypes.length) {
                    methodToAdd = String.valueOf(methodToAdd) + "arg_" + argNumber;
                    if (argNumber + 1 < parameterTypes.length) {
                        methodToAdd = String.valueOf(methodToAdd) + ",";
                    }
                    ++argNumber;
                }
            }
            methodToAdd = String.valueOf(methodToAdd) + ");";
        }
        methodToAdd = String.valueOf(methodToAdd) + "java.lang.reflect.Method method=clazz.getDeclaredMethod(\"" + method.getName() + "\",classes" + ");";
        methodToAdd = String.valueOf(methodToAdd) + "result=" + interceptorName + ".invoke(this,method,args); ";
        methodToAdd = String.valueOf(methodToAdd) + "}catch(RuntimeException t){t.printStackTrace(); throw (t); " + " } catch (Exception ex1) { ex1.printStackTrace(); throw (ex1); }";
        if (callSuperMethod && !method.getName().equals("profileStore")) {
            methodToAdd = String.valueOf(methodToAdd) + "super." + method.getName() + "(";
            if (parameterTypes != null && parameterTypes.length > 0) {
                int argNumber = 0;
                while (argNumber < parameterTypes.length) {
                    methodToAdd = String.valueOf(methodToAdd) + "arg_" + argNumber;
                    if (argNumber + 1 < parameterTypes.length) {
                        methodToAdd = String.valueOf(methodToAdd) + ",";
                    }
                    ++argNumber;
                }
            }
            methodToAdd = String.valueOf(methodToAdd) + ");";
        }
        if (hasReturn && !returnType.getName().equalsIgnoreCase("void")) {
            methodToAdd = !returnType.isPrimitive() ? String.valueOf(methodToAdd) + "return (" + returnType.getName() + ")result;" : String.valueOf(methodToAdd) + "return " + ClassUtils.getPrimitiveTypeFromObject(returnType.getName(), "result") + ";";
        }
        methodToAdd = String.valueOf(methodToAdd) + "}";
        logger.debug((Object)("Method " + methodToAdd + " added"));
        try {
            CtMethod methodTest = CtNewMethod.make((String)methodToAdd, (CtClass)concreteClass);
            concreteClass.addMethod(methodTest);
        }
        catch (CannotCompileException cce) {
            throw new SLEEException("Cannot compile method " + method.getName(), (Throwable)cce);
        }
    }

    public static String toArray(CtClass typeClass) {
        StringTokenizer st = new StringTokenizer(typeClass.getName(), "[");
        String name = null;
        try {
            CtClass arrayClass = typeClass.getComponentType();
            name = !arrayClass.isPrimitive() ? "L" + arrayClass.getName().replace('/', '.') + ";" : ConcreteClassGeneratorUtils.toJvmRepresentation(arrayClass.getName());
            st.nextToken();
            while (st.hasMoreTokens()) {
                st.nextToken();
                name = "[" + name;
            }
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        return name;
    }

    public static String toJvmRepresentation(String primitiveTypeName) {
        if (primitiveTypeName.equals("int")) {
            return "I";
        }
        if (primitiveTypeName.equals("boolean")) {
            return "Z";
        }
        if (primitiveTypeName.equals("byte")) {
            return "B";
        }
        if (primitiveTypeName.equals("char")) {
            return "C";
        }
        if (primitiveTypeName.equals("double")) {
            return "D";
        }
        if (primitiveTypeName.equals("float")) {
            return "F";
        }
        if (primitiveTypeName.equals("long")) {
            return "J";
        }
        if (primitiveTypeName.equals("short")) {
            return "S";
        }
        if (primitiveTypeName.equals("void")) {
            return "V";
        }
        return primitiveTypeName;
    }

    public static void copyMethods(CtClass source, CtClass destination, CtClass[] exceptions) {
        CtMethod[] methods = source.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            CtMethod method = null;
            try {
                method = new CtMethod(methods[i], destination, null);
                if (exceptions != null) {
                    try {
                        method.setExceptionTypes(exceptions);
                    }
                    catch (NotFoundException e1) {
                        e1.printStackTrace();
                    }
                }
                destination.addMethod(method);
            }
            catch (CannotCompileException e) {
                e.printStackTrace();
                return;
            }
            ++i;
        }
    }
}

