/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javax.slee.SLEEException;
import javax.slee.management.DeploymentException;
import javax.slee.usage.UnrecognizedUsageParameterSetNameException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.component.CMPField;
import org.mobicents.slee.container.component.DeployableUnitIDImpl;
import org.mobicents.slee.container.component.GetChildRelationMethod;
import org.mobicents.slee.container.component.MobicentsSbbDescriptor;
import org.mobicents.slee.container.component.ProfileCMPMethod;
import org.mobicents.slee.container.component.SbbEventEntry;
import org.mobicents.slee.container.deployment.ClassUtils;
import org.mobicents.slee.container.deployment.ConcreteActivityContextInterfaceGenerator;
import org.mobicents.slee.container.deployment.ConcreteClassGeneratorUtils;
import org.mobicents.slee.container.deployment.ConcreteSbbLocalObjectGenerator;
import org.mobicents.slee.container.deployment.MappingManager;
import org.mobicents.slee.container.deployment.interceptors.ChildRelationInterceptor;
import org.mobicents.slee.container.deployment.interceptors.DefaultChildRelationInterceptor;
import org.mobicents.slee.container.deployment.interceptors.DefaultFireEventInterceptor;
import org.mobicents.slee.container.deployment.interceptors.DefaultPersistenceInterceptor;
import org.mobicents.slee.container.deployment.interceptors.DefaultSBBProfileCMPInterceptor;
import org.mobicents.slee.container.deployment.interceptors.FireEventInterceptor;
import org.mobicents.slee.container.deployment.interceptors.PersistenceInterceptor;
import org.mobicents.slee.container.deployment.interceptors.SBBProfileCMPInterceptor;
import org.mobicents.slee.container.deployment.interceptors.UsageParameterInterceptor;
import org.mobicents.slee.runtime.ActivityContextInterfaceImpl;
import org.mobicents.slee.runtime.SbbConcrete;
import org.mobicents.slee.runtime.SbbEntity;
import org.mobicents.slee.runtime.SbbLocalObjectImpl;
import org.mobicents.slee.runtime.SbbObjectState;

public class ConcreteSbbGenerator {
    private static final String SBB_CHILDRELATION_INTERCEPTOR = "sbbChildRelationInterceptor";
    private static final String SBB_FIREEVENT_INTERCEPTOR = "sbbFireEventInterceptor";
    private static final String SBB_PERSISTENCE_INTERCEPTOR_FIELD = "sbbPersistenceInterceptor";
    private static final String SBB_PROFILE_CMP_INTERCEPTOR_FIELD = "sbbProfileCMPInterceptor";
    public static final String DEFAULT_USAGE_PARAMETER_SETTER = "sbbSetDefaultUsageParameter";
    public static final String NAMED_USAGE_PARAMETER_SETTER = "sbbSetNamedUsageParameterTable";
    private MobicentsSbbDescriptor sbbDeploymentDescriptor = null;
    private CtClass sbbAbstractClass = null;
    private CtClass sbbConcreteClass = null;
    private MappingManager mappingManager = null;
    private static Logger logger = null;
    private Map abstractMethods = null;
    private ConcreteActivityContextInterfaceGenerator concreteActivityContextInterfaceGenerator = null;
    private ClassPool pool = null;
    private Map superClassesAbstractMethods;
    private String deployPath;

    static {
        logger = Logger.getLogger(ConcreteSbbGenerator.class);
    }

    public ConcreteSbbGenerator(MobicentsSbbDescriptor sbbDeploymentDescriptor) {
        this.sbbDeploymentDescriptor = sbbDeploymentDescriptor;
        this.mappingManager = new MappingManager();
        this.deployPath = ((DeployableUnitIDImpl)sbbDeploymentDescriptor.getDeployableUnit()).getDUDeployer().getClasspathDirectory().getAbsolutePath();
        this.pool = ((DeployableUnitIDImpl)sbbDeploymentDescriptor.getDeployableUnit()).getDUDeployer().getClassPool();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class generateConcreteSbb() throws DeploymentException {
        String sbbAbstractClassName = this.sbbDeploymentDescriptor.getSbbAbstractClassName();
        String sbbConcreteClassName = ConcreteClassGeneratorUtils.getSbbConcreteClassName(sbbAbstractClassName);
        try {
            this.sbbConcreteClass = this.pool.get(sbbConcreteClassName).getClassPool().makeClass(sbbConcreteClassName);
        }
        catch (NotFoundException e3) {
            this.sbbConcreteClass = this.pool.makeClass(sbbConcreteClassName);
        }
        try {
            String s;
            try {
                this.sbbAbstractClass = this.pool.get(sbbAbstractClassName);
            }
            catch (NotFoundException nfe) {
                nfe.printStackTrace();
                return null;
            }
            try {
                ConcreteClassGeneratorUtils.createInterfaceLinks(this.sbbConcreteClass, new CtClass[]{this.pool.get(SbbConcrete.class.getName())});
            }
            catch (NotFoundException nfe) {
                nfe.printStackTrace();
                return null;
            }
            ConcreteClassGeneratorUtils.createInheritanceLink(this.sbbConcreteClass, this.sbbAbstractClass);
            this.createInterceptorFields();
            this.createDefaultConstructor();
            try {
                this.createFields(new CtClass[]{this.pool.get(SbbEntity.class.getName()), this.pool.get(SbbObjectState.class.getName())});
                CtClass[] parameters = new CtClass[]{this.pool.get(SbbEntity.class.getName())};
                this.createStateGetterAndSetter(this.sbbConcreteClass);
                this.createInterceptors(this.sbbConcreteClass);
                this.createSbbEntityGetterAndSetter(this.sbbConcreteClass);
                this.createDefaultUsageParameterSetter(this.sbbConcreteClass);
                this.createDefaultUsageParameterGetter(this.sbbConcreteClass);
                this.createNamedUsageParameterSetter(this.sbbConcreteClass);
                this.createNamedUsageParameterGetter(this.sbbConcreteClass);
                this.createConstructorWithParameter(parameters);
            }
            catch (NotFoundException nfe) {
                logger.error((Object)"Constructor With Parameter not created");
                throw new DeploymentException("Constructor not created.", (Throwable)nfe);
            }
            this.abstractMethods = ClassUtils.getAbstractMethodsFromClass(this.sbbAbstractClass);
            this.superClassesAbstractMethods = ClassUtils.getSuperClassesAbstractMethodsFromClass(this.sbbAbstractClass);
            CMPField[] cmpFieldDescriptors = this.sbbDeploymentDescriptor.getCMPFields();
            this.createCMPAccessors(cmpFieldDescriptors);
            GetChildRelationMethod[] childRelations = this.sbbDeploymentDescriptor.getChildRelationMethods();
            this.createGetChildRelationsMethod(childRelations);
            ProfileCMPMethod[] cmpProfiles = this.sbbDeploymentDescriptor.getProfileCMPMethods();
            this.createGetProfileCMPMethods(cmpProfiles);
            HashSet sbbEventEntries = this.sbbDeploymentDescriptor.getSbbEventEntries();
            this.createFireEventMethods(sbbEventEntries);
            String activityContextInterfaceName = this.sbbDeploymentDescriptor.getActivityContextInterfaceClassName();
            if (activityContextInterfaceName != null) {
                Class<?> activityContextInterfaceClass = null;
                try {
                    activityContextInterfaceClass = Thread.currentThread().getContextClassLoader().loadClass(activityContextInterfaceName);
                }
                catch (ClassNotFoundException e2) {
                    String s2 = "Error creating constructor -  class not found";
                    logger.error((Object)s2, (Throwable)e2);
                    throw new DeploymentException(s2, (Throwable)e2);
                }
                Method[] methods = activityContextInterfaceClass.getMethods();
                if (methods != null) {
                    int i = 0;
                    while (i < methods.length) {
                        Class<?>[] args;
                        String methodName = methods[i].getName();
                        if (methodName.startsWith("Get")) {
                            return null;
                        }
                        if (methodName.startsWith("Set")) {
                            return null;
                        }
                        if (methodName.startsWith("set")) {
                            args = methods[i].getParameterTypes();
                            if (args.length != 1) {
                                return null;
                            }
                            Class<?> returnClass = methods[i].getReturnType();
                            if (!returnClass.equals(Void.TYPE)) {
                                return null;
                            }
                        } else if (methodName.startsWith("get") && (args = methods[i].getParameterTypes()) != null && args.length != 0) {
                            return null;
                        }
                        ++i;
                    }
                }
                try {
                    CtClass activityContextInterface = this.pool.get(activityContextInterfaceClass.getName());
                    this.createField(activityContextInterface, "sbbActivityContextInterface");
                    this.createSetActivityContextInterfaceMethod(activityContextInterface);
                    ConcreteActivityContextInterfaceGenerator concreteActivityContextInterfaceGenerator = new ConcreteActivityContextInterfaceGenerator(this.sbbDeploymentDescriptor);
                    Class concreteActivityContextInterfaceClass = concreteActivityContextInterfaceGenerator.generateActivityContextInterfaceConcreteClass(activityContextInterfaceClass.getName());
                    this.createGetSbbActivityContextInterfaceMethod(activityContextInterface, concreteActivityContextInterfaceClass);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("SETTING ACI concrete class  " + concreteActivityContextInterfaceClass + " in " + this.sbbDeploymentDescriptor));
                    }
                    this.sbbDeploymentDescriptor.setActivityContextInterfaceConcreteClass(concreteActivityContextInterfaceClass);
                }
                catch (NotFoundException nfe) {
                    logger.error((Object)"Narrow Activity context interface method and activity context interface concrete class not created");
                    nfe.printStackTrace();
                }
            }
            Class sbbLocalInterfaceClass = this.sbbDeploymentDescriptor.getSbbLocalInterface();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sbb Local Object interface :" + sbbLocalInterfaceClass.getName()));
            }
            if (sbbLocalInterfaceClass != null && !sbbLocalInterfaceClass.getName().equals("javax.slee.SbbLocalObject")) {
                try {
                    CtClass sbbLocalInterface = this.pool.get(sbbLocalInterfaceClass.getName());
                    ConcreteSbbLocalObjectGenerator concreteSbbLocalObjectGenerator = new ConcreteSbbLocalObjectGenerator(this.sbbDeploymentDescriptor);
                    Class concreteSbbLocalObjectClass = concreteSbbLocalObjectGenerator.generateSbbLocalObjectConcreteClass(this.deployPath, sbbLocalInterfaceClass.getName(), sbbAbstractClassName);
                    this.sbbDeploymentDescriptor.setLocalInterfaceConcreteClass(concreteSbbLocalObjectClass);
                }
                catch (NotFoundException nfe) {
                    s = "sbb Local Object concrete class not created for interface " + sbbLocalInterfaceClass.getName();
                    logger.error((Object)s, (Throwable)nfe);
                    throw new RuntimeException(s, nfe);
                }
            }
            try {
                this.sbbDeploymentDescriptor.setSbbLocalInterfaceClassName("javax.slee.SbbLocalObject");
                this.sbbDeploymentDescriptor.setLocalInterfaceConcreteClass(SbbLocalObjectImpl.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.sbbConcreteClass.writeFile(this.deployPath);
                this.sbbConcreteClass.detach();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Concrete Class " + sbbConcreteClassName + " generated in the following path " + this.deployPath));
                }
            }
            catch (Exception e) {
                s = "Error generating concrete class";
                logger.error((Object)s, (Throwable)e);
                throw new RuntimeException(s, e);
            }
            Class<?> clazz = null;
            try {
                ClassLoader sbbCl = this.sbbDeploymentDescriptor.getClassLoader();
                clazz = sbbCl.loadClass(sbbConcreteClassName);
            }
            catch (ClassNotFoundException e1) {
                String s3 = "What the heck?! Could not find generated class. Is it under the chair?";
                logger.error((Object)s3, (Throwable)e1);
                throw new RuntimeException(s3, e1);
            }
            this.sbbDeploymentDescriptor.setConcreteSbb(clazz);
            Class<?> clazz2 = clazz;
            return clazz2;
        }
        finally {
            this.sbbConcreteClass.defrost();
        }
    }

    private void createField(CtClass parameter, String parameterName) {
        try {
            CtField ctField = new CtField(parameter, parameterName, this.sbbConcreteClass);
            ctField.setModifiers(2);
            this.sbbConcreteClass.addField(ctField);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
    }

    protected void createConstructorWithParameter(CtClass[] parameters) {
        CtConstructor constructorWithParameter = new CtConstructor(parameters, this.sbbConcreteClass);
        String constructorBody = "{this();";
        int i = 0;
        while (i < parameters.length) {
            String parameterName = parameters[i].getName();
            parameterName = parameterName.substring(parameterName.lastIndexOf(".") + 1);
            String firstCharLowerCase = parameterName.substring(0, 1).toLowerCase();
            parameterName = firstCharLowerCase.concat(parameterName.substring(1));
            int paramNumber = i + 1;
            constructorBody = String.valueOf(constructorBody) + parameterName + "=$" + paramNumber + ";";
            ++i;
        }
        constructorBody = String.valueOf(constructorBody) + "createInterceptors();";
        constructorBody = String.valueOf(constructorBody) + "this.setSbbEntity($1);";
        constructorBody = String.valueOf(constructorBody) + "}";
        try {
            this.sbbConcreteClass.addConstructor(constructorWithParameter);
            constructorWithParameter.setBody(constructorBody);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"ConstructorWithParameter created");
            }
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
    }

    private void createFields(CtClass[] parameters) {
        int i = 0;
        while (i < parameters.length) {
            String parameterName = parameters[i].getName();
            parameterName = parameterName.substring(parameterName.lastIndexOf(".") + 1);
            String firstCharLowerCase = parameterName.substring(0, 1).toLowerCase();
            parameterName = firstCharLowerCase.concat(parameterName.substring(1));
            try {
                CtField ctField = new CtField(parameters[i], parameterName, this.sbbConcreteClass);
                ctField.setModifiers(2);
                this.sbbConcreteClass.addField(ctField);
            }
            catch (CannotCompileException cce) {
                cce.printStackTrace();
            }
            ++i;
        }
    }

    protected void createDefaultConstructor() {
        CtConstructor defaultConstructor = new CtConstructor(null, this.sbbConcreteClass);
        String constructorBody = "{}";
        try {
            defaultConstructor.setBody(constructorBody);
            this.sbbConcreteClass.addConstructor(defaultConstructor);
            logger.debug((Object)"DefaultConstructor created");
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
    }

    protected void createInterceptorFields() {
        CtField persistenceInterceptor = null;
        try {
            persistenceInterceptor = new CtField(this.pool.get(PersistenceInterceptor.class.getName()), SBB_PERSISTENCE_INTERCEPTOR_FIELD, this.sbbConcreteClass);
            persistenceInterceptor.setModifiers(2);
            this.sbbConcreteClass.addField(persistenceInterceptor);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
        }
        CtField fireEventInterceptor = null;
        try {
            fireEventInterceptor = new CtField(this.pool.get(FireEventInterceptor.class.getName()), SBB_FIREEVENT_INTERCEPTOR, this.sbbConcreteClass);
            fireEventInterceptor.setModifiers(2);
            this.sbbConcreteClass.addField(fireEventInterceptor);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
        }
        CtField childRelationInterceptor = null;
        try {
            childRelationInterceptor = new CtField(this.pool.get(ChildRelationInterceptor.class.getName()), SBB_CHILDRELATION_INTERCEPTOR, this.sbbConcreteClass);
            childRelationInterceptor.setModifiers(2);
            this.sbbConcreteClass.addField(childRelationInterceptor);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
        }
        CtField usageParameterInterceptor = null;
        try {
            usageParameterInterceptor = new CtField(this.pool.get(UsageParameterInterceptor.class.getName()), "sbbUsageParameterInterceptor", this.sbbConcreteClass);
            usageParameterInterceptor.setModifiers(2);
            this.sbbConcreteClass.addField(usageParameterInterceptor);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
        }
        CtField profileCMPInterceptor = null;
        try {
            profileCMPInterceptor = new CtField(this.pool.get(SBBProfileCMPInterceptor.class.getName()), SBB_PROFILE_CMP_INTERCEPTOR_FIELD, this.sbbConcreteClass);
            profileCMPInterceptor.setModifiers(2);
            this.sbbConcreteClass.addField(profileCMPInterceptor);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
        }
    }

    protected void createCMPAccessors(CMPField[] cmpAccessors) {
        if (cmpAccessors == null) {
            return;
        }
        int i = 0;
        while (i < cmpAccessors.length) {
            String fieldName = cmpAccessors[i].getFieldName();
            fieldName = String.valueOf(fieldName.substring(0, 1).toUpperCase()) + fieldName.substring(1);
            CtMethod setterAccessor = (CtMethod)this.abstractMethods.get("set" + fieldName);
            CtMethod getterAccessor = (CtMethod)this.abstractMethods.get("get" + fieldName);
            if (setterAccessor == null) {
                setterAccessor = (CtMethod)this.superClassesAbstractMethods.get("set" + fieldName);
            }
            if (getterAccessor == null) {
                getterAccessor = (CtMethod)this.superClassesAbstractMethods.get("get" + fieldName);
            }
            if (setterAccessor != null) {
                ConcreteClassGeneratorUtils.addInterceptedMethod(this.sbbConcreteClass, setterAccessor, SBB_PERSISTENCE_INTERCEPTOR_FIELD, false);
            }
            if (getterAccessor != null) {
                ConcreteClassGeneratorUtils.addInterceptedMethod(this.sbbConcreteClass, getterAccessor, SBB_PERSISTENCE_INTERCEPTOR_FIELD, false);
            }
            ++i;
        }
        this.createPersistentStateHolderClass(cmpAccessors);
    }

    private void createStateGetterAndSetter(CtClass sbbConcrete) {
        try {
            CtMethod getSbbState = CtNewMethod.make((String)("public " + SbbObjectState.class.getName() + " getState() { return sbbObjectState; }"), (CtClass)sbbConcrete);
            getSbbState.setModifiers(1);
            sbbConcrete.addMethod(getSbbState);
            CtMethod setSbbState = CtNewMethod.make((String)("public void setState ( " + SbbObjectState.class.getName() + " state ) { this.sbbObjectState = state; }"), (CtClass)sbbConcrete);
            getSbbState.setModifiers(1);
            sbbConcrete.addMethod(setSbbState);
        }
        catch (Exception ex) {
            logger.fatal((Object)"unexpected exception ", (Throwable)ex);
        }
    }

    private void createDefaultUsageParameterGetter(CtClass sbbConcrete) {
        String usageParameterInterfaceName = this.sbbDeploymentDescriptor.getUsageParametersInterface();
        if (usageParameterInterfaceName == null) {
            return;
        }
        try {
            CtMethod getDefaultUsageParameter = CtNewMethod.make((String)("public " + usageParameterInterfaceName + " getDefaultSbbUsageParameterSet( ) { " + "return this.defaultUsageParameterSet;" + "}"), (CtClass)sbbConcrete);
            getDefaultUsageParameter.setModifiers(1);
            sbbConcrete.addMethod(getDefaultUsageParameter);
        }
        catch (Exception ex) {
            logger.fatal((Object)"Unexpected exception ", (Throwable)ex);
        }
    }

    private void createDefaultUsageParameterSetter(CtClass sbbConcrete) {
        String usageParameterInterfaceName = this.sbbDeploymentDescriptor.getUsageParametersInterface();
        if (usageParameterInterfaceName == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No usage parameter interface for this sbb.");
            }
            return;
        }
        try {
            CtField defaultUsageParameter = new CtField(this.pool.get(usageParameterInterfaceName), "defaultUsageParameterSet", this.sbbConcreteClass);
            defaultUsageParameter.setModifiers(2);
            this.sbbConcreteClass.addField(defaultUsageParameter);
            CtMethod setDefaultUsageParameter = CtNewMethod.make((String)("public void  sbbSetDefaultUsageParameter(" + usageParameterInterfaceName + " defaultUsageParameter ) { " + "this.defaultUsageParameterSet = defaultUsageParameter ;" + "}"), (CtClass)sbbConcrete);
            setDefaultUsageParameter.setModifiers(1);
            sbbConcrete.addMethod(setDefaultUsageParameter);
        }
        catch (Exception ex) {
            logger.fatal((Object)"Unexpected exception ", (Throwable)ex);
        }
    }

    private void createNamedUsageParameterSetter(CtClass sbbConcrete) {
        try {
            CtField ctField = new CtField(this.pool.get(Map.class.getName()), "usageParameterTable", sbbConcrete);
            ctField.setModifiers(2);
            sbbConcrete.addField(ctField);
            CtMethod setNamedUsageParameterTable = CtNewMethod.make((String)("public void sbbSetNamedUsageParameterTable ( " + Map.class.getName() + " usageParamTable )  {" + "this.usageParameterTable = usageParamTable; }"), (CtClass)sbbConcrete);
            sbbConcrete.addMethod(setNamedUsageParameterTable);
        }
        catch (Exception ex) {
            String s = "Unexpected exception in setNamedUsageParameterTable generation";
            logger.fatal((Object)s, (Throwable)ex);
        }
    }

    private void createNamedUsageParameterGetter(CtClass sbbConcrete) {
        String usageParameterInterfaceName = this.sbbDeploymentDescriptor.getUsageParametersInterface();
        if (usageParameterInterfaceName == null) {
            return;
        }
        try {
            CtMethod getDefaultUsageParameter = CtNewMethod.make((String)("public " + usageParameterInterfaceName + " getSbbUsageParameterSet( String name ) " + "throws " + UnrecognizedUsageParameterSetNameException.class.getName() + " { " + "if(this.usageParameterTable.get( sbbEntity.getUsageParameterPathName(name))" + " ==null) throw new " + UnrecognizedUsageParameterSetNameException.class.getName() + "(\"Usage Parameter Set \" + name +  \" does not exist!\");" + "return " + "(" + usageParameterInterfaceName + ") this.usageParameterTable.get(sbbEntity.getUsageParameterPathName(name)) ;" + " } "), (CtClass)sbbConcrete);
            getDefaultUsageParameter.setModifiers(1);
            sbbConcrete.addMethod(getDefaultUsageParameter);
        }
        catch (Exception ex) {
            String s = "Unexpected exception in createNamedUsageParameterGetter";
            logger.fatal((Object)s, (Throwable)ex);
            throw new RuntimeException(s, ex);
        }
    }

    private void createMethodWrapper(CtClass sbbConcrete, CtMethod methodToWrap) {
        try {
            String methodName = methodToWrap.getName();
            CtClass[] params = methodToWrap.getParameterTypes();
            String returnType = null;
            returnType = methodToWrap.getReturnType().equals(CtClass.voidType) ? "void" : methodToWrap.getReturnType().getName();
            String args = "";
            int i = 0;
            while (i < params.length) {
                args = String.valueOf(args) + params[i].getName() + " " + "param" + i;
                if (i < params.length - 1) {
                    args = String.valueOf(args) + ",";
                }
                ++i;
            }
            CtClass[] exceptions = methodToWrap.getExceptionTypes();
            String wrapper = "public " + returnType + " " + methodName + "(" + args + ") ";
            if (exceptions.length > 0) {
                wrapper = String.valueOf(wrapper) + SLEEException.class.getName() + " , ";
            }
            int i2 = 0;
            while (i2 < exceptions.length) {
                wrapper = String.valueOf(wrapper) + exceptions[i2].getName();
                if (i2 < exceptions.length - 1) {
                    wrapper = String.valueOf(wrapper) + ",";
                }
                ++i2;
            }
            wrapper = String.valueOf(wrapper) + "   {  sbbEntity.checkReEntrant();" + MobicentsSbbDescriptor.class.getName() + "sbbDescriptor  =  sbbEntity.getSbbDescriptor();" + ClassLoader.class.getName() + " oldClassLoader =  Thread.currentThread().setContextClassLoader(sbbDescriptor.getClassLoader());";
            wrapper = String.valueOf(wrapper) + " try { ";
            if (!returnType.equals("void")) {
                wrapper = String.valueOf(wrapper) + "return ";
            }
            wrapper = String.valueOf(wrapper) + "super." + methodName + "(";
            i2 = 0;
            while (i2 < params.length) {
                wrapper = String.valueOf(wrapper) + "param" + i2;
                if (i2 < params.length - 1) {
                    wrapper = String.valueOf(wrapper) + ",";
                }
                ++i2;
            }
            wrapper = String.valueOf(wrapper) + "); } finally { Thread.currentThread().setContextClassLoader(oldClassLoader);  }}";
            logger.debug((Object)("wrapper generated = " + wrapper));
            CtMethod method = CtNewMethod.make((String)wrapper, (CtClass)sbbConcrete);
            sbbConcrete.addMethod(method);
        }
        catch (Exception ex) {
            String s = "Unexpected error in createMethodWrapper";
            logger.fatal((Object)s, (Throwable)ex);
            throw new RuntimeException(s, ex);
        }
    }

    private void createInterceptors(CtClass sbbConcrete) {
        try {
            String body = "public void createInterceptors ( ) { ";
            body = String.valueOf(body) + "sbbPersistenceInterceptor = new " + DefaultPersistenceInterceptor.class.getName() + "();";
            body = String.valueOf(body) + "sbbFireEventInterceptor = new " + DefaultFireEventInterceptor.class.getName() + "();";
            body = String.valueOf(body) + "sbbChildRelationInterceptor =new " + DefaultChildRelationInterceptor.class.getName() + "();";
            body = String.valueOf(body) + "sbbProfileCMPInterceptor = new " + DefaultSBBProfileCMPInterceptor.class.getName() + "();";
            body = String.valueOf(body) + "}";
            CtMethod createInterceptors = CtNewMethod.make((String)body, (CtClass)sbbConcrete);
            sbbConcrete.addMethod(createInterceptors);
        }
        catch (Exception ex) {
            String s = "Unexpected error createInterceptors";
            logger.fatal((Object)s, (Throwable)ex);
            throw new RuntimeException(s, ex);
        }
    }

    private void createSbbEntityGetterAndSetter(CtClass sbbConcrete) {
        try {
            CtClass sbbEntityClass = this.pool.get(SbbEntity.class.getName());
            CtMethod getSbbEntity = CtNewMethod.make((String)("public " + SbbEntity.class.getName() + " getSbbEntity() { return this.sbbEntity; }"), (CtClass)sbbConcrete);
            getSbbEntity.setModifiers(1);
            sbbConcrete.addMethod(getSbbEntity);
            CtMethod setSbbEntity = CtNewMethod.make((String)("public void setSbbEntity ( " + SbbEntity.class.getName() + " sbbEntity )" + "{" + "this.createInterceptors();" + "this.sbbEntity = sbbEntity;" + SBB_PERSISTENCE_INTERCEPTOR_FIELD + ".setSbbEntity(sbbEntity);" + SBB_FIREEVENT_INTERCEPTOR + ".setSbbEntity(sbbEntity);" + SBB_CHILDRELATION_INTERCEPTOR + ".setSbbEntity(sbbEntity);" + SBB_PROFILE_CMP_INTERCEPTOR_FIELD + ".setSbbEntity(sbbEntity);" + "}"), (CtClass)sbbConcrete);
            setSbbEntity.setModifiers(1);
            sbbConcrete.addMethod(setSbbEntity);
        }
        catch (Exception ex) {
            logger.fatal((Object)"unexpected exception ", (Throwable)ex);
        }
    }

    protected void createPersistentStateHolderClass(CMPField[] cmpAccessors) {
        CtClass sbbPersisentStateClass = null;
        try {
            sbbPersisentStateClass = this.pool.get(String.valueOf(this.sbbAbstractClass.getName()) + "PersistentState");
            if (sbbPersisentStateClass.isFrozen()) {
                sbbPersisentStateClass.defrost();
            }
            sbbPersisentStateClass.getClassPool().makeClass(String.valueOf(this.sbbAbstractClass.getName()) + "PersistentState");
        }
        catch (NotFoundException e2) {
            sbbPersisentStateClass = this.pool.makeClass(String.valueOf(this.sbbAbstractClass.getName()) + "PersistentState");
        }
        try {
            try {
                ConcreteClassGeneratorUtils.createInterfaceLinks(sbbPersisentStateClass, new CtClass[]{this.pool.get("java.io.Serializable")});
            }
            catch (NotFoundException e1) {
                e1.printStackTrace();
            }
            int i = 0;
            while (i < cmpAccessors.length) {
                String fieldName = cmpAccessors[i].getFieldName();
                CtMethod accessor = (CtMethod)this.abstractMethods.get("get" + (fieldName = String.valueOf(fieldName.substring(0, 1).toUpperCase()) + fieldName.substring(1)));
                if (accessor == null) {
                    accessor = (CtMethod)this.abstractMethods.get("set" + fieldName);
                }
                if (accessor == null) {
                    accessor = (CtMethod)this.superClassesAbstractMethods.get("set" + fieldName);
                }
                CtField persistentField = null;
                try {
                    persistentField = new CtField(accessor.getReturnType(), "persistentState" + fieldName, sbbPersisentStateClass);
                    persistentField.setModifiers(1);
                    sbbPersisentStateClass.addField(persistentField);
                }
                catch (CannotCompileException cce) {
                    cce.printStackTrace();
                }
                catch (NotFoundException nfe) {
                    nfe.printStackTrace();
                }
                ++i;
            }
            try {
                this.pool.get(String.valueOf(this.sbbAbstractClass.getName()) + "PersistentState").writeFile(this.deployPath);
                this.pool.get(String.valueOf(this.sbbAbstractClass.getName()) + "PersistentState").detach();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Concrete Class " + this.sbbAbstractClass.getName() + "PersistentState" + " generated in the following path " + this.deployPath));
                }
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
            catch (CannotCompileException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            sbbPersisentStateClass.defrost();
        }
    }

    protected void createFireEventMethods(HashSet firedEvents) {
        if (firedEvents == null) {
            return;
        }
        for (SbbEventEntry sbbEventEntry : firedEvents) {
            if (!sbbEventEntry.isFired()) continue;
            String methodName = "fire" + sbbEventEntry.getEventName();
            CtMethod method = (CtMethod)this.abstractMethods.get(methodName);
            if (method == null) {
                method = (CtMethod)this.superClassesAbstractMethods.get(methodName);
            }
            if (method == null) continue;
            ConcreteClassGeneratorUtils.addInterceptedMethod(this.sbbConcreteClass, method, SBB_FIREEVENT_INTERCEPTOR, false);
        }
    }

    protected void createGetChildRelationsMethod(GetChildRelationMethod[] childRelations) {
        if (childRelations == null) {
            return;
        }
        int i = 0;
        while (i < childRelations.length) {
            String methodName = childRelations[i].getMethodName();
            CtMethod method = (CtMethod)this.abstractMethods.get(methodName);
            CtMethod superClassMethod = (CtMethod)this.superClassesAbstractMethods.get(methodName);
            if (method != null) {
                ConcreteClassGeneratorUtils.addInterceptedMethod(this.sbbConcreteClass, method, SBB_CHILDRELATION_INTERCEPTOR, false);
            } else if (superClassMethod != null) {
                ConcreteClassGeneratorUtils.addInterceptedMethod(this.sbbConcreteClass, superClassMethod, SBB_CHILDRELATION_INTERCEPTOR, false);
            }
            ++i;
        }
    }

    protected void createGetProfileCMPMethods(ProfileCMPMethod[] cmpProfiles) {
        if (cmpProfiles == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"no CMP Profile method implementation to generate.");
            }
            return;
        }
        int i = 0;
        while (i < cmpProfiles.length) {
            String methodName = cmpProfiles[i].getProfileCMPMethod();
            CtMethod method = (CtMethod)this.abstractMethods.get(methodName);
            if (method == null) {
                method = (CtMethod)this.superClassesAbstractMethods.get(methodName);
            }
            if (method != null) {
                ConcreteClassGeneratorUtils.addInterceptedMethod(this.sbbConcreteClass, method, SBB_PROFILE_CMP_INTERCEPTOR_FIELD, false);
            }
            ++i;
        }
    }

    protected void createSetActivityContextInterfaceMethod(CtClass activityContextInterface) {
        String methodToAdd = "public void sbbSetActivityContextInterface( Object aci ) {this.sbbActivityContextInterface = (" + activityContextInterface.getName() + ") aci ; } ";
        try {
            CtMethod methodTest = CtNewMethod.make((String)methodToAdd, (CtClass)this.sbbConcreteClass);
            this.sbbConcreteClass.addMethod(methodTest);
            logger.debug((Object)("Method " + methodToAdd + " added"));
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
    }

    protected void createGetSbbActivityContextInterfaceMethod(CtClass activityContextInterface, Class concreteActivityContextInterfaceClass) {
        String methodToAdd = "public " + activityContextInterface.getName() + " asSbbActivityContextInterface(javax.slee.ActivityContextInterface aci) {" + "if(aci==null)" + "     throw new " + IllegalStateException.class.getName() + "(\"Passed argument can not be of null value.\");" + " if(sbbEntity == null || sbbEntity.getSbbObject().getState() != " + SbbObjectState.class.getName() + ".READY) { throw new " + IllegalStateException.class.getName() + "(\"Cannot call asSbbActivityContextInterface\"); } " + "else if ( aci instanceof " + concreteActivityContextInterfaceClass.getName() + ") return aci;" + "else return  new " + concreteActivityContextInterfaceClass.getName() + " ( ( " + ActivityContextInterfaceImpl.class.getName() + ")$1, " + "sbbEntity.getSbbDescriptor());" + "}";
        try {
            CtMethod methodTest = CtNewMethod.make((String)methodToAdd, (CtClass)this.sbbConcreteClass);
            this.sbbConcreteClass.addMethod(methodTest);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Method " + methodToAdd + " added"));
            }
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
    }
}

