/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.slee.Sbb;
import javax.slee.management.DeploymentException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.apache.log4j.BasicConfigurator;
import org.jboss.logging.Log4jLoggerPlugin;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.component.MobicentsSbbDescriptor;
import org.mobicents.slee.container.component.MobicentsSbbDescriptorInternalImpl;
import org.mobicents.slee.container.component.deployment.SbbDeploymentDescriptorParser;
import org.mobicents.slee.container.deployment.ConcreteSbbGenerator;
import org.mobicents.slee.container.deployment.SbbVerifierTest;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ConcreteSbbGeneratorTest
extends TestCase {
    private Logger logger = null;
    private SbbDeploymentDescriptorParser sbbDeploymentDescriptorParser = null;
    private Document sbbJarDocument = null;
    private Element rootNode = null;
    private Element sbbNode = null;
    private MobicentsSbbDescriptor mobicentsSbbDescriptor = null;
    ConcreteSbbGenerator concreteSbbGenerator = null;
    public static String SBB_JAR_XML = "<?xml version=\"1.0\"?>\n<sbb-jar>\n    <sbb>\n        <description>Foo Sbb</description>\n        <sbb-name>Foo Sbb</sbb-name>\n        <sbb-vendor>NIST</sbb-vendor>\n        <sbb-version>1.0</sbb-version>\n\n        <profile-spec-ref>\n            <profile-spec-name>CallForwardingProfile</profile-spec-name>\n            <profile-spec-vendor>The Open Source Community</profile-spec-vendor>\n            <profile-spec-version>1.0</profile-spec-version>\n            <profile-spec-alias>CFP</profile-spec-alias>\n        </profile-spec-ref>\n\n        <sbb-ref>\n           <description></description>\n        \t<sbb-name>Foo SBB</sbb-name>\n        \t<sbb-vendor>NIST</sbb-vendor>\n        \t<sbb-version> 1.0 </sbb-version>\n        \t<sbb-alias>FooSBB</sbb-alias>\n        </sbb-ref>\n        <sbb-classes>\n            <sbb-abstract-class>\n                <sbb-abstract-class-name>org.mobicents.slee.container.deployment.FooSbb</sbb-abstract-class-name>\n                \t<get-profile-cmp-method>\n                   \t<profile-spec-alias-ref>CFP</profile-spec-alias-ref>\n                    \t<get-profile-cmp-method-name>getFooProfileCMP</get-profile-cmp-method-name>\n                \t</get-profile-cmp-method>\n             \t\t<cmp-field>\n             \t\t\t<description>\n             \t\t\t\tAn integer counter.\n             \t\t\t</description>\n             \t\t\t<cmp-field-name>counter</cmp-field-name>\n             \t\t</cmp-field>\n             \t\t<cmp-field>\n             \t\t\t<description>\n             \t\t\tThe most recent time that the counter was updated.\n             \t\t\t</description>\n             \t\t\t<cmp-field-name>counterLastUpdated</cmp-field-name>\n             \t\t</cmp-field>\n             \t\t<cmp-field>\n             \t\t\t<description>\n             \t\t\tHolds a reference to my peer FooSBB.\n             \t\t\t</description>\n             \t\t\t<cmp-field-name>peerFooSbb</cmp-field-name>\n             \t\t</cmp-field>\n             \t\t<get-child-relation-method>\n             \t\t       <description />\n             \t\t       <sbb-alias-ref>FooSBB</sbb-alias-ref>\n             \t\t<get-child-relation-method-name>getFooSbb</get-child-relation-method-name>\n             \t\t<default-priority>1</default-priority>\n             \t\t</get-child-relation-method>\n            </sbb-abstract-class>\n\t\t\t<sbb-local-interface>\n\t\t\t\t<sbb-local-interface-name>\norg.mobicents.slee.container.deployment.FooSbbLocalObject\n \t\t\t\t</sbb-local-interface-name>\n\t\t\t</sbb-local-interface>\n                   <sbb-activity-context-interface>\n                   <description />\n                   <sbb-activity-context-interface-name>org.mobicents.slee.container.deployment.FooSbbActivityContextInterface</sbb-activity-context-interface-name>\n                   </sbb-activity-context-interface>\n        </sbb-classes>\n    \t<event event-direction=\"Receive\">\n    \t\t<description>\n    \t\t\tThis SBB fires events of the org.mobicents.slee.container.deployment.FooEvent.StartEvent\n    \t\t\tevent type and assigns StartEvent as the event name of\n    \t\t\tthis event type.\n    \t\t</description>\n    \t\t<event-name>StartEvent</event-name>\n    \t\t<event-type-ref>\n    \t\t<event-type-name> org.mobicents.slee.container.deployment.FooEvent.StartEvent </event-type-name>\n    \t\t<event-type-vendor> org.mobicents.slee.container.deployment.foobar </event-type-vendor>\n    \t\t<event-type-version> 1.3a </event-type-version>\n    \t\t</event-type-ref>\n    \t</event>\n    </sbb>\n</sbb-jar>\n";

    public ConcreteSbbGeneratorTest() {
    }

    public ConcreteSbbGeneratorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        BasicConfigurator.configure();
        Logger.setPluginClassName((String)Log4jLoggerPlugin.class.getName());
        this.logger = Logger.getLogger(ConcreteSbbGeneratorTest.class);
        try {
            BasicConfigurator.configure();
            Logger.setPluginClassName((String)Log4jLoggerPlugin.class.getName());
            this.logger = Logger.getLogger(SbbVerifierTest.class);
            this.sbbDeploymentDescriptorParser = new SbbDeploymentDescriptorParser();
            InputSource sbbJarSource = new InputSource(new StringReader(SBB_JAR_XML));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.sbbJarDocument = builder.parse(sbbJarSource);
            List sbbNodes = XMLUtils.getAllChildElements(this.sbbJarDocument.getDocumentElement(), "sbb");
            this.sbbNode = (Element)sbbNodes.get(0);
            this.mobicentsSbbDescriptor = new MobicentsSbbDescriptorInternalImpl();
            this.mobicentsSbbDescriptor = this.sbbDeploymentDescriptorParser.parseSbbComponent(this.sbbNode, (MobicentsSbbDescriptorInternalImpl)this.mobicentsSbbDescriptor);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void tearDown() throws Exception {
        this.mobicentsSbbDescriptor = null;
        this.concreteSbbGenerator = null;
        super.tearDown();
    }

    public void testGenerateClass() throws IllegalArgumentException, DeploymentException {
        this.concreteSbbGenerator = new ConcreteSbbGenerator(this.mobicentsSbbDescriptor);
        Class clazz = null;
        this.mobicentsSbbDescriptor.setSbbAbstractClassName("org.mobicents.slee.container.deployment.FooSbb");
        clazz = this.concreteSbbGenerator.generateConcreteSbb();
        Sbb sbb = null;
        try {
            sbb = (Sbb)clazz.newInstance();
        }
        catch (InstantiationException e2) {
            e2.printStackTrace();
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
        ConcreteSbbGeneratorTest.assertNotNull((String)"Failed creating Sbb", (Object)sbb);
    }
}

