/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment;

import java.io.IOException;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainerUtils;
import org.mobicents.slee.container.component.DeployableUnitIDImpl;
import org.mobicents.slee.container.component.MobicentsSbbDescriptor;
import org.mobicents.slee.container.deployment.ClassUtils;
import org.mobicents.slee.container.deployment.ConcreteClassGeneratorUtils;
import org.mobicents.slee.container.deployment.interceptors.SbbLocalObjectInterceptor;
import org.mobicents.slee.runtime.SbbEntity;
import org.mobicents.slee.runtime.SbbLocalObjectConcrete;
import org.mobicents.slee.runtime.SbbLocalObjectImpl;

public class ConcreteSbbLocalObjectGenerator {
    private static Logger logger = null;
    private ClassPool pool = null;
    protected CtClass sleeSbbLocalObject = null;
    protected CtClass sbbLocalObjectInterface = null;
    protected CtClass concreteSbbLocalObject = null;

    static {
        logger = Logger.getLogger(ConcreteSbbLocalObjectGenerator.class);
    }

    public ConcreteSbbLocalObjectGenerator(MobicentsSbbDescriptor sbbDescriptor) {
        this.pool = ((DeployableUnitIDImpl)sbbDescriptor.getDeployableUnit()).getDUDeployer().getClassPool();
    }

    public Class generateSbbLocalObjectConcreteClass(String deployPath, String sbbLocalObjectName, String sbbAbstractClassName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("generateSbbLocalObjectConcreteClass: sbbLocalObjectInterface = " + sbbLocalObjectName + " deployPath = " + deployPath));
        }
        try {
            CtClass concreteClassInterface;
            String tmpClassName = sbbLocalObjectName + "Impl";
            try {
                this.concreteSbbLocalObject = this.pool.get(tmpClassName).getClassPool().makeClass(tmpClassName);
            }
            catch (NotFoundException e2) {
                this.concreteSbbLocalObject = this.pool.makeClass(tmpClassName);
            }
            try {
                this.sleeSbbLocalObject = this.pool.get(SbbLocalObjectImpl.class.getName());
                this.sbbLocalObjectInterface = this.pool.get(sbbLocalObjectName);
            }
            catch (NotFoundException nfe) {
                nfe.printStackTrace();
                String s = "Problem with pool ";
                logger.error((Object)s, (Throwable)nfe);
                throw new RuntimeException(s, nfe);
            }
            try {
                concreteClassInterface = this.pool.get(SbbLocalObjectConcrete.class.getName());
            }
            catch (NotFoundException nfe) {
                nfe.printStackTrace();
                String s = "Problem with the pool! ";
                logger.error((Object)s, (Throwable)nfe);
                throw new RuntimeException(s, nfe);
            }
            ConcreteClassGeneratorUtils.createInterfaceLinks(this.concreteSbbLocalObject, new CtClass[]{this.sbbLocalObjectInterface, concreteClassInterface});
            ConcreteClassGeneratorUtils.createInheritanceLink(this.concreteSbbLocalObject, this.sleeSbbLocalObject);
            try {
                CtClass[] parameters = new CtClass[]{this.pool.get(SbbEntity.class.getName())};
                this.createConstructorWithParameter(parameters);
            }
            catch (NotFoundException nfe) {
                nfe.printStackTrace();
                logger.error((Object)"Constructor With Parameter not created", (Throwable)nfe);
                throw new RuntimeException("Problem with the pool", nfe);
            }
            Map interfaceMethods = ClassUtils.getInterfaceMethodsFromInterface(this.sbbLocalObjectInterface);
            this.generateConcreteMethods(interfaceMethods, sbbAbstractClassName);
            this.generateEqualsMethod();
            this.generateGetSbbEntityId();
            try {
                this.pool.get(tmpClassName).writeFile(deployPath);
                this.pool.get(tmpClassName).detach();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Concrete Class " + tmpClassName + " generated in the following path " + deployPath));
                }
            }
            catch (NotFoundException e) {
                String s = " Unexpected exception ! ";
                logger.fatal((Object)s, (Throwable)e);
                throw new RuntimeException(s, e);
            }
            catch (CannotCompileException e) {
                String s = " Unexpected exception ! ";
                logger.fatal((Object)s, (Throwable)e);
                throw new RuntimeException(s, e);
            }
            catch (IOException e) {
                String s = "IO Exception!";
                logger.error((Object)s, (Throwable)e);
                if (this.concreteSbbLocalObject != null) {
                    this.concreteSbbLocalObject.defrost();
                }
                return null;
            }
            Class<?> clazz = null;
            try {
                ClassLoader currentClassloader = Thread.currentThread().getContextClassLoader();
                clazz = currentClassloader.loadClass(sbbLocalObjectName + "Impl");
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
            }
            Class<?> clazz2 = clazz;
            return clazz2;
        }
        finally {
            if (this.concreteSbbLocalObject != null) {
                this.concreteSbbLocalObject.defrost();
            }
        }
    }

    protected void createConstructorWithParameter(CtClass[] parameters) {
        CtConstructor constructorWithParameter = new CtConstructor(parameters, this.concreteSbbLocalObject);
        String constructorBody = "{";
        int i = 0;
        while (i < parameters.length) {
            CtField ctField;
            String parameterName = parameters[i].getName();
            parameterName = parameterName.substring(parameterName.lastIndexOf(".") + 1);
            String firstCharLowerCase = parameterName.substring(0, 1).toLowerCase();
            parameterName = firstCharLowerCase.concat(parameterName.substring(1));
            int paramNumber = i + 1;
            if (parameters[i].getName().equals(SbbEntity.class.getName())) {
                constructorBody = String.valueOf(constructorBody) + "super($" + paramNumber + ");";
            } else {
                try {
                    ctField = new CtField(parameters[i], parameterName, this.concreteSbbLocalObject);
                    ctField.setModifiers(2);
                }
                catch (CannotCompileException cce) {
                    cce.printStackTrace();
                    String s = "Cannot compile field!";
                    logger.fatal((Object)s, (Throwable)cce);
                    throw new RuntimeException(s, cce);
                }
                constructorBody = String.valueOf(constructorBody) + parameterName + "=$" + paramNumber + ";";
            }
            try {
                ctField = new CtField(this.pool.get(SbbLocalObjectInterceptor.class.getName()), "sbbLocalObjectInterceptor", this.concreteSbbLocalObject);
                this.concreteSbbLocalObject.addField(ctField);
            }
            catch (Exception cce) {
                String s = "Cannot add field!";
                logger.fatal((Object)s, (Throwable)cce);
                throw new RuntimeException(s, cce);
            }
            constructorBody = String.valueOf(constructorBody) + "this.sbbLocalObjectInterceptor = new " + SbbLocalObjectInterceptor.class.getName() + "( this ) ;";
            ++i;
        }
        constructorBody = String.valueOf(constructorBody) + "}";
        try {
            this.concreteSbbLocalObject.addConstructor(constructorWithParameter);
            constructorWithParameter.setBody(constructorBody);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ConstructorWithParameter created: " + constructorBody));
            }
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("cannot compile constructor! body =  " + constructorBody), (Throwable)e);
            }
            throw new RuntimeException("cannot compile constructor!", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ConstructorWithParameter created: " + constructorBody));
        }
    }

    private void generateEqualsMethod() {
        String methodToAdd = "public boolean equals(Object other) { return this.getClass().equals(other.getClass() ) && this.getSbbEntityId().equals(((" + SbbLocalObjectConcrete.class.getName() + ")other).getSbbEntityId());" + "}";
        try {
            CtMethod methodTest = CtNewMethod.make((String)methodToAdd, (CtClass)this.concreteSbbLocalObject);
            this.concreteSbbLocalObject.addMethod(methodTest);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
            logger.error((Object)"cannot generate method ", (Throwable)cce);
            throw new RuntimeException("error generating method ", cce);
        }
    }

    private void generateGetSbbEntityId() {
        String methodToAdd = "public String getSbbEntityId() { return this.getSbbEntity().getSbbEntityId(); }";
        try {
            CtMethod methodTest = CtNewMethod.make((String)methodToAdd, (CtClass)this.concreteSbbLocalObject);
            this.concreteSbbLocalObject.addMethod(methodTest);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
            logger.error((Object)"cannot generate method ", (Throwable)cce);
            throw new RuntimeException("error generating method ", cce);
        }
    }

    private void generateConcreteMethods(Map interfaceMethods, String sbbAbstractClassName) {
        if (interfaceMethods == null) {
            return;
        }
        for (CtMethod interfaceMethod : interfaceMethods.values()) {
            int argNumber;
            if (interfaceMethod == null) {
                return;
            }
            if (interfaceMethod.getName().equals("isIdentical") || interfaceMethod.getName().equals("getSbbPriority") || interfaceMethod.getName().equals("remove") || interfaceMethod.getName().equals("setSbbPriority")) continue;
            String methodToAdd = "public ";
            boolean hasReturn = false;
            CtClass returnType = null;
            try {
                returnType = interfaceMethod.getReturnType();
                if (returnType.equals(CtClass.voidType)) {
                    methodToAdd = String.valueOf(methodToAdd) + "void ";
                } else {
                    methodToAdd = methodToAdd.concat(String.valueOf(returnType.getName()) + " ");
                    hasReturn = true;
                }
            }
            catch (NotFoundException nfe) {
                nfe.printStackTrace();
                methodToAdd = String.valueOf(methodToAdd) + "void ";
            }
            methodToAdd = String.valueOf(methodToAdd) + interfaceMethod.getName() + "(";
            CtClass[] parameterTypes = null;
            try {
                parameterTypes = interfaceMethod.getParameterTypes();
                argNumber = 0;
                while (argNumber < parameterTypes.length) {
                    methodToAdd = methodToAdd.concat(String.valueOf(parameterTypes[argNumber].getName()) + " arg_" + argNumber);
                    if (argNumber + 1 < parameterTypes.length) {
                        methodToAdd = String.valueOf(methodToAdd) + ",";
                    }
                    ++argNumber;
                }
            }
            catch (NotFoundException nfe) {
                nfe.printStackTrace();
                throw new RuntimeException("unexpected Exception ! ", nfe);
            }
            methodToAdd = String.valueOf(methodToAdd) + ") { ";
            methodToAdd = String.valueOf(methodToAdd) + "getSbbEntity().checkReEntrant();";
            methodToAdd = String.valueOf(methodToAdd) + Object.class.getName() + " concrete = " + " getSbbEntity().getSbbObject().getSbbConcrete();";
            methodToAdd = String.valueOf(methodToAdd) + "Object[] args = new Object [" + parameterTypes.length + "];";
            methodToAdd = String.valueOf(methodToAdd) + "Class[] types = new Class [" + parameterTypes.length + "];";
            if (parameterTypes != null && parameterTypes.length > 0) {
                CtClass ptype;
                argNumber = 0;
                while (argNumber < parameterTypes.length) {
                    methodToAdd = String.valueOf(methodToAdd) + "args[" + argNumber + "]  = ";
                    if (parameterTypes[argNumber].isPrimitive()) {
                        ptype = parameterTypes[argNumber];
                        if (ptype.equals(CtClass.intType)) {
                            methodToAdd = String.valueOf(methodToAdd) + "new Integer (arg_" + argNumber + ");";
                        } else if (ptype.equals(CtClass.booleanType)) {
                            methodToAdd = String.valueOf(methodToAdd) + "new Boolean (arg_" + argNumber + ");";
                        } else if (ptype.equals(CtClass.longType)) {
                            methodToAdd = String.valueOf(methodToAdd) + "new Long (arg_" + argNumber + ");";
                        } else if (ptype.equals(CtClass.shortType)) {
                            methodToAdd = String.valueOf(methodToAdd) + "new Short (arg_" + argNumber + ");";
                        } else if (ptype.equals(CtClass.floatType)) {
                            methodToAdd = String.valueOf(methodToAdd) + "new Float (arg_" + argNumber + ");";
                        } else if (ptype.equals(CtClass.doubleType)) {
                            methodToAdd = String.valueOf(methodToAdd) + "new Double (arg_" + argNumber + ");";
                        } else if (ptype.equals(CtClass.charType)) {
                            methodToAdd = String.valueOf(methodToAdd) + "new Character(arg_" + argNumber + ");";
                        }
                    } else {
                        methodToAdd = String.valueOf(methodToAdd) + "arg_" + argNumber + ";";
                    }
                    ++argNumber;
                }
                int i = 0;
                while (i < parameterTypes.length) {
                    methodToAdd = String.valueOf(methodToAdd) + "types[" + i + "] = ";
                    if (parameterTypes[i].isPrimitive()) {
                        ptype = parameterTypes[i];
                        if (ptype.equals(CtClass.intType)) {
                            methodToAdd = String.valueOf(methodToAdd) + "Integer.TYPE;";
                        } else if (ptype.equals(CtClass.booleanType)) {
                            methodToAdd = String.valueOf(methodToAdd) + "Boolean.TYPE;";
                        } else if (ptype.equals(CtClass.longType)) {
                            methodToAdd = String.valueOf(methodToAdd) + "Long.TYPE;";
                        } else if (ptype.equals(CtClass.shortType)) {
                            methodToAdd = String.valueOf(methodToAdd) + "Short.TYPE;";
                        } else if (ptype.equals(CtClass.floatType)) {
                            methodToAdd = String.valueOf(methodToAdd) + "Float.TYPE;";
                        } else if (ptype.equals(CtClass.doubleType)) {
                            methodToAdd = String.valueOf(methodToAdd) + "Double.TYPE;";
                        } else if (ptype.equals(CtClass.charType)) {
                            methodToAdd = String.valueOf(methodToAdd) + "Character.TYPE;";
                        }
                    } else {
                        methodToAdd = String.valueOf(methodToAdd) + SleeContainerUtils.class.getName() + ".getCurrentThreadClassLoader().loadClass(\"" + parameterTypes[i].getName() + "\"); ";
                    }
                    ++i;
                }
            }
            if (hasReturn) {
                methodToAdd = String.valueOf(methodToAdd) + " return  (" + returnType.getName() + ")";
            }
            methodToAdd = returnType.isPrimitive() ? String.valueOf(methodToAdd) + "sbbLocalObjectInterceptor.invokeAndReturn" + returnType.getSimpleName() + "(concrete," + "\"" + interfaceMethod.getName() + "\"" + ", args, types); " : String.valueOf(methodToAdd) + "sbbLocalObjectInterceptor.invokeAndReturnObject(concrete,\"" + interfaceMethod.getName() + "\"" + ", args, types );";
            methodToAdd = String.valueOf(methodToAdd) + "}";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Method " + methodToAdd + " added"));
            }
            try {
                CtMethod methodTest = CtNewMethod.make((String)methodToAdd, (CtClass)this.concreteSbbLocalObject);
                this.concreteSbbLocalObject.addMethod(methodTest);
            }
            catch (CannotCompileException cce) {
                cce.printStackTrace();
                throw new RuntimeException("error generating method ", cce);
            }
        }
    }
}

