/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment;

import java.lang.reflect.Method;
import java.util.HashSet;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javax.slee.management.DeploymentException;
import javax.slee.usage.SampleStatistics;
import org.jboss.logging.Logger;
import org.jboss.util.Strings;
import org.mobicents.slee.container.component.DeployableUnitIDImpl;
import org.mobicents.slee.container.component.InstalledUsageParameterSet;
import org.mobicents.slee.container.component.MobicentsSbbDescriptor;
import org.mobicents.slee.container.component.SbbIDImpl;
import org.mobicents.slee.container.component.ServiceIDImpl;
import org.mobicents.slee.container.deployment.ConcreteClassGeneratorUtils;
import org.mobicents.slee.container.management.jmx.SampleStatisticsImpl;
import org.mobicents.slee.container.management.jmx.SbbUsageMBeanImpl;

public class ConcreteUsageParameterClassGenerator {
    private static Logger logger = Logger.getLogger(ConcreteUsageParameterClassGenerator.class);
    private ClassPool classPool;
    private static final String NAME_FIELD = "name";
    public static final String SET_NAME = "setName";
    public static final String GET_NAME = "getName";
    private static final String USAGE_PARAMETER_MBEAN_FIELD = "sbbUsageParameterMBean";
    public static final String SET_USAGE_PARAMETER_MBEAN = "setSbbUsageMBean";
    public static final String GET_USAGE_PARAMETER_MBEAN = "getSbbUsageMBean";
    private HashSet generatedFields;

    public ConcreteUsageParameterClassGenerator(MobicentsSbbDescriptor sbbDescriptor) {
        this.classPool = ((DeployableUnitIDImpl)sbbDescriptor.getDeployableUnit()).getDUDeployer().getClassPool();
        this.generatedFields = new HashSet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkUsageParameterInterface(MobicentsSbbDescriptor sbbDescriptor) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(sbbDescriptor.getUsageParametersInterface());
            if (!clazz.isInterface()) {
                return false;
            }
            Method[] methods = clazz.getMethods();
            HashSet<String> incrementMethods = new HashSet<String>();
            HashSet<String> sampleMethods = new HashSet<String>();
            int i = 0;
            while (true) {
                String p;
                if (i >= methods.length) {
                    return true;
                }
                Method method = methods[i];
                if (!method.getName().startsWith("increment") && !method.getName().startsWith("sample")) {
                    logger.debug((Object)("method name " + method.getName() + " is invalid! "));
                    return false;
                }
                if (method.getExceptionTypes() != null && method.getExceptionTypes().length != 0) {
                    logger.debug((Object)("Signature of usage parameter is invalid --  should not throw an exception : " + method.getName()));
                    return false;
                }
                if (method.getParameterTypes() == null || method.getParameterTypes().length > 1) {
                    logger.error((Object)("Signature of usage parameter is invalid -- should have a single long parameter type " + method.getName()));
                    return false;
                }
                Class<?>[] paramTypes = method.getParameterTypes();
                if (paramTypes[0] != Long.TYPE) {
                    logger.error((Object)"the parameter type should be long! ");
                    return false;
                }
                if (method.getName().startsWith("increment")) {
                    p = method.getName().substring("increment".length());
                    if (sampleMethods.contains(p)) {
                        logger.error((Object)("already saw method in sample method set " + p));
                        return false;
                    }
                    if (!Character.isUpperCase(p.charAt(0))) {
                        logger.error((Object)("First character of usage parameter name must be upper case : " + p));
                        return false;
                    }
                    incrementMethods.add(p);
                }
                if (method.getName().startsWith("sample")) {
                    p = method.getName().substring("sample".length());
                    if (incrementMethods.contains(p)) {
                        logger.error((Object)("usage parameter is already an increment parameter " + method.getName()));
                        return false;
                    }
                    if (!Character.isUpperCase(p.charAt(0))) {
                        logger.error((Object)("First character of usage parameter name must be upper case : " + p));
                        return false;
                    }
                    sampleMethods.add(p);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public Class generateConcreteUsageParameterClass(MobicentsSbbDescriptor sbbDescriptor) throws Exception {
        String usageParamInterfaceName = sbbDescriptor.getUsageParametersInterface();
        if (usageParamInterfaceName == null) {
            return null;
        }
        String concreteClassName = String.valueOf(usageParamInterfaceName) + "Impl";
        CtClass usageParamInterface = this.classPool.get(usageParamInterfaceName);
        CtClass implClassInterface = this.classPool.get(InstalledUsageParameterSet.class.getName());
        CtMethod[] methods = usageParamInterface.getMethods();
        CtClass ctClass = null;
        try {
            ctClass = this.classPool.get(concreteClassName).getClassPool().makeClass(concreteClassName);
        }
        catch (NotFoundException nfe) {
            ctClass = this.classPool.makeClass(concreteClassName);
        }
        try {
            Class<?> retval;
            this.generateFields(ctClass, new CtClass[]{this.classPool.get(ServiceIDImpl.class.getName()), this.classPool.get(SbbIDImpl.class.getName())});
            ConcreteClassGeneratorUtils.createInterfaceLinks(ctClass, new CtClass[]{usageParamInterface, implClassInterface});
            CtField ctField = new CtField(this.classPool.get(SbbUsageMBeanImpl.class.getName()), USAGE_PARAMETER_MBEAN_FIELD, ctClass);
            ctField.setModifiers(2);
            ctClass.addField(ctField);
            this.generateSbbUsageMBeanSetter(ctClass);
            this.generateSbbUsageMBeanGetter(ctClass);
            this.generateSbbIDGetter(ctClass);
            this.generateServiceIDGetter(ctClass);
            ctField = new CtField(this.classPool.get(String.class.getName()), NAME_FIELD, ctClass);
            ctField.setModifiers(2);
            ctClass.addField(ctField);
            this.generateNameSetter(ctClass);
            this.generateNameGetter(ctClass);
            int i = 0;
            while (i < methods.length) {
                this.generateConcreteMethod(ctClass, methods[i]);
                ++i;
            }
            this.generateResetMethod(ctClass);
            this.createConstructor(ctClass, new CtClass[]{this.classPool.get(ServiceIDImpl.class.getName()), this.classPool.get(SbbIDImpl.class.getName())});
            this.createDefaultConstructor(ctClass);
            String sbbDeploymentPathStr = sbbDescriptor.getDeploymentPath();
            this.classPool.get(concreteClassName).writeFile(sbbDeploymentPathStr);
            this.classPool.get(concreteClassName).detach();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("UsageParameterGenerator Writing file " + concreteClassName));
            }
            Class<?> clazz = retval = Thread.currentThread().getContextClassLoader().loadClass(concreteClassName);
            return clazz;
        }
        finally {
            ctClass.defrost();
        }
    }

    private void generateSbbUsageMBeanSetter(CtClass concreteClass) throws Exception {
        String body = "public void setSbbUsageMBean ( " + SbbUsageMBeanImpl.class.getName() + " usageMbean ) { this." + USAGE_PARAMETER_MBEAN_FIELD + "= usageMbean; }";
        CtMethod ctMethod = CtNewMethod.make((String)body, (CtClass)concreteClass);
        concreteClass.addMethod(ctMethod);
    }

    private void generateSbbUsageMBeanGetter(CtClass concreteClass) throws Exception {
        String body = "public " + SbbUsageMBeanImpl.class.getName() + " " + GET_USAGE_PARAMETER_MBEAN + "() {";
        body = String.valueOf(body) + "return sbbUsageParameterMBean; }";
        CtMethod ctMethod = CtNewMethod.make((String)body, (CtClass)concreteClass);
        concreteClass.addMethod(ctMethod);
    }

    private void generateNameGetter(CtClass concreteClass) throws Exception {
        String body = "public " + String.class.getName() + " getName() { return " + NAME_FIELD + "; } ";
        CtMethod ctMethod = CtNewMethod.make((String)body, (CtClass)concreteClass);
        concreteClass.addMethod(ctMethod);
    }

    private void generateNameSetter(CtClass concreteClass) throws Exception {
        String body = "public void setName( " + String.class.getName() + " n) { " + NAME_FIELD + " = n   ; } ";
        CtMethod ctMethod = CtNewMethod.make((String)body, (CtClass)concreteClass);
        concreteClass.addMethod(ctMethod);
    }

    private void generateServiceIDGetter(CtClass concreteClass) throws Exception {
        String body = "public " + ServiceIDImpl.class.getName() + " getServiceID() { return this.serviceIDImpl; }";
        CtMethod ctMethod = CtNewMethod.make((String)body, (CtClass)concreteClass);
        concreteClass.addMethod(ctMethod);
    }

    private void generateSbbIDGetter(CtClass concreteClass) throws Exception {
        String body = "public " + SbbIDImpl.class.getName() + " getSbbID() { return this.sbbIDImpl; }";
        CtMethod ctMethod = CtNewMethod.make((String)body, (CtClass)concreteClass);
        concreteClass.addMethod(ctMethod);
    }

    private void createDefaultConstructor(CtClass concreteClass) {
        CtConstructor defaultConstructor = new CtConstructor(null, concreteClass);
        String constructorBody = "{ this.reset(); }";
        try {
            defaultConstructor.setBody(constructorBody);
            concreteClass.addConstructor(defaultConstructor);
            logger.debug((Object)"DefaultConstructor created");
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
        }
    }

    private void generateFields(CtClass concreteClass, CtClass[] parameters) {
        int i = 0;
        while (i < parameters.length) {
            String parameterName = ConcreteUsageParameterClassGenerator.paramNameFromClassName(parameters[i]);
            try {
                CtField ctField = new CtField(parameters[i], parameterName, concreteClass);
                ctField.setModifiers(2);
                concreteClass.addField(ctField);
            }
            catch (CannotCompileException cce) {
                cce.printStackTrace();
            }
            ++i;
        }
    }

    private void createConstructor(CtClass concreteClass, CtClass[] parameters) throws Exception {
        CtConstructor ctCons = new CtConstructor(parameters, concreteClass);
        String constructorBody = "{";
        constructorBody = String.valueOf(constructorBody) + " this.reset(); ";
        int i = 0;
        while (i < parameters.length) {
            String parameterName = ConcreteUsageParameterClassGenerator.paramNameFromClassName(parameters[i]);
            int paramNumber = i + 1;
            constructorBody = String.valueOf(constructorBody) + parameterName + "=$" + paramNumber + ";";
            ++i;
        }
        constructorBody = String.valueOf(constructorBody) + "}";
        ctCons.setBody(constructorBody);
        concreteClass.addConstructor(ctCons);
    }

    private static String paramNameFromClassName(CtClass parameter) {
        String parameterName = parameter.getName();
        if ((parameterName = parameterName.substring(parameterName.lastIndexOf(".") + 1)).indexOf(91) != -1) {
            parameterName = parameterName.substring(0, parameterName.indexOf(91));
        }
        String firstCharLowerCase = parameterName.substring(0, 1).toLowerCase();
        parameterName = firstCharLowerCase.concat(parameterName.substring(1));
        return parameterName;
    }

    private void generateResetMethod(CtClass ctClass) throws Exception {
        String body = "public synchronized void reset() {";
        for (String generatedField : this.generatedFields) {
            body = generatedField.endsWith("Max") ? String.valueOf(body) + generatedField + " = Long.MIN_VALUE  ; " : (generatedField.endsWith("Min") ? String.valueOf(body) + generatedField + " = Long.MAX_VALUE ; " : String.valueOf(body) + generatedField + " = 0; ");
        }
        body = String.valueOf(body) + "}";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("generateResetMethod(): body = " + body));
        }
        CtMethod newMethod = CtNewMethod.make((String)body, (CtClass)ctClass);
        ctClass.addMethod(newMethod);
    }

    private void generateSampleMethod(CtClass ctClass, String sampleParameterName) throws Exception {
        String body = "public " + SampleStatisticsImpl.class.getName() + " " + sampleParameterName + "SampleStatistics ( ) { ";
        body = String.valueOf(body) + " return new " + SampleStatisticsImpl.class.getName() + "(" + sampleParameterName + "Mean," + sampleParameterName + "Max , " + sampleParameterName + "Min, " + sampleParameterName + "Count ); " + " } ";
        CtMethod newMethod = CtNewMethod.make((String)body, (CtClass)ctClass);
        ctClass.addMethod(newMethod);
    }

    private void generateConcreteMethod(CtClass ctClass, CtMethod method) throws Exception {
        CtMethod newmethod;
        CtField ctField;
        String firstCharLowerCase;
        String methodName = method.getName();
        String paramName = null;
        if (methodName.startsWith("increment")) {
            paramName = methodName.substring("increment".length());
            firstCharLowerCase = paramName.substring(0, 1).toLowerCase();
            paramName = firstCharLowerCase.concat(paramName.substring(1));
            ctField = new CtField(CtClass.longType, String.valueOf(paramName) + "Value", ctClass);
            ctField.setModifiers(2);
            ctClass.addField(ctField);
            this.generatedFields.add(String.valueOf(paramName) + "Value");
            ctField = new CtField(CtClass.longType, String.valueOf(paramName) + "Sum", ctClass);
            ctField.setModifiers(2);
            ctClass.addField(ctField);
            this.generatedFields.add(String.valueOf(paramName) + "Sum");
            ctField = new CtField(CtClass.longType, String.valueOf(paramName) + "Count", ctClass);
            ctField.setModifiers(2);
            ctClass.addField(ctField);
            this.generatedFields.add(String.valueOf(paramName) + "Count");
        } else if (methodName.startsWith("sample")) {
            paramName = methodName.substring("sample".length());
            firstCharLowerCase = paramName.substring(0, 1).toLowerCase();
            paramName = firstCharLowerCase.concat(paramName.substring(1));
            ctField = new CtField(CtClass.longType, String.valueOf(paramName) + "Value", ctClass);
            ctField.setModifiers(2);
            ctClass.addField(ctField);
            this.generatedFields.add(String.valueOf(paramName) + "Value");
            ctField = new CtField(CtClass.doubleType, String.valueOf(paramName) + "Mean", ctClass);
            ctField.setModifiers(2);
            ctClass.addField(ctField);
            this.generatedFields.add(String.valueOf(paramName) + "Mean");
            ctField = new CtField(CtClass.longType, String.valueOf(paramName) + "Min", ctClass);
            ctField.setModifiers(2);
            ctClass.addField(ctField);
            this.generatedFields.add(String.valueOf(paramName) + "Min");
            ctField = new CtField(CtClass.longType, String.valueOf(paramName) + "Max", ctClass);
            ctField.setModifiers(2);
            ctClass.addField(ctField);
            this.generatedFields.add(String.valueOf(paramName) + "Max");
            ctField = new CtField(CtClass.longType, String.valueOf(paramName) + "Count", ctClass);
            ctField.setModifiers(2);
            ctClass.addField(ctField);
            this.generatedFields.add(String.valueOf(paramName) + "Count");
            ctField = new CtField(CtClass.doubleType, String.valueOf(paramName) + "Sum", ctClass);
            ctField.setModifiers(2);
            ctClass.addField(ctField);
            this.generatedFields.add(String.valueOf(paramName) + "Sum");
        } else {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("generateConcreteMethod(): USAGEPARAM variable is " + paramName));
        }
        if (Strings.isJavaKeyword((String)paramName)) {
            throw new DeploymentException("Usage parameter concrete class generator is a Java keyword!");
        }
        if (!Strings.isValidJavaIdentifier((String)paramName)) {
            throw new DeploymentException("Usage parameter concrete class generator, invalid Java identifier!");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Generating usage method = " + methodName));
        }
        String body = "";
        String getterBody = "";
        if (methodName.startsWith("increment")) {
            body = String.valueOf(body) + "public synchronized void " + methodName + "( long longValue ) { ";
            body = String.valueOf(body) + "this." + paramName + "Count += \tlongValue;";
            body = String.valueOf(body) + "this." + paramName + "Sum += longValue;";
            body = String.valueOf(body) + "this." + paramName + "Value = longValue;";
            body = String.valueOf(body) + "this.sbbUsageParameterMBean.sendUsageNotification(this." + paramName + "Sum, " + "this." + paramName + "Count, " + "this." + NAME_FIELD + "," + "\"" + paramName + "\"" + "," + Boolean.TRUE.toString() + ");";
            body = String.valueOf(body) + "}";
            getterBody = String.valueOf(getterBody) + "public synchronized long get" + methodName.substring("increment".length()) + "( boolean reset) { ";
            getterBody = String.valueOf(getterBody) + "long tempCount = this." + paramName + "Count;";
            getterBody = String.valueOf(getterBody) + "if (reset == true) {this." + paramName + "Count=0;";
            getterBody = String.valueOf(getterBody) + "this." + paramName + "Sum = 0;";
            getterBody = String.valueOf(getterBody) + "this." + paramName + "Value = 0;}";
            getterBody = String.valueOf(getterBody) + "return tempCount;";
            getterBody = String.valueOf(getterBody) + "}";
            logger.debug((Object)("body = " + getterBody));
            newmethod = CtNewMethod.make((String)getterBody, (CtClass)ctClass);
            ctClass.addMethod(newmethod);
        } else if (methodName.startsWith("sample")) {
            body = String.valueOf(body) + "public synchronized void " + methodName + "( long longValue ) { ";
            body = String.valueOf(body) + "this." + paramName + "Sum += longValue;";
            body = String.valueOf(body) + "this." + paramName + "Mean = this." + paramName + "Sum / (this." + paramName + "Count+1);";
            body = String.valueOf(body) + " if ( this." + paramName + "Max <  longValue ) this." + paramName + "Max = longValue;";
            body = String.valueOf(body) + " if ( this." + paramName + "Min >  longValue ) this." + paramName + "Min = longValue;";
            body = String.valueOf(body) + "this." + paramName + "Count++;";
            body = String.valueOf(body) + "this.sbbUsageParameterMBean.sendUsageNotification( longValue, this." + paramName + "Count, " + "this." + NAME_FIELD + "," + "\"" + paramName + "\"" + "," + Boolean.FALSE.toString() + ");";
            body = String.valueOf(body) + "}";
            getterBody = String.valueOf(getterBody) + "public synchronized " + SampleStatistics.class.getName() + " get" + methodName.substring("sample".length()) + "( boolean reset) { ";
            getterBody = String.valueOf(getterBody) + SampleStatistics.class.getName() + " tempValue" + "= new " + SampleStatisticsImpl.class.getName() + "(this." + paramName + "Mean, " + "this." + paramName + "Min, " + "this." + paramName + "Max, " + "this." + paramName + "Count);";
            getterBody = String.valueOf(getterBody) + "if (reset == true) {this." + paramName + "Count=0;";
            getterBody = String.valueOf(getterBody) + "this." + paramName + "Mean = 0;";
            getterBody = String.valueOf(getterBody) + "this." + paramName + "Value = 0;";
            getterBody = String.valueOf(getterBody) + "this." + paramName + "Min = Long.MAX_VALUE ;";
            getterBody = String.valueOf(getterBody) + "this." + paramName + "Max = Long.MIN_VALUE ;}";
            getterBody = String.valueOf(getterBody) + "return tempValue;";
            getterBody = String.valueOf(getterBody) + "}";
            logger.debug((Object)("body = " + getterBody));
            newmethod = CtNewMethod.make((String)getterBody, (CtClass)ctClass);
            ctClass.addMethod(newmethod);
        } else {
            return;
        }
        logger.debug((Object)("body = " + body));
        newmethod = CtNewMethod.make((String)body, (CtClass)ctClass);
        ctClass.addMethod(newmethod);
        if (methodName.startsWith("sample")) {
            this.generateSampleMethod(ctClass, paramName);
        }
    }
}

