/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment;

import javax.slee.EventTypeID;
import javax.slee.management.DeploymentException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.EventTypeIDImpl;
import org.mobicents.slee.container.deployment.RaTypeVerifier;
import org.mobicents.slee.resource.ResourceAdaptorType;
import org.mobicents.slee.resource.ResourceAdaptorTypeDescriptorImpl;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;

public class RaTypeDeployer {
    private static Logger logger = Logger.getLogger(RaTypeDeployer.class);
    private ResourceAdaptorTypeDescriptorImpl raTypeDescriptor = null;
    private SleeContainer container = null;
    private RaTypeVerifier verifier = null;

    public RaTypeDeployer(ResourceAdaptorTypeDescriptorImpl raTypeDescriptor, SleeContainer container) {
        this.raTypeDescriptor = raTypeDescriptor;
        this.container = container;
    }

    public void deployRaType() throws DeploymentException {
        this.verifier = new RaTypeVerifier(this.raTypeDescriptor);
        boolean verified = false;
        try {
            verified = this.verifier.verifyRaType();
        }
        catch (Exception e) {
            logger.error((Object)"=================================");
            e.printStackTrace();
            logger.error((Object)"=================================");
            throw new DeploymentException("Failed to verify RaType[" + this.raTypeDescriptor.getID() + "] due to: " + e.getMessage());
        }
        if (!verified) {
            throw new DeploymentException("Failed to verify RaType[" + this.raTypeDescriptor.getID() + "]");
        }
        ComponentKey[] eventTypeRefEntries = this.raTypeDescriptor.getEventTypeRefEntries();
        EventTypeID[] eventTypeIDs = new EventTypeIDImpl[eventTypeRefEntries.length];
        int i = 0;
        while (i < eventTypeRefEntries.length) {
            EventTypeIDImpl eventTypeId = this.container.getEventType(eventTypeRefEntries[i]);
            if (eventTypeId == null) {
                throw new DeploymentException("Could not resolve event type ref" + eventTypeRefEntries[i]);
            }
            eventTypeIDs[i] = eventTypeId;
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The event type array has " + eventTypeIDs.length));
        }
        this.raTypeDescriptor.setEventTypes(eventTypeIDs);
        ResourceAdaptorType raType = new ResourceAdaptorType(this.raTypeDescriptor);
        ResourceAdaptorTypeIDImpl key = raType.getResourceAdaptorTypeID();
        if (logger.isDebugEnabled()) {
            logger.info((Object)("Inserting RAT key: " + key + " RAType: " + raType));
        }
        this.container.addResourceAdaptorType(key, raType);
    }
}

