/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment;

import java.io.IOException;
import java.io.InputStream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.DeployableUnitIDImpl;
import org.mobicents.slee.resource.ActivityTypeEntry;
import org.mobicents.slee.resource.ResourceAdaptorTypeClassEntry;
import org.mobicents.slee.resource.ResourceAdaptorTypeDescriptorImpl;

public class RaTypeVerifier {
    private static String DEPLOYMENT_PATH = SleeContainer.getDeployPath();
    private ResourceAdaptorTypeDescriptorImpl raTypeDescriptor = null;
    private ClassPool pool = null;
    private static Logger logger = null;
    private String errorString;
    private String acifClassName = null;

    static {
        logger = Logger.getLogger(RaTypeVerifier.class);
    }

    public RaTypeVerifier(ResourceAdaptorTypeDescriptorImpl raTypeDescriptor) {
        this.raTypeDescriptor = raTypeDescriptor;
        this.pool = ((DeployableUnitIDImpl)raTypeDescriptor.getDeployableUnit()).getDUDeployer().getClassPool();
        this.acifClassName = raTypeDescriptor.getRaTypeClassEntry().getAcifInterfaceEntry().getInterfaceName();
    }

    public boolean verifyRaType() {
        boolean failed = false;
        if (!this.verifyActivityContextInterfaceFactory()) {
            failed = true;
            logger.error((Object)"Failed to verify RaType activity context factory interface, possibly activities defined in interface class and in xml descriptor do not match!!!");
        }
        return !failed;
    }

    private boolean verifyActivityContextInterfaceFactory() {
        String classRsrcName;
        logger.info((Object)("RATYPE [" + this.raTypeDescriptor.getID() + "] - Verifying ACIF [" + this.acifClassName + "]"));
        if (this.acifClassName == null) {
            return true;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream acifClassIS = cl.getResourceAsStream(classRsrcName = String.valueOf(this.acifClassName.replace('.', '/')) + ".class");
        if (acifClassIS == null) {
            logger.error((Object)("Cannot find class file for specified entry in ra-type xml - activity-context-interface-factory-interface-name -> " + classRsrcName));
            return false;
        }
        CtClass ctClass = null;
        try {
            ctClass = this.pool.get(this.acifClassName).getClassPool().makeClass(acifClassIS);
        }
        catch (NotFoundException e) {
            ctClass = this.pool.makeClass(this.acifClassName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return false;
        }
        CtMethod[] acifMethods = ctClass.getDeclaredMethods();
        ResourceAdaptorTypeClassEntry entry = this.raTypeDescriptor.getRaTypeClassEntry();
        ActivityTypeEntry[] activitiesEntries = entry.getActivityTypeEntries();
        boolean[] found = new boolean[activitiesEntries.length];
        boolean passed = true;
        int counter = 0;
        while (counter < activitiesEntries.length) {
            ActivityTypeEntry e = activitiesEntries[counter];
            String activityName = e.getActivityTypeName();
            int i = 0;
            while (i < acifMethods.length) {
                CtMethod m = acifMethods[i];
                if (m != null) {
                    logger.debug((Object)(" [" + this.raTypeDescriptor.getID() + "]  Checking method [" + m.getName() + "]"));
                    if (m.getName().equals("getActivityContextInterface")) {
                        try {
                            CtClass[] params = m.getParameterTypes();
                            if (params.length > 1 || params.length == 0) {
                                passed = false;
                                logger.error((Object)(" [" + this.raTypeDescriptor.getID() + "]  Method [" + m.getName() + "] has too many/few[" + params.length + "] params!!!"));
                            } else {
                                logger.debug((Object)(" [" + this.raTypeDescriptor.getID() + "] Checking param - name[" + params[0].getName() + "] against [" + activityName + "]"));
                                if (activityName.equals(params[0].getName())) {
                                    found[counter] = true;
                                    logger.info((Object)(" [" + this.raTypeDescriptor.getID() + "] activity - name[" + params[0].getName() + "]"));
                                    acifMethods[i] = null;
                                }
                            }
                        }
                        catch (NotFoundException e1) {
                            passed = false;
                            logger.error((Object)(" [" + this.raTypeDescriptor.getID() + "]  getActivityContextInterface method with no params!!!"));
                            e1.printStackTrace();
                        }
                    } else {
                        acifMethods[i] = null;
                    }
                }
                ++i;
            }
            ++counter;
        }
        if (!passed) {
            return passed;
        }
        boolean[] blArray = found;
        int n = 0;
        int n2 = blArray.length;
        while (n < n2) {
            boolean b = blArray[n];
            if (!b) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

