/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.interceptors;

import java.lang.reflect.Method;
import javax.slee.ActivityContextInterface;
import javax.slee.SLEEException;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.MobicentsSbbDescriptor;
import org.mobicents.slee.container.deployment.interceptors.FireEventInterceptor;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextIDInterface;
import org.mobicents.slee.runtime.DeferredEvent;
import org.mobicents.slee.runtime.SbbEntity;
import org.mobicents.slee.runtime.SbbObjectState;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class DefaultFireEventInterceptor
implements FireEventInterceptor {
    SbbEntity sbbEntity = null;
    Logger logger = Logger.getLogger(DefaultFireEventInterceptor.class);

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args[2] != null) {
            throw new SLEEException("Address support when firing events is not implemented!");
        }
        if (this.sbbEntity == null || this.sbbEntity.getSbbObject() == null || !this.sbbEntity.getSbbObject().getState().equals(SbbObjectState.READY)) {
            throw new IllegalStateException("SbbObject not assigned!");
        }
        if (args[0] == null) {
            throw new NullPointerException("JAIN SLEE (TM) specs - Section 8.4.1: The event ... cannot be null. If ... argument is null, the fire event method throws a java.lang.NullPointerException.");
        }
        if (args[1] == null) {
            throw new NullPointerException("JAIN SLEE (TM) specs - Section 8.4.1: The activity ... cannot be null. If ... argument is null, the fire event method throws a java.lang.NullPointerException.");
        }
        ActivityContextInterface activityContextInterface = (ActivityContextInterface)args[1];
        ActivityContext ac = ((ActivityContextIDInterface)activityContextInterface).retrieveActivityContext();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("invoke(): " + ((ActivityContextIDInterface)activityContextInterface).retrieveActivityContextID() + " ACTIVITY: " + activityContextInterface.getActivity()));
            this.logger.debug((Object)("invoke(): ACTIVITY CONTEXT IS IN STATE: " + ac.getState() + " for activity: " + ac.getActivity() + " ac_id=" + ac.getActivityContextId()));
            this.logger.debug((Object)("invoke(): FIRED EVENT ON ACTIVITY CONTEXT: " + ((ActivityContextIDInterface)activityContextInterface).retrieveActivityContext()));
        }
        if (ac.isEnding() || ac.isInvalid()) {
            throw new IllegalStateException("activity is ending/ended!");
        }
        SleeTransactionManager tm = SleeContainer.getTransactionManager();
        tm.mandateTransaction();
        String eventTypeName = method.getName().substring("fire".length());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("invoke(): EventType Name " + eventTypeName));
        }
        MobicentsSbbDescriptor mobicentsSbbDescriptor = this.sbbEntity.getSbbDescriptor();
        SleeContainer sleeContainer = this.sbbEntity.getServiceContainer();
        ComponentKey eventKey = mobicentsSbbDescriptor.getEventType(eventTypeName).getEventTypeRefKey();
        int eventID = sleeContainer.getEventLookupFacility().getEventID(eventKey);
        Object activity = sleeContainer.getActivityContextFactory().getActivityFromKey(((ActivityContextIDInterface)activityContextInterface).retrieveActivityContextID());
        DeferredEvent deferredEvent = new DeferredEvent(sleeContainer, eventID, args[0], activity, null);
        tm.addAfterCommitAction(deferredEvent);
        return null;
    }

    public SbbEntity getSbbEntity() {
        return this.sbbEntity;
    }

    public void setSbbEntity(SbbEntity sbbEntity) {
        this.sbbEntity = sbbEntity;
    }
}

