/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.deployment.jboss;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.DeploymentMBean;
import javax.slee.management.ResourceManagementMBean;
import javax.slee.management.ServiceManagementMBean;
import javax.slee.resource.ResourceAdaptorDescriptor;
import javax.slee.resource.ResourceAdaptorID;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.ServiceControllerMBean;
import org.mobicents.slee.container.deployment.jboss.SleeDeployerMBean;
import org.mobicents.slee.container.management.jmx.SleeManagementMBeanImplMBean;

public class SleeDeployer
extends SubDeployerSupport
implements SleeDeployerMBean {
    private ServiceControllerMBean serviceController;
    private DeploymentMBean sleeDeploymentMBean;
    private ResourceManagementMBean resourceManagementMBean;
    private boolean validateDTDs;
    private HashMap deployments = new HashMap();
    private ObjectName sleeManagementMBeanName;
    private SleeManagementMBeanImplMBean sleeManagementMBean;
    private ServiceManagementMBean serviceManagementMBean;

    public Iterator getDeployedApplications() {
        return this.deployments.values().iterator();
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? new ObjectName("slee:service=SleeDeployer,platform=jboss") : name;
    }

    protected void startService() throws Exception {
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)this.server);
        this.sleeManagementMBean = (SleeManagementMBeanImplMBean)MBeanProxyExt.create(SleeManagementMBeanImplMBean.class, (ObjectName)this.sleeManagementMBeanName, (MBeanServer)this.server);
        this.sleeDeploymentMBean = (DeploymentMBean)MBeanProxyExt.create(DeploymentMBean.class, (ObjectName)this.sleeManagementMBean.getDeploymentMBean(), (MBeanServer)this.server);
        this.resourceManagementMBean = (ResourceManagementMBean)MBeanProxyExt.create(ResourceManagementMBean.class, (ObjectName)this.sleeManagementMBean.getResourceManagementMBean(), (MBeanServer)this.server);
        this.serviceManagementMBean = (ServiceManagementMBean)MBeanProxyExt.create(ServiceManagementMBean.class, (ObjectName)this.sleeManagementMBean.getServiceManagementMBean(), (MBeanServer)this.server);
        super.startService();
    }

    protected void stopService() throws Exception {
        for (DeploymentInfo di : this.deployments.values()) {
            this.stop(di);
        }
        for (DeploymentInfo di : new ArrayList(this.deployments.values())) {
            this.destroy(di);
        }
        this.deployments.clear();
        super.stopService();
        this.serviceController = null;
    }

    public boolean accepts(DeploymentInfo di) {
        URL dd;
        boolean accepts;
        String urlStr;
        block6: {
            urlStr = di.url.getFile();
            if (!urlStr.endsWith("jar") && !urlStr.endsWith("jar/")) {
                return false;
            }
            accepts = false;
            dd = di.localCl.findResource("META-INF/deployable-unit.xml");
            if (dd != null) break block6;
            return false;
        }
        try {
            String ddStr;
            if (di.localUrl != null) {
                urlStr = di.localUrl.toString();
            }
            if ((ddStr = dd.toString()).indexOf(urlStr) >= 0) {
                accepts = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return accepts;
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        this.log.debug((Object)("init, " + di.shortName));
        try {
            File file;
            di.watch = di.url.getProtocol().equalsIgnoreCase("file") ? (!(file = new File(di.url.getFile())).isDirectory() ? di.url : new URL(di.url, "META-INF/deployable-unit.xml")) : di.url;
        }
        catch (Exception e) {
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            throw new DeploymentException("failed to initialize", (Throwable)e);
        }
        super.init(di);
    }

    protected void processNestedDeployments(DeploymentInfo di) throws DeploymentException {
    }

    public synchronized void start(DeploymentInfo di) throws DeploymentException {
        try {
            this.log.debug((Object)("start application, deploymentInfo: " + di + ", short name: " + di.shortName + ", parent short name: " + (di.parent == null ? "null" : di.parent.shortName)));
            DeployableUnitID did = this.sleeDeploymentMBean.install(di.localUrl.toExternalForm());
            di.metaData = did;
            DeployableUnitDescriptor dud = this.sleeDeploymentMBean.getDescriptor(did);
            this.activateComponents(dud.getComponents());
            this.deployments.put(di.url, di);
            this.log.info((Object)("Deployed: " + di.url));
        }
        catch (Exception e) {
            this.stop(di);
            this.destroy(di);
            throw new DeploymentException("Could not deploy " + di.url, (Throwable)e);
        }
        super.start(di);
    }

    private void activateComponents(ComponentID[] components) throws Exception {
        int i = 0;
        while (i < components.length) {
            ComponentID cid = components[i];
            if (cid instanceof ResourceAdaptorID) {
                this.activateResourceAdaptor((ResourceAdaptorID)cid);
            } else if (cid instanceof ServiceID) {
                this.activateService((ServiceID)cid);
            }
            ++i;
        }
    }

    private void activateService(ServiceID serviceID) throws Exception {
        this.serviceManagementMBean.activate(serviceID);
    }

    private void deactivateService(ServiceID serviceID) throws Exception {
        this.serviceManagementMBean.deactivate(serviceID);
    }

    private void deactivateComponents(ComponentID[] components) throws Exception {
        int i = components.length - 1;
        while (i >= 0) {
            ComponentID cid = components[i];
            if (cid instanceof ResourceAdaptorID) {
                this.deactivateResourceAdaptor((ResourceAdaptorID)cid);
            } else if (cid instanceof ServiceID) {
                this.deactivateService((ServiceID)cid);
            }
            --i;
        }
    }

    private String getRADefaultEntityName(ResourceAdaptorID raid) throws Exception {
        ResourceAdaptorDescriptor rad = (ResourceAdaptorDescriptor)this.sleeDeploymentMBean.getDescriptor((ComponentID)raid);
        String raEntityName = String.valueOf(rad.getName()) + "-ra";
        return raEntityName;
    }

    private void activateResourceAdaptor(ResourceAdaptorID raid) throws Exception {
        String raEntityName = this.getRADefaultEntityName(raid);
        this.resourceManagementMBean.createResourceAdaptorEntity(raid, raEntityName, new Properties());
        this.resourceManagementMBean.activateResourceAdaptorEntity(raEntityName);
        this.resourceManagementMBean.bindLinkName(raEntityName, raEntityName);
    }

    private void deactivateResourceAdaptor(ResourceAdaptorID raid) throws Exception {
        String raEntityName = this.getRADefaultEntityName(raid);
        this.resourceManagementMBean.unbindLinkName(raEntityName);
        this.resourceManagementMBean.deactivateResourceAdaptorEntity(raEntityName);
        this.resourceManagementMBean.removeResourceAdaptorEntity(raEntityName);
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        this.log.info((Object)("Undeploying: " + di.url));
        try {
            DeployableUnitID did = (DeployableUnitID)di.metaData;
            if (did == null) {
                return;
            }
            DeployableUnitDescriptor dud = this.sleeDeploymentMBean.getDescriptor(did);
            this.deactivateComponents(dud.getComponents());
            this.sleeDeploymentMBean.uninstall(did);
        }
        catch (Exception e) {
            throw new DeploymentException("problem stopping SLEE module: " + di.url, (Throwable)e);
        }
        super.stop(di);
    }

    public boolean getValidateDTDs() {
        return this.validateDTDs;
    }

    public void setValidateDTDs(boolean validate) {
        this.validateDTDs = validate;
    }

    public ObjectName getSleeManagementMBean() {
        return this.sleeManagementMBeanName;
    }

    public void setSleeManagementMBean(ObjectName newSM) {
        this.sleeManagementMBeanName = newSM;
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        this.deployments.remove(di.url);
        super.destroy(di);
    }
}

