/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.NotCompliantMBeanException;
import javax.slee.SbbID;
import javax.slee.facilities.TimerID;
import javax.slee.nullactivity.NullActivity;
import javax.slee.resource.ResourceException;
import javax.transaction.SystemException;
import org.apache.log4j.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.component.SbbIDImpl;
import org.mobicents.slee.container.management.jmx.ActivityManagementMBeanImplMBean;
import org.mobicents.slee.resource.SleeActivityHandle;
import org.mobicents.slee.runtime.ActivityContext;
import org.mobicents.slee.runtime.ActivityContextFactoryImpl;
import org.mobicents.slee.runtime.SbbEntity;
import org.mobicents.slee.runtime.SbbEntityFactory;
import org.mobicents.slee.runtime.SleeInternalEndpoint;
import org.mobicents.slee.runtime.facilities.ActivityContextNamingFacilityImpl;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class ActivityManagementMBeanImpl
extends ServiceMBeanSupport
implements ActivityManagementMBeanImplMBean {
    private long querryInterval = 600000L;
    private long maxActivityIdleTime = 600000L;
    private ActivityContextFactoryImpl acFactory = null;
    private SleeTransactionManager txMgr = null;
    private SleeContainer container = null;
    private TimerTask currentQuestioner = null;
    private Timer queryRunner = new Timer("MOBICENTS_ACTIVITY_LIVELINESS_TIMER");
    private static Logger logger = Logger.getLogger(ActivityManagementMBeanImpl.class);

    public int getActivityContextCount() {
        try {
            return this.acFactory.getActivityContextCount();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public long getQueryActivityContextLivelinessPeriod() {
        return this.querryInterval;
    }

    public void setQueryActivityContextLivelinessPeriod(long set) {
        long originalV = this.querryInterval;
        this.querryInterval = set <= 100L ? 15000L : set;
        logger.info((Object)("Reinitiating liveliness querry to run [" + (this.querryInterval != 0L) + "]"));
        if (this.currentQuestioner.cancel()) {
            if (this.querryInterval == 0L) {
                return;
            }
            this.currentQuestioner = new PeriodicLivelinessScanner();
            this.queryRunner.schedule(this.currentQuestioner, this.querryInterval);
        } else if (originalV == 0L) {
            this.currentQuestioner = new PeriodicLivelinessScanner();
            this.queryRunner.schedule(this.currentQuestioner, this.querryInterval);
        }
        logger.info((Object)"Reinitiated");
    }

    public void setActivityContextMaxIdleTime(long set) {
        this.maxActivityIdleTime = set <= 100L && set > 0L ? 15000L : set;
    }

    public long getActivityContextMaxIdleTime() {
        return this.maxActivityIdleTime;
    }

    public void endActivity(String nullACID) throws ResourceException {
        block15: {
            logger.info((Object)("Trying to stop null activity[" + nullACID + "]!!"));
            boolean createdTx = false;
            try {
                try {
                    ActivityContext ac;
                    if (!this.txMgr.isInTx()) {
                        this.txMgr.begin();
                        createdTx = true;
                    }
                    if ((ac = this.acFactory.getActivityContextById(nullACID, false)) == null) {
                        logger.debug((Object)("There is no ac associated with given acID[" + nullACID + "]!!"));
                        throw new ResourceException("Can not find AC for given ID[" + nullACID + "], try again!!!");
                    }
                    if (ac.getActivity() instanceof NullActivity) {
                        logger.debug((Object)("Scheduling activity end for acID[" + nullACID + "]"));
                        SleeInternalEndpoint end = this.container.getSleeEndpoint();
                        end.scheduleActivityEndedEvent(ac.getActivity());
                        break block15;
                    }
                    logger.debug((Object)"AC is not null activity context");
                    throw new IllegalArgumentException("Given ID[" + nullACID + "] does not point to NullActivity");
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (createdTx) {
                    try {
                        this.txMgr.commit();
                    }
                    catch (SystemException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void queryActivityContextLiveness() {
        logger.info((Object)"Extorting liveliness query!!");
        if (this.currentQuestioner.cancel()) {
            this.currentQuestioner = new PeriodicLivelinessScanner();
            this.currentQuestioner.run();
        }
        logger.info((Object)"Extortion complete");
    }

    public String[] listActivityContextsFactories() {
        HashSet<String> factoriesSet;
        String[] ret;
        boolean createdTx;
        block17: {
            block18: {
                logger.info((Object)"Listing AC  factory");
                createdTx = false;
                ret = null;
                if (!this.txMgr.isInTx()) {
                    this.txMgr.begin();
                    createdTx = true;
                }
                factoriesSet = new HashSet<String>();
                Iterator it = this.acFactory.getAllActivityContextsNoAccessUpdate().iterator();
                logger.debug((Object)"Gathering information");
                while (it.hasNext()) {
                    ActivityContext ac = (ActivityContext)it.next();
                    String key = null;
                    Object activity = ac.getActivity();
                    key = activity instanceof SleeActivityHandle ? ((SleeActivityHandle)activity).getRaEntityName() : activity.getClass().getName();
                    factoriesSet.add(key);
                }
                logger.debug((Object)"Composing response");
                if (factoriesSet.size() != 0) break block17;
                if (!createdTx) break block18;
                try {
                    this.txMgr.commit();
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
        try {
            try {
                ret = new String[factoriesSet.size()];
                ret = factoriesSet.toArray(ret);
            }
            catch (SystemException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (createdTx) {
                try {
                    this.txMgr.commit();
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public Object[] listActivityContexts(boolean inDetails) {
        logger.info((Object)("Listing ACs with details[" + inDetails + "]"));
        boolean createdTx = false;
        Object[] ret = null;
        try {
            try {
                if (!this.txMgr.isInTx()) {
                    this.txMgr.begin();
                    createdTx = true;
                }
                ret = this.listWithCriteria(false, inDetails, -1, null);
            }
            catch (SystemException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (createdTx) {
                try {
                    this.txMgr.commit();
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public Object[] retrieveActivityContextDetails(String AC_ID) throws ResourceException {
        logger.info((Object)("Retrieving AC details for acID[" + AC_ID + "]"));
        boolean createdTx = false;
        Object[] o = null;
        try {
            try {
                ActivityContext ac;
                if (!this.txMgr.isInTx()) {
                    this.txMgr.begin();
                    createdTx = true;
                }
                if ((ac = this.acFactory.getActivityContextById(AC_ID, false)) == null) {
                    logger.debug((Object)("Ac retrieval failed, no such ac[" + AC_ID + "]!!!"));
                    throw new ResourceException("Activity Context does not exist (ACID[" + AC_ID + "]), try another one!!");
                }
                o = this.getDetails(ac);
            }
            catch (SystemException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (createdTx) {
                try {
                    this.txMgr.commit();
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
        }
        return o;
    }

    private Object[] listWithCriteria(boolean listIDsOnly, boolean inDetails, int criteria, String comparisonCriteria) {
        logger.info((Object)("Listing with criteria[" + criteria + "] with details[" + inDetails + "] only IDS[" + listIDsOnly + "]"));
        Collection col = this.acFactory.getAllActivityContextsNoAccessUpdate();
        Iterator it = col.iterator();
        ArrayList<Object[]> lst = new ArrayList<Object[]>();
        HashMap<String, SbbID> sbbEntityIdToSbbID = new HashMap<String, SbbID>();
        SbbEntityFactory sbbEntityFactory = this.container.getSbbEntityFactory();
        block7: while (it.hasNext()) {
            ActivityContext ac = (ActivityContext)it.next();
            Object activity = null;
            switch (criteria) {
                case 0: {
                    String activityClassName = null;
                    activity = ac.getActivity();
                    if (activity instanceof SleeActivityHandle) {
                        activity = ((SleeActivityHandle)activity).getActivity();
                    }
                    if ((activityClassName = activity.getClass().getCanonicalName()).equals(comparisonCriteria)) break;
                    ac = null;
                    break;
                }
                case 1: {
                    String raEntityName = null;
                    activity = ac.getActivity();
                    if (activity instanceof SleeActivityHandle) {
                        SleeActivityHandle SLAH = (SleeActivityHandle)activity;
                        raEntityName = SLAH.getRaEntityName();
                        if (raEntityName.equals(comparisonCriteria)) break;
                        ac = null;
                        break;
                    }
                    ac = null;
                    break;
                }
                case 2: {
                    if (!comparisonCriteria.equals("") && ac.getSortedCopyOfSbbAttachmentSet().contains(comparisonCriteria)) break;
                    ac = null;
                    break;
                }
                case 3: {
                    SbbIDImpl idBeingLookedUp = new SbbIDImpl(new ComponentKey(comparisonCriteria));
                    boolean match = false;
                    SbbID implSbbID = null;
                    List list = ac.getSortedCopyOfSbbAttachmentSet();
                    int i = 0;
                    while (i < list.size()) {
                        String sbbEID = (String)list.get(i);
                        if (sbbEntityIdToSbbID.containsKey(sbbEID)) {
                            implSbbID = (SbbID)sbbEntityIdToSbbID.get(sbbEID);
                        } else {
                            SbbEntity sbbe = sbbEntityFactory.getSbbEntity(sbbEID);
                            implSbbID = sbbe.getSbbId();
                            sbbEntityIdToSbbID.put(sbbEID, implSbbID);
                        }
                        if (implSbbID.equals((Object)idBeingLookedUp)) {
                            match = true;
                            break;
                        }
                        match = false;
                        ++i;
                    }
                    if (match) break;
                    ac = null;
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    continue block7;
                }
            }
            if (ac == null) continue;
            Object[] singleResult = null;
            if (!listIDsOnly) {
                logger.debug((Object)("Adding AC[" + ac.getActivityContextId() + "]"));
                Object[] o = this.getDetails(ac);
                if (!inDetails) {
                    o[4] = String.valueOf(((Object[])o[4]).length);
                    o[5] = String.valueOf(((Object[])o[5]).length);
                    o[6] = String.valueOf(((Object[])o[6]).length);
                    o[7] = String.valueOf(((Object[])o[7]).length);
                }
                singleResult = o;
            } else {
                singleResult = ac.getActivityContextId();
            }
            lst.add(singleResult);
        }
        if (lst.size() == 0) {
            return null;
        }
        logger.info((Object)("RETURN SIZE[" + lst.size() + "]"));
        Object[] ret = new Object[lst.size()];
        ret = lst.toArray(ret);
        return ret;
    }

    private Object[] getDetails(ActivityContext ac) {
        logger.debug((Object)("Retrieveing details for acID[" + ac.getActivityContextId() + "]"));
        Object[] o = new Object[8];
        o[0] = ac.getActivityContextId();
        logger.debug((Object)("======[getDetails][" + o[0] + "][" + ac.hashCode() + "]"));
        String activityClassName = null;
        Object activity = ac.getActivity();
        if (activity instanceof SleeActivityHandle) {
            SleeActivityHandle SLAH = (SleeActivityHandle)activity;
            activityClassName = SLAH.getActivity().getClass().getCanonicalName();
            o[3] = SLAH.getRaEntityName();
        } else {
            activityClassName = activity.getClass().getCanonicalName();
        }
        o[1] = activityClassName;
        logger.debug((Object)("======[getDetails][ACTIVITY_CLASS][" + o[1] + "]"));
        o[2] = String.valueOf(ac.getLastAccessTime());
        logger.debug((Object)("======[getDetails][LAST_ACCESS_TIME][" + o[2] + "][" + new Date(Long.parseLong((String)o[2])) + "]"));
        List lst = ac.getSortedCopyOfSbbAttachmentSet();
        String[] tmp = new String[lst.size()];
        o[4] = tmp = lst.toArray(tmp);
        Set s = ac.getNamingBindingCopy();
        tmp = new String[s.size()];
        o[5] = tmp = s.toArray(tmp);
        s = ac.getAttachedTimersCopy();
        tmp = new String[s.size()];
        Iterator<Object> it = s.iterator();
        int counter = 0;
        while (it.hasNext()) {
            tmp[counter++] = ((TimerID)it.next()).toString();
        }
        o[6] = tmp;
        Map m = ac.getDataAttributesCopy();
        tmp = new String[m.size()];
        it = m.keySet().iterator();
        counter = 0;
        while (it.hasNext()) {
            Object k = it.next();
            Object v = m.get(k);
            tmp[counter++] = k + "=" + v;
        }
        o[7] = tmp;
        return o;
    }

    public Object[] retrieveActivityContextIDByActivityType(String fullQualifiedActivityClassName) {
        logger.info((Object)("Retrieving AC by activity class name[" + fullQualifiedActivityClassName + "]"));
        boolean createdTx = false;
        Object[] ret = null;
        try {
            try {
                if (!this.txMgr.isInTx()) {
                    this.txMgr.begin();
                    createdTx = true;
                }
                ret = this.listWithCriteria(true, true, 0, fullQualifiedActivityClassName);
            }
            catch (SystemException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (createdTx) {
                try {
                    this.txMgr.commit();
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public Object[] retrieveActivityContextIDByResourceAdaptorEntityName(String entityName) {
        logger.info((Object)("Retrieving AC by entity name[" + entityName + "]"));
        boolean createdTx = false;
        Object[] ret = null;
        try {
            try {
                if (!this.txMgr.isInTx()) {
                    this.txMgr.begin();
                    createdTx = true;
                }
                ret = this.listWithCriteria(true, true, 1, entityName);
            }
            catch (SystemException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (createdTx) {
                try {
                    this.txMgr.commit();
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public Object[] retrieveActivityContextIDBySbbEntityID(String sbbEID) {
        logger.info((Object)("Retrieving ACs by sbb entity id [" + sbbEID + "]"));
        boolean createdTx = false;
        Object[] ret = null;
        try {
            try {
                if (!this.txMgr.isInTx()) {
                    this.txMgr.begin();
                    createdTx = true;
                }
                ret = this.listWithCriteria(true, true, 2, sbbEID);
            }
            catch (SystemException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (createdTx) {
                try {
                    this.txMgr.commit();
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public Object[] retrieveActivityContextIDBySbbID(String sbbID) {
        logger.info((Object)("Retrieving ACs by sbb id [" + sbbID + "]"));
        boolean createdTx = false;
        Object[] ret = null;
        try {
            try {
                if (!this.txMgr.isInTx()) {
                    this.txMgr.begin();
                    createdTx = true;
                }
                ret = this.listWithCriteria(true, true, 3, sbbID);
            }
            catch (SystemException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (createdTx) {
                try {
                    this.txMgr.commit();
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public Map retrieveNamesToActivityContextIDMappings() {
        ActivityContextNamingFacilityImpl naming = (ActivityContextNamingFacilityImpl)this.container.getActivityContextNamingFacility();
        boolean createdTx = false;
        Map ret = null;
        try {
            try {
                if (!this.txMgr.isInTx()) {
                    this.txMgr.begin();
                    createdTx = true;
                }
                ret = naming.getBindings();
            }
            catch (SystemException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (createdTx) {
                try {
                    this.txMgr.commit();
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    private void prepareBean() {
        if (this.acFactory == null) {
            this.container = SleeContainer.lookupFromJndi();
            this.acFactory = this.container.getActivityContextFactory();
            this.txMgr = SleeContainer.getTransactionManager();
            this.currentQuestioner = new PeriodicLivelinessScanner();
            this.queryRunner.schedule(this.currentQuestioner, this.querryInterval);
        }
    }

    public void startService() throws Exception {
        logger.info((Object)"Starting Activity Manager MBean");
        this.prepareBean();
        logger.info((Object)"Finished configurin Activity Manager MBean");
    }

    protected void stopService() throws Exception {
        this.queryRunner.cancel();
    }

    private class PeriodicLivelinessScanner
    extends TimerTask {
        private PeriodicLivelinessScanner() {
        }

        public void run() {
            logger.info((Object)"Periodic Liveliness Task is on the run, scanning through acs");
            boolean createdTx = false;
            try {
                try {
                    if (!ActivityManagementMBeanImpl.this.txMgr.isInTx()) {
                        ActivityManagementMBeanImpl.this.txMgr.begin();
                        createdTx = true;
                    }
                    Collection acs = ActivityManagementMBeanImpl.this.acFactory.getAllActivityContextsNoAccessUpdate();
                    Iterator it = acs.iterator();
                    long currentTime = System.currentTimeMillis();
                    while (it.hasNext()) {
                        SleeActivityHandle SLAH;
                        ActivityContext ac = (ActivityContext)it.next();
                        if (!(ac.getActivity() instanceof SleeActivityHandle) || currentTime - ac.getLastAccessTime() < ActivityManagementMBeanImpl.this.maxActivityIdleTime || (SLAH = (SleeActivityHandle)ac.getActivity()).getResourceAdaptor() == null) continue;
                        SLAH.getResourceAdaptor().queryLiveness(SLAH.getHandle());
                    }
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (createdTx) {
                    try {
                        ActivityManagementMBeanImpl.this.txMgr.commit();
                    }
                    catch (SystemException e) {
                        e.printStackTrace();
                    }
                }
                if (ActivityManagementMBeanImpl.this.querryInterval == 0L) {
                    return;
                }
                logger.info((Object)"Periodic Liveliness Task has finished, scheduling another run");
                ActivityManagementMBeanImpl.this.currentQuestioner = new PeriodicLivelinessScanner();
                ActivityManagementMBeanImpl.this.queryRunner.schedule(ActivityManagementMBeanImpl.this.currentQuestioner, ActivityManagementMBeanImpl.this.querryInterval);
                logger.info((Object)"Periodic Liveliness Task scheduled for next run");
            }
        }
    }
}

