/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.slee.AlarmID;
import javax.slee.UnrecognizedAlarmException;
import javax.slee.management.Alarm;
import javax.slee.management.AlarmNotification;
import javax.slee.management.ManagementException;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.management.jmx.AlarmMBeanImplMBean;
import org.mobicents.slee.runtime.facilities.AlarmFacilityImpl;

public class AlarmMBeanImpl
extends ServiceMBeanSupport
implements AlarmMBeanImplMBean {
    private List listeners = new CopyOnWriteArrayList();
    private AlarmFacilityImpl alarmFacility = new AlarmFacilityImpl(this);
    public static String JNDI_NAME = "alarm";
    private static Logger log = Logger.getLogger(AlarmMBeanImpl.class);

    public AlarmMBeanImpl() throws NotCompliantMBeanException {
        super(AlarmMBeanImplMBean.class);
    }

    public AlarmMBeanImpl(AlarmFacilityImpl alarmFacility) throws NotCompliantMBeanException {
        this();
        this.alarmFacility = alarmFacility;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        log.debug((Object)"addNotificationListener");
        this.listeners.add(new ListenerFilterHandbackTriplet(listener, filter, handback));
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        log.debug((Object)"removeNotificationListener");
        boolean found = false;
        for (ListenerFilterHandbackTriplet triplet : this.listeners) {
            if (triplet.notificationListener != listener) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new ListenerNotFoundException();
        }
        this.listeners.remove(listener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        log.debug((Object)"getNotificationInfo");
        if (this.alarmFacility == null) {
            return null;
        }
        String[] notificationTypes = this.alarmFacility.getNotificationTypes();
        MBeanNotificationInfo[] mbeanNotificationInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notificationTypes, "javax.slee.management.alarm", "User Notifications")};
        return mbeanNotificationInfo;
    }

    public void sendNotification(AlarmNotification notification) {
        log.debug((Object)"sendNotification");
        for (ListenerFilterHandbackTriplet triplet : this.listeners) {
            if (triplet.notificationFilter != null && !triplet.notificationFilter.isNotificationEnabled((Notification)notification)) continue;
            triplet.notificationListener.handleNotification((Notification)notification, triplet.handbackObject);
        }
    }

    protected void startService() throws Exception {
        SleeContainer.registerFacilityWithJndi(JNDI_NAME, this.alarmFacility);
    }

    protected void stopService() throws Exception {
        SleeContainer.unregisterFacilityWithJndi(JNDI_NAME);
    }

    public void clearAlarm(AlarmID arg0) throws NullPointerException, ManagementException {
    }

    public void clearAlarms(String arg0) throws NullPointerException, ManagementException {
    }

    public Alarm getAlarm(AlarmID arg0) throws NullPointerException, UnrecognizedAlarmException, ManagementException {
        return null;
    }

    public AlarmID[] getAlarms() throws ManagementException {
        return null;
    }

    public Alarm[] getAlarms(AlarmID[] arg0) throws NullPointerException, ManagementException {
        return null;
    }

    class ListenerFilterHandbackTriplet {
        NotificationListener notificationListener;
        NotificationFilter notificationFilter;
        Object handbackObject;

        public ListenerFilterHandbackTriplet(NotificationListener listener, NotificationFilter notificationFilter, Object handbackObject) {
            this.notificationListener = listener;
            this.notificationFilter = notificationFilter;
            this.handbackObject = handbackObject;
        }
    }
}

