/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx;

import java.util.Collection;
import java.util.HashSet;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.InvalidArgumentException;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.management.ManagementException;
import javax.slee.management.SleeState;
import javax.slee.profile.AttributeNotIndexedException;
import javax.slee.profile.AttributeTypeMismatchException;
import javax.slee.profile.ProfileAlreadyExistsException;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.ProfileTableAlreadyExistsException;
import javax.slee.profile.UnrecognizedAttributeException;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileSpecificationException;
import javax.slee.profile.UnrecognizedProfileTableNameException;
import javax.slee.profile.UnrecognizedQueryNameException;
import javax.slee.profile.search.SearchExpression;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.ProfileSpecificationDescriptorImpl;
import org.mobicents.slee.container.management.jmx.ProfileProvisioningMBeanImplMBean;
import org.mobicents.slee.container.profile.SingleProfileException;
import org.mobicents.slee.container.profile.SleeProfileManager;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class ProfileProvisioningMBeanImpl
extends ServiceMBeanSupport
implements ProfileProvisioningMBeanImplMBean {
    private static Logger logger;

    static {
        try {
            logger = Logger.getLogger(ProfileProvisioningMBeanImpl.class);
        }
        catch (Exception ex) {
            logger.fatal((Object)"error initializing profile provisioning mbean");
        }
    }

    public ProfileProvisioningMBeanImpl() throws NotCompliantMBeanException {
        super(ProfileProvisioningMBeanImplMBean.class);
    }

    public void createProfileTable(ProfileSpecificationID profileSpecificationID, String newProfileTableName) throws NullPointerException, UnrecognizedProfileSpecificationException, InvalidArgumentException, ProfileTableAlreadyExistsException, ManagementException {
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        if (!sleeContainer.getSleeState().equals((Object)SleeState.RUNNING)) {
            return;
        }
        SleeTransactionManager transactionManager = SleeContainer.getTransactionManager();
        boolean b = false;
        try {
            try {
                b = transactionManager.requireTransaction();
                logger.debug((Object)("creating new Profile Table " + newProfileTableName + " ..."));
                logger.debug((Object)("profile specification ID :" + profileSpecificationID.toString()));
                if (newProfileTableName == null) {
                    throw new NullPointerException();
                }
                if (newProfileTableName.length() < 1) {
                    this.log.error((Object)("InvaidArgument: " + newProfileTableName));
                    throw new InvalidArgumentException();
                }
                if (newProfileTableName.indexOf(47) != -1) {
                    this.log.error((Object)("InvaidArgument: " + newProfileTableName));
                    throw new InvalidArgumentException();
                }
                if (this.profileTableHasInvalidCharacters(newProfileTableName)) {
                    this.log.error((Object)("InvaidArgument: " + newProfileTableName));
                    throw new InvalidArgumentException();
                }
                SleeProfileManager profileManager = SleeProfileManager.getInstance();
                try {
                    ProfileSpecificationID profileSpecification = profileManager.findProfileSpecId(newProfileTableName);
                    if (profileSpecification != null) {
                        throw new ProfileTableAlreadyExistsException("Failed creating Profile Table " + newProfileTableName + " in " + profileSpecificationID);
                    }
                }
                catch (SystemException e1) {
                    String err = "Failed to create profile table, because of failure in findProfuleTable(" + newProfileTableName + "). System Exception.";
                    logger.error((Object)err, (Throwable)e1);
                    throw new ManagementException(err, (Throwable)e1);
                }
                logger.debug((Object)("Profile table does not exist -- creating one  " + profileSpecificationID.toString()));
                ProfileSpecificationDescriptorImpl profileSpecificationDescriptor = (ProfileSpecificationDescriptorImpl)sleeContainer.getComponentDescriptor((ComponentID)profileSpecificationID);
                if (profileSpecificationDescriptor == null) {
                    throw new UnrecognizedProfileSpecificationException();
                }
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    try {
                        Thread.currentThread().setContextClassLoader(profileSpecificationDescriptor.getClassLoader());
                        profileManager.addProfileTable(newProfileTableName, profileSpecificationDescriptor);
                    }
                    catch (TransactionRequiredLocalException e) {
                        throw new ManagementException("Transaction Manager Failure", (Throwable)e);
                    }
                    catch (SystemException e) {
                        throw new ManagementException("System-level failure", (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ManagementException("Profile Specification has not been correctly deployed", (Throwable)e);
                    }
                    catch (Exception e) {
                        throw new ManagementException(e.getMessage(), (Throwable)e);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
                logger.debug((Object)("new Profile Table " + newProfileTableName + " created"));
            }
            catch (Exception x) {
                try {
                    transactionManager.setRollbackOnly();
                }
                catch (SystemException e) {
                    logger.error((Object)"System Exception", (Throwable)e);
                    throw new ManagementException("System Exception", (Throwable)e);
                }
                if (x instanceof NullPointerException) {
                    throw (NullPointerException)x;
                }
                if (x instanceof UnrecognizedProfileSpecificationException) {
                    throw (UnrecognizedProfileSpecificationException)x;
                }
                if (x instanceof InvalidArgumentException) {
                    throw (InvalidArgumentException)x;
                }
                if (x instanceof ProfileTableAlreadyExistsException) {
                    throw (ProfileTableAlreadyExistsException)x;
                }
                if (x instanceof ManagementException) {
                    throw (ManagementException)x;
                }
                throw new ManagementException("Failed createProfileTable", (Throwable)x);
            }
        }
        finally {
            if (b) {
                try {
                    transactionManager.commit();
                }
                catch (SystemException e) {
                    logger.error((Object)"System Exception", (Throwable)e);
                    throw new ManagementException("System Exception", (Throwable)e);
                }
            }
        }
    }

    private boolean profileTableHasInvalidCharacters(String profileTableName) {
        char invalidChar = '\u0000';
        while (invalidChar < '\u001f') {
            if (profileTableName.indexOf(invalidChar) != -1) {
                logger.debug((Object)("Profile Table Name " + profileTableName + " " + "contains the following invalid character " + invalidChar));
                return true;
            }
            invalidChar = (char)(invalidChar + 1);
        }
        if (profileTableName.indexOf(47) != -1) {
            logger.debug((Object)("Profile Table Name " + profileTableName + " contains the following invalid character /"));
            return true;
        }
        if (profileTableName.indexOf(127) != -1) {
            logger.debug((Object)("Profile Table Name " + profileTableName + " " + "contains the following invalid character \u007f"));
            return true;
        }
        return false;
    }

    private boolean profileHasInvalidCharacters(String profileName) {
        char invalidChar = '\u0000';
        while (invalidChar < '\u001f') {
            if (profileName.indexOf(invalidChar) != -1) {
                logger.debug((Object)("Profile Name " + profileName + " " + "contains the following invalid character " + invalidChar));
                return true;
            }
            invalidChar = (char)(invalidChar + 1);
        }
        if (profileName.indexOf(127) != -1) {
            logger.debug((Object)("Profile Name " + profileName + " " + "contains the following invalid character \u007f"));
            return true;
        }
        return false;
    }

    public void removeProfileTable(String profileTableName) throws NullPointerException, UnrecognizedProfileTableNameException, ManagementException {
        logger.debug((Object)("removing Profile Table " + profileTableName + " ..."));
        if (profileTableName == null) {
            logger.error((Object)"Cannot remove profile table when passed name equals null!!!");
            throw new NullPointerException();
        }
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        SleeTransactionManager transactionManager = SleeContainer.getTransactionManager();
        boolean b = false;
        boolean rb = true;
        try {
            ProfileSpecificationID profileSpecificationID;
            b = transactionManager.requireTransaction();
            if (!sleeContainer.getSleeState().equals((Object)SleeState.RUNNING)) {
                return;
            }
            SleeProfileManager profileManager = SleeProfileManager.getInstance();
            try {
                profileSpecificationID = profileManager.findProfileSpecId(profileTableName);
            }
            catch (SystemException e) {
                throw new ManagementException("System-level failure", (Throwable)e);
            }
            if (profileSpecificationID == null) {
                throw new UnrecognizedProfileTableNameException("Failed removing Profile Table " + profileTableName);
            }
            try {
                profileManager.removeProfileTable(profileTableName);
            }
            catch (TransactionRequiredLocalException e) {
                throw new ManagementException("Transaction Manager Failure", (Throwable)e);
            }
            catch (SystemException e) {
                throw new ManagementException("System-level failure", (Throwable)e);
            }
            logger.debug((Object)("Removed Profile Table " + profileTableName));
            rb = false;
        }
        finally {
            try {
                if (rb) {
                    transactionManager.setRollbackOnly();
                }
                if (b) {
                    transactionManager.commit();
                }
            }
            catch (SystemException e) {
                throw new ManagementException("Failed removeProfileTable( " + profileTableName + ") due to tx commit error", (Throwable)e);
            }
        }
    }

    public ProfileSpecificationID getProfileSpecification(String profileTableName) throws NullPointerException, UnrecognizedProfileTableNameException, ManagementException {
        ProfileSpecificationID profileSpecificationID;
        logger.debug((Object)("trying to get the profile specification for " + profileTableName + " ..."));
        if (profileTableName == null) {
            throw new NullPointerException();
        }
        SleeProfileManager profileManager = SleeProfileManager.getInstance();
        try {
            profileSpecificationID = profileManager.findProfileSpecId(profileTableName);
        }
        catch (SystemException e) {
            throw new ManagementException("System-level failure", (Throwable)e);
        }
        if (profileSpecificationID == null) {
            throw new UnrecognizedProfileTableNameException();
        }
        logger.debug((Object)("profile specification for " + profileTableName + " found :" + profileSpecificationID));
        return profileSpecificationID;
    }

    public void renameProfileTable(String oldProfileTableName, String newProfileTableName) throws NullPointerException, UnrecognizedProfileTableNameException, InvalidArgumentException, ProfileTableAlreadyExistsException, ManagementException {
        logger.debug((Object)("Profile Table " + oldProfileTableName + " to be renamed to " + newProfileTableName));
        if (newProfileTableName == null) {
            throw new NullPointerException();
        }
        if (newProfileTableName.length() < 1) {
            throw new InvalidArgumentException();
        }
        if (newProfileTableName.indexOf(47) != -1) {
            throw new InvalidArgumentException();
        }
        ProfileSpecificationID profileSpecificationID = this.getProfileSpecification(oldProfileTableName);
        ProfileSpecificationDescriptorImpl profileSpecificationDescriptor = null;
        SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
        profileSpecificationDescriptor = (ProfileSpecificationDescriptorImpl)serviceContainer.getComponentDescriptor((ComponentID)profileSpecificationID);
        if (profileSpecificationDescriptor == null) {
            throw new UnrecognizedProfileTableNameException();
        }
        SleeProfileManager profileManager = SleeProfileManager.getInstance();
        try {
            ProfileSpecificationID profileSpecification = profileManager.findProfileSpecId(newProfileTableName);
            if (profileSpecification != null) {
                throw new ProfileTableAlreadyExistsException();
            }
        }
        catch (SystemException e1) {
            e1.printStackTrace();
            throw new ManagementException("System-level failure");
        }
        try {
            profileManager.renameProfileTable(oldProfileTableName, newProfileTableName, profileSpecificationDescriptor);
        }
        catch (TransactionRequiredLocalException e) {
            throw new ManagementException("System-level failure", (Throwable)e);
        }
        catch (SystemException e) {
            throw new ManagementException("System-level failure", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ManagementException("System-level failure", (Throwable)e);
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
        logger.debug((Object)("Profile Table " + oldProfileTableName + " renamed to " + newProfileTableName));
    }

    /*
     * Exception decompiling
     */
    public ObjectName getDefaultProfile(String profileTableName) throws NullPointerException, UnrecognizedProfileTableNameException, ManagementException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ObjectName createProfile(String profileTableName, String newProfileName) throws NullPointerException, UnrecognizedProfileTableNameException, InvalidArgumentException, ProfileAlreadyExistsException, ManagementException {
        ObjectName objectName;
        SleeTransactionManager transactionManager = SleeContainer.getTransactionManager();
        boolean b = false;
        boolean rb = true;
        try {
            ProfileSpecificationID profileSpecificationID;
            b = transactionManager.requireTransaction();
            String infoStr = "Creating new Profile " + newProfileName + " in profile table " + profileTableName;
            String errorStr = "Failed " + infoStr;
            logger.debug((Object)infoStr);
            if (profileTableName == null) {
                throw new NullPointerException();
            }
            if (newProfileName == null) {
                throw new NullPointerException();
            }
            if (newProfileName.length() < 1) {
                throw new InvalidArgumentException();
            }
            if (this.profileHasInvalidCharacters(newProfileName)) {
                throw new InvalidArgumentException();
            }
            newProfileName = newProfileName.replace('/', ' ');
            SleeProfileManager profileManager = SleeProfileManager.getInstance();
            try {
                profileSpecificationID = profileManager.findProfileSpecId(profileTableName);
            }
            catch (SystemException e) {
                throw new ManagementException(errorStr, (Throwable)e);
            }
            if (profileSpecificationID == null) {
                throw new UnrecognizedProfileTableNameException(errorStr);
            }
            try {
                ObjectName profile = profileManager.findProfileMBean(profileTableName, newProfileName);
                if (profile != null) {
                    throw new ProfileAlreadyExistsException(errorStr);
                }
                if (profileManager.isProfileCommitted(profileTableName, newProfileName)) {
                    throw new ProfileAlreadyExistsException(errorStr);
                }
            }
            catch (SystemException e1) {
                throw new ManagementException(errorStr, (Throwable)e1);
            }
            objectName = null;
            try {
                objectName = profileManager.addProfileToProfileTable(profileTableName, newProfileName);
            }
            catch (TransactionRequiredLocalException e) {
                throw new ManagementException(errorStr, (Throwable)e);
            }
            catch (SystemException e) {
                throw new ManagementException(errorStr, (Throwable)e);
            }
            catch (SingleProfileException e) {
                throw new ManagementException("This profile specification defines that it can exists only a single profile for it and there is already a profile for this specification." + errorStr, (Throwable)e);
            }
            logger.debug((Object)(String.valueOf(infoStr) + "DONE. The profile has the following JMX Object Name " + objectName));
            rb = false;
        }
        finally {
            try {
                if (rb) {
                    transactionManager.setRollbackOnly();
                }
                if (b) {
                    transactionManager.commit();
                }
            }
            catch (SystemException e) {
                logger.error((Object)"Failed getProfiles.", (Throwable)e);
                throw new ManagementException("Failed getProfiles.", (Throwable)e);
            }
        }
        return objectName;
    }

    public void removeProfile(String profileTableName, String profileName) throws NullPointerException, UnrecognizedProfileTableNameException, UnrecognizedProfileNameException, ManagementException {
        logger.debug((Object)("Removing Profile " + profileName + " from profile table " + profileTableName));
        if (profileTableName == null) {
            throw new NullPointerException();
        }
        if (profileName == null) {
            throw new NullPointerException();
        }
        profileName = profileName.replace('/', ' ');
        SleeTransactionManager transactionManager = SleeContainer.getTransactionManager();
        boolean b = false;
        boolean rb = true;
        try {
            ProfileSpecificationID profileSpecificationID;
            b = transactionManager.requireTransaction();
            SleeProfileManager profileManager = SleeProfileManager.getInstance();
            try {
                profileSpecificationID = profileManager.findProfileSpecId(profileTableName);
            }
            catch (SystemException e) {
                throw new ManagementException("System-level failure");
            }
            if (profileSpecificationID == null) {
                throw new UnrecognizedProfileTableNameException("Failed removing Profile " + profileName + " from Profile Table " + profileTableName);
            }
            ObjectName profileMBeanName = profileManager.findProfileMBean(profileTableName, profileName);
            if (profileMBeanName == null) {
                throw new UnrecognizedProfileNameException("Failed removing Profile " + profileName + " from Profile Table " + profileTableName);
            }
            try {
                profileManager.removeProfile(profileTableName, profileName);
            }
            catch (TransactionRequiredLocalException e) {
                throw new ManagementException("Transaction Manager Failure", (Throwable)e);
            }
            catch (SystemException e) {
                throw new ManagementException("System-level failure", (Throwable)e);
            }
            logger.debug((Object)("Profile " + profileName + " removed from profile table " + profileTableName));
            rb = false;
        }
        finally {
            try {
                if (rb) {
                    transactionManager.setRollbackOnly();
                }
                if (b) {
                    transactionManager.commit();
                }
            }
            catch (SystemException e) {
                throw new ManagementException("Failed removeProfileTable( " + profileTableName + ") due to tx commit error", (Throwable)e);
            }
        }
    }

    public ObjectName getProfile(String profileTableName, String profileName) throws NullPointerException, UnrecognizedProfileTableNameException, UnrecognizedProfileNameException, ManagementException {
        logger.debug((Object)("Getting Profile " + profileName + " from profile table " + profileTableName));
        if (profileTableName == null) {
            throw new NullPointerException();
        }
        if (profileName == null) {
            throw new NullPointerException();
        }
        profileName = profileName.replace('/', ' ');
        SleeTransactionManager transactionManager = SleeContainer.getTransactionManager();
        boolean b = false;
        boolean rb = true;
        try {
            ProfileSpecificationID profileSpecificationID;
            b = transactionManager.requireTransaction();
            SleeProfileManager profileManager = SleeProfileManager.getInstance();
            try {
                profileSpecificationID = profileManager.findProfileSpecId(profileTableName);
            }
            catch (SystemException e) {
                throw new ManagementException("System-level failure", (Throwable)e);
            }
            if (profileSpecificationID == null) {
                throw new UnrecognizedProfileTableNameException();
            }
            try {
                ObjectName profile = profileManager.findProfileMBean(profileTableName, profileName);
                if (profile == null) {
                    throw new UnrecognizedProfileNameException("Profile MBean does not exist.");
                }
                if (!profileManager.isProfileCommitted(profileTableName, profileName)) {
                    throw new UnrecognizedProfileNameException("Profile has been created but not committed.");
                }
            }
            catch (SystemException e1) {
                throw new ManagementException("System-level failure", (Throwable)e1);
            }
            ObjectName objectName = null;
            try {
                objectName = ProfileProvisioningMBeanImpl.getProfileObjectName(profileTableName, profileName);
            }
            catch (MalformedObjectNameException e2) {
                throw new ManagementException("System-level failure", (Throwable)e2);
            }
            catch (NullPointerException e2) {
                throw new ManagementException("System-level failure", (Throwable)e2);
            }
            logger.debug((Object)("Profile " + profileName + " from profile table " + profileTableName + " has the following JMX Object Name " + objectName));
            rb = false;
            ObjectName objectName2 = objectName;
            return objectName2;
        }
        finally {
            try {
                if (rb) {
                    transactionManager.setRollbackOnly();
                }
                if (b) {
                    transactionManager.commit();
                }
            }
            catch (SystemException e) {
                throw new ManagementException("Failed removeProfileTable( " + profileTableName + ") due to tx commit error", (Throwable)e);
            }
        }
    }

    public static ObjectName getProfileObjectName(String profileTableName, String profileName) throws MalformedObjectNameException {
        String jmxProfileTableObjectName = SleeProfileManager.toValidJmxName(profileTableName);
        String jmxProfileObjectName = SleeProfileManager.toValidJmxName(profileName);
        ObjectName objectName = new ObjectName("slee:profileTableName=" + jmxProfileTableObjectName + "," + "type=profile," + "profile=" + jmxProfileObjectName);
        return objectName;
    }

    public static ObjectName getDefaultProfileObjectName(String profileTableName) throws MalformedObjectNameException {
        return ProfileProvisioningMBeanImpl.getProfileObjectName(profileTableName, "defaultProfile");
    }

    public Collection getProfileTables() throws ManagementException {
        SleeTransactionManager transactionManager = SleeContainer.getTransactionManager();
        HashSet profileTables = null;
        boolean b = false;
        try {
            try {
                b = transactionManager.requireTransaction();
                SleeProfileManager profileManager = SleeProfileManager.getInstance();
                profileTables = profileManager.findAllProfileTables();
                profileTables = new HashSet(profileTables);
            }
            catch (Exception x) {
                try {
                    transactionManager.setRollbackOnly();
                }
                catch (SystemException e) {
                    logger.error((Object)"System Exception", (Throwable)e);
                    throw new ManagementException("System Exception", (Throwable)e);
                }
                if (x instanceof ManagementException) {
                    throw (ManagementException)x;
                }
                throw new ManagementException("Failed createProfileTable", (Throwable)x);
            }
        }
        finally {
            if (b) {
                try {
                    transactionManager.commit();
                }
                catch (SystemException e) {
                    logger.error((Object)"System Exception", (Throwable)e);
                    throw new ManagementException("System Exception", (Throwable)e);
                }
            }
        }
        return profileTables;
    }

    public Collection getProfiles(String profileTableName) throws NullPointerException, UnrecognizedProfileTableNameException, ManagementException {
        SleeTransactionManager transactionManager = SleeContainer.getTransactionManager();
        Collection profiles = null;
        boolean b = false;
        boolean rb = true;
        try {
            ProfileSpecificationID profileSpecificationID;
            b = transactionManager.requireTransaction();
            SleeProfileManager profileManager = SleeProfileManager.getInstance();
            if (profileTableName == null) {
                throw new NullPointerException();
            }
            try {
                profileSpecificationID = profileManager.findProfileSpecId(profileTableName);
            }
            catch (SystemException e) {
                throw new ManagementException("System-level failure");
            }
            if (profileSpecificationID == null) {
                throw new UnrecognizedProfileTableNameException();
            }
            profiles = profileManager.findAllProfilesByTableName(profileTableName);
            rb = false;
        }
        finally {
            try {
                if (rb) {
                    transactionManager.setRollbackOnly();
                }
                if (b) {
                    transactionManager.commit();
                }
            }
            catch (SystemException e) {
                logger.error((Object)"Failed getProfiles.", (Throwable)e);
                throw new ManagementException("Failed getProfiles.", (Throwable)e);
            }
        }
        return profiles;
    }

    public Collection getProfilesByIndexedAttribute(String profileTableName, String attributeName, Object attributeValue) throws NullPointerException, UnrecognizedProfileTableNameException, UnrecognizedAttributeException, AttributeNotIndexedException, AttributeTypeMismatchException, ManagementException {
        SleeTransactionManager transactionManager = SleeContainer.getTransactionManager();
        Collection profiles = null;
        boolean b = false;
        boolean rb = true;
        try {
            b = transactionManager.requireTransaction();
            if (profileTableName == null) {
                throw new NullPointerException();
            }
            if (attributeName == null) {
                throw new NullPointerException();
            }
            if (attributeValue == null) {
                throw new NullPointerException();
            }
            SleeProfileManager profileManager = SleeProfileManager.getInstance();
            try {
                ProfileSpecificationID profileSpecification = profileManager.findProfileSpecId(profileTableName);
                if (profileSpecification == null) {
                    throw new UnrecognizedProfileTableNameException();
                }
            }
            catch (SystemException e) {
                throw new ManagementException("System-level failure");
            }
            try {
                profiles = profileManager.getProfilesByIndexedAttribute(profileTableName, attributeName, attributeValue, false);
            }
            catch (SystemException e1) {
                throw new ManagementException("System-level failure");
            }
            rb = false;
        }
        finally {
            try {
                if (rb) {
                    transactionManager.setRollbackOnly();
                }
                if (b) {
                    transactionManager.commit();
                }
            }
            catch (SystemException e) {
                logger.error((Object)"Failed getProfiles.", (Throwable)e);
                throw new ManagementException("Failed getProfiles.", (Throwable)e);
            }
        }
        return profiles;
    }

    protected void startService() throws Exception {
        logger.info((Object)"ProfileProvisioningMBean has been started");
    }

    protected void stopService() throws Exception {
    }

    public Collection getProfilesByDynamicQuery(String arg0, SearchExpression arg1) throws NullPointerException, UnrecognizedProfileTableNameException, AttributeNotIndexedException, AttributeTypeMismatchException, ManagementException {
        return null;
    }

    public Collection getProfilesByStaticQuery(String arg0, String arg1, Object[] arg2) throws NullPointerException, UnrecognizedProfileTableNameException, UnrecognizedQueryNameException, AttributeTypeMismatchException, ManagementException {
        return null;
    }

    public void snapshot() throws ManagementException {
    }

    public void snapshot(String arg0) throws UnrecognizedProfileTableNameException, ManagementException {
    }
}

