/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx;

import java.util.Properties;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.slee.CreateException;
import javax.slee.InvalidArgumentException;
import javax.slee.InvalidStateException;
import javax.slee.management.DependencyException;
import javax.slee.management.LinkNameAlreadyBoundException;
import javax.slee.management.ManagementException;
import javax.slee.management.ResourceAdaptorEntityAlreadyExistsException;
import javax.slee.management.ResourceAdaptorEntityState;
import javax.slee.management.ResourceManagementMBean;
import javax.slee.management.UnrecognizedLinkNameException;
import javax.slee.management.UnrecognizedResourceAdaptorEntityException;
import javax.slee.management.UnrecognizedResourceAdaptorException;
import javax.slee.resource.ResourceAdaptorID;
import javax.slee.resource.ResourceException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.ResourceAdaptorIDImpl;

public class ResourceManagementMBeanImpl
extends StandardMBean
implements ResourceManagementMBean {
    public final String OBJECT_NAME = "slee:name=ResourceAdaptorManagement";
    private ObjectName objectName;
    private static final Logger logger = Logger.getLogger(ResourceManagementMBeanImpl.class);

    public ResourceManagementMBeanImpl() throws NotCompliantMBeanException {
        super(ResourceManagementMBean.class);
        try {
            this.objectName = new ObjectName("slee:name=ResourceAdaptorManagement");
        }
        catch (Exception ex) {
            throw new NotCompliantMBeanException("Object name is malformed : slee:name=ResourceAdaptorManagement");
        }
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void createResourceAdaptorEntity(ResourceAdaptorID id, String entityName, Properties properties) throws NullPointerException, InvalidArgumentException, UnrecognizedResourceAdaptorException, ResourceAdaptorEntityAlreadyExistsException, ResourceException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        logger.info((Object)("Creating Resource Adaptor Entity. RA ID: " + id + ", name: " + entityName + ", Properties: " + properties));
        try {
            container.createResourceAdaptorEntity((ResourceAdaptorIDImpl)id, entityName, properties);
        }
        catch (CreateException e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeResourceAdaptorEntity(String entityName) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, InvalidStateException, DependencyException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        logger.info((Object)("Removing Resource Adaptor Entity. RA name: " + entityName));
        container.removeResourceAdaptorEntity(entityName);
    }

    public void updateConfigurationProperties(String entityName, Properties properties) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, InvalidStateException, InvalidArgumentException, ResourceException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        logger.info((Object)("Updating Resource Adaptor Entity Config. Properties: " + properties));
        container.updateConfigurationProperties(entityName, properties);
    }

    public void activateResourceAdaptorEntity(String entityName) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, InvalidStateException, ResourceException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        logger.info((Object)("Activating Resource Adaptor Entity. RA name: " + entityName));
        container.activateResourceAdaptorEntity(entityName);
    }

    public void deactivateResourceAdaptorEntity(String name) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, InvalidStateException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        logger.info((Object)("Deactivating Resource Adaptor Entity. RA name: " + name));
        container.deactivateResourceAdaptorEntity(name);
    }

    public void bindLinkName(String entityName, String linkName) throws NullPointerException, InvalidArgumentException, UnrecognizedResourceAdaptorEntityException, LinkNameAlreadyBoundException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        logger.info((Object)("Creating RA Entity Link. RA name: " + entityName + ", Link: " + linkName));
        container.createResourceAdaptorEntityLink(linkName, entityName);
    }

    public Properties getConfigurationProperties(ResourceAdaptorID id) throws NullPointerException, UnrecognizedResourceAdaptorException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        return container.getRAProperties(id);
    }

    public Properties getConfigurationProperties(String entityName) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        return container.getRAEntityProperties(entityName);
    }

    public String[] getLinkNames() throws ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        return container.getResourceAdaptorEntityLinks();
    }

    public String[] getLinkNames(String entityName) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        return container.getResourceAdaptorEntityLinks(entityName);
    }

    public ResourceAdaptorID getResourceAdaptor(String entityName) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        return container.getResourceAdaptorID(entityName);
    }

    public String[] getResourceAdaptorEntities() throws ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        return container.getResourceAdaptorEntityNames();
    }

    public String[] getResourceAdaptorEntities(ResourceAdaptorID id) throws NullPointerException, UnrecognizedResourceAdaptorException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        return container.getResourceAdaptorEntityNames(id);
    }

    public String[] getResourceAdaptorEntities(ResourceAdaptorEntityState state) throws NullPointerException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        return container.getResourceAdaptorEntities(state);
    }

    public String[] getResourceAdaptorEntities(String[] linkNames) throws NullPointerException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        return container.getResourceAdaptorEntityNames(linkNames);
    }

    public String getResourceAdaptorEntity(String linkName) throws NullPointerException, UnrecognizedLinkNameException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        return container.getResourceAdaptorEntityName(linkName);
    }

    public ResourceAdaptorEntityState getState(String entityName) throws NullPointerException, UnrecognizedResourceAdaptorEntityException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        return container.getResourceAdaptorEntity(entityName).getState();
    }

    public void unbindLinkName(String linkName) throws NullPointerException, UnrecognizedLinkNameException, DependencyException, ManagementException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        logger.info((Object)("Removing RA Entity Link. RA link: " + linkName));
        container.removeResourceAdaptorEntityLink(linkName);
    }
}

