/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.management.jmx.SbbEntitiesMBeanImplMBean;
import org.mobicents.slee.runtime.SbbEntity;
import org.mobicents.slee.runtime.SbbEntityFactory;

public class SbbEntitiesMBeanImpl
extends StandardMBean
implements SbbEntitiesMBeanImplMBean {
    public final String OBJECT_NAME = "slee:name=SbbEntitiesMBean";
    private ObjectName objectName;

    public SbbEntitiesMBeanImpl() throws NotCompliantMBeanException {
        super(SbbEntitiesMBeanImplMBean.class);
        try {
            this.objectName = new ObjectName("slee:name=SbbEntitiesMBean");
        }
        catch (Exception ex) {
            throw new NotCompliantMBeanException("Object name is malformed : slee:name=SbbEntitiesMBean");
        }
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public Object[] retrieveSbbEntitiesBySbbId(String sbbId) {
        return null;
    }

    public Object[] retrieveAllSbbEntities() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        try {
            SleeContainer container = SleeContainer.lookupFromJndi();
            SbbEntityFactory factory = container.getSbbEntityFactory();
            HashMap sbbEntities = factory.getEntities();
            for (SbbEntity sbbe : sbbEntities.values()) {
                result.add(this.sbbEntityToArray(sbbe));
            }
            return result.toArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object[] sbbEntityToArray(SbbEntity sbbe) {
        Set acsSet;
        SbbEntity entity;
        Object[] info;
        block6: {
            info = new Object[11];
            try {
                SleeContainer.getTransactionManager().begin();
                entity = sbbe;
                if (entity != null) break block6;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        info[0] = entity.getSbbEntityId();
        info[1] = entity.getNodeName();
        info[2] = entity.getParentSbbId();
        info[3] = entity.getRootSbbId();
        info[4] = entity.getSbbId().toString();
        info[5] = Byte.toString(entity.getPriority());
        info[6] = entity.getServiceConvergenceName();
        info[7] = entity.getUsageParameterPathName();
        if (entity.getServiceId() != null) {
            info[8] = entity.getServiceId().toString();
        }
        if (entity.getCurrentEvent() != null) {
            info[9] = entity.getCurrentEvent().getEventTypeID().toString();
        }
        if ((acsSet = entity.getActivityContexts()) != null && acsSet.size() > 0) {
            String[] acs;
            Object[] acsArray = acsSet.toArray();
            info[10] = acs = new String[acsArray.length];
        }
        SleeContainer.getTransactionManager().commit();
        return info;
    }

    private SbbEntity getSbbEntityById(String sbbeId) {
        SleeContainer container = SleeContainer.lookupFromJndi();
        SbbEntityFactory factory = container.getSbbEntityFactory();
        HashMap sbbEntities = factory.getEntities();
        SbbEntity entity = (SbbEntity)sbbEntities.get(sbbeId);
        return entity;
    }

    public Object[] retrieveSbbEntityInfo(String sbbeId) {
        SbbEntity entity = this.getSbbEntityById(sbbeId);
        return this.sbbEntityToArray(entity);
    }

    public void removeSbbEntity(String sbbeId) {
        try {
            SleeContainer.getTransactionManager().begin();
            SbbEntity entity = this.getSbbEntityById(sbbeId);
            entity.remove();
            SleeContainer.getTransactionManager().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

