/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.StandardMBean;
import javax.slee.InvalidArgumentException;
import javax.slee.InvalidStateException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.management.ManagementException;
import javax.slee.usage.SbbUsageMBean;
import javax.slee.usage.UsageNotification;
import javax.transaction.SystemException;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.SleeContainerUtils;
import org.mobicents.slee.container.component.InstalledUsageParameterSet;
import org.mobicents.slee.container.service.Service;
import org.mobicents.slee.container.service.ServiceComponent;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class SbbUsageMBeanImpl
extends StandardMBean
implements SbbUsageMBean,
NotificationBroadcaster {
    private SbbID sbbId;
    private String name;
    private List listeners = new CopyOnWriteArrayList();
    private InstalledUsageParameterSet usagePramSet;
    private ServiceID serviceId;

    public SbbUsageMBeanImpl(String interfaceName) throws NotCompliantMBeanException, ClassNotFoundException {
        super(SleeContainerUtils.getCurrentThreadClassLoader().loadClass(interfaceName));
    }

    public SbbUsageMBeanImpl(ServiceID serviceID, SbbID sbbId, String name, String interfaceName) throws NotCompliantMBeanException, ClassNotFoundException {
        this(interfaceName);
        this.serviceId = serviceID;
        this.sbbId = sbbId;
        this.name = name;
    }

    public ServiceID getService() throws ManagementException {
        return this.serviceId;
    }

    public SbbID getSbb() throws ManagementException {
        return this.sbbId;
    }

    public String getUsageParameterSet() throws ManagementException {
        return this.name;
    }

    public void close() throws InvalidStateException, ManagementException {
        if (this.listeners.size() != 0) {
            throw new InvalidStateException("Could not close Usage MBean listeners still attached!");
        }
    }

    public void resetAllUsageParameters() throws ManagementException {
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        SleeTransactionManager txmgr = SleeContainer.getTransactionManager();
        boolean rb = true;
        try {
            try {
                InstalledUsageParameterSet ups;
                txmgr.begin();
                ServiceComponent service = sleeContainer.getServiceComponent(this.serviceId);
                try {
                    String[] paramNames = service.getNamedUsageParameterSets(this.sbbId);
                    int i = 0;
                    while (paramNames != null && i < paramNames.length) {
                        InstalledUsageParameterSet ups2 = Service.getNamedUsageParameter(this.serviceId, this.sbbId, this.name);
                        if (ups2 != null) {
                            ups2.reset();
                        }
                        ++i;
                    }
                }
                catch (InvalidArgumentException paramNames) {
                    // empty catch block
                }
                if ((ups = Service.getDefaultUsageParameterSet(this.serviceId, this.sbbId)) != null) {
                    ups.reset();
                }
                rb = false;
            }
            catch (Exception ex) {
                throw new ManagementException("error resetting usage parametes", (Throwable)ex);
            }
        }
        finally {
            try {
                if (rb) {
                    txmgr.setRollbackOnly();
                }
                txmgr.commit();
            }
            catch (SystemException e) {
                throw new RuntimeException("Txmgr failed", e);
            }
        }
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.listeners.add(new ListenerFilterHandbackTriplet(listener, filter, handback));
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        boolean found = false;
        for (ListenerFilterHandbackTriplet triplet : this.listeners) {
            if (triplet.notificationListener != listener) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new ListenerNotFoundException();
        }
        this.listeners.remove(listener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] notificationTypes = new String[]{"javax.slee.management.usage"};
        MBeanNotificationInfo[] mbeanNotificationInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notificationTypes, "UsageNotifications", "Notification of SBB usage")};
        return mbeanNotificationInfo;
    }

    public void sendUsageNotification(long value, long seqno, String usageParameterSetName, String usageParameterName, boolean isCounter) {
        UsageNotification notification = new UsageNotification((SbbUsageMBean)this, this.serviceId, this.sbbId, usageParameterSetName, usageParameterName, isCounter, value, seqno, System.currentTimeMillis());
        for (ListenerFilterHandbackTriplet triplet : this.listeners) {
            if (triplet.notificationFilter != null && !triplet.notificationFilter.isNotificationEnabled((Notification)notification)) continue;
            triplet.notificationListener.handleNotification((Notification)notification, triplet.handbackObject);
        }
    }

    public void setUsageParameter(InstalledUsageParameterSet usageParam) {
        this.usagePramSet = usageParam;
    }

    class ListenerFilterHandbackTriplet {
        NotificationListener notificationListener;
        NotificationFilter notificationFilter;
        Object handbackObject;

        public ListenerFilterHandbackTriplet(NotificationListener listener, NotificationFilter notificationFilter, Object handbackObject) {
            this.notificationListener = listener;
            this.notificationFilter = notificationFilter;
            this.handbackObject = handbackObject;
        }
    }
}

