/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx;

import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.slee.InvalidArgumentException;
import javax.slee.InvalidStateException;
import javax.slee.ServiceID;
import javax.slee.UnrecognizedServiceException;
import javax.slee.management.ManagementException;
import javax.slee.management.ServiceManagementMBean;
import javax.slee.management.ServiceState;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.service.Service;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class ServiceManagementMBeanImpl
extends StandardMBean
implements ServiceManagementMBean {
    private static Logger logger = Logger.getLogger(ServiceManagementMBeanImpl.class);

    public ServiceManagementMBeanImpl() throws NotCompliantMBeanException {
        super(ServiceManagementMBean.class);
    }

    public ServiceState getState(ServiceID serviceID) throws NullPointerException, UnrecognizedServiceException, ManagementException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Service.getState " + serviceID));
        }
        if (serviceID == null) {
            throw new NullPointerException("Null service ID!");
        }
        SleeTransactionManager transactionManager = SleeContainer.getTransactionManager();
        boolean b = false;
        try {
            SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
            Service service = null;
            b = transactionManager.requireTransaction();
            service = serviceContainer.getService(serviceID);
            if (service == null) {
                throw new UnrecognizedServiceException(" unrecognized service " + serviceID);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("returning state " + service.getState()));
            }
            ServiceState serviceState = service.getState();
            return serviceState;
        }
        catch (Exception ex) {
            try {
                transactionManager.setRollbackOnly();
            }
            catch (SystemException e) {
                logger.error((Object)("Failed getState for serviceID " + serviceID));
            }
            throw new ManagementException("Unexpected system exception while getting state of service: " + serviceID, (Throwable)ex);
        }
        finally {
            if (b) {
                try {
                    transactionManager.commit();
                }
                catch (SystemException e) {
                    logger.error((Object)("Failed getState for serviceID " + serviceID));
                    throw new ManagementException("Unexpected system exception while committing transaction after getState for serviceID: " + serviceID, (Throwable)e);
                }
            }
        }
    }

    public ServiceID[] getServices(ServiceState serviceState) throws NullPointerException, ManagementException {
        if (serviceState == null) {
            throw new NullPointerException("Passed a null state");
        }
        try {
            SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
            ServiceID[] retval = serviceContainer.getServicesByState(serviceState);
            return retval;
        }
        catch (Exception ex) {
            throw new ManagementException("Error getting services by state!", (Throwable)ex);
        }
    }

    public void activate(ServiceID serviceID) throws NullPointerException, UnrecognizedServiceException, InvalidStateException, ManagementException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("activate() " + serviceID));
        }
        if (serviceID == null) {
            throw new NullPointerException("NullPointerException");
        }
        try {
            SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
            serviceContainer.startService(serviceID);
        }
        catch (InvalidStateException ise) {
            throw ise;
        }
        catch (Exception ex) {
            throw new ManagementException("system exception starting service", (Throwable)ex);
        }
    }

    public void activate(ServiceID[] serviceIDs) throws NullPointerException, InvalidArgumentException, UnrecognizedServiceException, InvalidStateException, ManagementException {
        if (serviceIDs.length == 0) {
            throw new InvalidArgumentException("InvalidArgumentException");
        }
        int i = 0;
        while (i < serviceIDs.length) {
            if (serviceIDs[i] == null) {
                throw new InvalidArgumentException("InvalidArgumentException");
            }
            ++i;
        }
        i = 0;
        while (i < serviceIDs.length - 1) {
            int j = i + 1;
            while (j < serviceIDs.length) {
                if (serviceIDs[i] == serviceIDs[j]) {
                    throw new InvalidArgumentException("InvalidArgumentException");
                }
                ++j;
            }
            ++i;
        }
        try {
            i = 0;
            while (i < serviceIDs.length) {
                this.activate(serviceIDs[i]);
                ++i;
            }
        }
        catch (InvalidStateException ise) {
            throw ise;
        }
        catch (Exception ex) {
            throw new ManagementException("system exception starting service", (Throwable)ex);
        }
    }

    public void deactivate(ServiceID serviceID) throws NullPointerException, UnrecognizedServiceException, InvalidStateException, ManagementException {
        if (serviceID == null) {
            throw new NullPointerException("NullPointerException");
        }
        SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
        try {
            serviceContainer.stopService(serviceID);
        }
        catch (InvalidStateException ise) {
            throw ise;
        }
        catch (Exception ex) {
            logger.error((Object)"Could not deactivate service", (Throwable)ex);
            throw new ManagementException("exception whild deactivating service ! ", (Throwable)ex);
        }
    }

    public void deactivate(ServiceID[] arg0) throws NullPointerException, InvalidArgumentException, UnrecognizedServiceException, InvalidStateException, ManagementException {
        if (arg0.length == 0) {
            throw new InvalidArgumentException("InvalidArgumentException");
        }
        int i = 0;
        while (i < arg0.length) {
            if (arg0[i] == null) {
                throw new InvalidArgumentException("InvalidArgumentException");
            }
            ++i;
        }
        i = 0;
        while (i < arg0.length - 1) {
            int j = i + 1;
            while (j < arg0.length) {
                if (arg0[i] == arg0[j]) {
                    throw new InvalidArgumentException("InvalidArgumentException");
                }
                ++j;
            }
            ++i;
        }
        try {
            i = 0;
            while (i < arg0.length) {
                this.deactivate(arg0[i]);
                ++i;
            }
        }
        catch (InvalidStateException ise) {
            throw ise;
        }
        catch (Exception ex) {
            throw new ManagementException("system exception starting service", (Throwable)ex);
        }
    }

    public void deactivateAndActivate(ServiceID arg0, ServiceID arg1) throws NullPointerException, InvalidArgumentException, UnrecognizedServiceException, InvalidStateException, ManagementException {
        if (logger.isInfoEnabled()) {
            logger.debug((Object)("deactivateAndActivate (" + arg0 + " , " + arg1));
        }
        if (arg0 == arg1) {
            throw new InvalidArgumentException("Activating and deactivating the same service!");
        }
        if (arg0 == null || arg1 == null) {
            throw new InvalidArgumentException("The service(s) are null!");
        }
        try {
            this.deactivate(arg0);
            this.activate(arg1);
        }
        catch (InvalidStateException ise) {
            throw ise;
        }
        catch (Exception ex) {
            throw new ManagementException("exception in deactivating/activating service ! ");
        }
    }

    public void deactivateAndActivate(ServiceID[] arg0, ServiceID[] arg1) throws NullPointerException, InvalidArgumentException, UnrecognizedServiceException, InvalidStateException, ManagementException {
        int j;
        if (arg0.length == 0 || arg1.length == 0) {
            throw new InvalidArgumentException("The service array is empty!");
        }
        int i = 0;
        while (i < arg0.length) {
            if (arg0[i] == null) {
                throw new InvalidArgumentException("InvalidArgumentException");
            }
            ++i;
        }
        i = 0;
        while (i < arg1.length) {
            if (arg1[i] == null) {
                throw new InvalidArgumentException("InvalidArgumentException");
            }
            ++i;
        }
        i = 0;
        while (i < arg0.length - 1) {
            j = i + 1;
            while (j < arg0.length) {
                if (arg0[i] == arg0[j]) {
                    throw new InvalidArgumentException("InvalidArgumentException");
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < arg1.length - 1) {
            j = i + 1;
            while (j < arg1.length) {
                if (arg1[i] == arg1[j]) {
                    throw new InvalidArgumentException("InvalidArgumentException");
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < arg0.length) {
            j = 0;
            while (j < arg1.length) {
                if (arg0[i] == arg1[j]) {
                    throw new InvalidArgumentException("InvalidArgumentException");
                }
                ++j;
            }
            ++i;
        }
        try {
            i = 0;
            while (i < arg0.length) {
                this.deactivate(arg0[i]);
                ++i;
            }
            i = 0;
            while (i < arg1.length) {
                this.activate(arg1[i]);
                ++i;
            }
        }
        catch (InvalidStateException ise) {
            throw ise;
        }
        catch (ManagementException me) {
            throw me;
        }
    }

    public ObjectName getServiceUsageMBean(ServiceID serviceID) throws NullPointerException, UnrecognizedServiceException, ManagementException {
        try {
            if (serviceID == null) {
                throw new NullPointerException("Null service ID ");
            }
            logger.debug((Object)("getServiceUsageMBean " + serviceID));
            SleeContainer serviceContainer = SleeContainer.lookupFromJndi();
            if (!serviceContainer.checkServiceExists(serviceID)) {
                throw new UnrecognizedServiceException("bad service id " + serviceID);
            }
            ObjectName objName = new ObjectName("slee:ServiceUsageMBean=" + serviceID.toString());
            return objName;
        }
        catch (Exception ex) {
            throw new ManagementException(ex.getMessage(), (Throwable)ex);
        }
    }
}

