/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx;

import java.io.Serializable;
import java.util.Iterator;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.slee.ComponentID;
import javax.slee.InvalidArgumentException;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.UnrecognizedSbbException;
import javax.slee.UnrecognizedServiceException;
import javax.slee.management.ManagementException;
import javax.slee.management.ServiceUsageMBean;
import javax.slee.management.UsageParameterSetNameAlreadyExistsException;
import javax.slee.usage.UnrecognizedUsageParameterSetNameException;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.InstalledUsageParameterSet;
import org.mobicents.slee.container.service.Service;
import org.mobicents.slee.container.service.ServiceComponent;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class ServiceUsageMBeanImpl
extends StandardMBean
implements ServiceUsageMBean,
Serializable {
    private static final long serialVersionUID = 2670146310843436229L;
    private ServiceID serviceID;
    private static Logger logger = Logger.getLogger(ServiceUsageMBeanImpl.class);
    private transient ServiceComponent service;

    public ServiceUsageMBeanImpl() throws NotCompliantMBeanException {
        super(ServiceUsageMBean.class);
    }

    public ServiceUsageMBeanImpl(ServiceID serviceID) throws NotCompliantMBeanException, MalformedObjectNameException, NullPointerException {
        this();
        this.serviceID = serviceID;
    }

    public ServiceID getService() throws ManagementException {
        return this.serviceID;
    }

    public void createUsageParameterSet(SbbID sbbId, String usageParameterSetName) throws NullPointerException, UnrecognizedSbbException, InvalidArgumentException, UsageParameterSetNameAlreadyExistsException, ManagementException {
        if (usageParameterSetName == null) {
            throw new NullPointerException("Sbb usage param set is null");
        }
        if (sbbId == null) {
            throw new NullPointerException("Sbb ID is null!");
        }
        if (usageParameterSetName.length() == 0) {
            throw new InvalidArgumentException("The lenght of the Usage Parameter Set Name is zero!");
        }
        if (!this.isValidUsageParameterName(usageParameterSetName)) {
            throw new InvalidArgumentException("The lenght of the Usage Parameter Set Name is zero!");
        }
        SleeTransactionManager txmgr = SleeContainer.getTransactionManager();
        boolean rb = true;
        try {
            try {
                txmgr.begin();
                this.checkSbbUsageParams(sbbId);
                this.service.installUsageParameter(sbbId, usageParameterSetName);
                rb = false;
            }
            catch (UnrecognizedSbbException ex) {
                throw ex;
            }
            catch (InvalidArgumentException ex) {
                throw ex;
            }
            catch (InstanceAlreadyExistsException ex) {
                throw new UsageParameterSetNameAlreadyExistsException("Duplicate usage parameter set name " + usageParameterSetName);
            }
            catch (NullPointerException ex) {
                throw ex;
            }
            catch (UsageParameterSetNameAlreadyExistsException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new ManagementException("Unexpected exception!", (Throwable)e);
            }
        }
        finally {
            try {
                if (rb) {
                    txmgr.setRollbackOnly();
                }
                txmgr.commit();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unexpected exception ", ex);
            }
        }
    }

    private boolean isValidUsageParameterName(String str) {
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!(Character.isDigit(c) || Character.isLetter(c) || c <= '~' && c >= ' ')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void removeUsageParameterSet(SbbID sbbId, String name) throws NullPointerException, UnrecognizedSbbException, InvalidArgumentException, UnrecognizedUsageParameterSetNameException, ManagementException {
        if (name == null) {
            throw new NullPointerException("Sbb usage param set is null");
        }
        if (sbbId == null) {
            throw new NullPointerException("Sbb ID is null!");
        }
        SleeTransactionManager txmgr = SleeContainer.getTransactionManager();
        boolean rb = true;
        try {
            try {
                txmgr.begin();
                SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
                if (!sleeContainer.isInstalled((ComponentID)sbbId)) {
                    throw new UnrecognizedSbbException("Sbb not installed " + sbbId);
                }
                this.service = sleeContainer.getServiceComponent(this.serviceID);
                this.service.removeUsageParameter(sbbId, name);
            }
            catch (UnrecognizedUsageParameterSetNameException ex) {
                throw ex;
            }
            catch (InvalidArgumentException ex) {
                throw ex;
            }
            catch (UnrecognizedSbbException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ManagementException("Could not uninstall usage parameter", (Throwable)ex);
            }
        }
        finally {
            try {
                if (rb) {
                    txmgr.setRollbackOnly();
                }
                txmgr.commit();
            }
            catch (SystemException ex) {
                logger.fatal((Object)"Unexpected exception !", (Throwable)ex);
                throw new RuntimeException("Unexpected exception !", ex);
            }
        }
    }

    public String[] getUsageParameterSets(SbbID sbbId) throws NullPointerException, UnrecognizedSbbException, InvalidArgumentException, ManagementException {
        if (sbbId == null) {
            throw new NullPointerException("null sbb id specificed");
        }
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        SleeTransactionManager txmgr = SleeContainer.getTransactionManager();
        String[] usageParameterSets = null;
        boolean rb = true;
        try {
            try {
                txmgr.begin();
                this.checkSbbUsageParams(sbbId);
                usageParameterSets = this.service.getNamedUsageParameterSets(sbbId);
                if (usageParameterSets == null) {
                    throw new InvalidArgumentException("No usage parameters found ");
                }
                rb = false;
            }
            catch (UnrecognizedSbbException ex) {
                throw ex;
            }
            catch (InvalidArgumentException ex) {
                throw ex;
            }
            catch (Exception ex) {
                logger.error((Object)"unexpected exception ", (Throwable)ex);
                throw new ManagementException("Something bad happened ! ", (Throwable)ex);
            }
        }
        finally {
            try {
                if (rb) {
                    txmgr.setRollbackOnly();
                }
                txmgr.commit();
            }
            catch (SystemException ex) {
                logger.error((Object)"Txmgr failed", (Throwable)ex);
                throw new RuntimeException("Txmgr failed", ex);
            }
        }
        return usageParameterSets;
    }

    public ObjectName getSbbUsageMBean(SbbID sbbId) throws NullPointerException, UnrecognizedSbbException, InvalidArgumentException, ManagementException {
        if (sbbId == null) {
            throw new NullPointerException("Sbb ID is null!");
        }
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        SleeTransactionManager txMgr = SleeContainer.getTransactionManager();
        boolean rb = true;
        try {
            txMgr.begin();
            this.checkSbbUsageParams(sbbId);
            ObjectName on = this.service.getUsageParameterObjectName(sbbId);
            if (on == null) {
                throw new InvalidArgumentException("No usage mbean for this sbb ");
            }
            rb = false;
            ObjectName objectName = on;
            return objectName;
        }
        catch (UnrecognizedSbbException ex) {
            throw ex;
        }
        catch (InvalidArgumentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"Unexpected exception ", (Throwable)ex);
            throw new ManagementException("cannot getUsageMBean " + sbbId);
        }
        finally {
            try {
                if (rb) {
                    txMgr.setRollbackOnly();
                }
                txMgr.commit();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error with tx manager", e);
            }
        }
    }

    public ObjectName getSbbUsageMBean(SbbID sbbId, String name) throws NullPointerException, UnrecognizedSbbException, InvalidArgumentException, UnrecognizedUsageParameterSetNameException, ManagementException {
        if (sbbId == null) {
            throw new NullPointerException("Sbb ID is null!");
        }
        if (name == null) {
            throw new NullPointerException("Sbb usage param set is null");
        }
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        SleeTransactionManager txMgr = SleeContainer.getTransactionManager();
        boolean rb = true;
        try {
            txMgr.begin();
            this.checkSbbUsageParams(sbbId);
            ObjectName on = this.service.getUsageParameterObjectName(sbbId, name);
            rb = false;
            ObjectName objectName = on;
            return objectName;
        }
        catch (UnrecognizedSbbException ex) {
            throw ex;
        }
        catch (UnrecognizedUsageParameterSetNameException ex) {
            throw ex;
        }
        catch (InvalidArgumentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)("unexpected exception getting usage mbean name = " + name + " sbbid = " + sbbId), (Throwable)ex);
            throw new ManagementException("cannot getUsageMBean " + name, (Throwable)ex);
        }
        finally {
            try {
                if (rb) {
                    txMgr.setRollbackOnly();
                }
                txMgr.commit();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error with tx manager", e);
            }
        }
    }

    public void resetAllUsageParameters(SbbID sbbId) throws NullPointerException, UnrecognizedSbbException, InvalidArgumentException, ManagementException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("resetAllUsageParameters: " + sbbId));
        }
        if (sbbId == null) {
            throw new NullPointerException("Sbb ID is null");
        }
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        SleeTransactionManager txMgr = SleeContainer.getTransactionManager();
        boolean rb = true;
        try {
            try {
                txMgr.begin();
                this.checkSbbUsageParams(sbbId);
                InstalledUsageParameterSet usageParam = Service.getDefaultUsageParameterSet(this.serviceID, sbbId);
                if (usageParam != null) {
                    usageParam.reset();
                }
                String[] paramNames = this.service.getNamedUsageParameterSets(sbbId);
                int i = 0;
                while (paramNames != null && i < paramNames.length) {
                    String name = paramNames[i];
                    InstalledUsageParameterSet ups = Service.getNamedUsageParameter(this.serviceID, sbbId, name);
                    if (ups != null) {
                        ups.reset();
                    }
                    ++i;
                }
                rb = false;
            }
            catch (InvalidArgumentException ex) {
                throw ex;
            }
            catch (UnrecognizedSbbException ex) {
                throw ex;
            }
            catch (Exception ex) {
                String s = "unexpected exception in resetAllUsageParameters";
                logger.error((Object)s, (Throwable)ex);
                throw new ManagementException(s);
            }
        }
        finally {
            try {
                if (rb) {
                    txMgr.setRollbackOnly();
                }
                txMgr.commit();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error with tx manager", e);
            }
        }
    }

    public void resetAllUsageParameters() throws ManagementException {
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        SleeTransactionManager txMgr = SleeContainer.getTransactionManager();
        boolean rb = true;
        try {
            try {
                txMgr.begin();
                Service service = sleeContainer.getService(this.serviceID);
                Iterator it = Service.getAllUsageParameters(this.serviceID);
                while (it.hasNext()) {
                    InstalledUsageParameterSet ups = (InstalledUsageParameterSet)it.next();
                    ups.reset();
                }
                rb = false;
            }
            catch (Exception ex) {
                throw new ManagementException("Could not reset!", (Throwable)ex);
            }
        }
        finally {
            try {
                if (rb) {
                    txMgr.setRollbackOnly();
                }
                txMgr.commit();
            }
            catch (Exception ex) {
                throw new RuntimeException("unexpected system exception ", ex);
            }
        }
    }

    public void close() throws ManagementException {
    }

    private void checkSbbUsageParams(SbbID sbbId) throws UnrecognizedSbbException, InvalidArgumentException, UnrecognizedSbbException, SystemException, UnrecognizedServiceException {
        if (sbbId == null) {
            throw new NullPointerException("SbbId is null!");
        }
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        this.service = sleeContainer.getServiceComponent(this.serviceID);
        if (!sleeContainer.isInstalled((ComponentID)sbbId)) {
            throw new UnrecognizedSbbException("Sbb not installed " + sbbId);
        }
        if (!this.service.isComponent(sbbId)) {
            throw new UnrecognizedSbbException("This sbb is not part of this service serviceID = " + this.serviceID + " sbb id = " + sbbId);
        }
    }

    public ObjectName getSbbUsageNotificationManager(SbbID arg0) throws NullPointerException, UnrecognizedSbbException, InvalidArgumentException, ManagementException {
        return null;
    }
}

