/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx;

import java.net.InetAddress;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;
import org.mobicents.slee.container.management.jmx.SleeCommandInterface;

public class SleeBeanShellUtil {
    public Logger log = Logger.getLogger((String)SleeBeanShellUtil.class.getName());
    private SleeCommandInterface sci;

    public SleeBeanShellUtil() throws Exception {
        try {
            InetAddress myIpAddress = InetAddress.getByName(System.getProperty("jboss.bind.address"));
            this.sci = new SleeCommandInterface("jnp://" + myIpAddress.getHostAddress() + ":1099");
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to create instance of SleeCommandInterface", (Throwable)e);
            throw e;
        }
    }

    public Object install(String url) throws Exception {
        Object obj = null;
        try {
            if (url != null) {
                obj = this.sci.invokeOperation("-install", StringPropertyReplacer.replaceProperties((String)url), null, null);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
        return obj;
    }

    public void unInstall(String url) throws Exception {
        try {
            if (url != null) {
                this.sci.invokeOperation("-uninstall", StringPropertyReplacer.replaceProperties((String)url), null, null);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
    }

    public Object getDeploymentId(String url) throws Exception {
        Object deployableUnitID = null;
        try {
            if (url != null) {
                deployableUnitID = this.sci.invokeOperation("-getDeploymentId", StringPropertyReplacer.replaceProperties((String)url), null, null);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
        return deployableUnitID;
    }

    public Object getDescriptor(String deployableUnitID) throws Exception {
        Object deployableUnitDescriptor = null;
        try {
            if (deployableUnitID != null) {
                deployableUnitDescriptor = this.sci.invokeOperation("-getDescriptor", deployableUnitID, null, null);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
        return deployableUnitDescriptor;
    }

    public void activateService(String serviceId) throws Exception {
        try {
            if (serviceId != null) {
                this.sci.invokeOperation("-activateService", serviceId, null, null);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
    }

    public void deactivateService(String serviceId) throws Exception {
        try {
            if (serviceId != null) {
                this.sci.invokeOperation("-deactivateService", serviceId, null, null);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
    }

    public Object getServiceState(String serviceId) throws Exception {
        Object serviceState = null;
        try {
            if (serviceId != null) {
                serviceState = this.sci.invokeOperation("-getServiceState", serviceId, null, null);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
        return serviceState;
    }

    public void setTraceLevel(String componentId, String traceLevel) throws Exception {
        try {
            if (componentId != null && traceLevel != null) {
                this.sci.invokeOperation("-setTraceLevel", componentId, traceLevel, null);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
    }

    public Object getTraceLevel(String componentId) throws Exception {
        Object level = null;
        try {
            if (componentId != null) {
                level = this.sci.invokeOperation("-getTraceLevel", componentId, null, null);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
        return level;
    }

    public void createRaEntity(String resourceAdaptorID, String entityName, String properties) throws Exception {
        try {
            if (resourceAdaptorID != null & entityName != null) {
                this.sci.invokeOperation("-createRaEntity", resourceAdaptorID, entityName, properties);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
    }

    public void activateRaEntity(String entityName) throws Exception {
        try {
            if (entityName != null) {
                this.sci.invokeOperation("-activateRaEntity", entityName, null, null);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
    }

    public void deactivateRaEntity(String entityName) throws Exception {
        try {
            if (entityName != null) {
                this.sci.invokeOperation("-deactivateRaEntity", entityName, null, null);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
    }

    public void removeRaEntity(String entityName) throws Exception {
        try {
            if (entityName != null) {
                this.sci.invokeOperation("-removeRaEntity", entityName, null, null);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
    }

    public void createRaLink(String linkName, String entityName) throws Exception {
        try {
            if (linkName != null & entityName != null) {
                this.sci.invokeOperation("-createRaLink", linkName, entityName, null);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
    }

    public void removeRaLink(String linkName) throws Exception {
        try {
            if (linkName != null) {
                this.sci.invokeOperation("-removeRaLink", linkName, null, null);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
    }

    public void deployService(String url, String serviceId) throws Exception {
        this.install(url);
        this.activateService(serviceId);
    }

    public void deployRa(String raTypeURL, String raURL, String raID, String raName, String linkName, String props) throws Exception {
        this.install(raTypeURL);
        this.install(raURL);
        this.createRaEntity(raID, raName, props);
        this.activateRaEntity(raName);
        this.createRaLink(linkName, raName);
    }

    public void undeployService(String url, String serviceId) throws Exception {
        this.deactivateService(serviceId);
        this.unInstall(url);
    }

    public void undeployRa(String raTypeURL, String raURL, String raName, String linkName) throws Exception {
        this.removeRaLink(linkName);
        this.deactivateRaEntity(raName);
        this.removeRaEntity(raName);
        this.unInstall(raURL);
        this.unInstall(raTypeURL);
    }

    public void createProfileTable(String profileSpecID, String profileTableName) throws Exception {
        try {
            this.sci.invokeOperation("-createProfileTable", profileSpecID, profileTableName, null);
        }
        catch (Exception e) {
            this.log.warn((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()));
            throw e;
        }
    }

    public void removeProfileTable(String profileTableName) throws Exception {
        try {
            this.sci.invokeOperation("-removeProfileTable", profileTableName, null, null);
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
    }

    public Object createProfile(String profileTableName, String profileName) throws Exception {
        Object profileObject = null;
        try {
            profileObject = this.sci.invokeOperation("-createProfile", profileTableName, profileName, null);
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
        return profileObject;
    }

    public void removeProfile(String profileTableName, String profileName) throws Exception {
        try {
            this.sci.invokeOperation("-removeProfile", profileTableName, profileName, null);
        }
        catch (Exception e) {
            this.log.error((Object)("Bad result: " + this.sci.commandBean + "." + this.sci.commandString + "\n" + e.getCause().toString()), (Throwable)e);
            throw e;
        }
    }
}

