/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx;

import EDU.oswego.cs.dl.util.concurrent.ThreadedExecutor;
import java.util.HashMap;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.slee.InvalidStateException;
import javax.slee.ServiceID;
import javax.slee.UnrecognizedServiceException;
import javax.slee.management.ManagementException;
import javax.slee.management.ServiceState;
import javax.slee.management.SleeManagementMBean;
import javax.slee.management.SleeState;
import javax.slee.management.SleeStateChangeNotification;
import javax.transaction.SystemException;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.container.management.jmx.SleeManagementMBeanImplMBean;
import org.mobicents.slee.container.profile.SleeProfileManager;
import org.mobicents.slee.resource.SleeEndpointImpl;
import org.mobicents.slee.runtime.facilities.ProfileTableActivityImpl;

public class SleeManagementMBeanImpl
extends StandardMBean
implements SleeManagementMBeanImplMBean {
    private MBeanServer mbeanServer;
    private ObjectName alarmMBean;
    private ObjectName activityManagementMBean;
    private ObjectName sbbEntitiesMBean;
    private ObjectName traceMBean;
    private static Logger logger;
    private ObjectName objectName;
    private ObjectName deploymentMBean;
    private SleeContainer sleeContainer;
    private ObjectName profileProvisioningMBean;
    private ObjectName serviceManagementMBean;
    private ObjectName resourceManagementMBean;
    private NotificationBroadcasterSupport notificationBroadcaster = new NotificationBroadcasterSupport();
    private long sleeStateChangeSequenceNumber = 1L;
    private static final MBeanNotificationInfo[] MBEAN_NOTIFICATIONS;
    private long startupTime = System.currentTimeMillis();
    private boolean isFullSleeStop = true;
    private ServiceID[] activeServicesBeforeStop;

    static {
        MBEAN_NOTIFICATIONS = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{SleeStateChangeNotification.class.getName()}, "javax.slee.management.sleestatechange", "SLEE 1.0 Spec, #14.6, Each time the operational state of the SLEE changes, the SleeManagementMBean object generates a SLEE state change notification.")};
        try {
            logger = Logger.getLogger(SleeManagementMBeanImpl.class);
        }
        catch (Exception ex) {
            System.err.println("error initializing slee management mbean");
        }
    }

    public SleeManagementMBeanImpl() throws Exception {
        super(SleeManagementMBeanImplMBean.class);
        logger.info((Object)"[[[[[[[[[ MOBICENTS starting... ]]]]]]]]]");
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public SleeState getState() throws ManagementException {
        return this.sleeContainer.getSleeState();
    }

    public void start() throws InvalidStateException, ManagementException {
        if (this.sleeContainer.getSleeState() == SleeState.STARTING || this.sleeContainer.getSleeState() == SleeState.RUNNING || this.sleeContainer.getSleeState() == SleeState.STOPPING) {
            throw new InvalidStateException("SLEE is already in an active state");
        }
        try {
            this.startSleeContainer();
        }
        catch (Exception ex) {
            throw new ManagementException(ex.getMessage());
        }
    }

    public void stop() throws InvalidStateException, ManagementException {
        try {
            if (this.sleeContainer.getSleeState() == SleeState.STOPPING || this.sleeContainer.getSleeState() == SleeState.STOPPED) {
                throw new InvalidStateException("SLEE is already stopping or stopped.");
            }
            this.stopSleeContainer();
        }
        catch (Exception ex) {
            if (ex instanceof InvalidStateException) {
                throw (InvalidStateException)((Object)ex);
            }
            throw new ManagementException("Failed stopping SLEE container", (Throwable)ex);
        }
    }

    public void shutdown() throws InvalidStateException, ManagementException {
        if (this.sleeContainer.getSleeState() != SleeState.STOPPED) {
            throw new InvalidStateException("SLEE is not in STOPPED state.");
        }
    }

    public ObjectName getDeploymentMBean() {
        return this.deploymentMBean;
    }

    public void setDeploymentMBean(ObjectName newDM) {
        this.deploymentMBean = newDM;
    }

    public ObjectName getServiceManagementMBean() {
        return this.serviceManagementMBean;
    }

    public void setServiceManagementMBean(ObjectName newSMM) {
        this.serviceManagementMBean = newSMM;
    }

    public ObjectName getProfileProvisioningMBean() {
        return this.profileProvisioningMBean;
    }

    public void setProfileProvisioningMBean(ObjectName newPPM) {
        this.profileProvisioningMBean = newPPM;
    }

    public ObjectName getTraceMBean() {
        return this.traceMBean;
    }

    public void setTraceMBean(ObjectName newTM) {
        this.traceMBean = newTM;
    }

    public void setResourceManagementMBean(ObjectName resourceManagementMBean) {
        this.resourceManagementMBean = resourceManagementMBean;
    }

    public ObjectName getResourceManagementMBean() {
        return this.resourceManagementMBean;
    }

    public ObjectName getAlarmMBean() {
        return this.alarmMBean;
    }

    public void setAlarmMBean(ObjectName newAM) {
        this.alarmMBean = newAM;
    }

    public ObjectName preRegister(MBeanServer mbs, ObjectName oname) throws Exception {
        this.mbeanServer = mbs;
        this.objectName = oname;
        this.sleeContainer = new SleeContainer(this.mbeanServer);
        return oname;
    }

    public void postRegister(Boolean arg0) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.notificationBroadcaster.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notificationBroadcaster.removeNotificationListener(listener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return MBEAN_NOTIFICATIONS;
    }

    public void create() throws Exception {
    }

    public void destroy() {
    }

    protected void startSleeContainer() throws Exception {
        this.changeSleeState(SleeState.STARTING);
        try {
            try {
                if (this.isFullSleeStop) {
                    this.sleeContainer.init(this);
                    this.isFullSleeStop = false;
                }
                this.changeSleeState(SleeState.RUNNING);
                this.resumeServicesActiveBeforeStop();
            }
            catch (Exception ex) {
                logger.error((Object)"Error starting SLEE container", (Throwable)ex);
                throw ex;
            }
        }
        finally {
            if (this.sleeContainer.getSleeState() != SleeState.RUNNING) {
                this.stopSleeContainer();
            }
        }
    }

    private void resumeServicesActiveBeforeStop() throws UnrecognizedServiceException, InvalidStateException {
        if (this.activeServicesBeforeStop != null) {
            int i = 0;
            while (i < this.activeServicesBeforeStop.length) {
                try {
                    this.sleeContainer.reviveAndStartService(this.activeServicesBeforeStop[i]);
                }
                catch (UnrecognizedServiceException e) {
                    logger.info((Object)("Service was removed while SLEE was inactive: " + this.activeServicesBeforeStop[i]));
                }
                catch (Exception e) {
                    logger.error((Object)("Failed starting service " + this.activeServicesBeforeStop[i]), (Throwable)e);
                }
                ++i;
            }
        }
    }

    protected void stopSleeContainer() throws Exception {
        this.changeSleeState(SleeState.STOPPING);
        this.rememberActiveServicesBeforeStop();
        this.rememberActiveResourceAdaptorsBeforeStop();
        if (this.isFullSleeStop) {
            this.sleeContainer.close();
            logger.info((Object)"[[[[[[[[[[ MOBICENTS Stopped (HA). ]]]]]]]]]");
        } else {
            this.scheduleStopped();
        }
    }

    protected void scheduleStopped() {
        ThreadedExecutor exec = new ThreadedExecutor();
        Runnable acStateChecker = new Runnable(){

            public void run() {
                SleeManagementMBeanImpl.this.stopAllResourceAdaptors();
                SleeManagementMBeanImpl.this.stopAllServices();
                SleeManagementMBeanImpl.this.stopAllProfileTableActivities();
                SleeEndpointImpl.allActivitiesEnding();
                while (!SleeManagementMBeanImpl.this.areAllServicesInvalid()) {
                    logger.info((Object)"Waiting on all Activities and Services  to end before setting the SLEE container in STOPPED state...");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                SleeManagementMBeanImpl.this.changeSleeState(SleeState.STOPPED);
            }
        };
        try {
            exec.execute(acStateChecker);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Failed scheduling polling task for STOPPED state. The SLEE Container may remain in STOPPING state.");
        }
    }

    private void stopAllProfileTableActivities() {
        SleeProfileManager sleeProfileManager = SleeProfileManager.getInstance();
        HashMap profileTableActivities = sleeProfileManager.getProfileTableActivities();
        logger.debug((Object)"Stopping profile table activities !");
        for (String profileTableName : profileTableActivities.keySet()) {
            logger.debug((Object)("Stopping following profile table activity : " + profileTableName));
            SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
            int eventID = sleeContainer.getEventLookupFacility().getEventID(new ComponentKey("javax.slee.ActivityEndEvent", "javax.slee", "1.0"));
            ProfileTableActivityImpl profileTableActivity = (ProfileTableActivityImpl)profileTableActivities.get(profileTableName);
            sleeContainer.getSleeEndpoint().scheduleActivityEndedEvent(profileTableActivity);
        }
    }

    private void stopAllServices() {
        ServiceID[] services = null;
        try {
            services = this.sleeContainer.getServicesByState(ServiceState.ACTIVE);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        int i = 0;
        while (i < services.length) {
            try {
                this.sleeContainer.stopService(services[i]);
            }
            catch (Exception e1) {
                logger.debug((Object)"Failed to schedule SLEE end", (Throwable)e1);
            }
            ++i;
        }
    }

    private void stopAllResourceAdaptors() {
    }

    private boolean areAllServicesInvalid() {
        boolean b = SleeContainer.getTransactionManager().requireTransaction();
        boolean rb = true;
        try {
            int invalidServices = this.sleeContainer.getServicesByState(ServiceState.INACTIVE).length;
            int allServices = this.sleeContainer.getDeploymentManager().getServiceComponents().size();
            rb = false;
            boolean bl = invalidServices == allServices;
            return bl;
        }
        catch (Exception e) {
            logger.info((Object)("Failed areAllServicesInvalid() " + e.getMessage()));
        }
        finally {
            try {
                if (rb) {
                    SleeContainer.getTransactionManager().setRollbackOnly();
                }
                if (b) {
                    SleeContainer.getTransactionManager().commit();
                }
            }
            catch (SystemException e1) {
                logger.info((Object)"Failed areAllServicesInvalid() ", (Throwable)e1);
            }
        }
        return false;
    }

    private void rememberActiveServicesBeforeStop() throws Exception {
        this.activeServicesBeforeStop = this.sleeContainer.getServicesByState(ServiceState.ACTIVE);
    }

    private void rememberActiveResourceAdaptorsBeforeStop() throws Exception {
    }

    protected void changeSleeState(SleeState newState) {
        SleeState oldState = this.sleeContainer.getSleeState();
        this.sleeContainer.setSleeState(newState);
        this.notificationBroadcaster.sendNotification((Notification)new SleeStateChangeNotification((SleeManagementMBean)this, newState, oldState, this.sleeStateChangeSequenceNumber++));
        if (newState.equals((Object)SleeState.RUNNING)) {
            String timerSt = "";
            if (this.isFullSleeStop) {
                this.startupTime = System.currentTimeMillis() - this.startupTime;
                long startupSec = this.startupTime / 1000L;
                long startupMillis = this.startupTime % 1000L;
                timerSt = "in " + startupSec + "s:" + startupMillis + "ms ";
            }
            logger.info((Object)("[[[[[[[[[ MOBICENTS Started " + timerSt + "]]]]]]]]]"));
        } else if (newState.equals((Object)SleeState.STOPPED)) {
            logger.info((Object)"[[[[[[[[[[ MOBICENTS Stopped (SLEE). ]]]]]]]]]");
        }
    }

    public void setFullSleeStop(boolean b) {
        this.isFullSleeStop = b;
    }

    public boolean isFullSleeStop() {
        return this.isFullSleeStop;
    }

    public ObjectName getActivityManagementMBean() {
        return this.activityManagementMBean;
    }

    public void setActivityManagementMBean(ObjectName activityManagementMBean) {
        this.activityManagementMBean = activityManagementMBean;
    }

    public ObjectName getSbbEntitiesMBean() {
        return this.sbbEntitiesMBean;
    }

    public void setSbbEntitiesMBean(ObjectName sbbEntitiesMBean) {
        this.sbbEntitiesMBean = sbbEntitiesMBean;
    }
}

