/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.jmx.test;

import java.io.File;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ServiceState;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.mobicents.slee.container.management.jmx.SleeBeanShellUtil;

public class ZSleeBeanShellUtilTest
extends TestCase {
    SleeBeanShellUtil sleeBeanShellUtil = null;
    String pathToSBBDuJar = null;
    String serviceId = null;
    String sbbId = null;

    public ZSleeBeanShellUtilTest(String arg0) {
        super(arg0);
    }

    public static Test suite() {
        return new TestSuite(ZSleeBeanShellUtilTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Object path = null;
        this.sleeBeanShellUtil = new SleeBeanShellUtil();
        String mobicents_home = System.getProperty("MOBICENTS_HOME");
        if (mobicents_home == null) {
            try {
                mobicents_home = new File(".").getCanonicalPath();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.pathToSBBDuJar = "file:" + mobicents_home + File.separator + "build" + File.separator + "slee-bean-shell-util-test-du.jar";
        this.serviceId = "ServiceID[SleeBeanShellUtilService#org.mobicents#1.0]";
        this.sbbId = "SbbID[SleeBeanShellUtilSbb#org.mobicents#1.0]";
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testService() throws Exception {
        DeployableUnitID deployableUnitIDOfService = null;
        deployableUnitIDOfService = (DeployableUnitID)this.sleeBeanShellUtil.install(this.pathToSBBDuJar);
        ZSleeBeanShellUtilTest.assertNotNull((String)("DeployableUnitID of Service Installed = " + deployableUnitIDOfService.toString()), (Object)deployableUnitIDOfService);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        DeployableUnitID tmpDeployableUnitID = (DeployableUnitID)this.sleeBeanShellUtil.getDeploymentId(this.pathToSBBDuJar);
        ZSleeBeanShellUtilTest.assertNotNull((Object)tmpDeployableUnitID);
        ZSleeBeanShellUtilTest.assertEquals((String)("getDeploymentId returns DeployableUnitID of Service = " + tmpDeployableUnitID.toString()), (Object)tmpDeployableUnitID, (Object)deployableUnitIDOfService);
        DeployableUnitDescriptor tmpDeployableUnitDescriptor = (DeployableUnitDescriptor)this.sleeBeanShellUtil.getDescriptor(deployableUnitIDOfService.toString());
        ZSleeBeanShellUtilTest.assertNotNull((Object)tmpDeployableUnitDescriptor);
        ServiceState serviceState = (ServiceState)this.sleeBeanShellUtil.getServiceState(this.serviceId);
        ZSleeBeanShellUtilTest.assertNotNull((Object)serviceState);
        ZSleeBeanShellUtilTest.assertEquals((Object)ServiceState.INACTIVE, (Object)serviceState);
        this.sleeBeanShellUtil.activateService(this.serviceId);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        serviceState = (ServiceState)this.sleeBeanShellUtil.getServiceState(this.serviceId);
        ZSleeBeanShellUtilTest.assertNotNull((Object)serviceState);
        ZSleeBeanShellUtilTest.assertEquals((Object)ServiceState.ACTIVE, (Object)serviceState);
        this.sleeBeanShellUtil.deactivateService(this.serviceId);
        this.sleeBeanShellUtil.unInstall(this.pathToSBBDuJar);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

