/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import org.jboss.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DefaultSleeEntityResolver
implements EntityResolver {
    private Hashtable resources = null;
    private static DefaultSleeEntityResolver instance;
    private static Logger log;
    private ClassLoader sleeClassLoader;

    static {
        log = Logger.getLogger(DefaultSleeEntityResolver.class);
    }

    public static void init(ClassLoader sleeClassLoader) {
        instance = new DefaultSleeEntityResolver(sleeClassLoader);
    }

    private DefaultSleeEntityResolver(ClassLoader sleeClassLoader) {
        this.sleeClassLoader = sleeClassLoader;
        this.resources = new Hashtable();
        this.registerResource("-//Sun Microsystems, Inc.//DTD JAIN SLEE Deployable Unit 1.0//EN", "dtd/slee-deployable-unit_1_0.dtd");
        this.registerResource("-//Sun Microsystems, Inc.//DTD JAIN SLEE SBB 1.0//EN", "dtd/slee-sbb-jar_1_0.dtd");
        this.registerResource("-//Sun Microsystems, Inc.//DTD JAIN SLEE Service 1.0//EN", "dtd/slee-service_1_0.dtd");
        this.registerResource("-//Sun Microsystems, Inc.//DTD JAIN SLEE Resource Adaptor Type 1.0//EN", "dtd/slee-resource-adaptor-type-jar_1_0.dtd");
        this.registerResource("-//Sun Microsystems, Inc.//DTD JAIN SLEE Resource Adaptor 1.0//EN", "dtd/slee-resource-adaptor-jar_1_0.dtd");
        this.registerResource("-//Sun Microsystems, Inc.//DTD JAIN SLEE Profile Specification 1.0//EN", "dtd/slee-profile-spec-jar_1_0.dtd");
        this.registerResource("-//Sun Microsystems, Inc.//DTD JAIN SLEE Event 1.0//EN", "dtd/slee-event-jar_1_0.dtd");
    }

    static DefaultSleeEntityResolver getInstance() {
        if (instance == null) {
            throw new IllegalStateException("First create instance with slee classloader");
        }
        return instance;
    }

    private void registerResource(String publicID, String resourceName) {
        URL url = this.sleeClassLoader.getResource(resourceName);
        if (url == null) {
            throw new IllegalStateException("Cannot find resource:" + resourceName);
        }
        this.resources.put(publicID, url);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        URL resourceURL = (URL)this.resources.get(publicId);
        if (resourceURL != null) {
            InputStream resourceStream = null;
            resourceStream = resourceURL.openStream();
            InputSource is = new InputSource(resourceStream);
            is.setPublicId(publicId);
            is.setSystemId(resourceURL.toExternalForm());
            return is;
        }
        return null;
    }
}

