/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.xml;

import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.mobicents.slee.container.management.xml.XMLDescriptorStringsFixture;
import org.mobicents.slee.container.management.xml.XMLException;
import org.mobicents.slee.container.management.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLUtilsTest
extends TestCase {
    private XMLUtils xmlUtils = null;
    private Document sbbJarDocument = null;

    public XMLUtilsTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.xmlUtils = new XMLUtils();
        InputSource sbbJarSource = new InputSource(new StringReader(XMLDescriptorStringsFixture.SBB_JAR_XML));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.sbbJarDocument = builder.parse(sbbJarSource);
    }

    protected void tearDown() throws Exception {
        this.xmlUtils = null;
        super.tearDown();
    }

    public void testGetAllChildElements() throws IllegalArgumentException {
        Element parent = this.sbbJarDocument.getDocumentElement();
        String name = "sbb";
        List actualReturn = XMLUtils.getAllChildElements(parent, name);
        XMLUtilsTest.assertEquals((String)"Failed retriving node children", (String)"sbb", (String)((Node)actualReturn.get(0)).getNodeName());
        XMLUtilsTest.assertEquals((String)"Failed retriving node children", (String)"sbb", (String)((Node)actualReturn.get(1)).getNodeName());
    }

    public void testGetChildElement() throws IllegalArgumentException, XMLException {
        Element parent = this.sbbJarDocument.getDocumentElement();
        String name = "sbb";
        boolean assertUnique = false;
        Element actualReturn = XMLUtils.getChildElement(parent, name, assertUnique);
        XMLUtilsTest.assertEquals((String)"getChildElement did not return the expected node", (String)name, (String)actualReturn.getNodeName());
        assertUnique = true;
        try {
            actualReturn = XMLUtils.getChildElement(parent, name, assertUnique);
            XMLUtilsTest.fail((String)"getChildElement did not properly assert node uniqueness");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetElementTextValue() throws IllegalArgumentException, XMLException {
        Element sbbNode = XMLUtils.getChildElement(this.sbbJarDocument.getDocumentElement(), "sbb", false);
        Element descriptionNode = XMLUtils.getChildElement(sbbNode, "description", true);
        String expectedReturn = "JCC Call Forwarding SBB for JCC 1.0a";
        String actualReturn = XMLUtils.getElementTextValue(descriptionNode);
        XMLUtilsTest.assertEquals((String)"XML Node text value was not properly extracted", (String)expectedReturn, (String)actualReturn);
    }

    public void testGetElementTextValue1() throws XMLException {
        Element sbbNode = XMLUtils.getChildElement(this.sbbJarDocument.getDocumentElement(), "sbb", false);
        String expectedReturn = "JCC Call Forwarding SBB for JCC 1.0a";
        String actualReturn = XMLUtils.getElementTextValue(sbbNode, "description");
        XMLUtilsTest.assertEquals((String)"XML Node text value was not properly extracted", (String)expectedReturn, (String)actualReturn);
    }
}

